/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.ui.viewmodel.update;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dd.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMData;
import org.eclipse.dd.dsf.datamodel.IDMService;
import org.eclipse.dd.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.dd.dsf.ui.concurrent.ViewerCountingRequestMonitor;
import org.eclipse.dd.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMAdapter;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.IVMModelProxy;
import org.eclipse.dd.dsf.ui.viewmodel.IVMModelProxyExtension;
import org.eclipse.dd.dsf.ui.viewmodel.IVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.VMChildrenCountUpdate;
import org.eclipse.dd.dsf.ui.viewmodel.VMChildrenUpdate;
import org.eclipse.dd.dsf.ui.viewmodel.VMHasChildrenUpdate;
import org.eclipse.dd.dsf.ui.viewmodel.update.AllUpdateScope;
import org.eclipse.dd.dsf.ui.viewmodel.update.AutomaticUpdatePolicy;
import org.eclipse.dd.dsf.ui.viewmodel.update.ICachingVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.update.ICachingVMProviderExtension;
import org.eclipse.dd.dsf.ui.viewmodel.update.IElementUpdateTester;
import org.eclipse.dd.dsf.ui.viewmodel.update.IVMUpdatePolicy;
import org.eclipse.dd.dsf.ui.viewmodel.update.IVMUpdateScope;
import org.eclipse.dd.dsf.ui.viewmodel.update.ManualUpdatePolicy;
import org.eclipse.dd.dsf.ui.viewmodel.update.VisibleUpdateScope;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractCachingVMProvider
extends AbstractVMProvider
implements ICachingVMProvider,
ICachingVMProviderExtension {
    private boolean fIsAtomicUpdate = false;
    public static boolean DEBUG_CACHE = false;
    private static final int MAX_CACHE_SIZE = 1000;
    protected static String SELECTED_UPDATE_MODE;
    protected static String SELECTED_UPDATE_SCOPE;
    private IVMUpdatePolicy[] fAvailableUpdatePolicies;
    private IVMUpdateScope[] fAvailableUpdateScopes;
    public Map<Object, RootElementMarkerKey> fRootMarkers = new HashMap<Object, RootElementMarkerKey>();
    private final Map<Object, Entry> fCacheData = Collections.synchronizedMap(new HashMap(200, 0.75f));
    private final Entry fCacheListHead;

    public AbstractCachingVMProvider(AbstractVMAdapter adapter, IPresentationContext presentationContext) {
        super(adapter, presentationContext);
        this.fCacheListHead.fNext = this.fCacheListHead = new Entry(null){

            public String toString() {
                return "HEAD";
            }
        };
        this.fCacheListHead.fPrevious = this.fCacheListHead;
        this.fAvailableUpdatePolicies = this.createUpdateModes();
        this.fAvailableUpdateScopes = this.createUpdateScopes();
        this.setActiveUpdateScope(new VisibleUpdateScope());
    }

    protected IVMUpdatePolicy[] createUpdateModes() {
        return new IVMUpdatePolicy[]{new AutomaticUpdatePolicy()};
    }

    protected IVMUpdateScope[] createUpdateScopes() {
        return new IVMUpdateScope[]{new VisibleUpdateScope(), new AllUpdateScope()};
    }

    @Override
    public IVMUpdatePolicy[] getAvailableUpdatePolicies() {
        return this.fAvailableUpdatePolicies;
    }

    @Override
    public IVMUpdatePolicy getActiveUpdatePolicy() {
        String updateModeId = (String)this.getPresentationContext().getProperty(SELECTED_UPDATE_MODE);
        if (updateModeId != null) {
            for (IVMUpdatePolicy updateMode : this.getAvailableUpdatePolicies()) {
                if (!updateMode.getID().equals(updateModeId)) continue;
                return updateMode;
            }
        }
        return this.getAvailableUpdatePolicies()[0];
    }

    @Override
    public void setActiveUpdatePolicy(IVMUpdatePolicy updatePolicy) {
        this.getPresentationContext().setProperty(SELECTED_UPDATE_MODE, (Object)updatePolicy.getID());
    }

    @Override
    public void refresh() {
        IElementUpdateTester elementTester = this.getActiveUpdatePolicy().getElementUpdateTester(ManualUpdatePolicy.REFRESH_EVENT);
        for (IVMModelProxy proxyStrategy : this.getActiveModelProxies()) {
            this.flush(new FlushMarkerKey(proxyStrategy.getRootElement(), elementTester));
        }
        for (IVMModelProxy proxyStrategy : this.getActiveModelProxies()) {
            if (proxyStrategy.isDisposed()) continue;
            proxyStrategy.fireModelChanged((IModelDelta)new ModelDelta(proxyStrategy.getRootElement(), 1024));
        }
    }

    @Override
    public void updateNode(final IVMNode node, IHasChildrenUpdate[] updates) {
        LinkedList<VMHasChildrenUpdate> missUpdates = new LinkedList<VMHasChildrenUpdate>();
        for (final IHasChildrenUpdate update : updates) {
            ElementDataKey key = this.makeEntryKey(node, (IViewerUpdate)update);
            final ElementDataEntry entry = this.getElementDataEntry(key);
            if (entry.fHasChildren != null) {
                if (DEBUG_CACHE && (DEBUG_PRESENTATION_ID == null || this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
                    DsfUIPlugin.debug("cacheHitHasChildren(node = " + node + ", update = " + update + ", " + entry.fHasChildren + ")");
                }
                update.setHasChilren(entry.fHasChildren.booleanValue());
                update.done();
                continue;
            }
            final int flushCounter = entry.fFlushCounter;
            missUpdates.add(new VMHasChildrenUpdate((IViewerUpdate)update, (DataRequestMonitor<Boolean>)new ViewerDataRequestMonitor<Boolean>(this.getExecutor(), (IViewerUpdate)update){

                protected void handleCompleted() {
                    if (this.isSuccess()) {
                        if (flushCounter == entry.fFlushCounter) {
                            if (DEBUG_CACHE && (AbstractVMProvider.DEBUG_PRESENTATION_ID == null || AbstractCachingVMProvider.this.getPresentationContext().getId().equals(AbstractVMProvider.DEBUG_PRESENTATION_ID))) {
                                DsfUIPlugin.debug("cacheSavedHasChildren(node = " + node + ", update = " + update + ", " + this.getData() + ")");
                            }
                            entry.fHasChildren = (Boolean)this.getData();
                        }
                        update.setHasChilren(((Boolean)this.getData()).booleanValue());
                    } else {
                        update.setStatus(this.getStatus());
                    }
                    update.done();
                }
            }));
        }
        if (!missUpdates.isEmpty()) {
            super.updateNode(node, missUpdates.toArray(new IHasChildrenUpdate[missUpdates.size()]));
        }
    }

    @Override
    public void updateNode(final IVMNode node, final IChildrenCountUpdate update) {
        ElementDataKey key = this.makeEntryKey(node, (IViewerUpdate)update);
        final ElementDataEntry entry = this.getElementDataEntry(key);
        if (entry.fChildrenCount != null) {
            if (DEBUG_CACHE && (DEBUG_PRESENTATION_ID == null || this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
                DsfUIPlugin.debug("cacheHitChildrenCount(node = " + node + ", update = " + update + ", " + entry.fChildrenCount + ")");
            }
            update.setChildCount(entry.fChildrenCount.intValue());
            update.done();
        } else {
            final int flushCounter = entry.fFlushCounter;
            VMChildrenCountUpdate updateProxy = new VMChildrenCountUpdate((IViewerUpdate)update, (DataRequestMonitor<Integer>)new ViewerDataRequestMonitor<Integer>(this.getExecutor(), (IViewerUpdate)update){

                protected void handleCompleted() {
                    if (this.isSuccess()) {
                        if (flushCounter == entry.fFlushCounter) {
                            if (DEBUG_CACHE && (AbstractVMProvider.DEBUG_PRESENTATION_ID == null || AbstractCachingVMProvider.this.getPresentationContext().getId().equals(AbstractVMProvider.DEBUG_PRESENTATION_ID))) {
                                DsfUIPlugin.debug("cacheSavedChildrenCount(node = " + node + ", update = " + update + ", " + this.getData() + ")");
                            }
                            entry.fChildrenCount = (Integer)this.getData();
                        }
                        update.setChildCount(((Integer)this.getData()).intValue());
                    } else {
                        update.setStatus(this.getStatus());
                    }
                    update.done();
                }
            });
            super.updateNode(node, updateProxy);
        }
    }

    @Override
    public void updateNode(final IVMNode node, final IChildrenUpdate update) {
        ElementDataKey key = this.makeEntryKey(node, (IViewerUpdate)update);
        final ElementDataEntry entry = this.getElementDataEntry(key);
        final int flushCounter = entry.fFlushCounter;
        if (entry.fChildren == null || update.getOffset() < 0 && !entry.fAllChildrenKnown) {
            VMChildrenUpdate updateProxy = new VMChildrenUpdate((IViewerUpdate)update, update.getOffset(), update.getLength(), (DataRequestMonitor<List<Object>>)new ViewerDataRequestMonitor<List<Object>>(this.getExecutor(), (IViewerUpdate)update){

                @Override
                protected void handleSuccess() {
                    int updateOffset = update.getOffset();
                    if (updateOffset < 0) {
                        updateOffset = 0;
                        if (entry.fFlushCounter == flushCounter) {
                            entry.fAllChildrenKnown = true;
                        }
                    }
                    if (DEBUG_CACHE && (AbstractVMProvider.DEBUG_PRESENTATION_ID == null || AbstractCachingVMProvider.this.getPresentationContext().getId().equals(AbstractVMProvider.DEBUG_PRESENTATION_ID))) {
                        DsfUIPlugin.debug("cacheSavedChildren(node = " + node + ", update = " + update + ", children = {" + updateOffset + "->" + (updateOffset + ((List)this.getData()).size()) + "})");
                    }
                    if (flushCounter == entry.fFlushCounter) {
                        entry.ensureChildrenMap();
                    }
                    for (int j = 0; j < ((List)this.getData()).size(); ++j) {
                        int offset = updateOffset + j;
                        Object child = ((List)this.getData()).get(j);
                        if (child == null) continue;
                        if (flushCounter == entry.fFlushCounter) {
                            entry.fChildren.put(offset, child);
                        }
                        update.setChild(child, offset);
                    }
                    update.done();
                }

                @Override
                protected void handleCancel() {
                    if (DEBUG_CACHE && (AbstractVMProvider.DEBUG_PRESENTATION_ID == null || AbstractCachingVMProvider.this.getPresentationContext().getId().equals(AbstractVMProvider.DEBUG_PRESENTATION_ID))) {
                        DsfUIPlugin.debug("cacheCanceledChildren(node = " + node + ", update = " + update + ")");
                    }
                    super.handleCancel();
                }
            });
            super.updateNode(node, updateProxy);
        } else if (update.getOffset() < 0) {
            if (DEBUG_CACHE && (DEBUG_PRESENTATION_ID == null || this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
                DsfUIPlugin.debug("cacheHitChildren(node = " + node + ", update = " + update + ", children = " + entry.fChildren.keySet() + ")");
            }
            assert (entry.fAllChildrenKnown);
            for (int position = 0; position < entry.fChildren.size(); ++position) {
                update.setChild(entry.fChildren.get(position), position);
            }
            update.done();
        } else {
            LinkedList<Integer> childrenMissingFromCache = new LinkedList<Integer>();
            for (int i = update.getOffset(); i < update.getOffset() + update.getLength(); ++i) {
                childrenMissingFromCache.add(i);
            }
            Integer position = update.getOffset();
            while (position < update.getOffset() + update.getLength()) {
                Object child = entry.fChildren.get(position);
                if (child != null) {
                    update.setChild(entry.fChildren.get(position), position.intValue());
                    childrenMissingFromCache.remove(position);
                }
                child = position;
                Integer n = position = Integer.valueOf(position + 1);
            }
            if (DEBUG_CACHE && (DEBUG_PRESENTATION_ID == null || this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
                DsfUIPlugin.debug("cachePartialHitChildren(node = " + node + ", update = " + update + ", missing = " + childrenMissingFromCache + ")");
            }
            if (childrenMissingFromCache.size() > 0) {
                ArrayList<VMChildrenUpdate> partialUpdates = new ArrayList<VMChildrenUpdate>(2);
                final ViewerCountingRequestMonitor multiRm = new ViewerCountingRequestMonitor(this.getExecutor(), (IViewerUpdate)update);
                while (childrenMissingFromCache.size() > 0) {
                    final int offset = (Integer)childrenMissingFromCache.get(0);
                    childrenMissingFromCache.remove(0);
                    int n = 1;
                    while (childrenMissingFromCache.size() > 0 && (Integer)childrenMissingFromCache.get(0) == offset + n) {
                        ++n;
                        childrenMissingFromCache.remove(0);
                    }
                    partialUpdates.add(new VMChildrenUpdate((IViewerUpdate)update, offset, n, new DataRequestMonitor<List<Object>>(this.getExecutor(), (RequestMonitor)multiRm){

                        protected void handleSuccess() {
                            if (flushCounter == entry.fFlushCounter) {
                                if (DEBUG_CACHE && (AbstractVMProvider.DEBUG_PRESENTATION_ID == null || AbstractCachingVMProvider.this.getPresentationContext().getId().equals(AbstractVMProvider.DEBUG_PRESENTATION_ID))) {
                                    DsfUIPlugin.debug("cachePartialSaveChildren(node = " + node + ", update = " + update + ", saved = {" + offset + "->" + (offset + ((List)this.getData()).size()) + "})");
                                }
                                entry.ensureChildrenMap();
                            }
                            for (int i = 0; i < ((List)this.getData()).size(); ++i) {
                                if (((List)this.getData()).get(i) == null) continue;
                                update.setChild(((List)this.getData()).get(i), offset + i);
                                if (flushCounter != entry.fFlushCounter) continue;
                                entry.fChildren.put(offset + i, ((List)this.getData()).get(i));
                            }
                            multiRm.done();
                        }
                    }));
                }
                for (IChildrenUpdate iChildrenUpdate : partialUpdates) {
                    super.updateNode(node, iChildrenUpdate);
                }
                multiRm.setDoneCount(partialUpdates.size());
            } else {
                update.done();
            }
        }
    }

    private void flush(FlushMarkerKey flushKey) {
        if (DEBUG_CACHE && (DEBUG_PRESENTATION_ID == null || this.getPresentationContext().getId().equals(DEBUG_PRESENTATION_ID))) {
            DsfUIPlugin.debug("cacheFlushing(" + flushKey + ")");
        }
        Entry entry = this.fCacheListHead.fPrevious;
        while (entry != this.fCacheListHead) {
            if (entry.fKey instanceof FlushMarkerKey) {
                FlushMarkerKey entryFlushKey = (FlushMarkerKey)entry.fKey;
                if (flushKey.includes(entryFlushKey)) {
                    this.fCacheData.remove(entryFlushKey);
                    entry.remove();
                }
                if (entryFlushKey.includes(flushKey)) {
                    break;
                }
            } else if (entry instanceof ElementDataEntry) {
                ElementDataEntry elementDataEntry = (ElementDataEntry)entry;
                int updateFlags = flushKey.getUpdateFlags((ElementDataKey)elementDataEntry.fKey);
                if ((updateFlags & 1) != 0) {
                    if ((updateFlags & 3) == 3) {
                        for (Map.Entry<IDMContext, Object> dataOrStatusEntry : elementDataEntry.fDataOrStatus.entrySet()) {
                            if (!(dataOrStatusEntry.getValue() instanceof IDMData)) continue;
                            elementDataEntry.fArchiveData.put(dataOrStatusEntry.getKey(), (IDMData)dataOrStatusEntry.getValue());
                        }
                        elementDataEntry.fDataOrStatus.clear();
                        if (elementDataEntry.fArchiveData.isEmpty()) {
                            this.fCacheData.remove(entry.fKey);
                            entry.remove();
                        }
                    } else if (!elementDataEntry.fArchiveData.isEmpty()) {
                        elementDataEntry.fDataOrStatus.clear();
                    } else {
                        this.fCacheData.remove(entry.fKey);
                        entry.remove();
                    }
                    ++elementDataEntry.fFlushCounter;
                    elementDataEntry.fHasChildren = null;
                    elementDataEntry.fChildrenCount = null;
                    elementDataEntry.fChildren = null;
                    elementDataEntry.fAllChildrenKnown = false;
                    elementDataEntry.fDirty = false;
                } else if ((updateFlags & 4) != 0) {
                    elementDataEntry.fDirty = true;
                }
            }
            entry = entry.fPrevious;
        }
        Entry flushMarkerEntry = new Entry(flushKey);
        this.fCacheData.put(flushKey, flushMarkerEntry);
        flushMarkerEntry.insert(this.fCacheListHead);
    }

    @Override
    protected void handleEvent(final IVMModelProxy proxyStrategy, final Object event, final RequestMonitor rm) {
        IElementUpdateTester elementTester = this.getActiveUpdatePolicy().getElementUpdateTester(event);
        this.flush(new FlushMarkerKey(proxyStrategy.getRootElement(), elementTester));
        if (proxyStrategy instanceof IVMModelProxyExtension) {
            IVMModelProxyExtension proxyStrategyExtension = (IVMModelProxyExtension)proxyStrategy;
            if (this.fIsAtomicUpdate) {
                if (this.getActiveUpdateScope().getID().equals(AllUpdateScope.ALL_UPDATE_SCOPE_ID)) {
                    this.updateExpanded(proxyStrategyExtension, proxyStrategyExtension.getViewerInput(), proxyStrategyExtension.getRootPath(), new RequestMonitor(this.getExecutor(), null){

                        protected void handleCompleted() {
                            AbstractCachingVMProvider.super.handleEvent(proxyStrategy, event, rm);
                        }
                    });
                } else {
                    TreeViewer viewer = (TreeViewer)proxyStrategyExtension.getViewer();
                    Tree tree = viewer.getTree();
                    int[] count = new int[]{tree.getSize().y / tree.getItemHeight()};
                    CountingRequestMonitor multiRm = new CountingRequestMonitor(this.getExecutor(), rm);
                    multiRm.setDoneCount(count[0] + 1);
                    ArrayList<IChildrenUpdate> childrenUpdateVector = new ArrayList<IChildrenUpdate>();
                    this.updateVisibleExpanded(tree, new TreeItem[]{tree.getTopItem()}, count, viewer, proxyStrategyExtension, (RequestMonitor)multiRm, childrenUpdateVector);
                    this.update(childrenUpdateVector.toArray(new IChildrenUpdate[childrenUpdateVector.size()]));
                    super.handleEvent(proxyStrategy, event, (RequestMonitor)multiRm);
                }
            } else if (this.getActiveUpdateScope().getID().equals(AllUpdateScope.ALL_UPDATE_SCOPE_ID)) {
                CountingRequestMonitor multiRm = new CountingRequestMonitor(this.getExecutor(), rm);
                multiRm.setDoneCount(2);
                this.updateExpanded(proxyStrategyExtension, proxyStrategyExtension.getViewerInput(), proxyStrategyExtension.getRootPath(), (RequestMonitor)multiRm);
                super.handleEvent(proxyStrategy, event, (RequestMonitor)multiRm);
            } else {
                super.handleEvent(proxyStrategy, event, rm);
            }
        } else {
            super.handleEvent(proxyStrategy, event, rm);
        }
    }

    private void updateVisibleExpanded(Object parent, TreeItem[] startItem, int[] count, TreeViewer viewer, IVMModelProxy proxyStrategy, RequestMonitor rm, List<IChildrenUpdate> childrenUpdatesVector) {
        if (parent instanceof Tree) {
            for (int i = 0; i < ((Tree)parent).getItemCount() && count[0] > 0; ++i) {
                TreeItem item = ((Tree)parent).getItem(i);
                if (item.equals(startItem[0])) {
                    startItem[0] = null;
                }
                if (startItem[0] == null) {
                    childrenUpdatesVector.add(this.createChildrenUpdate(item, proxyStrategy, viewer.getInput(), rm));
                    count[0] = count[0] - 1;
                }
                if (item.getData() == null || !viewer.getExpandedState(item.getData())) continue;
                this.updateVisibleExpanded(item, startItem, count, viewer, proxyStrategy, rm, childrenUpdatesVector);
            }
        } else {
            for (int i = 0; i < ((TreeItem)parent).getItemCount() && count[0] > 0; ++i) {
                TreeItem item = ((TreeItem)parent).getItem(i);
                if (item.equals(startItem[0])) {
                    startItem[0] = null;
                }
                if (startItem[0] == null) {
                    childrenUpdatesVector.add(this.createChildrenUpdate(item, proxyStrategy, viewer.getInput(), rm));
                    count[0] = count[0] - 1;
                }
                if (item.getData() == null || !viewer.getExpandedState(item.getData())) continue;
                this.updateVisibleExpanded(item, startItem, count, viewer, proxyStrategy, rm, childrenUpdatesVector);
            }
        }
    }

    private IChildrenUpdate createChildrenUpdate(TreeItem child, IVMModelProxy proxyStrategy, final Object viewerInput, final RequestMonitor rm) {
        LinkedList<Object> pathList = new LinkedList<Object>();
        Object tree = null;
        for (TreeItem item = child.getParentItem(); item != null; item = item.getParentItem()) {
            pathList.add(0, item.getData());
        }
        final TreePath path = new TreePath(pathList.toArray());
        int index = 0;
        index = child.getParentItem() != null ? child.getParentItem().indexOf(child) : child.getParent().indexOf(child);
        final IPresentationContext presentationContext = this.getPresentationContext();
        final String[] columns = presentationContext.getColumns();
        return new VMChildrenUpdate(path, viewerInput, this.getPresentationContext(), index, 1, new DataRequestMonitor<List<Object>>(this.getExecutor(), null){

            protected void handleCompleted() {
                for (final Object o : (List)this.getData()) {
                    if (!(o instanceof IAdaptable)) continue;
                    IElementLabelProvider labelProvider = (IElementLabelProvider)((IAdaptable)o).getAdapter(IElementLabelProvider.class);
                    labelProvider.update(new ILabelUpdate[]{new ILabelUpdate(){

                        public Object getElement() {
                            return o;
                        }

                        public TreePath getElementPath() {
                            return path;
                        }

                        public IPresentationContext getPresentationContext() {
                            return presentationContext;
                        }

                        public Object getViewerInput() {
                            return viewerInput;
                        }

                        public void cancel() {
                        }

                        public IStatus getStatus() {
                            return null;
                        }

                        public boolean isCanceled() {
                            return false;
                        }

                        public void setStatus(IStatus status) {
                        }

                        public String[] getColumnIds() {
                            return columns;
                        }

                        public void setBackground(RGB arg0, int arg1) {
                        }

                        public void setFontData(FontData arg0, int arg1) {
                        }

                        public void setForeground(RGB arg0, int arg1) {
                        }

                        public void setImageDescriptor(ImageDescriptor arg0, int arg1) {
                        }

                        public void setLabel(String arg0, int arg1) {
                        }

                        public void done() {
                            rm.done();
                        }
                    }});
                }
            }
        });
    }

    private void updateExpanded(final IVMModelProxyExtension proxyStrategy, final Object viewerInput, final TreePath path, final RequestMonitor rm) {
        final IPresentationContext presentationContext = this.getPresentationContext();
        final String[] columns = presentationContext.getColumns();
        this.update(new IChildrenUpdate[]{new VMChildrenUpdate(path, viewerInput, presentationContext, -1, -1, new DataRequestMonitor<List<Object>>(this.getExecutor(), null){

            protected void handleCompleted() {
                if (this.getData() != null) {
                    TreeViewer viewer = (TreeViewer)proxyStrategy.getViewer();
                    int expandedCount = 0;
                    int elementCount = 0;
                    final CountingRequestMonitor multiRm = new CountingRequestMonitor(AbstractCachingVMProvider.this.getExecutor(), rm);
                    for (final Object data : (List)this.getData()) {
                        if (viewer.getExpandedState(data)) {
                            Object[] childPathSegments = new Object[path.getSegmentCount() + 1];
                            int i = 0;
                            for (i = 0; i < path.getSegmentCount(); ++i) {
                                childPathSegments[i] = path.getSegment(i);
                            }
                            childPathSegments[i] = data;
                            AbstractCachingVMProvider.this.updateExpanded(proxyStrategy, viewerInput, new TreePath(childPathSegments), (RequestMonitor)multiRm);
                            ++expandedCount;
                        }
                        if (!(data instanceof IAdaptable)) continue;
                        ++elementCount;
                        IElementLabelProvider labelProvider = (IElementLabelProvider)((IAdaptable)data).getAdapter(IElementLabelProvider.class);
                        labelProvider.update(new ILabelUpdate[]{new ILabelUpdate(){

                            public Object getElement() {
                                return data;
                            }

                            public TreePath getElementPath() {
                                return path;
                            }

                            public IPresentationContext getPresentationContext() {
                                return presentationContext;
                            }

                            public Object getViewerInput() {
                                return viewerInput;
                            }

                            public void cancel() {
                            }

                            public IStatus getStatus() {
                                return null;
                            }

                            public boolean isCanceled() {
                                return false;
                            }

                            public void setStatus(IStatus status) {
                            }

                            public String[] getColumnIds() {
                                return columns;
                            }

                            public void setBackground(RGB arg0, int arg1) {
                            }

                            public void setFontData(FontData arg0, int arg1) {
                            }

                            public void setForeground(RGB arg0, int arg1) {
                            }

                            public void setImageDescriptor(ImageDescriptor arg0, int arg1) {
                            }

                            public void setLabel(String arg0, int arg1) {
                            }

                            public void done() {
                                multiRm.done();
                            }
                        }});
                    }
                    multiRm.setDoneCount(expandedCount + elementCount);
                }
            }
        })});
    }

    @Override
    public IModelProxy createModelProxy(Object element, IPresentationContext context) {
        IVMModelProxy proxy = null;
        for (IVMModelProxy next : this.getActiveModelProxies()) {
            if (next == null || !next.getRootElement().equals(element)) continue;
            proxy = next;
            break;
        }
        if (proxy == null) {
            proxy = this.createModelProxyStrategy(element);
            this.getActiveModelProxies().add(proxy);
        } else if (proxy.isDisposed()) {
            proxy.init(context);
        }
        return proxy;
    }

    protected void rootElementRemovedFromCache(Object rootElement) {
        this.fRootMarkers.remove(rootElement);
        Iterator<IVMModelProxy> proxiesItr = this.getActiveModelProxies().iterator();
        while (proxiesItr.hasNext()) {
            IVMModelProxy proxy = proxiesItr.next();
            if (!proxy.isDisposed() || !proxy.getRootElement().equals(rootElement)) continue;
            proxiesItr.remove();
        }
    }

    private ElementDataKey makeEntryKey(IVMNode node, IViewerUpdate update) {
        Object rootElement = update.getViewerInput();
        block0: for (IVMModelProxy proxy : this.getActiveModelProxies()) {
            Object proxyRoot = proxy.getRootElement();
            if (proxyRoot.equals(update.getViewerInput())) {
                rootElement = proxyRoot;
                break;
            }
            TreePath path = update.getElementPath();
            for (int i = 0; i < path.getSegmentCount(); ++i) {
                if (!proxyRoot.equals(path.getSegment(i))) continue;
                rootElement = proxyRoot;
                break block0;
            }
        }
        return new ElementDataKey(rootElement, node, update.getViewerInput(), update.getElementPath());
    }

    private ElementDataEntry getElementDataEntry(ElementDataKey key) {
        Entry rootMarkerEntry;
        assert (key != null);
        ElementDataEntry entry = (ElementDataEntry)this.fCacheData.get(key);
        if (entry == null) {
            entry = new ElementDataEntry(key);
            this.addEntry(key, entry);
        } else {
            entry.remove();
            entry.insert(this.fCacheListHead);
        }
        RootElementMarkerKey rootMarker = this.fRootMarkers.get(key.fRootElement);
        if (rootMarker == null) {
            rootMarker = new RootElementMarkerKey(key.fRootElement);
            this.fRootMarkers.put(key.fRootElement, rootMarker);
        }
        if ((rootMarkerEntry = this.fCacheData.get(rootMarker)) == null) {
            rootMarkerEntry = new RootElementMarkerEntry(rootMarker);
            this.addEntry(rootMarker, rootMarkerEntry);
        } else if (rootMarkerEntry.fNext != this.fCacheListHead) {
            rootMarkerEntry.remove();
            rootMarkerEntry.insert(this.fCacheListHead);
        }
        return entry;
    }

    private void addEntry(Object key, Entry entry) {
        this.fCacheData.put(key, entry);
        entry.insert(this.fCacheListHead);
        if (this.fCacheData.size() > 1000) {
            this.fCacheData.remove(this.fCacheListHead.fNext.fKey);
            this.fCacheListHead.fNext.remove();
        }
    }

    @Deprecated
    public void getModelData(final IVMNode node, final IViewerUpdate update, final IDMService service, final IDMContext dmc, final DataRequestMonitor rm, final Executor executor) {
        this.getExecutor().execute((Runnable)new DsfRunnable(){

            public void run() {
                ElementDataKey key = AbstractCachingVMProvider.this.makeEntryKey(node, update);
                final ElementDataEntry entry = AbstractCachingVMProvider.this.getElementDataEntry(key);
                Object dataOrStatus = entry.fDataOrStatus.get(dmc);
                if (dataOrStatus != null) {
                    if (dataOrStatus instanceof IDMData) {
                        rm.setData(dataOrStatus);
                    } else {
                        rm.setStatus((IStatus)dataOrStatus);
                    }
                    rm.done();
                } else {
                    service.getExecutor().execute((Runnable)new DsfRunnable(){

                        public void run() {
                            service.getModelData(dmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IDMData>(executor, update){

                                protected void handleCompleted() {
                                    if (this.isSuccess()) {
                                        entry.fDataOrStatus.put(dmc, this.getData());
                                        rm.setData(this.getData());
                                    } else {
                                        if (!this.isCanceled()) {
                                            entry.fDataOrStatus.put(dmc, this.getStatus());
                                        }
                                        rm.setStatus(this.getStatus());
                                    }
                                    rm.done();
                                }
                            });
                        }
                    });
                }
            }
        });
    }

    @Deprecated
    public IDMData getArchivedModelData(IVMNode node, IViewerUpdate update, IDMContext dmc) {
        Map<IDMContext, IDMData> archiveData;
        ElementDataKey key = this.makeEntryKey(node, update);
        Entry entry = this.fCacheData.get(key);
        if (entry instanceof ElementDataEntry && (archiveData = ((ElementDataEntry)entry).fArchiveData) != null) {
            return archiveData.get(dmc);
        }
        return null;
    }

    @Override
    public IVMUpdateScope[] getAvailableUpdateScopes() {
        return this.fAvailableUpdateScopes;
    }

    @Override
    public IVMUpdateScope getActiveUpdateScope() {
        String updateScopeId = (String)this.getPresentationContext().getProperty(SELECTED_UPDATE_SCOPE);
        if (updateScopeId != null) {
            for (IVMUpdateScope updateScope : this.getAvailableUpdateScopes()) {
                if (!updateScope.getID().equals(updateScopeId)) continue;
                return updateScope;
            }
        }
        return this.getAvailableUpdateScopes()[0];
    }

    @Override
    public void setActiveUpdateScope(IVMUpdateScope updateScope) {
        this.getPresentationContext().setProperty(SELECTED_UPDATE_SCOPE, (Object)updateScope.getID());
    }

    @Override
    public boolean isAtomicUpdate() {
        return this.fIsAtomicUpdate;
    }

    @Override
    public void setAtomicUpdate(boolean enable) {
        this.fIsAtomicUpdate = enable;
    }

    static {
        DEBUG_CACHE = DsfUIPlugin.DEBUG && "true".equals(Platform.getDebugOption((String)"org.eclipse.dd.dsf.ui/debug/vm/cache"));
        SELECTED_UPDATE_MODE = "org.eclipse.dd.dsf.ui.viewmodel.update.selectedUpdateMode";
        SELECTED_UPDATE_SCOPE = "org.eclipse.dd.dsf.ui.viewmodel.update.selectedUpdateScope";
    }

    class RootElementMarkerEntry
    extends Entry {
        RootElementMarkerEntry(RootElementMarkerKey key) {
            super(key);
        }

        void remove() {
            super.remove();
            AbstractCachingVMProvider.this.rootElementRemovedFromCache(((RootElementMarkerKey)this.fKey).fRootElement);
        }

        public String toString() {
            return "ROOT MARKER " + this.fKey;
        }
    }

    private static class RootElementMarkerKey {
        private Object fRootElement;

        RootElementMarkerKey(Object rootElement) {
            this.fRootElement = rootElement;
        }

        public boolean equals(Object obj) {
            return obj instanceof RootElementMarkerKey && ((RootElementMarkerKey)obj).fRootElement.equals(this.fRootElement);
        }

        public int hashCode() {
            return this.fRootElement.hashCode();
        }

        public String toString() {
            return this.fRootElement.toString();
        }
    }

    private static class FlushMarkerKey {
        private Object fRootElement;
        private IElementUpdateTester fElementTester;

        FlushMarkerKey(Object rootElement, IElementUpdateTester pathTester) {
            this.fRootElement = rootElement;
            this.fElementTester = pathTester;
        }

        boolean includes(FlushMarkerKey key) {
            return this.fRootElement.equals(key.fRootElement) && this.fElementTester.includes(key.fElementTester);
        }

        int getUpdateFlags(ElementDataKey key) {
            if (this.fRootElement.equals(key.fRootElement)) {
                return this.fElementTester.getUpdateFlags(key.fViewerInput, key.fPath);
            }
            return 0;
        }

        public String toString() {
            return this.fElementTester.toString() + " " + this.fRootElement.toString();
        }
    }

    static class ElementDataEntry
    extends Entry {
        int fFlushCounter = 0;
        Boolean fDirty = false;
        Boolean fHasChildren = null;
        Integer fChildrenCount = null;
        boolean fAllChildrenKnown = false;
        Map<Integer, Object> fChildren = null;
        Map<IDMContext, Object> fDataOrStatus = new HashMap<IDMContext, Object>(1);
        Map<IDMContext, IDMData> fArchiveData = new HashMap<IDMContext, IDMData>(1);

        ElementDataEntry(ElementDataKey key) {
            super(key);
        }

        void ensureChildrenMap() {
            if (this.fChildren == null) {
                Integer childrenCount = this.fChildrenCount;
                childrenCount = childrenCount != null ? childrenCount : 0;
                int capacity = Math.max(childrenCount * 4 / 3, 32);
                this.fChildren = new HashMap<Integer, Object>(capacity);
            }
        }

        public String toString() {
            return this.fKey.toString() + " = " + "[hasChildren=" + this.fHasChildren + ", " + "childrenCount=" + this.fChildrenCount + ", children=" + this.fChildren + ", data/status=" + this.fDataOrStatus + ", oldData=" + this.fArchiveData + "]";
        }
    }

    private static class Entry {
        final Object fKey;
        Entry fNext;
        Entry fPrevious;

        Entry(Object key) {
            this.fKey = key;
        }

        void insert(Entry nextEntry) {
            this.fNext = nextEntry;
            this.fPrevious = nextEntry.fPrevious;
            this.fPrevious.fNext = this;
            this.fNext.fPrevious = this;
        }

        void remove() {
            this.fPrevious.fNext = this.fNext;
            this.fNext.fPrevious = this.fPrevious;
        }
    }

    private static class ElementDataKey {
        final Object fRootElement;
        final IVMNode fNode;
        final Object fViewerInput;
        final TreePath fPath;

        ElementDataKey(Object rootElement, IVMNode node, Object viewerInput, TreePath path) {
            this.fRootElement = rootElement;
            this.fNode = node;
            this.fViewerInput = viewerInput;
            this.fPath = path;
        }

        public String toString() {
            return this.fNode.toString() + " " + (this.fPath.getSegmentCount() == 0 ? this.fViewerInput.toString() : this.fPath.getLastSegment().toString());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ElementDataKey)) {
                return false;
            }
            ElementDataKey key = (ElementDataKey)obj;
            return (this.fNode == null && key.fNode == null || this.fNode != null && this.fNode.equals(key.fNode)) && (this.fRootElement == null && key.fRootElement == null || this.fRootElement != null && this.fRootElement.equals(key.fRootElement)) && (this.fViewerInput == null && key.fViewerInput == null || this.fViewerInput != null && this.fViewerInput.equals(key.fViewerInput)) && (this.fPath == null && key.fPath == null || this.fPath != null && this.fPath.equals((Object)key.fPath));
        }

        public int hashCode() {
            return (this.fRootElement != null ? this.fRootElement.hashCode() : 0) + (this.fNode != null ? this.fNode.hashCode() : 0) + (this.fViewerInput != null ? this.fViewerInput.hashCode() : 0) + (this.fPath != null ? this.fPath.hashCode() : 0);
        }
    }
}

