/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.model;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.Query;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.internal.DsfDebugPlugin;
import org.eclipse.dd.dsf.debug.model.DsfMemoryBlock;
import org.eclipse.dd.dsf.debug.service.IExpressions;
import org.eclipse.dd.dsf.debug.service.IFormattedValues;
import org.eclipse.dd.dsf.debug.service.IMemory;
import org.eclipse.dd.dsf.service.DsfServices;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DsfMemoryBlockRetrieval
extends PlatformObject
implements IMemoryBlockRetrievalExtension {
    private final String fModelId;
    private final DsfSession fSession;
    private final DsfExecutor fExecutor;
    private final String fContextString;
    private final ServiceTracker fMemoryServiceTracker;
    private final ServiceTracker fExpressionServiceTracker;
    private final ILaunchConfiguration fLaunchConfig;
    private final ILaunch fLaunch;
    private final IDebugTarget fDebugTarget;
    private final boolean fSupportsValueModification;
    private final boolean fSupportBaseAddressModification;
    private final int fAddressSize;
    private final int fWordSize;
    private static final String DSF_LAUNCH_ID = "org.eclipse.dsf.launch";
    private static final String ATTR_DEBUGGER_MEMORY_BLOCKS = "org.eclipse.dsf.launch.MEMORY_BLOCKS";
    private static final String MEMORY_BLOCK_EXPRESSION_LIST = "memoryBlockExpressionList";
    private static final String ATTR_EXPRESSION_LIST_CONTEXT = "context";
    private static final String MEMORY_BLOCK_EXPRESSION = "memoryBlockExpression";
    private static final String ATTR_MEMORY_BLOCK_EXPR_LABEL = "label";
    private static final String ATTR_MEMORY_BLOCK_EXPR_ADDRESS = "address";

    public DsfMemoryBlockRetrieval(String modelId, ILaunchConfiguration config, DsfSession session) throws DebugException {
        this.fModelId = modelId;
        this.fContextString = "Context string";
        this.fSession = session;
        if (this.fSession == null) {
            throw new IllegalArgumentException("Session " + session + " is not active");
        }
        this.fExecutor = this.fSession.getExecutor();
        BundleContext bundle = DsfDebugPlugin.getBundleContext();
        String memoryServiceFilter = DsfServices.createServiceFilter(IMemory.class, (String)session.getId());
        try {
            this.fMemoryServiceTracker = new ServiceTracker(bundle, bundle.createFilter(memoryServiceFilter), null);
        }
        catch (InvalidSyntaxException e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.debug.service", 5013, "Error creating service filter.", (Throwable)e));
        }
        this.fMemoryServiceTracker.open();
        String expressionServiceFilter = "(&(OBJECTCLASS=" + IExpressions.class.getName() + ")" + "(" + "org.eclipse.dd.dsf.service.IService.session_id" + "=" + session.getId() + ")" + ")";
        try {
            this.fExpressionServiceTracker = new ServiceTracker(bundle, bundle.createFilter(expressionServiceFilter), null);
        }
        catch (InvalidSyntaxException e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.debug.service", 5013, "Error creating service filter.", (Throwable)e));
        }
        this.fExpressionServiceTracker.open();
        this.fLaunchConfig = config;
        this.fLaunch = null;
        this.fDebugTarget = null;
        this.fAddressSize = 4;
        this.fWordSize = 1;
        this.fSupportsValueModification = true;
        this.fSupportBaseAddressModification = false;
    }

    public void initialize(final IMemory.IMemoryDMContext memoryCtx) {
        try {
            final String memento = this.fLaunchConfig.getAttribute(ATTR_DEBUGGER_MEMORY_BLOCKS, "");
            if (memento != null && memento.trim().length() != 0) {
                this.getExecutor().submit(new Runnable(){

                    public void run() {
                        try {
                            DsfMemoryBlockRetrieval.this.createBlocksFromConfiguration(memoryCtx, memento);
                        }
                        catch (CoreException e) {
                            DsfDebugPlugin.getDefault().getLog().log(e.getStatus());
                        }
                    }
                });
            }
        }
        catch (CoreException e) {
            DsfDebugPlugin.getDefault().getLog().log(e.getStatus());
        }
    }

    private void createBlocksFromConfiguration(IMemory.IMemoryDMContext memoryCtx, String memento) throws CoreException {
        Element root = DebugPlugin.parseDocument((String)memento);
        if (!root.getNodeName().equalsIgnoreCase(MEMORY_BLOCK_EXPRESSION_LIST)) {
            Status status = new Status(4, "org.eclipse.dd.dsf.debug.debug.service", 120, "Memory monitor initialization: invalid memento", null);
            throw new CoreException((IStatus)status);
        }
        if (root.getAttribute(ATTR_EXPRESSION_LIST_CONTEXT).equals(this.fContextString)) {
            ArrayList<DsfMemoryBlock> blocks = new ArrayList<DsfMemoryBlock>();
            NodeList expressionList = root.getChildNodes();
            int length = expressionList.getLength();
            for (int i = 0; i < length; ++i) {
                Element entry;
                Node node = expressionList.item(i);
                if (node.getNodeType() != 1 || !(entry = (Element)node).getNodeName().equalsIgnoreCase(MEMORY_BLOCK_EXPRESSION)) continue;
                String label = entry.getAttribute(ATTR_MEMORY_BLOCK_EXPR_LABEL);
                String address = entry.getAttribute(ATTR_MEMORY_BLOCK_EXPR_ADDRESS);
                BigInteger blockAddress = new BigInteger(address);
                DsfMemoryBlock block = new DsfMemoryBlock(this, memoryCtx, this.fModelId, label, blockAddress, this.fWordSize, 0L);
                blocks.add(block);
            }
            DebugPlugin.getDefault().getMemoryBlockManager().addMemoryBlocks(blocks.toArray(new IMemoryBlock[blocks.size()]));
        }
    }

    public void saveMemoryBlocks() {
        try {
            ILaunchConfigurationWorkingCopy wc = this.fLaunchConfig.getWorkingCopy();
            wc.setAttribute(ATTR_DEBUGGER_MEMORY_BLOCKS, this.getMemento());
            wc.doSave();
        }
        catch (CoreException e) {
            DsfDebugPlugin.getDefault().getLog().log(e.getStatus());
        }
    }

    public String getMemento() throws CoreException {
        IMemoryBlock[] blocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks((IMemoryBlockRetrieval)this);
        Document document = DebugPlugin.newDocument();
        Element expressionList = document.createElement(MEMORY_BLOCK_EXPRESSION_LIST);
        expressionList.setAttribute(ATTR_EXPRESSION_LIST_CONTEXT, this.fContextString);
        for (IMemoryBlock block : blocks) {
            if (!(block instanceof IMemoryBlockExtension)) continue;
            IMemoryBlockExtension memoryBlock = (IMemoryBlockExtension)block;
            Element expression = document.createElement(MEMORY_BLOCK_EXPRESSION);
            expression.setAttribute(ATTR_MEMORY_BLOCK_EXPR_LABEL, memoryBlock.getExpression());
            expression.setAttribute(ATTR_MEMORY_BLOCK_EXPR_ADDRESS, memoryBlock.getBigBaseAddress().toString());
            expressionList.appendChild(expression);
        }
        document.appendChild(expressionList);
        return DebugPlugin.serializeDocument((Document)document);
    }

    public DsfSession getSession() {
        return this.fSession;
    }

    public DsfExecutor getExecutor() {
        return this.fExecutor;
    }

    public ServiceTracker getServiceTracker() {
        return this.fMemoryServiceTracker;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public IDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    public int getAddressSize() {
        return this.fAddressSize;
    }

    public int getAddressableSize() {
        return this.fWordSize;
    }

    public boolean supportsValueModification() {
        return this.fSupportsValueModification;
    }

    public boolean supportBaseAddressModification() {
        return this.fSupportBaseAddressModification;
    }

    public boolean supportsStorageRetrieval() {
        return true;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        throw new DebugException((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.debug.service", 5011, "getMemoryBlock() not supported, use getExtendedMemoryBlock()", null));
    }

    public IMemoryBlockExtension getExtendedMemoryBlock(String expression, Object context) throws DebugException {
        BigInteger blockAddress;
        IMemory.IMemoryDMContext memoryDmc;
        block7: {
            memoryDmc = null;
            IDMContext dmc = null;
            if (context instanceof IAdaptable && (dmc = (IDMContext)((IAdaptable)context).getAdapter(IDMContext.class)) != null) {
                memoryDmc = (IMemory.IMemoryDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMemory.IMemoryDMContext.class);
            }
            if (memoryDmc == null) {
                return null;
            }
            try {
                int base = 10;
                int offset = 0;
                if (expression.startsWith("0x") || expression.startsWith("0X")) {
                    base = 16;
                    offset = 2;
                } else if (expression.startsWith("0")) {
                    base = 8;
                    offset = 1;
                }
                blockAddress = new BigInteger(expression.substring(offset), base);
            }
            catch (NumberFormatException nfexc) {
                blockAddress = this.resolveMemoryAddress(dmc, expression);
                if (blockAddress != null) break block7;
                return null;
            }
        }
        return new DsfMemoryBlock(this, memoryDmc, this.fModelId, expression, blockAddress, this.fWordSize, 0L);
    }

    private BigInteger resolveMemoryAddress(final IDMContext dmc, final String expression) throws DebugException {
        Query<BigInteger> query = new Query<BigInteger>(){

            protected void execute(final DataRequestMonitor<BigInteger> drm) {
                IExpressions expressionService = (IExpressions)DsfMemoryBlockRetrieval.this.fExpressionServiceTracker.getService();
                if (expressionService != null) {
                    IExpressions.IExpressionDMContext expressionDMC = expressionService.createExpression(dmc, expression);
                    String formatId = "HEX.Format";
                    IFormattedValues.FormattedValueDMContext valueDmc = expressionService.getFormattedValueContext(expressionDMC, formatId);
                    expressionService.getFormattedExpressionValue(valueDmc, new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)DsfMemoryBlockRetrieval.this.getExecutor(), drm){

                        protected void handleSuccess() {
                            IFormattedValues.FormattedValueDMData data = (IFormattedValues.FormattedValueDMData)this.getData();
                            String value = data.getFormattedValue().substring(2);
                            drm.setData((Object)new BigInteger(value, 16));
                            drm.done();
                        }
                    });
                }
            }
        };
        this.fExecutor.execute((Runnable)query);
        try {
            return (BigInteger)query.get();
        }
        catch (InterruptedException e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.debug.service", 5013, "Error evaluating memory address (InterruptedException).", (Throwable)e));
        }
        catch (ExecutionException e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.debug.service", 5013, "Error evaluating memory address (ExecutionException).", (Throwable)e));
        }
    }
}

