/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.gdb.internal.provisional.launching.GdbLaunch;
import org.eclipse.dd.gdb.internal.provisional.launching.LaunchMessages;
import org.eclipse.dd.gdb.internal.ui.GdbAdapterFactory;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class GdbUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.dd.gdb.ui";
    private static GdbUIPlugin plugin;
    private static BundleContext fgBundleContext;
    private static Shell debugDialogShell;

    public void start(BundleContext context) throws Exception {
        fgBundleContext = context;
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        this.disposeAdapterSets();
        plugin = null;
        super.stop(context);
        fgBundleContext = null;
    }

    private void disposeAdapterSets() {
        for (ILaunch launch : DebugPlugin.getDefault().getLaunchManager().getLaunches()) {
            if (!(launch instanceof GdbLaunch)) continue;
            GdbAdapterFactory.disposeAdapterSet(launch);
        }
    }

    public static GdbUIPlugin getDefault() {
        return plugin;
    }

    public static BundleContext getBundleContext() {
        return fgBundleContext;
    }

    public static Shell getShell() {
        if (GdbUIPlugin.getActiveWorkbenchShell() != null) {
            return GdbUIPlugin.getActiveWorkbenchShell();
        }
        if (debugDialogShell != null) {
            if (!debugDialogShell.isDisposed()) {
                return debugDialogShell;
            }
            debugDialogShell = null;
        }
        IWorkbenchWindow[] windows = GdbUIPlugin.getDefault().getWorkbench().getWorkbenchWindows();
        return windows[0].getShell();
    }

    public static void setDialogShell(Shell shell) {
        debugDialogShell = shell;
    }

    public static String getUniqueIdentifier() {
        if (GdbUIPlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return GdbUIPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static void log(IStatus status) {
        GdbUIPlugin.getDefault().getLog().log(status);
    }

    public static void logErrorMessage(String message) {
        GdbUIPlugin.log((IStatus)new Status(4, GdbUIPlugin.getUniqueIdentifier(), 4, message, null));
    }

    public static void log(Throwable e) {
        GdbUIPlugin.log((IStatus)new Status(4, GdbUIPlugin.getUniqueIdentifier(), 4, e.getMessage(), e));
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return GdbUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow w = GdbUIPlugin.getActiveWorkbenchWindow();
        if (w != null) {
            return w.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = GdbUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static void errorDialog(String message, IStatus status) {
        GdbUIPlugin.log(status);
        Shell shell = GdbUIPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            ErrorDialog.openError((Shell)shell, (String)LaunchMessages.getString((String)"LaunchUIPlugin.Error"), (String)message, (IStatus)status);
        }
    }

    public static void errorDialog(String message, Throwable t) {
        GdbUIPlugin.log(t);
        Shell shell = GdbUIPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            Status status = new Status(4, GdbUIPlugin.getUniqueIdentifier(), 1, t.getMessage(), null);
            ErrorDialog.openError((Shell)shell, (String)LaunchMessages.getString((String)"LaunchUIPlugin.Error"), (String)message, (IStatus)status);
        }
    }
}

