/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service.command;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandControlService;
import org.eclipse.dd.dsf.debug.service.command.ICommandListener;
import org.eclipse.dd.dsf.debug.service.command.ICommandResult;
import org.eclipse.dd.dsf.debug.service.command.ICommandToken;
import org.eclipse.dd.dsf.debug.service.command.IEventListener;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.mi.internal.MIPlugin;
import org.eclipse.dd.mi.service.command.AbstractMIControl;
import org.eclipse.dd.mi.service.command.CLIEventProcessor;
import org.eclipse.dd.mi.service.command.LargePipedInputStream;
import org.eclipse.dd.mi.service.command.commands.CLICommand;
import org.eclipse.dd.mi.service.command.commands.MICommand;
import org.eclipse.dd.mi.service.command.commands.MIInterpreterExecConsole;
import org.eclipse.dd.mi.service.command.commands.RawCommand;
import org.eclipse.dd.mi.service.command.output.MIConsoleStreamOutput;
import org.eclipse.dd.mi.service.command.output.MIInfo;
import org.eclipse.dd.mi.service.command.output.MILogStreamOutput;
import org.eclipse.dd.mi.service.command.output.MIOOBRecord;
import org.eclipse.dd.mi.service.command.output.MIOutput;
import org.eclipse.dd.mi.service.command.output.MIStreamRecord;

@ThreadSafe
public abstract class AbstractCLIProcess
extends Process
implements IEventListener,
ICommandListener {
    public static final String PRIMARY_PROMPT = "(gdb)";
    public static final String SECONDARY_PROMPT = ">";
    private final DsfSession fSession;
    private final ICommandControlService fCommandControl;
    private final OutputStream fOutputStream;
    private final PipedInputStream fMIInConsolePipe;
    private final PipedOutputStream fMIOutConsolePipe;
    private final PipedInputStream fMIInLogPipe;
    private final PipedOutputStream fMIOutLogPipe;
    private boolean fDisposed;
    private int fSuppressConsoleOutputCounter;
    private int fPrompt;

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    public AbstractCLIProcess(ICommandControlService commandControl) throws IOException {
        PipedOutputStream miOutLogPipe;
        LargePipedInputStream miInLogPipe;
        PipedOutputStream miOutConsolePipe;
        LargePipedInputStream miInConsolePipe;
        block2: {
            this.fOutputStream = new CLIOutputStream();
            this.fDisposed = false;
            this.fSuppressConsoleOutputCounter = 0;
            this.fPrompt = 1;
            this.fSession = commandControl.getSession();
            this.fCommandControl = commandControl;
            commandControl.addEventListener((IEventListener)this);
            commandControl.addCommandListener((ICommandListener)this);
            miInConsolePipe = null;
            miOutConsolePipe = null;
            miInLogPipe = null;
            miOutLogPipe = null;
            try {
                miOutConsolePipe = new PipedOutputStream();
                miInConsolePipe = new LargePipedInputStream(miOutConsolePipe);
                miOutLogPipe = new PipedOutputStream();
                miInLogPipe = new LargePipedInputStream(miOutLogPipe);
            }
            catch (IOException e) {
                ILog log = MIPlugin.getDefault().getLog();
                if (log == null) break block2;
                log.log((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", -1, "Error when creating log pipes", (Throwable)e));
            }
        }
        this.fMIOutConsolePipe = miOutConsolePipe;
        this.fMIInConsolePipe = miInConsolePipe;
        this.fMIOutLogPipe = miOutLogPipe;
        this.fMIInLogPipe = miInLogPipe;
    }

    @Deprecated
    public AbstractCLIProcess(AbstractMIControl commandControl) throws IOException {
        this((ICommandControlService)commandControl);
    }

    protected DsfSession getSession() {
        return this.fSession;
    }

    @Deprecated
    protected AbstractMIControl getCommandControl() {
        return (AbstractMIControl)this.fCommandControl;
    }

    protected ICommandControlService getCommandControlService() {
        return this.fCommandControl;
    }

    protected boolean isDisposed() {
        return this.fDisposed;
    }

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    public void dispose() {
        this.fCommandControl.removeEventListener((IEventListener)this);
        this.fCommandControl.removeCommandListener((ICommandListener)this);
        this.closeIO();
        this.fDisposed = true;
    }

    private void closeIO() {
        try {
            this.fMIOutConsolePipe.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.fMIInConsolePipe.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.fMIOutLogPipe.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.fMIInLogPipe.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public InputStream getErrorStream() {
        return this.fMIInLogPipe;
    }

    public InputStream getInputStream() {
        return this.fMIInConsolePipe;
    }

    public OutputStream getOutputStream() {
        return this.fOutputStream;
    }

    public void eventReceived(Object output) {
        if (this.fSuppressConsoleOutputCounter > 0) {
            return;
        }
        for (MIOOBRecord oobr : ((MIOutput)output).getMIOOBRecords()) {
            String str;
            MIStreamRecord out;
            if (oobr instanceof MIConsoleStreamOutput) {
                out = (MIConsoleStreamOutput)oobr;
                str = out.getString();
                this.setPrompt(str);
                try {
                    this.fMIOutConsolePipe.write(str.getBytes());
                    this.fMIOutConsolePipe.flush();
                }
                catch (IOException e) {}
                continue;
            }
            if (!(oobr instanceof MILogStreamOutput) || (str = (out = (MILogStreamOutput)oobr).getString()) == null) continue;
            try {
                this.fMIOutLogPipe.write(str.getBytes());
                this.fMIOutLogPipe.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public void commandQueued(ICommandToken token) {
    }

    public void commandSent(ICommandToken token) {
        ICommand command = token.getCommand();
        if (command instanceof CLICommand && !(command instanceof ProcessCLICommand) && !(command instanceof ProcessMIInterpreterExecConsole)) {
            ++this.fSuppressConsoleOutputCounter;
        }
    }

    public void commandRemoved(ICommandToken token) {
    }

    public void commandDone(ICommandToken token, ICommandResult result) {
        ICommand command = token.getCommand();
        if (token.getCommand() instanceof CLICommand && !(command instanceof ProcessCLICommand) && !(command instanceof ProcessMIInterpreterExecConsole)) {
            --this.fSuppressConsoleOutputCounter;
        }
    }

    void setPrompt(String line) {
        this.fPrompt = 0;
        if (line == null) {
            return;
        }
        if ((line = line.trim()).equals(PRIMARY_PROMPT)) {
            this.fPrompt = 1;
        } else if (line.equals(SECONDARY_PROMPT)) {
            this.fPrompt = 2;
        }
    }

    public boolean inPrimaryPrompt() {
        return this.fPrompt == 1;
    }

    public boolean inSecondaryPrompt() {
        return this.fPrompt == 2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProcessMIInterpreterExecConsole
    extends MIInterpreterExecConsole<MIInfo> {
        public ProcessMIInterpreterExecConsole(IDMContext ctx, String cmd) {
            super(ctx, cmd);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProcessCLICommand
    extends CLICommand<MIInfo> {
        public ProcessCLICommand(IDMContext ctx, String oper) {
            super(ctx, oper);
        }
    }

    private class CLIOutputStream
    extends OutputStream {
        private final StringBuffer buf = new StringBuffer();

        private CLIOutputStream() {
        }

        public void write(int b) throws IOException {
            this.buf.append((char)b);
            if (b == 10) {
                final String bufString = this.buf.toString().trim();
                this.buf.setLength(0);
                try {
                    AbstractCLIProcess.this.fSession.getExecutor().execute((Runnable)new DsfRunnable(){

                        public void run() {
                            try {
                                CLIOutputStream.this.post(bufString);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    });
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
        }

        public void post(String str) throws IOException {
            if (AbstractCLIProcess.this.isDisposed()) {
                return;
            }
            MICommand cmd = null;
            boolean secondary = AbstractCLIProcess.this.inSecondaryPrompt();
            cmd = secondary ? new RawCommand((IDMContext)AbstractCLIProcess.this.getCommandControlService().getContext(), str) : (!CLIEventProcessor.isSteppingOperation(str) ? new ProcessMIInterpreterExecConsole((IDMContext)AbstractCLIProcess.this.getCommandControlService().getContext(), str) : new ProcessCLICommand((IDMContext)AbstractCLIProcess.this.getCommandControlService().getContext(), str));
            final RawCommand finalCmd = cmd;
            AbstractCLIProcess.this.fSession.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    if (AbstractCLIProcess.this.isDisposed()) {
                        return;
                    }
                    AbstractCLIProcess.this.getCommandControlService().queueCommand(finalCmd, null);
                }
            });
        }
    }
}

