/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.provisional.service;

import org.eclipse.dd.dsf.debug.service.AbstractDsfDebugServicesFactory;
import org.eclipse.dd.dsf.debug.service.IBreakpoints;
import org.eclipse.dd.dsf.debug.service.IDisassembly;
import org.eclipse.dd.dsf.debug.service.IExpressions;
import org.eclipse.dd.dsf.debug.service.IMemory;
import org.eclipse.dd.dsf.debug.service.IModules;
import org.eclipse.dd.dsf.debug.service.IProcesses;
import org.eclipse.dd.dsf.debug.service.IRegisters;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.ISourceLookup;
import org.eclipse.dd.dsf.debug.service.IStack;
import org.eclipse.dd.dsf.debug.service.command.ICommandControl;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.gdb.internal.provisional.service.GDBBackend;
import org.eclipse.dd.gdb.internal.provisional.service.GDBMemory_7_0;
import org.eclipse.dd.gdb.internal.provisional.service.GDBProcesses;
import org.eclipse.dd.gdb.internal.provisional.service.GDBProcesses_7_0;
import org.eclipse.dd.gdb.internal.provisional.service.GDBRunControl;
import org.eclipse.dd.gdb.internal.provisional.service.GDBRunControl_7_0;
import org.eclipse.dd.gdb.internal.provisional.service.command.GDBControl;
import org.eclipse.dd.gdb.internal.provisional.service.command.GDBControl_7_0;
import org.eclipse.dd.mi.service.CSourceLookup;
import org.eclipse.dd.mi.service.ExpressionService;
import org.eclipse.dd.mi.service.IMIBackend;
import org.eclipse.dd.mi.service.MIBreakpoints;
import org.eclipse.dd.mi.service.MIBreakpointsManager;
import org.eclipse.dd.mi.service.MIDisassembly;
import org.eclipse.dd.mi.service.MIMemory;
import org.eclipse.dd.mi.service.MIModules;
import org.eclipse.dd.mi.service.MIRegisters;
import org.eclipse.dd.mi.service.MIStack;
import org.eclipse.debug.core.ILaunchConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GdbDebugServicesFactory
extends AbstractDsfDebugServicesFactory {
    private final String fVersion;

    public GdbDebugServicesFactory(String version) {
        this.fVersion = version;
    }

    public String getVersion() {
        return this.fVersion;
    }

    public <V> V createService(Class<V> clazz, DsfSession session, Object ... optionalArguments) {
        block4: {
            block3: {
                if (MIBreakpointsManager.class.isAssignableFrom(clazz)) {
                    return (V)this.createBreakpointManagerService(session);
                }
                if (!ICommandControl.class.isAssignableFrom(clazz)) break block3;
                for (Object arg : optionalArguments) {
                    if (!(arg instanceof ILaunchConfiguration)) continue;
                    return (V)this.createCommandControl(session, (ILaunchConfiguration)arg);
                }
                break block4;
            }
            if (!IMIBackend.class.isAssignableFrom(clazz)) break block4;
            for (Object arg : optionalArguments) {
                if (!(arg instanceof ILaunchConfiguration)) continue;
                return (V)this.createBackendGDBService(session, (ILaunchConfiguration)arg);
            }
        }
        return (V)super.createService(clazz, session, new Object[0]);
    }

    protected MIBreakpointsManager createBreakpointManagerService(DsfSession session) {
        return new MIBreakpointsManager(session, "org.eclipse.cdt.debug.core");
    }

    protected IBreakpoints createBreakpointService(DsfSession session) {
        return new MIBreakpoints(session);
    }

    protected ICommandControl createCommandControl(DsfSession session, ILaunchConfiguration config) {
        if ("6.8".compareTo(this.fVersion) < 0) {
            return new GDBControl_7_0(session, config);
        }
        return new GDBControl(session, config);
    }

    protected IMIBackend createBackendGDBService(DsfSession session, ILaunchConfiguration lc) {
        return new GDBBackend(session, lc);
    }

    protected IDisassembly createDisassemblyService(DsfSession session) {
        return new MIDisassembly(session);
    }

    protected IExpressions createExpressionService(DsfSession session) {
        return new ExpressionService(session);
    }

    protected IMemory createMemoryService(DsfSession session) {
        if ("6.8".compareTo(this.fVersion) < 0) {
            return new GDBMemory_7_0(session);
        }
        return new MIMemory(session);
    }

    protected IModules createModulesService(DsfSession session) {
        return new MIModules(session);
    }

    protected IProcesses createProcessesService(DsfSession session) {
        if (this.fVersion.startsWith("6.8.50.20080730")) {
            return new GDBProcesses_7_0(session);
        }
        return new GDBProcesses(session);
    }

    protected IRegisters createRegistersService(DsfSession session) {
        return new MIRegisters(session);
    }

    protected IRunControl createRunControlService(DsfSession session) {
        if ("6.8".compareTo(this.fVersion) < 0) {
            return new GDBRunControl_7_0(session);
        }
        return new GDBRunControl(session);
    }

    protected ISourceLookup createSourceLookupService(DsfSession session) {
        return new CSourceLookup(session);
    }

    protected IStack createStackService(DsfSession session) {
        return new MIStack(session);
    }
}

