/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.ui.actions;

import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.core.IProcessInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dd.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.Query;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IProcesses;
import org.eclipse.dd.dsf.debug.service.command.ICommandControlService;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.gdb.internal.provisional.actions.IConnect;
import org.eclipse.dd.gdb.internal.provisional.launching.LaunchMessages;
import org.eclipse.dd.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.dd.gdb.internal.ui.actions.ProcessInfo;
import org.eclipse.dd.mi.service.IMIProcesses;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;

public class GdbConnectCommand
implements IConnect {
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;

    public GdbConnectCommand(DsfSession session) {
        this.fExecutor = session.getExecutor();
        this.fTracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), session.getId());
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    public boolean canConnect() {
        Query<Boolean> canConnectQuery = new Query<Boolean>(){

            public void execute(DataRequestMonitor<Boolean> rm) {
                IProcesses procService = (IProcesses)GdbConnectCommand.this.fTracker.getService(IProcesses.class);
                ICommandControlService commandControl = (ICommandControlService)GdbConnectCommand.this.fTracker.getService(ICommandControlService.class);
                if (procService != null && commandControl != null) {
                    procService.isDebuggerAttachSupported((IDMContext)commandControl.getContext(), rm);
                } else {
                    rm.setData((Object)false);
                    rm.done();
                }
            }
        };
        try {
            this.fExecutor.execute((Runnable)canConnectQuery);
            return (Boolean)canConnectQuery.get();
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException e) {
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        return false;
    }

    public void connect(RequestMonitor requestMonitor) {
        final RequestMonitor rm = requestMonitor == null ? new RequestMonitor((Executor)this.fExecutor, null) : requestMonitor;
        this.fExecutor.execute((Runnable)new DsfRunnable(){

            public void run() {
                IProcesses procService = (IProcesses)GdbConnectCommand.this.fTracker.getService(IProcesses.class);
                ICommandControlService commandControl = (ICommandControlService)GdbConnectCommand.this.fTracker.getService(ICommandControlService.class);
                if (procService != null && commandControl != null) {
                    final ICommandControlService.ICommandControlDMContext controlCtx = commandControl.getContext();
                    procService.getRunningProcesses((IDMContext)controlCtx, (DataRequestMonitor)new DataRequestMonitor<IProcesses.IProcessDMContext[]>((Executor)GdbConnectCommand.this.fExecutor, rm){

                        protected void handleSuccess() {
                            final ArrayList procInfoList = new ArrayList();
                            final CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)GdbConnectCommand.this.fExecutor, rm){

                                protected void handleSuccess() {
                                    new PromptForPidJob("Prompt for Process", procInfoList.toArray(new IProcessInfo[0]), new DataRequestMonitor<Integer>((Executor)GdbConnectCommand.this.fExecutor, rm){

                                        protected void handleSuccess() {
                                            IMIProcesses procService = (IMIProcesses)GdbConnectCommand.this.fTracker.getService(IMIProcesses.class);
                                            if (procService != null) {
                                                IProcesses.IProcessDMContext procDmc = procService.createProcessContext(controlCtx, Integer.toString((Integer)this.getData()));
                                                procService.attachDebuggerToProcess(procDmc, new DataRequestMonitor((Executor)GdbConnectCommand.this.fExecutor, rm));
                                            }
                                        }
                                    }).schedule();
                                }
                            };
                            IProcesses procService = (IProcesses)GdbConnectCommand.this.fTracker.getService(IProcesses.class);
                            if (procService != null) {
                                countingRm.setDoneCount(((IProcesses.IProcessDMContext[])this.getData()).length);
                                for (IProcesses.IProcessDMContext processCtx : (IProcesses.IProcessDMContext[])this.getData()) {
                                    procService.getExecutionData((IProcesses.IThreadDMContext)processCtx, (DataRequestMonitor)new DataRequestMonitor<IProcesses.IThreadDMData>((Executor)GdbConnectCommand.this.fExecutor, (RequestMonitor)countingRm){

                                        protected void handleSuccess() {
                                            int pid = 0;
                                            try {
                                                pid = Integer.parseInt(((IProcesses.IThreadDMData)this.getData()).getId());
                                            }
                                            catch (NumberFormatException numberFormatException) {
                                                // empty catch block
                                            }
                                            procInfoList.add(new ProcessInfo(pid, ((IProcesses.IThreadDMData)this.getData()).getName()));
                                            countingRm.done();
                                        }
                                    });
                                }
                            } else {
                                countingRm.setDoneCount(1);
                                countingRm.done();
                            }
                        }
                    });
                } else {
                    rm.done();
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PromptForPidJob
    extends Job {
        IProcessInfo[] fProcessList;
        DataRequestMonitor<Integer> fRequestMonitor;

        public PromptForPidJob(String name, IProcessInfo[] procs, DataRequestMonitor<Integer> rm) {
            super(name);
            this.fProcessList = null;
            this.fProcessList = procs;
            this.fRequestMonitor = rm;
        }

        protected IStatus run(IProgressMonitor monitor) {
            Status promptStatus = new Status(1, "org.eclipse.debug.ui", 200, "", null);
            Status processPromptStatus = new Status(1, "org.eclipse.dd.gdb.ui", 100, "", null);
            IStatusHandler prompter = DebugPlugin.getDefault().getStatusHandler((IStatus)promptStatus);
            Status NO_PID_STATUS = new Status(4, "org.eclipse.dd.gdb.ui", -1, LaunchMessages.getString((String)"LocalAttachLaunchDelegate.No_Process_ID_selected"), null);
            if (prompter == null) {
                this.fRequestMonitor.setStatus((IStatus)NO_PID_STATUS);
                this.fRequestMonitor.done();
                return Status.OK_STATUS;
            }
            try {
                Object result = prompter.handleStatus((IStatus)processPromptStatus, (Object)this.fProcessList);
                if (result instanceof Integer) {
                    this.fRequestMonitor.setData((Object)((Integer)result));
                } else {
                    this.fRequestMonitor.setStatus((IStatus)NO_PID_STATUS);
                }
            }
            catch (CoreException e) {
                this.fRequestMonitor.setStatus((IStatus)NO_PID_STATUS);
            }
            this.fRequestMonitor.done();
            return Status.OK_STATUS;
        }
    }
}

