/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.gdb.internal.ui.breakpoints;

import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.ImmediateExecutor;
import org.eclipse.dd.dsf.concurrent.Query;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IProcesses;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.command.ICommandControlService;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.gdb.internal.provisional.breakpoints.CBreakpointGdbThreadsFilterExtension;
import org.eclipse.dd.gdb.internal.provisional.launching.GdbLaunch;
import org.eclipse.dd.gdb.internal.provisional.service.command.IGDBControl;
import org.eclipse.dd.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.dd.gdb.internal.ui.breakpoints.CBreakpointGdbThreadFilterPage;
import org.eclipse.dd.mi.service.IMIContainerDMContext;
import org.eclipse.dd.mi.service.IMIExecutionDMContext;
import org.eclipse.dd.mi.service.IMIProcesses;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.osgi.util.tracker.ServiceTracker;

public class GdbThreadFilterEditor {
    private CBreakpointGdbThreadFilterPage fPage;
    private CheckboxTreeViewer fThreadViewer;
    private ThreadFilterContentProvider fContentProvider;
    private CheckHandler fCheckHandler;

    public GdbThreadFilterEditor(Composite parent, CBreakpointGdbThreadFilterPage page) {
        this.fPage = page;
        this.fContentProvider = new ThreadFilterContentProvider();
        this.fCheckHandler = new CheckHandler();
        this.createThreadViewer(parent);
    }

    protected CBreakpointGdbThreadFilterPage getPage() {
        return this.fPage;
    }

    private void createThreadViewer(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("&Restrict to Selected Targets and Threads:");
        label.setFont(parent.getFont());
        label.setLayoutData((Object)new GridData());
        GridData data = new GridData(1808);
        data.heightHint = 100;
        this.fThreadViewer = new CheckboxTreeViewer(parent, 2048);
        this.fThreadViewer.addCheckStateListener((ICheckStateListener)this.fCheckHandler);
        this.fThreadViewer.getTree().setLayoutData((Object)data);
        this.fThreadViewer.getTree().setFont(parent.getFont());
        this.fThreadViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fThreadViewer.setLabelProvider((IBaseLabelProvider)new ThreadFilterLabelProvider());
        this.fThreadViewer.setInput((Object)DebugPlugin.getDefault().getLaunchManager());
        this.setInitialCheckedState();
    }

    protected IRunControl.IContainerDMContext[] getDebugTargets() {
        Object input = this.fThreadViewer.getInput();
        if (!(input instanceof ILaunchManager)) {
            return new IRunControl.IContainerDMContext[0];
        }
        ArrayList<IRunControl.IContainerDMContext> targets = new ArrayList<IRunControl.IContainerDMContext>();
        ILaunch[] launches = ((ILaunchManager)input).getLaunches();
        for (int i = 0; i < launches.length; ++i) {
            IRunControl.IContainerDMContext target;
            if (!(launches[i] instanceof GdbLaunch) || (target = this.syncGetContainer((GdbLaunch)launches[i])) == null) continue;
            targets.add(target);
        }
        return targets.toArray(new IRunControl.IContainerDMContext[targets.size()]);
    }

    protected CheckboxTreeViewer getThreadViewer() {
        return this.fThreadViewer;
    }

    protected void setInitialCheckedState() {
        CBreakpointGdbThreadsFilterExtension filterExtension = this.fPage.getFilterExtension();
        try {
            IRunControl.IContainerDMContext[] targets = filterExtension.getTargetFilters();
            if (targets.length == 0) {
                for (IRunControl.IContainerDMContext target : targets = this.getDebugTargets()) {
                    filterExtension.setTargetFilter(target);
                }
            }
            for (int i = 0; i < targets.length; ++i) {
                IRunControl.IExecutionDMContext[] filteredThreads = filterExtension.getThreadFilters(targets[i]);
                if (filteredThreads != null) {
                    for (int j = 0; j < filteredThreads.length; ++j) {
                        this.fCheckHandler.checkThread(filteredThreads[j], true);
                    }
                    continue;
                }
                this.fCheckHandler.checkTarget(targets[i], true);
            }
        }
        catch (CoreException e) {
            CDebugUIPlugin.log((Throwable)e);
        }
    }

    protected void doStore() {
        CBreakpointGdbThreadsFilterExtension filterExtension = this.fPage.getFilterExtension();
        IRunControl.IContainerDMContext[] targets = this.getDebugTargets();
        for (int i = 0; i < targets.length; ++i) {
            try {
                if (this.getThreadViewer().getChecked((Object)targets[i])) {
                    if (this.getThreadViewer().getGrayed((Object)targets[i])) {
                        IRunControl.IExecutionDMContext[] threads = this.getTargetThreadFilters(targets[i]);
                        filterExtension.setThreadFilters(threads);
                    } else {
                        filterExtension.setTargetFilter(targets[i]);
                    }
                } else {
                    filterExtension.removeTargetFilter(targets[i]);
                }
                DebugPlugin.getDefault().getBreakpointManager().fireBreakpointChanged((IBreakpoint)this.fPage.getBreakpoint());
                continue;
            }
            catch (CoreException e) {
                CDebugUIPlugin.log((Throwable)e);
            }
        }
    }

    private IRunControl.IExecutionDMContext[] getTargetThreadFilters(IRunControl.IContainerDMContext target) {
        Object[] threads = ((ITreeContentProvider)this.getThreadViewer().getContentProvider()).getChildren((Object)target);
        ArrayList<Object> list = new ArrayList<Object>(threads.length);
        for (int i = 0; i < threads.length; ++i) {
            if (!this.getThreadViewer().getChecked(threads[i])) continue;
            list.add(threads[i]);
        }
        return list.toArray(new IRunControl.IExecutionDMContext[list.size()]);
    }

    private IRunControl.IContainerDMContext syncGetContainer(GdbLaunch launch) {
        final DsfSession session = launch.getSession();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ContainerQuery
        extends Query<IRunControl.IContainerDMContext> {
            ContainerQuery() {
            }

            protected void execute(DataRequestMonitor<IRunControl.IContainerDMContext> rm) {
                if (!session.isActive()) {
                    rm.setStatus((IStatus)GdbThreadFilterEditor.this.getFailStatus(10001, "Launch's session not active."));
                    rm.done();
                    return;
                }
                ServiceTracker tracker1 = new ServiceTracker(GdbUIPlugin.getBundleContext(), ICommandControlService.class.getName(), null);
                tracker1.open();
                ICommandControlService commandControl = (ICommandControlService)tracker1.getService();
                ServiceTracker tracker2 = new ServiceTracker(GdbUIPlugin.getBundleContext(), IMIProcesses.class.getName(), null);
                tracker2.open();
                IMIProcesses procService = (IMIProcesses)tracker2.getService();
                if (commandControl != null && procService != null) {
                    IProcesses.IProcessDMContext procDmc = procService.createProcessContext(commandControl.getContext(), "");
                    IMIContainerDMContext containerDmc = procService.createContainerContext(procDmc, "");
                    rm.setData((Object)containerDmc);
                } else {
                    rm.setStatus((IStatus)GdbThreadFilterEditor.this.getFailStatus(10001, "GDB Control or Process service not accessible."));
                }
                rm.done();
                tracker1.close();
                tracker2.close();
            }
        }
        ContainerQuery query = new ContainerQuery();
        try {
            session.getExecutor().execute((Runnable)((Object)query));
            return (IRunControl.IContainerDMContext)query.get();
        }
        catch (RejectedExecutionException e) {
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException e) {
            // empty catch block
        }
        return null;
    }

    private IRunControl.IExecutionDMContext[] syncGetThreads(final IRunControl.IContainerDMContext container) {
        final DsfSession session = DsfSession.getSession((String)container.getSessionId());
        if (session == null) {
            return new IRunControl.IExecutionDMContext[0];
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ThreadsQuery
        extends Query<IRunControl.IExecutionDMContext[]> {
            ThreadsQuery() {
            }

            protected void execute(DataRequestMonitor<IRunControl.IExecutionDMContext[]> rm) {
                if (!session.isActive()) {
                    rm.setStatus((IStatus)GdbThreadFilterEditor.this.getFailStatus(10001, "Container's session not active."));
                    rm.done();
                    return;
                }
                ServiceTracker tracker = new ServiceTracker(GdbUIPlugin.getBundleContext(), IRunControl.class.getName(), null);
                tracker.open();
                IRunControl runControl = (IRunControl)tracker.getService();
                if (runControl != null) {
                    runControl.getExecutionContexts(container, rm);
                } else {
                    rm.setStatus((IStatus)GdbThreadFilterEditor.this.getFailStatus(10001, "GDB Control not accessible."));
                    rm.done();
                }
                tracker.close();
            }
        }
        ThreadsQuery query = new ThreadsQuery();
        try {
            session.getExecutor().execute((Runnable)((Object)query));
            return (IRunControl.IExecutionDMContext[])query.get();
        }
        catch (RejectedExecutionException e) {
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException e) {
            // empty catch block
        }
        return new IRunControl.IExecutionDMContext[0];
    }

    private String syncGetContainerLabel(IRunControl.IContainerDMContext container) {
        final DsfSession session = DsfSession.getSession((String)container.getSessionId());
        if (session == null) {
            return "Error reading data";
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ContainerLabelQuery
        extends Query<String> {
            ContainerLabelQuery() {
            }

            protected void execute(DataRequestMonitor<String> rm) {
                if (!session.isActive()) {
                    rm.setStatus((IStatus)GdbThreadFilterEditor.this.getFailStatus(10001, "Container's session not active."));
                    rm.done();
                    return;
                }
                ServiceTracker tracker = new ServiceTracker(GdbUIPlugin.getBundleContext(), IGDBControl.class.getName(), null);
                tracker.open();
                IGDBControl gdbControl = (IGDBControl)tracker.getService();
                if (gdbControl != null) {
                    rm.setData((Object)gdbControl.getExecutablePath().toOSString());
                } else {
                    rm.setStatus((IStatus)GdbThreadFilterEditor.this.getFailStatus(10001, "GDB Control not accessible."));
                }
                rm.done();
                tracker.close();
            }
        }
        ContainerLabelQuery query = new ContainerLabelQuery();
        try {
            session.getExecutor().execute((Runnable)((Object)query));
            return (String)query.get();
        }
        catch (RejectedExecutionException e) {
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException e) {
            // empty catch block
        }
        return "Error reading data";
    }

    private String syncGetThreadLabel(final IRunControl.IExecutionDMContext thread) {
        final DsfSession session = DsfSession.getSession((String)thread.getSessionId());
        if (session == null) {
            return "Error reading data";
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ThreadLabelQuery
        extends Query<String> {
            ThreadLabelQuery() {
            }

            protected void execute(final DataRequestMonitor<String> rm) {
                if (!session.isActive()) {
                    rm.setStatus((IStatus)GdbThreadFilterEditor.this.getFailStatus(10001, "Container's session not active."));
                    rm.done();
                    return;
                }
                ServiceTracker tracker = new ServiceTracker(GdbUIPlugin.getBundleContext(), IProcesses.class.getName(), null);
                tracker.open();
                IProcesses procService = (IProcesses)tracker.getService();
                if (procService != null) {
                    IProcesses.IThreadDMContext threadDmc = (IProcesses.IThreadDMContext)DMContexts.getAncestorOfType((IDMContext)thread, IProcesses.IThreadDMContext.class);
                    procService.getExecutionData(threadDmc, (DataRequestMonitor)new DataRequestMonitor<IProcesses.IThreadDMData>(ImmediateExecutor.getInstance(), rm){

                        protected void handleSuccess() {
                            StringBuilder builder = new StringBuilder("Thread[");
                            builder.append(((IMIExecutionDMContext)thread).getThreadId());
                            builder.append("] ");
                            builder.append(((IProcesses.IThreadDMData)this.getData()).getId());
                            builder.append(((IProcesses.IThreadDMData)this.getData()).getName());
                            rm.setData((Object)builder.toString());
                            rm.done();
                        }
                    });
                } else {
                    rm.setStatus((IStatus)GdbThreadFilterEditor.this.getFailStatus(10001, "IProcesses service not accessible."));
                    rm.done();
                }
                tracker.close();
            }
        }
        ThreadLabelQuery query = new ThreadLabelQuery();
        try {
            session.getExecutor().execute((Runnable)((Object)query));
            return (String)query.get();
        }
        catch (RejectedExecutionException e) {
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException e) {
            // empty catch block
        }
        return "Error reading data";
    }

    private Status getFailStatus(int code, String message) {
        return new Status(4, "org.eclipse.dd.gdb.ui", code, message, null);
    }

    public class CheckHandler
    implements ICheckStateListener {
        public void checkStateChanged(CheckStateChangedEvent event) {
            Object element = event.getElement();
            if (element instanceof IRunControl.IContainerDMContext) {
                this.checkTarget((IRunControl.IContainerDMContext)element, event.getChecked());
            } else if (element instanceof IRunControl.IExecutionDMContext) {
                this.checkThread((IRunControl.IExecutionDMContext)element, event.getChecked());
            }
        }

        protected void checkTarget(IRunControl.IContainerDMContext target, boolean checked) {
            GdbThreadFilterEditor.this.getThreadViewer().setChecked((Object)target, checked);
            GdbThreadFilterEditor.this.getThreadViewer().setGrayed((Object)target, false);
            GdbThreadFilterEditor.this.getThreadViewer().expandToLevel((Object)target, -1);
            IRunControl.IExecutionDMContext[] threads = GdbThreadFilterEditor.this.syncGetThreads(target);
            for (int i = 0; i < threads.length; ++i) {
                GdbThreadFilterEditor.this.getThreadViewer().setChecked((Object)threads[i], checked);
                GdbThreadFilterEditor.this.getThreadViewer().setGrayed((Object)threads[i], false);
            }
        }

        protected void checkThread(IRunControl.IExecutionDMContext thread, boolean checked) {
            GdbThreadFilterEditor.this.getThreadViewer().setChecked((Object)thread, checked);
            IRunControl.IContainerDMContext target = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)thread, IRunControl.IContainerDMContext.class);
            IRunControl.IExecutionDMContext[] threads = GdbThreadFilterEditor.this.syncGetThreads(target);
            int checkedNumber = 0;
            for (int i = 0; i < threads.length; ++i) {
                if (!GdbThreadFilterEditor.this.getThreadViewer().getChecked((Object)threads[i])) continue;
                ++checkedNumber;
            }
            if (checkedNumber == 0) {
                GdbThreadFilterEditor.this.getThreadViewer().setChecked((Object)target, false);
                GdbThreadFilterEditor.this.getThreadViewer().setGrayed((Object)target, false);
            } else if (checkedNumber == threads.length) {
                GdbThreadFilterEditor.this.getThreadViewer().setChecked((Object)target, true);
                GdbThreadFilterEditor.this.getThreadViewer().setGrayed((Object)target, false);
            } else {
                GdbThreadFilterEditor.this.getThreadViewer().setGrayChecked((Object)target, true);
            }
        }
    }

    public class ThreadFilterContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object parent) {
            if (parent instanceof IRunControl.IContainerDMContext) {
                return GdbThreadFilterEditor.this.syncGetThreads((IRunControl.IContainerDMContext)parent);
            }
            if (parent instanceof ILaunchManager) {
                ArrayList<IRunControl.IContainerDMContext> children = new ArrayList<IRunControl.IContainerDMContext>();
                ILaunch[] launches = ((ILaunchManager)parent).getLaunches();
                for (int i = 0; i < launches.length; ++i) {
                    IRunControl.IContainerDMContext target;
                    if (!(launches[i] instanceof GdbLaunch) || (target = GdbThreadFilterEditor.this.syncGetContainer((GdbLaunch)launches[i])) == null) continue;
                    children.add(target);
                }
                return children.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IRunControl.IContainerDMContext) {
                return DebugPlugin.getDefault().getLaunchManager();
            }
            if (element instanceof IRunControl.IExecutionDMContext) {
                return DMContexts.getAncestorOfType((IDMContext)((IRunControl.IExecutionDMContext)element), IRunControl.IContainerDMContext.class);
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class ThreadFilterLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            if (element instanceof IRunControl.IContainerDMContext) {
                return DebugUITools.getImage((String)"IMG_OBJS_DEBUG_TARGET");
            }
            return DebugUITools.getImage((String)"IMG_OBJS_THREAD_RUNNING");
        }

        public String getText(Object element) {
            if (element instanceof IRunControl.IContainerDMContext) {
                return GdbThreadFilterEditor.this.syncGetContainerLabel((IRunControl.IContainerDMContext)element);
            }
            return GdbThreadFilterEditor.this.syncGetThreadLabel((IRunControl.IExecutionDMContext)element);
        }
    }
}

