/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.debug.memory.renderings.actions;

import java.io.File;
import java.math.BigInteger;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public class ExportMemoryDialog
extends SelectionDialog {
    private Combo formatCombo;
    private IMemoryBlock fMemoryBlock;
    private Text startText;
    private Text endText;
    private Text lengthText;
    private Text fileText;

    public ExportMemoryDialog(Shell parent, IMemoryBlock memoryBlock) {
        super(parent);
        super.setTitle("Export Memory");
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fMemoryBlock = memoryBlock;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.validate();
    }

    public Object[] getResult() {
        Object[] results = super.getResult();
        if (results != null) {
            return results;
        }
        return new Object[0];
    }

    protected void cancelPressed() {
        this.setResult(null);
        super.cancelPressed();
    }

    protected void okPressed() {
        this.setSelectionResult(new Object[]{this.getFormat(), this.getStartAddress(), this.getEndAddress(), this.getLength(), this.getFile()});
        super.okPressed();
    }

    public String getFormat() {
        return this.formatCombo.getItem(this.formatCombo.getSelectionIndex());
    }

    public BigInteger getEndAddress() {
        String text = this.endText.getText();
        boolean hex = text.startsWith("0x");
        BigInteger endAddress = new BigInteger(hex ? text.substring(2) : text, hex ? 16 : 10);
        return endAddress;
    }

    public BigInteger getStartAddress() {
        String text = this.startText.getText();
        boolean hex = text.startsWith("0x");
        BigInteger startAddress = new BigInteger(hex ? text.substring(2) : text, hex ? 16 : 10);
        return startAddress;
    }

    public BigInteger getLength() {
        String text = this.lengthText.getText();
        boolean hex = text.startsWith("0x");
        BigInteger lengthAddress = new BigInteger(hex ? text.substring(2) : text, hex ? 16 : 10);
        return lengthAddress;
    }

    public File getFile() {
        return new File(this.fileText.getText());
    }

    private void validate() {
        boolean isValid = true;
        try {
            this.getEndAddress();
            this.getStartAddress();
            BigInteger length = this.getLength();
            if (length.compareTo(BigInteger.ZERO) <= 0) {
                isValid = false;
            }
            if (!this.getFile().getParentFile().exists()) {
                isValid = false;
            }
        }
        catch (Exception e) {
            isValid = false;
        }
        this.getButton(0).setEnabled(isValid);
    }

    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, DebugUIPlugin.getUniqueIdentifier() + ".AddMemoryRenderingDialog_context");
        Composite composite = new Composite(parent, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.spacing = 5;
        formLayout.marginHeight = 9;
        formLayout.marginWidth = 9;
        composite.setLayout((Layout)formLayout);
        Label textLabel = new Label(composite, 0);
        textLabel.setText("Format: ");
        this.formatCombo = new Combo(composite, 2056);
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.formatCombo, 0, 0x1000000);
        textLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)textLabel);
        this.formatCombo.setLayoutData((Object)data);
        this.formatCombo.setItems(new String[]{"S-Record"});
        this.formatCombo.select(0);
        Label startLabel = new Label(composite, 0);
        startLabel.setText("Start address: ");
        data = new FormData();
        data.top = new FormAttachment((Control)this.formatCombo);
        startLabel.setLayoutData((Object)data);
        this.startText = new Text(composite, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)this.formatCombo);
        data.left = new FormAttachment((Control)startLabel);
        data.width = 100;
        this.startText.setLayoutData((Object)data);
        Label endLabel = new Label(composite, 0);
        endLabel.setText("End address: ");
        data = new FormData();
        data.top = new FormAttachment((Control)this.startText, 0, 0x1000000);
        data.left = new FormAttachment((Control)this.startText);
        endLabel.setLayoutData((Object)data);
        this.endText = new Text(composite, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)this.startText, 0, 0x1000000);
        data.left = new FormAttachment((Control)endLabel);
        data.width = 100;
        this.endText.setLayoutData((Object)data);
        Label lengthLabel = new Label(composite, 0);
        lengthLabel.setText("Length: ");
        data = new FormData();
        data.top = new FormAttachment((Control)this.startText, 0, 0x1000000);
        data.left = new FormAttachment((Control)this.endText);
        lengthLabel.setLayoutData((Object)data);
        this.lengthText = new Text(composite, 0);
        data = new FormData();
        data.top = new FormAttachment((Control)this.startText, 0, 0x1000000);
        data.left = new FormAttachment((Control)lengthLabel);
        data.width = 100;
        this.lengthText.setLayoutData((Object)data);
        Label fileLabel = new Label(composite, 0);
        this.fileText = new Text(composite, 0);
        Button fileButton = new Button(composite, 8);
        fileLabel.setText("File name: ");
        data = new FormData();
        data.top = new FormAttachment((Control)fileButton, 0, 0x1000000);
        fileLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)fileButton, 0, 0x1000000);
        data.left = new FormAttachment((Control)fileLabel);
        data.width = 300;
        this.fileText.setLayoutData((Object)data);
        fileButton.setText("Browse...");
        data = new FormData();
        data.top = new FormAttachment((Control)this.lengthText);
        data.left = new FormAttachment((Control)this.fileText);
        fileButton.setLayoutData((Object)data);
        try {
            BigInteger startAddress = null;
            startAddress = this.fMemoryBlock instanceof IMemoryBlockExtension ? ((IMemoryBlockExtension)this.fMemoryBlock).getBigBaseAddress() : BigInteger.valueOf(this.fMemoryBlock.getStartAddress());
            this.startText.setText("0x" + startAddress.toString(16));
            this.endText.setText("0x" + startAddress.toString(16));
            this.lengthText.setText("0");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        fileButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ExportMemoryDialog.this.getShell(), 8192);
                dialog.setText("Choose memory export file");
                dialog.setFilterExtensions(new String[]{"*.*"});
                dialog.setFilterNames(new String[]{"All Files (*.*)"});
                dialog.setFileName(ExportMemoryDialog.this.fileText.getText());
                dialog.open();
                if (dialog.getFileName() != null) {
                    ExportMemoryDialog.this.fileText.setText(dialog.getFilterPath() + File.separator + dialog.getFileName());
                }
                ExportMemoryDialog.this.validate();
            }
        });
        this.startText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean valid = true;
                try {
                    ExportMemoryDialog.this.getStartAddress();
                }
                catch (Exception ex) {
                    valid = false;
                }
                ExportMemoryDialog.this.startText.setForeground(valid ? Display.getDefault().getSystemColor(2) : Display.getDefault().getSystemColor(3));
                BigInteger endAddress = ExportMemoryDialog.this.getEndAddress();
                BigInteger startAddress = ExportMemoryDialog.this.getStartAddress();
                ExportMemoryDialog.this.lengthText.setText(endAddress.subtract(startAddress).toString());
                ExportMemoryDialog.this.validate();
            }
        });
        this.endText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    ExportMemoryDialog.this.getEndAddress();
                    ExportMemoryDialog.this.endText.setForeground(Display.getDefault().getSystemColor(2));
                    BigInteger endAddress = ExportMemoryDialog.this.getEndAddress();
                    BigInteger startAddress = ExportMemoryDialog.this.getStartAddress();
                    String lengthString = endAddress.subtract(startAddress).toString();
                    if (!ExportMemoryDialog.this.lengthText.getText().equals(lengthString)) {
                        ExportMemoryDialog.this.lengthText.setText(lengthString);
                    }
                }
                catch (Exception ex) {
                    ExportMemoryDialog.this.endText.setForeground(Display.getDefault().getSystemColor(3));
                }
                ExportMemoryDialog.this.validate();
            }
        });
        this.lengthText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    BigInteger length = ExportMemoryDialog.this.getLength();
                    ExportMemoryDialog.this.lengthText.setForeground(Display.getDefault().getSystemColor(2));
                    BigInteger startAddress = ExportMemoryDialog.this.getStartAddress();
                    String endString = "0x" + startAddress.add(length).toString(16);
                    if (!ExportMemoryDialog.this.endText.getText().equals(endString)) {
                        ExportMemoryDialog.this.endText.setText(endString);
                    }
                }
                catch (Exception ex) {
                    ExportMemoryDialog.this.lengthText.setForeground(Display.getDefault().getSystemColor(3));
                }
                ExportMemoryDialog.this.validate();
            }
        });
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportMemoryDialog.this.validate();
            }
        });
        return composite;
    }
}

