/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.debug.memory.renderings.traditional;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.debug.memory.renderings.traditional.AbstractPane;
import org.eclipse.dd.debug.memory.renderings.traditional.AddressPane;
import org.eclipse.dd.debug.memory.renderings.traditional.DataPane;
import org.eclipse.dd.debug.memory.renderings.traditional.IMemorySelection;
import org.eclipse.dd.debug.memory.renderings.traditional.TextPane;
import org.eclipse.dd.debug.memory.renderings.traditional.TraditionalRendering;
import org.eclipse.dd.debug.memory.renderings.traditional.TraditionalRenderingMessages;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.renderings.GoToAddressComposite;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;

public class Rendering
extends Composite
implements IDebugEventSetListener {
    private TraditionalRendering fParent;
    private AddressPane fAddressPane;
    private DataPane fBinaryPane;
    private TextPane fTextPane;
    private GoToAddressComposite fAddressBar;
    private Control fAddressBarControl;
    private Selection fSelection = new Selection();
    BigInteger fViewportAddress = null;
    BigInteger fMemoryBlockStartAddress = null;
    BigInteger fMemoryBlockEndAddress = null;
    protected BigInteger fBaseAddress = null;
    private int fColumnCount = 0;
    private int fBytesPerRow = 0;
    private int fCurrentScrollSelection = 0;
    private BigInteger fCaretAddress = BigInteger.valueOf(0L);
    private int fTextMode = 1;
    private int fBytesPerColumn = 4;
    private int fRadix = 1;
    private int fColumnsSetting = 0;
    private boolean fIsTargetLittleEndian = false;
    private boolean fIsDisplayLittleEndian = false;
    public static final int RADIX_HEX = 1;
    public static final int RADIX_DECIMAL_SIGNED = 2;
    public static final int RADIX_DECIMAL_UNSIGNED = 3;
    public static final int RADIX_OCTAL = 4;
    public static final int RADIX_BINARY = 5;
    public static final int PANE_ADDRESS = 1;
    public static final int PANE_BINARY = 2;
    public static final int PANE_TEXT = 3;
    public static final int TEXT_ISO_8859_1 = 1;
    public static final int TEXT_USASCII = 2;
    public static final int TEXT_UTF8 = 3;
    protected static final int TEXT_UTF16 = 4;
    public static final int COLUMNS_AUTO_SIZE_TO_FIT = 0;
    private int fCellPadding = 2;
    private int fPaneSpacing = 16;
    private boolean fCacheDirty = false;
    static int suspendCount = 0;
    ViewportCache fViewportCache = new ViewportCache();
    static final char[] hexdigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public Rendering(Composite parent, TraditionalRendering renderingParent) {
        super(parent, 537133824);
        this.setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.MemoryViewTableFont"));
        this.fParent = renderingParent;
        if (this.fParent.getMemoryBlock() != null) {
            this.fViewportAddress = this.fParent.getMemoryBlockStartAddress();
            if (this.fViewportAddress == null) {
                this.fViewportAddress = this.fParent.getBigBaseAddress();
            }
            this.fBaseAddress = this.fViewportAddress;
        }
        this.fAddressPane = this.createAddressPane();
        this.fBinaryPane = this.createDataPane();
        this.fTextPane = this.createTextPane();
        this.fAddressBar = new GoToAddressComposite();
        this.fAddressBarControl = this.fAddressBar.createControl(parent);
        Button button = this.fAddressBar.getButton(0);
        if (button != null) {
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Rendering.this.doGoToAddress();
                }
            });
            button = this.fAddressBar.getButton(1);
            if (button != null) {
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Rendering.this.setVisibleAddressBar(false);
                    }
                });
            }
        }
        this.fAddressBar.getExpressionWidget().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                Rendering.this.doGoToAddress();
            }
        });
        this.fAddressBar.getExpressionWidget().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    Rendering.this.setVisibleAddressBar(false);
                }
                super.keyPressed(e);
            }
        });
        this.fAddressBarControl.setVisible(false);
        this.getHorizontalBar().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent se) {
                Rendering.this.layout();
            }

            public void widgetDefaultSelected(SelectionEvent se) {
            }
        });
        this.getVerticalBar().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent se) {
                int addressableSize = Rendering.this.getAddressableSize();
                switch (se.detail) {
                    case 0x1000002: {
                        Rendering.this.fViewportAddress = Rendering.this.fViewportAddress.add(BigInteger.valueOf(Rendering.this.getAddressableCellsPerRow()));
                        Rendering.this.ensureViewportAddressDisplayable();
                        Rendering.this.redrawPanes();
                        break;
                    }
                    case 0x1000006: {
                        Rendering.this.fViewportAddress = Rendering.this.fViewportAddress.add(BigInteger.valueOf(Rendering.this.getAddressableCellsPerRow() * (Rendering.this.getRowCount() - 1)));
                        Rendering.this.ensureViewportAddressDisplayable();
                        Rendering.this.redrawPanes();
                        break;
                    }
                    case 0x1000001: {
                        Rendering.this.fViewportAddress = Rendering.this.fViewportAddress.subtract(BigInteger.valueOf(Rendering.this.getAddressableCellsPerRow()));
                        Rendering.this.ensureViewportAddressDisplayable();
                        Rendering.this.redrawPanes();
                        break;
                    }
                    case 0x1000005: {
                        Rendering.this.fViewportAddress = Rendering.this.fViewportAddress.subtract(BigInteger.valueOf(Rendering.this.getAddressableCellsPerRow() * (Rendering.this.getRowCount() - 1)));
                        Rendering.this.ensureViewportAddressDisplayable();
                        Rendering.this.redrawPanes();
                        break;
                    }
                    case 1: {
                        if (Rendering.this.getVerticalBar().getSelection() == Rendering.this.getVerticalBar().getMinimum()) {
                            Rendering.this.fViewportAddress = Rendering.this.getMemoryBlockStartAddress();
                        } else if (Rendering.this.getVerticalBar().getSelection() == Rendering.this.getVerticalBar().getMaximum()) {
                            Rendering.this.fViewportAddress = Rendering.this.getMemoryBlockEndAddress();
                        } else {
                            int delta = Rendering.this.getVerticalBar().getSelection() - Rendering.this.fCurrentScrollSelection;
                            Rendering.this.fViewportAddress = Rendering.this.fViewportAddress.add(BigInteger.valueOf(Rendering.this.getAddressableCellsPerRow() * delta));
                        }
                        Rendering.this.ensureViewportAddressDisplayable();
                        if (!Rendering.this.fAddressPane.isPaneVisible()) break;
                        Rendering.this.fAddressPane.redraw();
                        break;
                    }
                    case 0: {
                        Rendering.this.redrawPanes();
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent se) {
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent pe) {
                pe.gc.setBackground(Rendering.this.getTraditionalRendering().getColorBackground());
                pe.gc.fillRectangle(0, 0, Rendering.this.getBounds().width, Rendering.this.getBounds().height);
            }
        });
        this.setLayout(new Layout(){

            public void layout(Composite composite, boolean changed) {
                int xOffset = 0;
                if (Rendering.this.getHorizontalBar().isVisible()) {
                    xOffset = Rendering.this.getHorizontalBar().getSelection();
                }
                int x = xOffset * -1;
                int y = 0;
                if (Rendering.this.fAddressBarControl.isVisible()) {
                    Rendering.this.fAddressBarControl.setBounds(0, 0, Rendering.this.getBounds().width, ((Rendering)Rendering.this).fAddressBarControl.computeSize((int)100, (int)30).y);
                }
                if (Rendering.this.fAddressPane.isPaneVisible()) {
                    Rendering.this.fAddressPane.setBounds(x, y, ((Rendering)Rendering.this).fAddressPane.computeSize((int)0, (int)0).x, Rendering.this.getBounds().height - y);
                    x = ((Rendering)Rendering.this).fAddressPane.getBounds().x + ((Rendering)Rendering.this).fAddressPane.getBounds().width;
                }
                if (Rendering.this.fBinaryPane.isPaneVisible()) {
                    Rendering.this.fBinaryPane.setBounds(x, y, ((Rendering)Rendering.this).fBinaryPane.computeSize((int)0, (int)0).x, Rendering.this.getBounds().height - y);
                    x = ((Rendering)Rendering.this).fBinaryPane.getBounds().x + ((Rendering)Rendering.this).fBinaryPane.getBounds().width;
                }
                if (Rendering.this.fTextPane.isPaneVisible()) {
                    Rendering.this.fTextPane.setBounds(x, y, Math.max(((Rendering)Rendering.this).fTextPane.computeSize((int)0, (int)0).x, Rendering.this.getClientArea().width - x - xOffset), Rendering.this.getBounds().height - y);
                }
                if (Rendering.this.getClientArea().width >= ((Rendering)Rendering.this).fTextPane.getBounds().x + ((Rendering)Rendering.this).fTextPane.getBounds().width + xOffset) {
                    Rendering.this.getHorizontalBar().setVisible(false);
                } else {
                    ScrollBar horizontal = Rendering.this.getHorizontalBar();
                    horizontal.setVisible(true);
                    horizontal.setMinimum(0);
                    horizontal.setMaximum(((Rendering)Rendering.this).fTextPane.getBounds().x + ((Rendering)Rendering.this).fTextPane.getBounds().width + xOffset);
                    horizontal.setThumb(Rendering.this.getClientArea().width);
                    horizontal.setPageIncrement(40);
                    horizontal.setIncrement(20);
                }
            }

            protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                return new Point(100, 100);
            }
        });
        this.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent ce) {
            }

            public void controlResized(ControlEvent ce) {
                Rendering.this.packColumns();
            }
        });
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    protected AddressPane createAddressPane() {
        return new AddressPane(this);
    }

    protected DataPane createDataPane() {
        return new DataPane(this);
    }

    protected TextPane createTextPane() {
        return new TextPane(this);
    }

    public TraditionalRendering getTraditionalRendering() {
        return this.fParent;
    }

    protected void setCaretAddress(BigInteger address) {
        this.fCaretAddress = address;
    }

    protected BigInteger getCaretAddress() {
        return this.fCaretAddress;
    }

    private void doGoToAddress() {
        try {
            BigInteger address = this.fAddressBar.getGoToAddress(this.getMemoryBlockStartAddress(), this.getCaretAddress());
            this.getTraditionalRendering().gotoAddress(address);
            this.setVisibleAddressBar(false);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void ensureViewportAddressDisplayable() {
        if (this.fViewportAddress.compareTo(this.getMemoryBlockStartAddress()) < 0) {
            this.fViewportAddress = this.getMemoryBlockStartAddress();
        } else if (this.getViewportEndAddress().compareTo(this.getMemoryBlockEndAddress().add(BigInteger.ONE)) > 0) {
            this.fViewportAddress = this.getMemoryBlockEndAddress().subtract(BigInteger.valueOf(this.getAddressableCellsPerRow() * this.getRowCount() - 1));
        }
        this.setCurrentScrollSelection();
    }

    public IMemorySelection getSelection() {
        return this.fSelection;
    }

    public void logError(String message, Exception e) {
        Status status = new Status(4, this.fParent.getRenderingId(), 5013, message, (Throwable)e);
        DebugUIPlugin.getDefault().getLog().log((IStatus)status);
    }

    public void handleFontPreferenceChange(Font font) {
        this.setFont(font);
        AbstractPane[] controls = this.getRenderingPanes();
        for (int i = 0; i < controls.length; ++i) {
            controls[i].setFont(font);
        }
        this.packColumns();
        this.layout(true);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        if (this.isDisposed()) {
            return;
        }
        for (int i = 0; i < events.length; ++i) {
            if (!(events[0].getSource() instanceof IDebugElement)) continue;
            int kind = events[i].getKind();
            int detail = events[i].getDetail();
            IDebugElement source = (IDebugElement)events[i].getSource();
            if (source.getDebugTarget() != this.getMemoryBlock().getDebugTarget()) continue;
            if (kind == 2) {
                this.handleSuspendEvent(detail);
                continue;
            }
            if (kind != 16) continue;
            this.handleChangeEvent();
        }
    }

    protected void handleSuspendEvent(int detail) {
        if (detail == 0) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    Rendering.this.archiveDeltas();
                    Rendering.this.refresh();
                }
            });
        }
    }

    protected void handleChangeEvent() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Rendering.this.refresh();
            }
        });
    }

    protected void handleResumeEvent() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
            }
        });
    }

    public boolean isDebug() {
        return false;
    }

    private IMemoryBlockExtension getMemoryBlock() {
        IMemoryBlock block = this.fParent.getMemoryBlock();
        if (block != null) {
            return (IMemoryBlockExtension)block.getAdapter(IMemoryBlockExtension.class);
        }
        return null;
    }

    public BigInteger getBigBaseAddress() {
        return this.fParent.getBigBaseAddress();
    }

    protected int getAddressableSize() {
        return this.fParent.getAddressableSize();
    }

    protected ViewportCache getViewportCache() {
        return this.fViewportCache;
    }

    public MemoryByte[] getBytes(BigInteger address, int bytes) throws DebugException {
        return this.fViewportCache.getBytes(address, bytes);
    }

    public void setVisibleAddressBar(boolean visible) {
        this.fAddressBarControl.setVisible(visible);
        if (visible) {
            String selectedStr = "0x" + this.getCaretAddress().toString(16);
            Text text = this.fAddressBar.getExpressionWidget();
            text.setText(selectedStr);
            text.setSelection(0, text.getCharCount());
            this.fAddressBar.getExpressionWidget().setFocus();
        }
        this.layout(true);
        this.layoutPanes();
    }

    public void setDirty(boolean needRefresh) {
        this.fCacheDirty = needRefresh;
    }

    public boolean isDirty() {
        return this.fCacheDirty;
    }

    public void dispose() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        if (this.fViewportCache != null) {
            this.fViewportCache.dispose();
            this.fViewportCache = null;
        }
        super.dispose();
    }

    public void setPaneVisible(int pane, boolean visible) {
        switch (pane) {
            case 1: {
                this.fAddressPane.setPaneVisible(visible);
                break;
            }
            case 2: {
                this.fBinaryPane.setPaneVisible(visible);
                break;
            }
            case 3: {
                this.fTextPane.setPaneVisible(visible);
            }
        }
        this.fireSettingsChanged();
        this.layoutPanes();
    }

    public boolean getPaneVisible(int pane) {
        switch (pane) {
            case 1: {
                return this.fAddressPane.isPaneVisible();
            }
            case 2: {
                return this.fBinaryPane.isPaneVisible();
            }
            case 3: {
                return this.fTextPane.isPaneVisible();
            }
        }
        return false;
    }

    protected void packColumns() {
        int availableWidth = this.getSize().x;
        if (this.fAddressPane.isPaneVisible()) {
            availableWidth -= this.fAddressPane.computeSize((int)0, (int)0).x;
            availableWidth -= this.getRenderSpacing() * 2;
        }
        int combinedWidth = 0;
        if (this.fBinaryPane.isPaneVisible()) {
            combinedWidth += this.fBinaryPane.getCellWidth();
        }
        if (this.fTextPane.isPaneVisible()) {
            combinedWidth += this.fTextPane.getCellWidth();
        }
        if (this.getColumnsSetting() == 0) {
            if (combinedWidth == 0) {
                this.fColumnCount = 0;
            } else {
                this.fColumnCount = availableWidth / combinedWidth;
                if (this.fColumnCount == 0) {
                    this.fColumnCount = 1;
                }
            }
        } else {
            this.fColumnCount = this.getColumnsSetting();
        }
        try {
            this.fBytesPerRow = this.getBytesPerColumn() * this.getColumnCount();
            BigInteger difference = this.getMemoryBlockEndAddress().subtract(this.getMemoryBlockStartAddress()).add(BigInteger.ONE);
            BigInteger maxScrollRange = difference.divide(BigInteger.valueOf(this.getAddressableCellsPerRow()));
            if (maxScrollRange.multiply(BigInteger.valueOf(this.getAddressableCellsPerRow())).compareTo(difference) != 0) {
                maxScrollRange = maxScrollRange.add(BigInteger.ONE);
            }
            maxScrollRange = maxScrollRange.divide(BigInteger.valueOf(this.getAddressableSize()));
            this.getVerticalBar().setMinimum(1);
            this.getVerticalBar().setMaximum(maxScrollRange.intValue());
            this.getVerticalBar().setIncrement(1);
            this.getVerticalBar().setPageIncrement(this.getRowCount() - 1);
            this.setCurrentScrollSelection();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.redraw();
        this.redrawPanes();
    }

    public AbstractPane[] getRenderingPanes() {
        return new AbstractPane[]{this.fAddressPane, this.fBinaryPane, this.fTextPane};
    }

    public int getCellPadding() {
        return this.fCellPadding;
    }

    protected int getRenderSpacing() {
        return this.fPaneSpacing;
    }

    public void refresh() {
        if (!this.isDisposed()) {
            if (this.isVisible() && this.fViewportCache != null) {
                this.fViewportCache.refresh();
            } else {
                this.setDirty(true);
                this.fParent.updateRenderingLabels();
            }
        }
    }

    protected void archiveDeltas() {
        this.fViewportCache.archiveDeltas();
    }

    public void gotoAddress(BigInteger address) {
        if (address.compareTo(this.getMemoryBlockStartAddress()) < 0 || address.compareTo(this.getMemoryBlockEndAddress()) > 0) {
            return;
        }
        this.fViewportAddress = address;
        this.redrawPanes();
    }

    protected void setViewportStartAddress(BigInteger newAddress) {
        this.fViewportAddress = newAddress;
    }

    public BigInteger getViewportStartAddress() {
        return this.fViewportAddress;
    }

    public BigInteger getViewportEndAddress() {
        return this.fViewportAddress.add(BigInteger.valueOf(this.getBytesPerRow() * this.getRowCount() / this.getAddressableSize()));
    }

    public String getAddressString(BigInteger address) {
        StringBuffer addressString = new StringBuffer(address.toString(16).toUpperCase());
        for (int chars = this.getAddressBytes() * 2 - addressString.length(); chars > 0; --chars) {
            addressString.insert(0, '0');
        }
        addressString.insert(0, "0x");
        return addressString.toString();
    }

    protected int getAddressBytes() {
        return this.fParent.getAddressSize();
    }

    public int getColumnCount() {
        return this.fColumnCount;
    }

    public int getColumnsSetting() {
        return this.fColumnsSetting;
    }

    public void setColumnsSetting(int columns) {
        if (this.fColumnsSetting != columns) {
            this.fColumnsSetting = columns;
            this.fireSettingsChanged();
            this.layoutPanes();
        }
    }

    protected void ensureVisible(BigInteger address) {
        boolean isAddressAfterViewportEnd;
        BigInteger viewportStart = this.getViewportStartAddress();
        BigInteger viewportEnd = this.getViewportEndAddress();
        boolean isAddressBeforeViewportStart = address.compareTo(viewportStart) < 0;
        boolean bl = isAddressAfterViewportEnd = address.compareTo(viewportEnd) > 0;
        if (isAddressBeforeViewportStart || isAddressAfterViewportEnd) {
            this.gotoAddress(address);
        }
    }

    protected int getRowCount() {
        int rowCount = 0;
        AbstractPane[] panes = this.getRenderingPanes();
        for (int i = 0; i < panes.length; ++i) {
            if (!(panes[i] instanceof AbstractPane)) continue;
            rowCount = Math.max(rowCount, panes[i].getRowCount());
        }
        return rowCount;
    }

    public int getBytesPerColumn() {
        return this.fBytesPerColumn;
    }

    protected int getBytesPerRow() {
        return this.fBytesPerRow;
    }

    protected int getAddressableCellsPerRow() {
        return this.getBytesPerRow() / this.getAddressableSize();
    }

    public int getAddressesPerColumn() {
        return this.getBytesPerColumn() / this.getAddressableSize();
    }

    protected void setCurrentScrollSelection() {
        BigInteger selection = this.getViewportStartAddress().divide(BigInteger.valueOf(this.getAddressableCellsPerRow()).add(BigInteger.ONE));
        this.getVerticalBar().setSelection(selection.intValue());
        this.fCurrentScrollSelection = selection.intValue();
    }

    protected BigInteger getMemoryBlockStartAddress() {
        if (this.fMemoryBlockStartAddress == null) {
            this.fMemoryBlockStartAddress = this.fParent.getMemoryBlockStartAddress();
        }
        if (this.fMemoryBlockStartAddress == null) {
            this.fMemoryBlockStartAddress = BigInteger.ZERO;
        }
        return this.fMemoryBlockStartAddress;
    }

    protected BigInteger getMemoryBlockEndAddress() {
        if (this.fMemoryBlockEndAddress == null) {
            this.fMemoryBlockEndAddress = this.fParent.getMemoryBlockEndAddress();
        }
        return this.fMemoryBlockEndAddress;
    }

    public int getRadix() {
        return this.fRadix;
    }

    protected int getNumericRadix(int radix) {
        switch (radix) {
            case 5: {
                return 2;
            }
            case 4: {
                return 8;
            }
            case 2: 
            case 3: {
                return 10;
            }
            case 1: {
                return 16;
            }
        }
        return -1;
    }

    public void setRadix(int mode) {
        if (this.fRadix == mode) {
            return;
        }
        this.fRadix = mode;
        this.fireSettingsChanged();
        this.layoutPanes();
    }

    public void setTextMode(int mode) {
        this.fTextMode = mode;
        this.fireSettingsChanged();
        this.layoutPanes();
    }

    public int getTextMode() {
        return this.fTextMode;
    }

    protected String getCharacterSet(int mode) {
        switch (mode) {
            case 3: {
                return "UTF8";
            }
            case 4: {
                return "UTF16";
            }
            case 2: {
                return "US-ASCII";
            }
        }
        return "ISO-8859-1";
    }

    public int getBytesPerCharacter() {
        if (this.fTextMode == 4) {
            return 2;
        }
        return 1;
    }

    public boolean isTargetLittleEndian() {
        return this.fIsTargetLittleEndian;
    }

    public void setTargetLittleEndian(boolean littleEndian) {
        if (this.fIsTargetLittleEndian == littleEndian) {
            return;
        }
        this.fParent.setTargetMemoryLittleEndian(littleEndian);
        this.fIsTargetLittleEndian = littleEndian;
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Rendering.this.fireSettingsChanged();
                Rendering.this.layoutPanes();
            }
        });
    }

    public boolean isDisplayLittleEndian() {
        return this.fIsDisplayLittleEndian;
    }

    public void setDisplayLittleEndian(boolean littleEndian) {
        this.fIsDisplayLittleEndian = littleEndian;
        if (this.fIsDisplayLittleEndian) {
            return;
        }
        this.fIsDisplayLittleEndian = littleEndian;
        this.fireSettingsChanged();
        this.layoutPanes();
    }

    public void setBytesPerColumn(int byteCount) {
        if (this.fBytesPerColumn != byteCount) {
            this.fBytesPerColumn = byteCount;
            this.fireSettingsChanged();
            this.layoutPanes();
        }
    }

    protected void redrawPanes() {
        if (!this.isDisposed() && this.isVisible()) {
            if (this.fAddressPane.isPaneVisible()) {
                this.fAddressPane.redraw();
                this.fAddressPane.setRowCount();
                if (this.fAddressPane.isFocusControl()) {
                    this.fAddressPane.updateCaret();
                }
            }
            if (this.fBinaryPane.isPaneVisible()) {
                this.fBinaryPane.redraw();
                this.fBinaryPane.setRowCount();
                if (this.fBinaryPane.isFocusControl()) {
                    this.fBinaryPane.updateCaret();
                }
            }
            if (this.fTextPane.isPaneVisible()) {
                this.fTextPane.redraw();
                this.fTextPane.setRowCount();
                if (this.fTextPane.isFocusControl()) {
                    this.fTextPane.updateCaret();
                }
            }
        }
        this.fParent.updateRenderingLabels();
    }

    private void layoutPanes() {
        this.packColumns();
        this.layout(true);
        this.redraw();
        this.redrawPanes();
    }

    private void fireSettingsChanged() {
        this.fAddressPane.settingsChanged();
        this.fBinaryPane.settingsChanged();
        this.fTextPane.settingsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyAddressToClipboard() {
        Clipboard clip = null;
        try {
            clip = new Clipboard(this.getDisplay());
            String addressString = "0x" + this.getCaretAddress().toString(16);
            TextTransfer plainTextTransfer = TextTransfer.getInstance();
            clip.setContents(new Object[]{addressString}, new Transfer[]{plainTextTransfer});
        }
        finally {
            if (clip != null) {
                clip.dispose();
            }
        }
    }

    public String getRadixText(MemoryByte[] bytes, int radix, boolean isLittleEndian) {
        boolean readable = true;
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i].isReadable()) continue;
            readable = false;
        }
        if (readable) {
            boolean needsSwap = false;
            if (this.isDisplayLittleEndian()) {
                needsSwap = true;
            }
            switch (radix) {
                case 1: 
                case 4: 
                case 5: {
                    int i;
                    long value = 0L;
                    if (needsSwap) {
                        for (i = 0; i < bytes.length; ++i) {
                            value <<= 8;
                            value |= (long)(bytes[bytes.length - 1 - i].getValue() & 0xFF);
                        }
                    } else {
                        for (i = 0; i < bytes.length; ++i) {
                            value <<= 8;
                            value |= (long)(bytes[i].getValue() & 0xFF);
                        }
                    }
                    char[] buf = new char[this.getRadixCharacterCount(radix, bytes.length)];
                    switch (radix) {
                        case 5: {
                            for (int i2 = buf.length - 1; i2 >= 0; --i2) {
                                buf[i2] = hexdigits[(int)(value & 1L)];
                                value >>>= 1;
                            }
                            break;
                        }
                        case 4: {
                            for (int i3 = buf.length - 1; i3 >= 0; --i3) {
                                buf[i3] = hexdigits[(int)(value & 7L)];
                                value >>>= 3;
                            }
                            break;
                        }
                        case 1: {
                            for (int i4 = buf.length - 1; i4 >= 0; --i4) {
                                buf[i4] = hexdigits[(int)(value & 0xFL)];
                                value >>>= 4;
                            }
                            break;
                        }
                    }
                    return new String(buf);
                }
                case 2: 
                case 3: {
                    BigInteger bigValue;
                    int i;
                    boolean isSignedType = radix == 2;
                    int textWidth = this.getRadixCharacterCount(radix, bytes.length);
                    char[] buf = new char[textWidth];
                    byte[] value = new byte[bytes.length + 1];
                    if (needsSwap) {
                        for (i = 0; i < bytes.length; ++i) {
                            value[bytes.length - i] = bytes[i].getValue();
                        }
                    } else {
                        for (i = 0; i < bytes.length; ++i) {
                            value[i + 1] = bytes[i].getValue();
                        }
                    }
                    boolean isNegative = false;
                    if (isSignedType && (value[1] & 0x80) != 0) {
                        value[0] = -1;
                        isNegative = true;
                        bigValue = new BigInteger(value).abs();
                    } else {
                        value[0] = 0;
                        bigValue = new BigInteger(value);
                    }
                    for (int i5 = 0; i5 < textWidth; ++i5) {
                        BigInteger[] divideRemainder = bigValue.divideAndRemainder(BigInteger.valueOf(10L));
                        int remainder = divideRemainder[1].intValue();
                        buf[textWidth - 1 - i5] = hexdigits[remainder % 10];
                        bigValue = divideRemainder[0];
                    }
                    if (isSignedType) {
                        buf[0] = isNegative ? 45 : 32;
                    }
                    return new String(buf);
                }
            }
        }
        StringBuffer errorText = new StringBuffer();
        for (int i = this.getRadixCharacterCount(radix, bytes.length); i > 0; --i) {
            errorText.append('?');
        }
        return errorText.toString();
    }

    public int getRadixCharacterCount(int radix, int bytes) {
        switch (radix) {
            case 1: {
                return bytes * 2;
            }
            case 5: {
                return bytes * 8;
            }
            case 4: {
                switch (bytes) {
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 6;
                    }
                    case 4: {
                        return 11;
                    }
                    case 8: {
                        return 22;
                    }
                }
            }
            case 3: {
                switch (bytes) {
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 5;
                    }
                    case 4: {
                        return 10;
                    }
                    case 8: {
                        return 20;
                    }
                }
            }
            case 2: {
                switch (bytes) {
                    case 1: {
                        return 4;
                    }
                    case 2: {
                        return 6;
                    }
                    case 4: {
                        return 11;
                    }
                    case 8: {
                        return 21;
                    }
                }
            }
        }
        return 0;
    }

    protected static boolean isValidEditCharacter(char character) {
        return character >= '0' && character <= '9' || character >= 'a' && character <= 'z' || character >= 'A' && character <= 'Z' || character == '-' || character == ' ';
    }

    public String formatText(MemoryByte[] memoryBytes, boolean isLittleEndian, int textMode) {
        int byteValue;
        int i;
        boolean readable = true;
        for (int i2 = 0; i2 < memoryBytes.length; ++i2) {
            if (memoryBytes[i2].isReadable()) continue;
            readable = false;
        }
        if (!readable) {
            StringBuffer errorText = new StringBuffer();
            for (int i3 = memoryBytes.length; i3 > 0; --i3) {
                errorText.append('?');
            }
            return errorText.toString();
        }
        byte[] bytes = new byte[memoryBytes.length];
        for (i = 0; i < bytes.length; ++i) {
            bytes[i] = memoryBytes[i].getValue();
        }
        if (textMode == 2) {
            for (i = 0; i < bytes.length; ++i) {
                byteValue = bytes[i];
                if (byteValue < 0) {
                    byteValue += 256;
                }
                if (byteValue >= 32 && byteValue <= 126) continue;
                bytes[i] = 46;
            }
        }
        if (textMode == 1) {
            for (i = 0; i < bytes.length; ++i) {
                byteValue = bytes[i];
                if (byteValue < 0) {
                    byteValue += 256;
                }
                if (byteValue >= 32 && (byteValue < 127 || byteValue >= 159)) continue;
                bytes[i] = 46;
            }
        }
        try {
            StringBuffer buf = new StringBuffer(new String(bytes, this.getCharacterSet(textMode)));
            for (int i4 = 0; i4 < memoryBytes.length - buf.length(); ++i4) {
                buf.append(' ');
            }
            return buf.toString();
        }
        catch (Exception e) {
            StringBuffer buf = new StringBuffer();
            for (int i5 = 0; i5 < memoryBytes.length - buf.length(); ++i5) {
                buf.append('?');
            }
            return buf.toString();
        }
    }

    private static interface Request {
    }

    class Selection
    implements IMemorySelection {
        private BigInteger fStartHigh;
        private BigInteger fStartLow;
        private BigInteger fEndHigh;
        private BigInteger fEndLow;

        Selection() {
        }

        public void clear() {
            this.fStartLow = null;
            this.fStartHigh = null;
            this.fEndLow = null;
            this.fEndHigh = null;
            Rendering.this.redrawPanes();
        }

        public boolean hasSelection() {
            return this.fStartHigh != null && this.fStartLow != null && this.fEndHigh != null && this.fEndLow != null;
        }

        public boolean isSelected(BigInteger address) {
            if (this.getEnd() == null || this.getStart() == null) {
                return false;
            }
            return this.getEnd().compareTo(this.getStart()) >= 0 ? address.compareTo(this.getStart()) >= 0 && address.compareTo(this.getEnd()) < 0 : this.getStart().compareTo(this.getEnd()) >= 0 && address.compareTo(this.getEnd()) >= 0 && address.compareTo(this.getStart()) < 0;
        }

        public void setStart(BigInteger high, BigInteger low) {
            if (high == null && low == null) {
                if (this.fStartHigh != null && this.fStartLow != null) {
                    this.fStartHigh = null;
                    this.fStartLow = null;
                    Rendering.this.redrawPanes();
                }
                return;
            }
            boolean changed = false;
            if (this.fStartHigh == null || !high.equals(this.fStartHigh)) {
                this.fStartHigh = high;
                changed = true;
            }
            if (this.fStartLow == null || !low.equals(this.fStartLow)) {
                this.fStartLow = low;
                changed = true;
            }
            if (changed) {
                Rendering.this.redrawPanes();
            }
        }

        public void setEnd(BigInteger high, BigInteger low) {
            if (high == null && low == null) {
                if (this.fEndHigh != null && this.fEndLow != null) {
                    this.fEndHigh = null;
                    this.fEndLow = null;
                    Rendering.this.redrawPanes();
                }
                return;
            }
            boolean changed = false;
            if (this.fEndHigh == null || !high.equals(this.fEndHigh)) {
                this.fEndHigh = high;
                changed = true;
            }
            if (this.fEndLow == null || !low.equals(this.fEndLow)) {
                this.fEndLow = low;
                changed = true;
            }
            if (changed) {
                Rendering.this.redrawPanes();
            }
        }

        public BigInteger getHigh() {
            if (!this.hasSelection()) {
                return null;
            }
            return this.getStart().max(this.getEnd());
        }

        public BigInteger getLow() {
            if (!this.hasSelection()) {
                return null;
            }
            return this.getStart().min(this.getEnd());
        }

        public BigInteger getStart() {
            BigInteger differenceEndToStartLow;
            if (this.fStartHigh == null) {
                return null;
            }
            if (this.fEndHigh == null) {
                return this.fStartHigh;
            }
            if (this.fStartHigh.equals(this.fEndHigh) && this.fStartLow.equals(this.fEndLow)) {
                return this.fStartLow;
            }
            BigInteger differenceEndToStartHigh = this.fEndHigh.subtract(this.fStartHigh).abs();
            if (differenceEndToStartHigh.compareTo(differenceEndToStartLow = this.fEndHigh.subtract(this.fStartLow).abs()) > 0) {
                return this.fStartHigh;
            }
            return this.fStartLow;
        }

        public BigInteger getEnd() {
            BigInteger differenceStartToEndLow;
            if (this.fEndHigh == null) {
                return null;
            }
            if (this.fStartHigh.equals(this.fEndHigh) && this.fStartLow.equals(this.fEndLow)) {
                return this.fStartHigh;
            }
            BigInteger differenceStartToEndHigh = this.fStartHigh.subtract(this.fEndHigh).abs();
            if (differenceStartToEndHigh.compareTo(differenceStartToEndLow = this.fStartHigh.subtract(this.fEndLow).abs()) >= 0) {
                return this.fEndHigh;
            }
            return this.fEndLow;
        }
    }

    class ViewportCache
    extends Thread {
        private HashMap fEditBuffer = new HashMap();
        private boolean fDisposed = false;
        private Vector fQueue = new Vector();
        protected MemoryUnit fCache = null;
        protected MemoryUnit fHistoryCache = null;

        public ViewportCache() {
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            this.fDisposed = true;
            ViewportCache viewportCache = this;
            synchronized (viewportCache) {
                this.notify();
            }
        }

        protected void refresh() {
            assert (Thread.currentThread().equals(Display.getDefault().getThread())) : TraditionalRenderingMessages.getString("TraditionalRendering.CALLED_ON_NON_DISPATCH_THREAD");
            if (this.fCache != null) {
                this.queueRequest(Rendering.this.fViewportAddress, Rendering.this.getViewportEndAddress());
            }
        }

        protected void archiveDeltas() {
            assert (Thread.currentThread().equals(Display.getDefault().getThread())) : TraditionalRenderingMessages.getString("TraditionalRendering.CALLED_ON_NON_DISPATCH_THREAD");
            if (this.fCache != null) {
                this.queueRequestArchiveDeltas();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void queueRequest(BigInteger startAddress, BigInteger endAddress) {
            AddressPair pair = new AddressPair();
            pair.startAddress = startAddress;
            pair.endAddress = endAddress;
            Object object = this.fQueue;
            synchronized (object) {
                this.fQueue.addElement(pair);
            }
            object = this;
            synchronized (object) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void queueRequestArchiveDeltas() {
            ArchiveDeltas archive = new ArchiveDeltas();
            Object object = this.fQueue;
            synchronized (object) {
                this.fQueue.addElement(archive);
            }
            object = this;
            synchronized (object) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.fDisposed) {
                AddressPair pair = null;
                boolean archiveDeltas = false;
                Object object = this.fQueue;
                synchronized (object) {
                    if (this.fQueue.size() > 0) {
                        Request request = (Request)this.fQueue.elementAt(0);
                        Class type = null;
                        if (request instanceof ArchiveDeltas) {
                            archiveDeltas = true;
                            type = ArchiveDeltas.class;
                        } else if (request instanceof AddressPair) {
                            pair = (AddressPair)request;
                            type = AddressPair.class;
                        }
                        while (this.fQueue.size() > 0 && type.isInstance(this.fQueue.elementAt(0))) {
                            this.fQueue.removeElementAt(0);
                        }
                    }
                }
                if (archiveDeltas) {
                    this.fHistoryCache = this.fCache.clone();
                    continue;
                }
                if (pair != null) {
                    this.populateCache(pair.startAddress, pair.endAddress);
                    continue;
                }
                object = this;
                synchronized (object) {
                    try {
                        this.wait();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }

        private void populateCache(final BigInteger startAddress, final BigInteger endAddress) {
            try {
                IMemoryBlockExtension memoryBlock = Rendering.this.getMemoryBlock();
                BigInteger lengthInBytes = endAddress.subtract(startAddress);
                BigInteger addressableSize = BigInteger.valueOf(Rendering.this.getAddressableSize());
                long units = lengthInBytes.divide(addressableSize).add(lengthInBytes.mod(addressableSize).compareTo(BigInteger.ZERO) > 0 ? BigInteger.ONE : BigInteger.ZERO).longValue();
                MemoryByte[] readBytes = memoryBlock.getBytesFromAddress(startAddress, units);
                MemoryByte[] cachedBytes = new MemoryByte[readBytes.length];
                for (int i = 0; i < readBytes.length; ++i) {
                    cachedBytes[i] = new MemoryByte(readBytes[i].getValue(), readBytes[i].getFlags());
                }
                if (cachedBytes.length > 0 && cachedBytes[0].isEndianessKnown()) {
                    Rendering.this.setTargetLittleEndian(!cachedBytes[0].isBigEndian());
                }
                if (Rendering.this.isTargetLittleEndian() && addressableSize.compareTo(BigInteger.ONE) != 0) {
                    int unitSize = addressableSize.intValue();
                    MemoryByte[] cachedBytesAsByteSequence = new MemoryByte[cachedBytes.length];
                    int unit = 0;
                    while ((long)unit < units) {
                        for (int unitbyte = 0; unitbyte < unitSize; ++unitbyte) {
                            cachedBytesAsByteSequence[unit * unitSize + unitbyte] = cachedBytes[unit * unitSize + unitSize - unitbyte];
                        }
                        ++unit;
                    }
                    cachedBytes = cachedBytesAsByteSequence;
                }
                final MemoryByte[] cachedBytesFinal = cachedBytes;
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (ViewportCache.this.fHistoryCache != null && ViewportCache.this.fHistoryCache.isValid()) {
                            BigInteger maxStart = startAddress.max(ViewportCache.this.fHistoryCache.start);
                            BigInteger minEnd = endAddress.min(ViewportCache.this.fHistoryCache.end).subtract(BigInteger.valueOf(1L));
                            BigInteger overlapLength = minEnd.subtract(maxStart);
                            if (overlapLength.compareTo(BigInteger.valueOf(0L)) > 0) {
                                int offsetIntoOld = maxStart.subtract(ViewportCache.this.fHistoryCache.start).intValue();
                                int offsetIntoNew = maxStart.subtract(startAddress).intValue();
                                for (int i = overlapLength.intValue(); i >= 0; --i) {
                                    cachedBytesFinal[offsetIntoNew + i].setChanged(cachedBytesFinal[offsetIntoNew + i].getValue() != ViewportCache.this.fHistoryCache.bytes[offsetIntoOld + i].getValue());
                                }
                            }
                        }
                        ViewportCache.this.fCache = new MemoryUnit();
                        ViewportCache.this.fCache.start = startAddress;
                        ViewportCache.this.fCache.end = endAddress;
                        ViewportCache.this.fCache.bytes = cachedBytesFinal;
                        if (ViewportCache.this.fHistoryCache == null) {
                            ViewportCache.this.fHistoryCache = ViewportCache.this.fCache.clone();
                        }
                        Rendering.this.redrawPanes();
                    }
                });
            }
            catch (Exception e) {
                Rendering.this.logError(TraditionalRenderingMessages.getString("TraditionalRendering.FAILURE_READ_MEMORY"), e);
            }
        }

        protected MemoryByte[] getBytes(BigInteger address, int bytesRequested) throws DebugException {
            assert (Thread.currentThread().equals(Display.getDefault().getThread())) : TraditionalRenderingMessages.getString("TraditionalRendering.CALLED_ON_NON_DISPATCH_THREAD");
            if (this.containsEditedCell(address)) {
                return this.getEditedMemory(address);
            }
            boolean contains = false;
            if (this.fCache != null && this.fCache.start != null) {
                BigInteger dataEnd = address.add(BigInteger.valueOf(bytesRequested));
                if (this.fCache.start.compareTo(address) <= 0 && this.fCache.end.compareTo(dataEnd) >= 0 && this.fCache.bytes.length > 0) {
                    contains = true;
                }
            }
            if (contains) {
                int offset = address.subtract(this.fCache.start).intValue();
                MemoryByte[] bytes = new MemoryByte[bytesRequested];
                for (int i = 0; i < bytes.length; ++i) {
                    bytes[i] = this.fCache.bytes[offset + i];
                }
                return bytes;
            }
            MemoryByte[] bytes = new MemoryByte[bytesRequested];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = new MemoryByte();
                bytes[i].setReadable(false);
            }
            Rendering.this.fViewportCache.queueRequest(Rendering.this.fViewportAddress, Rendering.this.getViewportEndAddress());
            return bytes;
        }

        private boolean containsEditedCell(BigInteger address) {
            assert (Thread.currentThread().equals(Display.getDefault().getThread())) : TraditionalRenderingMessages.getString("TraditionalRendering.CALLED_ON_NON_DISPATCH_THREAD");
            return this.fEditBuffer.containsKey(address);
        }

        private MemoryByte[] getEditedMemory(BigInteger address) {
            assert (Thread.currentThread().equals(Display.getDefault().getThread())) : TraditionalRenderingMessages.getString("TraditionalRendering.CALLED_ON_NON_DISPATCH_THREAD");
            return (MemoryByte[])this.fEditBuffer.get(address);
        }

        protected void clearEditBuffer() {
            assert (Thread.currentThread().equals(Display.getDefault().getThread())) : TraditionalRenderingMessages.getString("TraditionalRendering.CALLED_ON_NON_DISPATCH_THREAD");
            this.fEditBuffer.clear();
            Rendering.this.redrawPanes();
        }

        protected void writeEditBuffer() {
            assert (Thread.currentThread().equals(Display.getDefault().getThread())) : TraditionalRenderingMessages.getString("TraditionalRendering.CALLED_ON_NON_DISPATCH_THREAD");
            Set keySet = this.fEditBuffer.keySet();
            for (BigInteger address : keySet) {
                MemoryByte[] bytes = (MemoryByte[])this.fEditBuffer.get(address);
                byte[] byteValue = new byte[bytes.length];
                for (int i = 0; i < bytes.length; ++i) {
                    byteValue[i] = bytes[i].getValue();
                }
                try {
                    Rendering.this.getMemoryBlock().setValue(address.subtract(Rendering.this.fParent.getBigBaseAddress()), byteValue);
                }
                catch (Exception e) {
                    MemoryViewUtil.openError((String)TraditionalRenderingMessages.getString("TraditionalRendering.FAILURE_WRITE_MEMORY"), (String)"", (Exception)e);
                    Rendering.this.logError(TraditionalRenderingMessages.getString("TraditionalRendering.FAILURE_WRITE_MEMORY"), e);
                }
            }
            this.clearEditBuffer();
        }

        protected void setEditedValue(BigInteger address, MemoryByte[] bytes) {
            assert (Thread.currentThread().equals(Display.getDefault().getThread())) : TraditionalRenderingMessages.getString("TraditionalRendering.CALLED_ON_NON_DISPATCH_THREAD");
            this.fEditBuffer.put(address, bytes);
            Rendering.this.redrawPanes();
        }

        class AddressPair
        implements Request {
            BigInteger startAddress;
            BigInteger endAddress;

            AddressPair() {
            }
        }

        class ArchiveDeltas
        implements Request {
            ArchiveDeltas() {
            }
        }

        class MemoryUnit {
            BigInteger start;
            BigInteger end;
            MemoryByte[] bytes;

            MemoryUnit() {
            }

            public MemoryUnit clone() {
                MemoryUnit b = new MemoryUnit();
                b.start = this.start;
                b.end = this.end;
                b.bytes = new MemoryByte[this.bytes.length];
                for (int i = 0; i < this.bytes.length; ++i) {
                    b.bytes[i] = new MemoryByte(this.bytes[i].getValue());
                }
                return b;
            }

            public boolean isValid() {
                return this.start != null && this.end != null && this.bytes != null;
            }
        }
    }
}

