/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.debug.ui.memory.transport.actions;

import org.eclipse.dd.debug.ui.memory.transport.ExportMemoryDialog;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.MemoryView;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class ExportMemoryAction
implements IViewActionDelegate {
    private MemoryView fView;

    public void init(IViewPart view) {
        if (view instanceof MemoryView) {
            this.fView = (MemoryView)view;
        }
    }

    public void run(IAction action) {
        ISelection selection = this.fView.getSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection strucSel = (IStructuredSelection)selection;
            if (strucSel.isEmpty()) {
                return;
            }
            Object obj = strucSel.getFirstElement();
            if (obj == null) {
                return;
            }
            IMemoryBlock memBlock = null;
            if (obj instanceof IMemoryRendering) {
                memBlock = ((IMemoryRendering)obj).getMemoryBlock();
            } else if (obj instanceof IMemoryBlock) {
                memBlock = (IMemoryBlock)obj;
            }
            if (memBlock == null) {
                return;
            }
            ExportMemoryDialog dialog = new ExportMemoryDialog(DebugUIPlugin.getShell(), memBlock);
            dialog.open();
            dialog.getResult();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

