/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.ui.viewmodel;

import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMEvent;
import org.eclipse.dd.dsf.debug.ui.DsfDebugUIPlugin;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMRootLayoutNode;
import org.eclipse.dd.dsf.ui.viewmodel.IVMRootLayoutNode;
import org.eclipse.dd.dsf.ui.viewmodel.dm.AbstractDMVMLayoutNode;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugViewSelectionRootLayoutNode
extends AbstractVMRootLayoutNode
implements IVMRootLayoutNode {
    private final IWorkbenchWindow fWindow = DsfDebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();

    public DebugViewSelectionRootLayoutNode(AbstractVMProvider provider) {
        super(provider);
    }

    public int getDeltaFlags(Object event) {
        IDMContext<?> inputDmc = this.getSelectedDMC();
        if (event instanceof IDMEvent && inputDmc != null) {
            boolean potentialMatchFound = false;
            boolean matchFound = false;
            IDMContext eventDmc = ((IDMEvent)event).getDMContext();
            for (IDMContext eventDmcAncestor : DMContexts.toList((IDMContext)eventDmc)) {
                IDMContext inputDmcAncestor = DMContexts.getAncestorOfType(inputDmc, eventDmcAncestor.getClass());
                if (inputDmcAncestor == null) continue;
                potentialMatchFound = true;
                if (!inputDmcAncestor.equals(eventDmcAncestor)) continue;
                return super.getDeltaFlags(event);
            }
            if (potentialMatchFound && !matchFound) {
                return 0;
            }
        }
        return super.getDeltaFlags(event);
    }

    public ISelection getSelection() {
        return DebugUITools.getDebugContextManager().getContextService(this.fWindow).getActiveContext();
    }

    public Object getRootObject() {
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection) {
            return ((IStructuredSelection)selection).getFirstElement();
        }
        return null;
    }

    private IDMContext<?> getSelectedDMC() {
        IStructuredSelection structSelection;
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection && (structSelection = (IStructuredSelection)selection).getFirstElement() instanceof AbstractDMVMLayoutNode.DMVMContext) {
            AbstractDMVMLayoutNode.DMVMContext vmc = (AbstractDMVMLayoutNode.DMVMContext)structSelection.getFirstElement();
            return vmc.getDMC();
        }
        return null;
    }
}

