/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.ui.viewmodel.register;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMEvent;
import org.eclipse.dd.dsf.datamodel.IDMService;
import org.eclipse.dd.dsf.debug.service.IRegisters;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.ui.viewmodel.expression.AbstractExpressionLayoutNode;
import org.eclipse.dd.dsf.debug.ui.viewmodel.expression.WatchExpressionCellModifier;
import org.eclipse.dd.dsf.debug.ui.viewmodel.register.SyncRegisterDataAccess;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.IVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.dd.dsf.ui.viewmodel.dm.AbstractDMVMLayoutNode;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementEditor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.actions.IWatchExpressionFactoryAdapterExtension;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisterGroupLayoutNode
extends AbstractExpressionLayoutNode<IRegisters.IRegisterGroupDMData>
implements IElementEditor {
    private final SyncRegisterDataAccess fSyncRegisterDataAccess;
    protected final RegisterGroupExpressionFactory fRegisterGroupExpressionFactory = new RegisterGroupExpressionFactory();
    private WatchExpressionCellModifier fWatchExpressionCellModifier = new WatchExpressionCellModifier();

    public RegisterGroupLayoutNode(AbstractVMProvider provider, DsfSession session, SyncRegisterDataAccess syncDataAccess) {
        super(provider, session, IRegisters.IRegisterGroupDMContext.class);
        this.fSyncRegisterDataAccess = syncDataAccess;
    }

    protected SyncRegisterDataAccess getSyncRegisterDataAccess() {
        return this.fSyncRegisterDataAccess;
    }

    protected void updateElementsInSessionThread(final IChildrenUpdate update) {
        if (!this.checkService(IRegisters.class, null, (IViewerUpdate)update)) {
            return;
        }
        IRunControl.IExecutionDMContext execDmc = (IRunControl.IExecutionDMContext)this.findDmcInPath(update.getElementPath(), IRunControl.IExecutionDMContext.class);
        if (execDmc != null) {
            ((IRegisters)this.getServicesTracker().getService(IRegisters.class)).getRegisterGroups((IDMContext)execDmc, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterGroupDMContext[]>(this.getSession().getExecutor(), null){

                public void handleCompleted() {
                    if (!this.getStatus().isOK()) {
                        update.done();
                        return;
                    }
                    RegisterGroupLayoutNode.this.fillUpdateWithVMCs(update, (IDMContext[])this.getData());
                    update.done();
                }
            });
        } else {
            this.handleFailedUpdate((IViewerUpdate)update);
        }
    }

    protected IVMContext createVMContext(IDMContext<IRegisters.IRegisterGroupDMData> dmc) {
        return new RegisterGroupVMC(dmc);
    }

    protected void fillColumnLabel(IDMContext<IRegisters.IRegisterGroupDMData> dmContext, IRegisters.IRegisterGroupDMData dmData, String columnId, int idx, ILabelUpdate update) {
        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__NAME".equals(columnId)) {
            update.setLabel(dmData.getName(), idx);
            update.setImageDescriptor(DebugPluginImages.getImageDescriptor((String)"IMG_OBJS_REGISTER_GROUP"), idx);
        } else if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(columnId)) {
            update.setLabel("", idx);
        } else if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__DESCRIPTION".equals(columnId)) {
            update.setLabel(dmData.getDescription(), idx);
        } else if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__EXPRESSION".equals(columnId)) {
            IVMContext vmc = (IVMContext)update.getElement();
            IExpression expression = (IExpression)vmc.getAdapter(IExpression.class);
            if (expression != null) {
                update.setLabel(expression.getExpressionText(), idx);
            } else {
                update.setLabel(dmData.getName(), idx);
            }
        }
    }

    protected int getNodeDeltaFlagsForDMEvent(IDMEvent<?> e) {
        if (e instanceof IRunControl.ISuspendedDMEvent) {
            return 1024;
        }
        if (e instanceof IRegisters.IRegistersChangedDMEvent) {
            return 1024;
        }
        return 0;
    }

    protected void buildDeltaForDMEvent(IDMEvent<?> e, VMDelta parent, int nodeOffset, RequestMonitor rm) {
        if (e instanceof IRunControl.ISuspendedDMEvent) {
            parent.addFlags(1024);
        }
        if (e instanceof IRegisters.IRegistersChangedDMEvent) {
            parent.addNode((Object)this.createVMContext((IDMContext<IRegisters.IRegisterGroupDMData>)((IRegisters.IRegistersChangedDMEvent)e).getDMContext()), 2048);
        }
        super.buildDeltaForDMEvent(e, parent, nodeOffset, rm);
    }

    @Override
    public int getExpressionLength(String expression) {
        int secondQuoteIdx;
        if (expression.startsWith("$$\"") && (secondQuoteIdx = expression.indexOf(34, "$$\"".length())) > 0) {
            return secondQuoteIdx + 1;
        }
        return -1;
    }

    @Override
    protected int getDeltaFlagsForExpressionPart(Object event) {
        if (event instanceof IRunControl.ISuspendedDMEvent) {
            return 1024;
        }
        return 0;
    }

    @Override
    public void buildDeltaForExpression(IExpression expression, int elementIdx, String expressionText, Object event, VMDelta parentDelta, TreePath path, RequestMonitor rm) {
        if (event instanceof IRunControl.ISuspendedDMEvent) {
            parentDelta.addFlags(1024);
        }
        super.buildDeltaForExpression(expression, elementIdx, expressionText, event, parentDelta, path, rm);
    }

    @Override
    protected void buildDeltaForExpressionElement(Object element, int elementIdx, Object event, VMDelta parentDelta, RequestMonitor rm) {
        if (event instanceof IRegisters.IRegistersChangedDMEvent) {
            parentDelta.addNode(element, 2048);
        }
        super.buildDeltaForExpressionElement(element, elementIdx, event, parentDelta, rm);
    }

    @Override
    protected void testContextForExpression(Object element, final String expression, final DataRequestMonitor<Boolean> rm) {
        if (!(element instanceof AbstractDMVMLayoutNode.DMVMContext)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10002, "Invalid context", null));
            rm.done();
            return;
        }
        IRegisters.IRegisterGroupDMContext dmc = (IRegisters.IRegisterGroupDMContext)DMContexts.getAncestorOfType((IDMContext)((AbstractDMVMLayoutNode.DMVMContext)element).getDMC(), IRegisters.IRegisterGroupDMContext.class);
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10002, "Invalid context", null));
            rm.done();
            return;
        }
        ((IDMService)this.getServicesTracker().getService(null, dmc.getServiceFilter())).getModelData((IDMContext)dmc, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterGroupDMData>(this.getSession().getExecutor(), rm){

            protected void handleOK() {
                int endIdx;
                int startIdx = "$$\"".length();
                String groupName = expression.substring(startIdx, endIdx = expression.indexOf(34, startIdx));
                if (groupName.equals(((IRegisters.IRegisterGroupDMData)this.getData()).getName())) {
                    rm.setData((Object)Boolean.TRUE);
                } else {
                    rm.setData((Object)Boolean.FALSE);
                }
                rm.done();
            }
        });
    }

    @Override
    protected void associateExpression(Object element, IExpression expression) {
        if (element instanceof RegisterGroupVMC) {
            ((RegisterGroupVMC)((Object)element)).setExpression(expression);
        }
    }

    public CellEditor getCellEditor(IPresentationContext context, String columnId, Object element, Composite parent) {
        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__EXPRESSION".equals(columnId)) {
            return new TextCellEditor(parent);
        }
        return null;
    }

    public ICellModifier getCellModifier(IPresentationContext context, Object element) {
        return this.fWatchExpressionCellModifier;
    }

    protected class RegisterGroupExpressionFactory
    implements IWatchExpressionFactoryAdapterExtension {
        protected RegisterGroupExpressionFactory() {
        }

        public boolean canCreateWatchExpression(IVariable variable) {
            return variable instanceof RegisterGroupVMC;
        }

        public String createWatchExpression(IVariable variable) throws CoreException {
            RegisterGroupVMC registerVmc = (RegisterGroupVMC)variable;
            StringBuffer exprBuf = new StringBuffer();
            IRegisters.IRegisterGroupDMContext groupDmc = (IRegisters.IRegisterGroupDMContext)DMContexts.getAncestorOfType((IDMContext)registerVmc.getDMC(), IRegisters.IRegisterGroupDMContext.class);
            if (groupDmc != null) {
                exprBuf.append("$$\"");
                exprBuf.append(groupDmc.getName());
                exprBuf.append('\"');
                return exprBuf.toString();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RegisterGroupVMC
    extends AbstractDMVMLayoutNode.DMVMContext
    implements IVariable {
        private IExpression fExpression;

        public RegisterGroupVMC(IDMContext<?> dmc) {
            super((AbstractDMVMLayoutNode)RegisterGroupLayoutNode.this, dmc);
        }

        public void setExpression(IExpression expression) {
            this.fExpression = expression;
        }

        public Object getAdapter(Class adapter) {
            if (this.fExpression != null && adapter.isAssignableFrom(this.fExpression.getClass())) {
                return this.fExpression;
            }
            if (adapter.isAssignableFrom(IWatchExpressionFactoryAdapterExtension.class)) {
                return RegisterGroupLayoutNode.this.fRegisterGroupExpressionFactory;
            }
            return super.getAdapter(adapter);
        }

        public boolean equals(Object other) {
            if (other instanceof RegisterGroupVMC && super.equals(other)) {
                RegisterGroupVMC otherGroup = (RegisterGroupVMC)((Object)other);
                return otherGroup.fExpression == null && this.fExpression == null || otherGroup.fExpression != null && otherGroup.fExpression.equals(this.fExpression);
            }
            return false;
        }

        public int hashCode() {
            return super.hashCode() + (this.fExpression != null ? this.fExpression.hashCode() : 0);
        }

        public String getName() throws DebugException {
            return this.toString();
        }

        public String getReferenceTypeName() throws DebugException {
            return "";
        }

        public IValue getValue() throws DebugException {
            return null;
        }

        public boolean hasValueChanged() throws DebugException {
            return false;
        }

        public void setValue(IValue value) throws DebugException {
        }

        public void setValue(String expression) throws DebugException {
        }

        public boolean supportsValueModification() {
            return false;
        }

        public boolean verifyValue(IValue value) throws DebugException {
            return false;
        }

        public boolean verifyValue(String expression) throws DebugException {
            return false;
        }

        public IDebugTarget getDebugTarget() {
            return null;
        }

        public ILaunch getLaunch() {
            return null;
        }

        public String getModelIdentifier() {
            return "org.eclipse.dd.dsf.debug.ui";
        }
    }
}

