/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.ui.viewmodel.register;

import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.Query;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.concurrent.ThreadSafeAndProhibitedFromDsfExecutor;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IFormattedValues;
import org.eclipse.dd.dsf.debug.service.IRegisters;
import org.eclipse.dd.dsf.debug.ui.DsfDebugUIPlugin;
import org.eclipse.dd.dsf.service.DsfSession;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafeAndProhibitedFromDsfExecutor(value="")
public class SyncRegisterDataAccess {
    private ServiceTracker fServiceTracker;

    private synchronized IRegisters getService(String filter) {
        if (this.fServiceTracker == null) {
            try {
                this.fServiceTracker = new ServiceTracker(DsfDebugUIPlugin.getBundleContext(), DsfDebugUIPlugin.getBundleContext().createFilter(filter), null);
                this.fServiceTracker.open();
            }
            catch (InvalidSyntaxException e) {
                assert (false) : "Invalid filter in DMC: " + filter;
                return null;
            }
        }
        try {
            assert (DsfDebugUIPlugin.getBundleContext().createFilter(filter).match(this.fServiceTracker.getServiceReference()));
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        return (IRegisters)this.fServiceTracker.getService();
    }

    public void dispose() {
        if (this.fServiceTracker != null) {
            this.fServiceTracker.close();
        }
    }

    public IRegisters.IBitFieldDMContext getBitFieldDMC(Object element) {
        if (element instanceof IAdaptable) {
            return (IRegisters.IBitFieldDMContext)((IAdaptable)element).getAdapter(IRegisters.IBitFieldDMContext.class);
        }
        return null;
    }

    public IRegisters.IBitFieldDMData readBitField(Object element) {
        IRegisters.IBitFieldDMContext dmc = this.getBitFieldDMC(element);
        if (dmc == null) {
            return null;
        }
        DsfSession session = DsfSession.getSession((String)dmc.getSessionId());
        if (session == null) {
            return null;
        }
        GetBitFieldValueQuery query = new GetBitFieldValueQuery(session.getExecutor(), dmc);
        session.getExecutor().execute((Runnable)((Object)query));
        try {
            return (IRegisters.IBitFieldDMData)query.get();
        }
        catch (InterruptedException e) {
            assert (false);
            return null;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public void writeBitField(Object element, String value, String formatId) {
        block6: {
            IRegisters.IBitFieldDMContext dmc = this.getBitFieldDMC(element);
            if (dmc == null) {
                return;
            }
            DsfSession session = DsfSession.getSession((String)dmc.getSessionId());
            if (session == null) {
                return;
            }
            SetBitFieldValueQuery query = new SetBitFieldValueQuery(session.getExecutor(), dmc, value, formatId);
            session.getExecutor().execute((Runnable)((Object)query));
            try {
                query.get();
            }
            catch (InterruptedException e) {
                assert (false);
            }
            catch (ExecutionException e) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
    }

    public void writeBitField(Object element, IRegisters.IMnemonic mnemonic) {
        IRegisters.IBitFieldDMContext dmc = this.getBitFieldDMC(element);
        if (dmc == null) {
            return;
        }
        DsfSession session = DsfSession.getSession((String)dmc.getSessionId());
        if (session == null) {
            return;
        }
        SetBitFieldValueMnemonicQuery query = new SetBitFieldValueMnemonicQuery(session.getExecutor(), dmc, mnemonic);
        session.getExecutor().execute((Runnable)((Object)query));
        try {
            query.get();
        }
        catch (InterruptedException e) {
            assert (false);
        }
        catch (ExecutionException e) {
            // empty catch block
        }
    }

    public IRegisters.IRegisterGroupDMContext getRegisterGroupDMC(Object element) {
        if (element instanceof IAdaptable) {
            return (IRegisters.IRegisterGroupDMContext)((IAdaptable)element).getAdapter(IRegisters.IRegisterGroupDMContext.class);
        }
        return null;
    }

    public IRegisters.IRegisterDMContext getRegisterDMC(Object element) {
        if (element instanceof IAdaptable) {
            return (IRegisters.IRegisterDMContext)((IAdaptable)element).getAdapter(IRegisters.IRegisterDMContext.class);
        }
        return null;
    }

    public IFormattedValues.IFormattedDataDMContext<?> getFormattedDMC(Object element) {
        if (element instanceof IAdaptable) {
            return (IFormattedValues.IFormattedDataDMContext)((IAdaptable)element).getAdapter(IFormattedValues.IFormattedDataDMContext.class);
        }
        return null;
    }

    public IRegisters.IRegisterGroupDMData readRegisterGroup(Object element) {
        IRegisters.IRegisterGroupDMContext dmc = this.getRegisterGroupDMC(element);
        if (dmc == null) {
            return null;
        }
        DsfSession session = DsfSession.getSession((String)dmc.getSessionId());
        if (session == null) {
            return null;
        }
        GetRegisterGroupValueQuery query = new GetRegisterGroupValueQuery(session.getExecutor(), dmc);
        session.getExecutor().execute((Runnable)((Object)query));
        try {
            return (IRegisters.IRegisterGroupDMData)query.get();
        }
        catch (InterruptedException e) {
            assert (false);
            return null;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public IRegisters.IRegisterDMData readRegister(Object element) {
        IRegisters.IRegisterDMContext dmc = this.getRegisterDMC(element);
        if (dmc == null) {
            return null;
        }
        DsfSession session = DsfSession.getSession((String)dmc.getSessionId());
        if (session == null) {
            return null;
        }
        GetRegisterValueQuery query = new GetRegisterValueQuery(session.getExecutor(), dmc);
        session.getExecutor().execute((Runnable)((Object)query));
        try {
            return (IRegisters.IRegisterDMData)query.get();
        }
        catch (InterruptedException e) {
            assert (false);
            return null;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public void writeRegister(Object element, String value, String formatId) {
        IRegisters.IRegisterDMContext dmc = this.getRegisterDMC(element);
        if (dmc == null) {
            return;
        }
        DsfSession session = DsfSession.getSession((String)dmc.getSessionId());
        if (session == null) {
            return;
        }
        SetRegisterValueQuery query = new SetRegisterValueQuery(session.getExecutor(), dmc, value, formatId);
        session.getExecutor().execute((Runnable)((Object)query));
        try {
            query.get();
        }
        catch (InterruptedException e) {
            assert (false);
        }
        catch (ExecutionException e) {
            // empty catch block
        }
    }

    public String[] getSupportedFormats(Object element) {
        IFormattedValues.IFormattedDataDMContext<?> dmc = this.getFormattedDMC(element);
        if (dmc == null) {
            return null;
        }
        DsfSession session = DsfSession.getSession((String)dmc.getSessionId());
        if (session == null) {
            return null;
        }
        GetSupportFormatsValueQuery query = new GetSupportFormatsValueQuery(session.getExecutor(), dmc);
        session.getExecutor().execute((Runnable)((Object)query));
        try {
            return (String[])query.get();
        }
        catch (InterruptedException e) {
            assert (false);
            return null;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public String getFormattedValue(Object element, String formatId) {
        IFormattedValues.IFormattedDataDMContext<?> dmc = this.getFormattedDMC(element);
        if (dmc == null) {
            return null;
        }
        DsfSession session = DsfSession.getSession((String)dmc.getSessionId());
        if (session == null) {
            return null;
        }
        GetFormattedValueValueQuery query = new GetFormattedValueValueQuery(session.getExecutor(), dmc, formatId);
        session.getExecutor().execute((Runnable)((Object)query));
        try {
            return (String)query.get();
        }
        catch (InterruptedException e) {
            assert (false);
            return null;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GetBitFieldValueQuery
    extends Query<IRegisters.IBitFieldDMData> {
        private IRegisters.IBitFieldDMContext fDmc;

        public GetBitFieldValueQuery(DsfExecutor executor, IRegisters.IBitFieldDMContext dmc) {
            super(executor);
            this.fDmc = dmc;
        }

        protected void execute(final DataRequestMonitor<IRegisters.IBitFieldDMData> rm) {
            final DsfSession session = DsfSession.getSession((String)this.fDmc.getSessionId());
            if (session == null) {
                this.cancel(false);
                return;
            }
            IRegisters service = SyncRegisterDataAccess.this.getService(this.fDmc.getServiceFilter());
            if (service == null) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10001, "Service not available", null));
                rm.done();
                return;
            }
            service.getModelData((IDMContext)this.fDmc, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IBitFieldDMData>(session.getExecutor(), rm){

                protected void handleCompleted() {
                    if (!DsfSession.isSessionActive((String)session.getId())) {
                        GetBitFieldValueQuery.this.cancel(false);
                        return;
                    }
                    super.handleCompleted();
                }

                protected void handleOK() {
                    rm.setData(this.getData());
                    rm.done();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GetFormattedValueValueQuery
    extends Query<Object> {
        private IFormattedValues.IFormattedDataDMContext<?> fDmc;
        private String fFormatId;

        public GetFormattedValueValueQuery(DsfExecutor executor, IFormattedValues.IFormattedDataDMContext<?> dmc, String formatId) {
            super(executor);
            this.fDmc = dmc;
            this.fFormatId = formatId;
        }

        protected void execute(final DataRequestMonitor<Object> rm) {
            final DsfSession session = DsfSession.getSession((String)this.fDmc.getSessionId());
            if (session == null) {
                this.cancel(false);
                return;
            }
            IRegisters service = SyncRegisterDataAccess.this.getService(this.fDmc.getServiceFilter());
            if (service == null) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10001, "Service unavailable", null));
                rm.done();
                return;
            }
            IFormattedValues.FormattedValueDMContext formDmc = service.getFormattedValue(this.fDmc, this.fFormatId);
            service.getModelData((IDMContext)formDmc, (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>(session.getExecutor(), rm){

                protected void handleCompleted() {
                    if (!DsfSession.isSessionActive((String)session.getId())) {
                        GetFormattedValueValueQuery.this.cancel(false);
                        return;
                    }
                    super.handleCompleted();
                }

                protected void handleOK() {
                    rm.setData((Object)((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue());
                    rm.done();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GetRegisterGroupValueQuery
    extends Query<IRegisters.IRegisterGroupDMData> {
        IRegisters.IRegisterGroupDMContext fDmc;

        public GetRegisterGroupValueQuery(DsfExecutor executor, IRegisters.IRegisterGroupDMContext dmc) {
            super(executor);
            this.fDmc = dmc;
        }

        protected void execute(final DataRequestMonitor<IRegisters.IRegisterGroupDMData> rm) {
            final DsfSession session = DsfSession.getSession((String)this.fDmc.getSessionId());
            if (session == null) {
                this.cancel(false);
                return;
            }
            IRegisters service = SyncRegisterDataAccess.this.getService(this.fDmc.getServiceFilter());
            if (service == null) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10001, "Service not available", null));
                rm.done();
                return;
            }
            service.getModelData((IDMContext)this.fDmc, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterGroupDMData>(session.getExecutor(), rm){

                protected void handleCompleted() {
                    if (!DsfSession.isSessionActive((String)session.getId())) {
                        GetRegisterGroupValueQuery.this.cancel(false);
                        return;
                    }
                    super.handleCompleted();
                }

                protected void handleOK() {
                    rm.setData(this.getData());
                    rm.done();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GetRegisterValueQuery
    extends Query<IRegisters.IRegisterDMData> {
        IRegisters.IRegisterDMContext fDmc;

        public GetRegisterValueQuery(DsfExecutor executor, IRegisters.IRegisterDMContext dmc) {
            super(executor);
            this.fDmc = dmc;
        }

        protected void execute(final DataRequestMonitor<IRegisters.IRegisterDMData> rm) {
            final DsfSession session = DsfSession.getSession((String)this.fDmc.getSessionId());
            if (session == null) {
                this.cancel(false);
                return;
            }
            IRegisters service = SyncRegisterDataAccess.this.getService(this.fDmc.getServiceFilter());
            if (service == null) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10001, "Service not available", null));
                rm.done();
                return;
            }
            service.getModelData((IDMContext)this.fDmc, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterDMData>(session.getExecutor(), rm){

                protected void handleCompleted() {
                    if (!DsfSession.isSessionActive((String)session.getId())) {
                        GetRegisterValueQuery.this.cancel(false);
                        return;
                    }
                    super.handleCompleted();
                }

                protected void handleOK() {
                    rm.setData(this.getData());
                    rm.done();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GetSupportFormatsValueQuery
    extends Query<Object> {
        IFormattedValues.IFormattedDataDMContext<?> fDmc;

        public GetSupportFormatsValueQuery(DsfExecutor executor, IFormattedValues.IFormattedDataDMContext<?> dmc) {
            super(executor);
            this.fDmc = dmc;
        }

        protected void execute(final DataRequestMonitor<Object> rm) {
            final DsfSession session = DsfSession.getSession((String)this.fDmc.getSessionId());
            if (session == null) {
                this.cancel(false);
                return;
            }
            IRegisters service = SyncRegisterDataAccess.this.getService(this.fDmc.getServiceFilter());
            if (service == null) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10001, "Service unavailable", null));
                rm.done();
                return;
            }
            service.getAvailableFormattedValues(this.fDmc, (DataRequestMonitor)new DataRequestMonitor<String[]>(session.getExecutor(), rm){

                protected void handleCompleted() {
                    if (!DsfSession.isSessionActive((String)session.getId())) {
                        GetSupportFormatsValueQuery.this.cancel(false);
                        return;
                    }
                    super.handleCompleted();
                }

                protected void handleOK() {
                    rm.setData(new Object());
                    rm.done();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SetBitFieldValueMnemonicQuery
    extends Query<Object> {
        IRegisters.IBitFieldDMContext fDmc;
        IRegisters.IMnemonic fMnemonic;

        public SetBitFieldValueMnemonicQuery(DsfExecutor executor, IRegisters.IBitFieldDMContext dmc, IRegisters.IMnemonic mnemonic) {
            super(executor);
            this.fDmc = dmc;
            this.fMnemonic = mnemonic;
        }

        protected void execute(final DataRequestMonitor<Object> rm) {
            final DsfSession session = DsfSession.getSession((String)this.fDmc.getSessionId());
            if (session == null) {
                this.cancel(false);
                return;
            }
            IRegisters service = SyncRegisterDataAccess.this.getService(this.fDmc.getServiceFilter());
            if (service == null) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10001, "Service unavailable", null));
                rm.done();
                return;
            }
            service.writeBitField((IDMContext)this.fDmc, this.fMnemonic, (RequestMonitor)new DataRequestMonitor<IRegisters.IBitFieldDMData>(session.getExecutor(), rm){

                protected void handleCompleted() {
                    if (!DsfSession.isSessionActive((String)session.getId())) {
                        SetBitFieldValueMnemonicQuery.this.cancel(false);
                        return;
                    }
                    super.handleCompleted();
                }

                protected void handleOK() {
                    rm.setData(new Object());
                    rm.done();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SetBitFieldValueQuery
    extends Query<Object> {
        private IRegisters.IBitFieldDMContext fDmc;
        private String fValue;
        private String fFormatId;

        public SetBitFieldValueQuery(DsfExecutor executor, IRegisters.IBitFieldDMContext dmc, String value, String formatId) {
            super(executor);
            this.fDmc = dmc;
            this.fValue = value;
            this.fFormatId = formatId;
        }

        protected void execute(final DataRequestMonitor<Object> rm) {
            final DsfSession session = DsfSession.getSession((String)this.fDmc.getSessionId());
            if (session == null) {
                this.cancel(false);
                return;
            }
            IRegisters service = SyncRegisterDataAccess.this.getService(this.fDmc.getServiceFilter());
            if (service == null) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10001, "Service unavailable", null));
                rm.done();
                return;
            }
            service.writeBitField((IDMContext)this.fDmc, this.fValue, this.fFormatId, (RequestMonitor)new DataRequestMonitor<IRegisters.IBitFieldDMData>(session.getExecutor(), rm){

                protected void handleCompleted() {
                    if (!DsfSession.isSessionActive((String)session.getId())) {
                        SetBitFieldValueQuery.this.cancel(false);
                        return;
                    }
                    super.handleCompleted();
                }

                protected void handleOK() {
                    rm.setData(new Object());
                    rm.done();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SetRegisterValueQuery
    extends Query<Object> {
        private IRegisters.IRegisterDMContext fDmc;
        private String fValue;
        private String fFormatId;

        public SetRegisterValueQuery(DsfExecutor executor, IRegisters.IRegisterDMContext dmc, String value, String formatId) {
            super(executor);
            this.fDmc = dmc;
            this.fValue = value;
            this.fFormatId = formatId;
        }

        protected void execute(final DataRequestMonitor<Object> rm) {
            final DsfSession session = DsfSession.getSession((String)this.fDmc.getSessionId());
            if (session == null) {
                this.cancel(false);
                return;
            }
            IRegisters service = SyncRegisterDataAccess.this.getService(this.fDmc.getServiceFilter());
            if (service == null) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10001, "Service unavailable", null));
                rm.done();
                return;
            }
            service.writeRegister((IDMContext)this.fDmc, this.fValue, this.fFormatId, (RequestMonitor)new DataRequestMonitor<IRegisters.IBitFieldDMData>(session.getExecutor(), rm){

                protected void handleCompleted() {
                    if (!DsfSession.isSessionActive((String)session.getId())) {
                        SetRegisterValueQuery.this.cancel(false);
                        return;
                    }
                    super.handleCompleted();
                }

                protected void handleOK() {
                    rm.setData(new Object());
                    rm.done();
                }
            });
        }
    }
}

