/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.ui.viewmodel.variable;

import java.util.Iterator;
import java.util.List;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMEvent;
import org.eclipse.dd.dsf.datamodel.IDMService;
import org.eclipse.dd.dsf.debug.service.IExpressions;
import org.eclipse.dd.dsf.debug.service.IFormattedValues;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.IStack;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.IVMLayoutNode;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.dd.dsf.ui.viewmodel.dm.AbstractDMVMLayoutNode;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableSubExpressionsLayoutNode
extends AbstractDMVMLayoutNode<IExpressions.IExpressionDMData> {
    private final IVMLayoutNode[] fChildLayoutNodes = new IVMLayoutNode[]{this};

    public VariableSubExpressionsLayoutNode(AbstractVMProvider provider, DsfSession session) {
        super(provider, session, IExpressions.IExpressionDMContext.class);
    }

    public IVMLayoutNode[] getChildLayoutNodes() {
        return this.fChildLayoutNodes;
    }

    protected void updateLabelInSessionThread(ILabelUpdate[] updates) {
        for (final ILabelUpdate update : updates) {
            final IExpressions.IExpressionDMContext dmc = (IExpressions.IExpressionDMContext)this.findDmcInPath(update.getElementPath(), IExpressions.IExpressionDMContext.class);
            ((IDMService)this.getServicesTracker().getService(null, dmc.getServiceFilter())).getModelData((IDMContext)dmc, (DataRequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMData>(this.getSession().getExecutor(), null){

                protected void handleCompleted() {
                    int idx;
                    if (!this.getStatus().isOK() || !((IExpressions.IExpressionDMData)this.getData()).isValid()) {
                        assert (this.getStatus().isOK() || this.getStatus().getCode() != 10005 || this.getStatus().getCode() != 10003);
                        VariableSubExpressionsLayoutNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                    String[] localColumns = update.getPresentationContext().getColumns();
                    if (localColumns == null) {
                        localColumns = new String[]{null};
                    }
                    boolean weAreExtractingFormattedData = false;
                    for (idx = 0; idx < localColumns.length; ++idx) {
                        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__NAME".equals(localColumns[idx])) {
                            update.setLabel(((IExpressions.IExpressionDMData)this.getData()).getName(), idx);
                            continue;
                        }
                        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__TYPE".equals(localColumns[idx])) {
                            update.setLabel(((IExpressions.IExpressionDMData)this.getData()).getTypeName(), idx);
                            continue;
                        }
                        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(localColumns[idx])) {
                            weAreExtractingFormattedData = true;
                            continue;
                        }
                        if (!"org.eclipse.dd.dsf.debug.ui.COLUMN_ID__DESCRIPTION".equals(localColumns[idx])) continue;
                        update.setLabel("", idx);
                    }
                    if (!weAreExtractingFormattedData) {
                        update.done();
                    } else {
                        for (idx = 0; idx < localColumns.length; ++idx) {
                            if (!"org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(localColumns[idx])) continue;
                            VariableSubExpressionsLayoutNode.this.updateFormattedExpressionValue(update, idx, dmc);
                        }
                    }
                }
            });
        }
    }

    private void updateFormattedExpressionValue(final ILabelUpdate update, final int labelIndex, final IExpressions.IExpressionDMContext dmc) {
        final IExpressions expressionService = (IExpressions)this.getServicesTracker().getService(IExpressions.class);
        String preferencePageFormatId = "NATURAL.Format";
        expressionService.getAvailableFormattedValues((IFormattedValues.IFormattedDataDMContext)dmc, (DataRequestMonitor)new DataRequestMonitor<String[]>(this.getSession().getExecutor(), null){

            public void handleCompleted() {
                if (!this.getStatus().isOK()) {
                    VariableSubExpressionsLayoutNode.this.handleFailedUpdate((IViewerUpdate)update);
                    return;
                }
                String[] formatIds = (String[])this.getData();
                String finalFormatId = "NATURAL.Format";
                boolean requestedFormatIsSupported = false;
                for (String fId : formatIds) {
                    if (!"NATURAL.Format".equals(fId)) continue;
                    finalFormatId = "NATURAL.Format";
                    requestedFormatIsSupported = true;
                    break;
                }
                if (!requestedFormatIsSupported) {
                    if (formatIds.length != 0) {
                        finalFormatId = formatIds[0];
                    } else {
                        VariableSubExpressionsLayoutNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                }
                IFormattedValues.FormattedValueDMContext valueDmc = expressionService.getFormattedValue((IFormattedValues.IFormattedDataDMContext)dmc, finalFormatId);
                expressionService.getModelData((IDMContext)valueDmc, (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>(VariableSubExpressionsLayoutNode.this.getSession().getExecutor(), null){

                    public void handleCompleted() {
                        if (!this.getStatus().isOK()) {
                            VariableSubExpressionsLayoutNode.this.handleFailedUpdate((IViewerUpdate)update);
                            return;
                        }
                        update.setLabel(((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue(), labelIndex);
                        update.done();
                    }
                });
            }
        });
    }

    protected void updateElementsInSessionThread(final IChildrenUpdate update) {
        IExpressions.IExpressionDMContext expressionDMC = (IExpressions.IExpressionDMContext)this.findDmcInPath(update.getElementPath(), IExpressions.IExpressionDMContext.class);
        IRunControl.IExecutionDMContext execDmc = (IRunControl.IExecutionDMContext)this.findDmcInPath(update.getElementPath(), IRunControl.IExecutionDMContext.class);
        IStack.IFrameDMContext frameDmc = (IStack.IFrameDMContext)this.findDmcInPath(update.getElementPath(), IStack.IFrameDMContext.class);
        IExpressions expressionService = (IExpressions)this.getServicesTracker().getService(IExpressions.class);
        if (execDmc == null || frameDmc == null || expressionService == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        DsfExecutor dsfExecutor = this.getSession().getExecutor();
        DataRequestMonitor<Iterable<IExpressions.IExpressionDMContext>> rm = new DataRequestMonitor<Iterable<IExpressions.IExpressionDMContext>>(dsfExecutor, null){

            public void handleCompleted() {
                if (!this.getStatus().isOK()) {
                    VariableSubExpressionsLayoutNode.this.handleFailedUpdate((IViewerUpdate)update);
                    return;
                }
                List subExpressionDMCList = (List)this.getData();
                IExpressions.IExpressionDMContext[] subExpressionDMCArray = new IExpressions.IExpressionDMContext[subExpressionDMCList.size()];
                Iterator iter = subExpressionDMCList.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    subExpressionDMCArray[i++] = (IExpressions.IExpressionDMContext)iter.next();
                }
                VariableSubExpressionsLayoutNode.this.fillUpdateWithVMCs(update, (IDMContext[])subExpressionDMCArray);
                update.done();
            }
        };
        expressionService.getSubExpressions(expressionDMC, (DataRequestMonitor)rm);
    }

    protected int getNodeDeltaFlagsForDMEvent(IDMEvent<?> e) {
        if (e instanceof IRunControl.ISuspendedDMEvent) {
            return 1024;
        }
        return 0;
    }

    protected void buildDeltaForDMEvent(IDMEvent<?> e, VMDelta parent, int nodeOffset, RequestMonitor requestMonitor) {
        if (e instanceof IRunControl.ISuspendedDMEvent) {
            parent.addFlags(1024);
        }
        super.buildDeltaForDMEvent(e, parent, nodeOffset, requestMonitor);
    }
}

