/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.ui.viewmodel.launch;

import java.util.List;
import java.util.concurrent.Executor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMEvent;
import org.eclipse.dd.dsf.datamodel.IDMService;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.IStack;
import org.eclipse.dd.dsf.debug.service.IStepQueueManager;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMLayoutNode;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.IVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.dd.dsf.ui.viewmodel.dm.AbstractDMVMLayoutNode;
import org.eclipse.dd.dsf.ui.viewmodel.update.VMCacheManager;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.DebugUITools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackFramesLayoutNode
extends AbstractDMVMLayoutNode {
    public IVMContext[] fCachedOldFrameVMCs;

    public StackFramesLayoutNode(AbstractVMProvider provider, DsfSession session) {
        super(provider, session, IStack.IFrameDMContext.class);
    }

    protected void updateHasElementsInSessionThread(IHasChildrenUpdate[] updates) {
        for (IHasChildrenUpdate update : updates) {
            if (!this.checkService(IStack.class, null, (IViewerUpdate)update)) {
                return;
            }
            IRunControl.IExecutionDMContext execDmc = (IRunControl.IExecutionDMContext)this.findDmcInPath(update.getElementPath(), IRunControl.IExecutionDMContext.class);
            if (execDmc == null) {
                this.handleFailedUpdate((IViewerUpdate)update);
                return;
            }
            update.setHasChilren(((IStack)this.getServicesTracker().getService(IStack.class)).isStackAvailable((IDMContext)execDmc));
            update.done();
        }
    }

    protected void updateElementsInSessionThread(final IChildrenUpdate update) {
        if (!this.checkService(IStack.class, null, (IViewerUpdate)update)) {
            return;
        }
        final IRunControl.IExecutionDMContext execDmc = (IRunControl.IExecutionDMContext)this.findDmcInPath(update.getElementPath(), IRunControl.IExecutionDMContext.class);
        if (execDmc == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        ((IStack)this.getServicesTracker().getService(IStack.class)).getFrames((IDMContext)execDmc, (DataRequestMonitor)new DataRequestMonitor<IStack.IFrameDMContext[]>((Executor)this.getSession().getExecutor(), null){

            public void handleCompleted() {
                if (!this.getStatus().isOK()) {
                    if (!StackFramesLayoutNode.this.checkService(IRunControl.class, null, (IViewerUpdate)update)) {
                        return;
                    }
                    if (((IRunControl)StackFramesLayoutNode.this.getServicesTracker().getService(IRunControl.class)).isStepping((IDMContext)execDmc)) {
                        StackFramesLayoutNode.this.getElementsTopStackFrameOnly(update);
                    } else {
                        update.done();
                    }
                    return;
                }
                StackFramesLayoutNode.this.fCachedOldFrameVMCs = StackFramesLayoutNode.this.dmcs2vmcs((IDMContext[])this.getData());
                for (int i = 0; i < StackFramesLayoutNode.this.fCachedOldFrameVMCs.length; ++i) {
                    update.setChild((Object)StackFramesLayoutNode.this.fCachedOldFrameVMCs[i], i);
                }
                update.done();
            }
        });
    }

    private void getElementsTopStackFrameOnly(final IChildrenUpdate update) {
        IRunControl.IExecutionDMContext execDmc = (IRunControl.IExecutionDMContext)this.findDmcInPath(update.getElementPath(), IRunControl.IExecutionDMContext.class);
        if (execDmc == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        ((IStack)this.getServicesTracker().getService(IStack.class)).getTopFrame((IDMContext)execDmc, (DataRequestMonitor)new DataRequestMonitor<IStack.IFrameDMContext>((Executor)this.getSession().getExecutor(), null){

            public void handleCompleted() {
                if (!this.getStatus().isOK()) {
                    StackFramesLayoutNode.this.handleFailedUpdate((IViewerUpdate)update);
                    return;
                }
                AbstractDMVMLayoutNode.DMVMContext topFrameVmc = new AbstractDMVMLayoutNode.DMVMContext((AbstractDMVMLayoutNode)StackFramesLayoutNode.this, (IDMContext)this.getData());
                update.setChild((Object)topFrameVmc, 0);
                if (StackFramesLayoutNode.this.fCachedOldFrameVMCs != null && StackFramesLayoutNode.this.fCachedOldFrameVMCs.length >= 1) {
                    StackFramesLayoutNode.this.fCachedOldFrameVMCs[0] = topFrameVmc;
                    for (int i = 0; i < StackFramesLayoutNode.this.fCachedOldFrameVMCs.length; ++i) {
                        update.setChild((Object)StackFramesLayoutNode.this.fCachedOldFrameVMCs[i], i);
                    }
                } else {
                    update.setChild((Object)topFrameVmc, 0);
                }
                update.done();
            }
        });
    }

    protected void updateLabelInSessionThread(ILabelUpdate[] updates) {
        for (final ILabelUpdate update : updates) {
            final IStack.IFrameDMContext dmc = (IStack.IFrameDMContext)this.findDmcInPath(update.getElementPath(), IStack.IFrameDMContext.class);
            if (!this.checkDmc((IDMContext)dmc, (IViewerUpdate)update) || !this.checkService(IStack.class, null, (IViewerUpdate)update)) continue;
            VMCacheManager.getVMCacheManager().getCache((Object)update.getPresentationContext()).getModelData((IDMService)this.getServicesTracker().getService(IStack.class, null), (IDMContext)dmc, (DataRequestMonitor)new DataRequestMonitor<IStack.IFrameDMData>((Executor)this.getSession().getExecutor(), null){

                protected void handleCompleted() {
                    if (!this.getStatus().isOK()) {
                        assert (this.getStatus().isOK() || this.getStatus().getCode() != 10005 || this.getStatus().getCode() != 10003);
                        StackFramesLayoutNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                    String[] localColumns = update.getPresentationContext().getColumns();
                    if (localColumns == null) {
                        localColumns = new String[]{null};
                    }
                    for (int i = 0; i < localColumns.length; ++i) {
                        StackFramesLayoutNode.this.fillColumnLabel(dmc, (IStack.IFrameDMData)this.getData(), localColumns[i], i, update);
                    }
                    update.done();
                }
            }, this.getExecutor());
        }
    }

    protected void fillColumnLabel(IStack.IFrameDMContext dmContext, IStack.IFrameDMData dmData, String columnId, int idx, ILabelUpdate update) {
        if (idx != 0) {
            return;
        }
        IRunControl.IExecutionDMContext execDmc = (IRunControl.IExecutionDMContext)this.findDmcInPath(update.getElementPath(), IRunControl.IExecutionDMContext.class);
        IRunControl runControlService = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
        IStepQueueManager stepQueueMgrService = (IStepQueueManager)this.getServicesTracker().getService(IStepQueueManager.class);
        if (execDmc == null || runControlService == null || stepQueueMgrService == null) {
            return;
        }
        String imageKey = null;
        imageKey = runControlService.isSuspended((IDMContext)execDmc) || runControlService.isStepping((IDMContext)execDmc) && !stepQueueMgrService.isSteppingTimedOut((IDMContext)execDmc) ? "IMG_OBJS_STACKFRAME" : "IMG_OBJS_STACKFRAME_RUNNING";
        update.setImageDescriptor(DebugUITools.getImageDescriptor((String)imageKey), 0);
        StringBuilder label = new StringBuilder();
        if (this.fCachedOldFrameVMCs != null) {
            label.append(this.fCachedOldFrameVMCs.length - dmData.getLevel());
        }
        if (dmData.getFunction() != null && dmData.getFunction().length() != 0) {
            label.append(" ");
            label.append(dmData.getFunction());
            label.append("()");
        }
        if (dmData.getFile() != null && dmData.getFile().length() != 0) {
            label.append(" at ");
            label.append(dmData.getFile());
        }
        if (dmData.getLine() >= 0) {
            label.append(":");
            label.append(dmData.getLine());
            label.append(" ");
        }
        label.append(dmData.getAddress());
        update.setLabel(label.toString(), 0);
    }

    protected void handleFailedUpdate(IViewerUpdate update) {
        if (!(update instanceof ILabelUpdate)) {
            super.handleFailedUpdate(update);
        }
    }

    protected int getNodeDeltaFlagsForDMEvent(IDMEvent<?> e) {
        if (e instanceof IRunControl.ISuspendedDMEvent) {
            return 0x300400;
        }
        if (e instanceof IRunControl.IResumedDMEvent) {
            if (((IRunControl.IResumedDMEvent)e).getReason() == IRunControl.StateChangeReason.STEP) {
                return 2048;
            }
            return 1024;
        }
        if (e instanceof IStepQueueManager.ISteppingTimedOutEvent) {
            return 1024;
        }
        return 0;
    }

    protected void buildDeltaForDMEvent(IDMEvent<?> e, VMDelta parent, int nodeOffset, RequestMonitor rm) {
        if (e instanceof IRunControl.IContainerSuspendedDMEvent) {
            IRunControl.IExecutionDMContext threadDmc = null;
            if (parent.getElement() instanceof AbstractDMVMLayoutNode.DMVMContext) {
                threadDmc = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)((AbstractDMVMLayoutNode.DMVMContext)parent.getElement()).getDMC(), IRunControl.IExecutionDMContext.class);
            }
            this.buildDeltaForSuspendedEvent((IRunControl.ISuspendedDMEvent)e, threadDmc, ((IRunControl.IContainerSuspendedDMEvent)e).getTriggeringContext(), parent, nodeOffset, rm);
        } else if (e instanceof IRunControl.ISuspendedDMEvent) {
            IRunControl.IExecutionDMContext execDmc = (IRunControl.IExecutionDMContext)((IRunControl.ISuspendedDMEvent)e).getDMContext();
            this.buildDeltaForSuspendedEvent((IRunControl.ISuspendedDMEvent)e, execDmc, execDmc, parent, nodeOffset, rm);
        } else if (e instanceof IRunControl.IResumedDMEvent) {
            this.buildDeltaForResumedEvent((IRunControl.IResumedDMEvent)e, parent, nodeOffset, rm);
        } else if (e instanceof IStepQueueManager.ISteppingTimedOutEvent) {
            this.buildDeltaForSteppingTimedOutEvent((IStepQueueManager.ISteppingTimedOutEvent)e, parent, nodeOffset, rm);
        } else {
            super.buildDeltaForDMEvent(e, parent, nodeOffset, rm);
        }
    }

    private void buildDeltaForSuspendedEvent(final IRunControl.ISuspendedDMEvent e, IRunControl.IExecutionDMContext executionCtx, IRunControl.IExecutionDMContext triggeringCtx, final VMDelta parent, final int nodeOffset, final RequestMonitor rm) {
        IRunControl runControlService = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
        IStack stackService = (IStack)this.getServicesTracker().getService(IStack.class);
        if (stackService == null || runControlService == null) {
            super.buildDeltaForDMEvent((IDMEvent)e, parent, nodeOffset, rm);
            return;
        }
        if (!runControlService.isStepping((IDMContext)triggeringCtx)) {
            parent.addFlags(1024);
        }
        if (executionCtx.equals(triggeringCtx)) {
            parent.addFlags(0x100000);
            this.getElementsTopStackFrameOnly((IChildrenUpdate)new AbstractVMLayoutNode.ElementsUpdate((AbstractVMLayoutNode)this, (DataRequestMonitor)new DataRequestMonitor<List<Object>>((Executor)this.getSession().getExecutor(), null){

                public void handleCompleted() {
                    if (this.getStatus().isOK() && ((List)this.getData()).size() != 0) {
                        parent.addNode(((List)this.getData()).get(0), 0x200800);
                        if (((List)this.getData()).size() >= 2) {
                            parent.addNode(((List)this.getData()).get(1), 2048);
                        }
                    }
                    StackFramesLayoutNode.super.buildDeltaForDMEvent((IDMEvent)e, parent, nodeOffset, rm);
                }
            }, (IModelDelta)parent));
        } else {
            StackFramesLayoutNode.super.buildDeltaForDMEvent((IDMEvent)e, parent, nodeOffset, rm);
        }
    }

    private void buildDeltaForResumedEvent(IRunControl.IResumedDMEvent e, VMDelta parent, int nodeOffset, RequestMonitor rm) {
        IStack stackService = (IStack)this.getServicesTracker().getService(IStack.class);
        if (stackService == null) {
            super.buildDeltaForDMEvent((IDMEvent)e, parent, nodeOffset, rm);
            return;
        }
        IRunControl.IResumedDMEvent resumedEvent = e;
        if (resumedEvent.getReason() != IRunControl.StateChangeReason.STEP) {
            parent.addFlags(1024);
            this.fCachedOldFrameVMCs = null;
        }
        super.buildDeltaForDMEvent((IDMEvent)e, parent, nodeOffset, rm);
    }

    private void buildDeltaForSteppingTimedOutEvent(IStepQueueManager.ISteppingTimedOutEvent e, VMDelta parent, int nodeOffset, RequestMonitor rm) {
        parent.addFlags(1024);
        super.buildDeltaForDMEvent((IDMEvent)e, parent, nodeOffset, rm);
    }
}

