/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.ui.viewmodel.register;

import java.util.concurrent.Executor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMEvent;
import org.eclipse.dd.dsf.datamodel.IDMService;
import org.eclipse.dd.dsf.debug.service.IFormattedValues;
import org.eclipse.dd.dsf.debug.service.IRegisters;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.ui.viewmodel.expression.AbstractExpressionLayoutNode;
import org.eclipse.dd.dsf.debug.ui.viewmodel.formatsupport.IFormattedValuePreferenceStore;
import org.eclipse.dd.dsf.debug.ui.viewmodel.formatsupport.IFormattedValueVMContext;
import org.eclipse.dd.dsf.debug.ui.viewmodel.register.RegisterBitFieldLayoutCellModifier;
import org.eclipse.dd.dsf.debug.ui.viewmodel.register.SyncRegisterDataAccess;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.IVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.dd.dsf.ui.viewmodel.dm.AbstractDMVMLayoutNode;
import org.eclipse.dd.dsf.ui.viewmodel.update.VMCacheManager;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementEditor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.actions.IWatchExpressionFactoryAdapterExtension;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisterBitFieldLayoutNode
extends AbstractExpressionLayoutNode
implements IElementEditor {
    private SyncRegisterDataAccess fDataAccess = null;
    protected final BitFieldExpressionFactory fBitFieldExpressionFactory = new BitFieldExpressionFactory();
    private final IFormattedValuePreferenceStore fFormattedPrefStore;

    public RegisterBitFieldLayoutNode(IFormattedValuePreferenceStore prefStore, AbstractVMProvider provider, DsfSession session, SyncRegisterDataAccess access) {
        super(provider, session, IRegisters.IBitFieldDMContext.class);
        this.fDataAccess = access;
        this.fFormattedPrefStore = prefStore;
    }

    public IFormattedValuePreferenceStore getPreferenceStore() {
        return this.fFormattedPrefStore;
    }

    private void updateFormattedRegisterValue(final ILabelUpdate update, final int labelIndex, final IRegisters.IBitFieldDMContext dmc, final IRegisters.IBitFieldDMData data) {
        final IRegisters regService = (IRegisters)this.getServicesTracker().getService(IRegisters.class);
        IPresentationContext context = update.getPresentationContext();
        final String preferencePageFormatId = this.fFormattedPrefStore.getCurrentNumericFormat(context);
        regService.getAvailableFormats((IFormattedValues.IFormattedDataDMContext)dmc, (DataRequestMonitor)new DataRequestMonitor<String[]>((Executor)this.getSession().getExecutor(), null){

            public void handleCompleted() {
                if (!this.getStatus().isOK()) {
                    RegisterBitFieldLayoutNode.this.handleFailedUpdate((IViewerUpdate)update);
                    return;
                }
                String[] formatIds = (String[])this.getData();
                String finalFormatId = "HEX.Format";
                boolean requestedFormatIsSupported = false;
                for (String fId : formatIds) {
                    if (!preferencePageFormatId.equals(fId)) continue;
                    finalFormatId = preferencePageFormatId;
                    requestedFormatIsSupported = true;
                    break;
                }
                if (!requestedFormatIsSupported) {
                    if (formatIds.length != 0) {
                        finalFormatId = formatIds[0];
                    } else {
                        RegisterBitFieldLayoutNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                }
                IFormattedValues.FormattedValueDMContext valueDmc = regService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)dmc, finalFormatId);
                VMCacheManager.getVMCacheManager().getCache((Object)update.getPresentationContext()).getModelData((IDMService)regService, (IDMContext)valueDmc, (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)RegisterBitFieldLayoutNode.this.getSession().getExecutor(), null){

                    public void handleCompleted() {
                        if (!this.getStatus().isOK()) {
                            RegisterBitFieldLayoutNode.this.handleFailedUpdate((IViewerUpdate)update);
                            return;
                        }
                        IRegisters.IMnemonic mnemonic = data.getCurrentMnemonicValue();
                        if (mnemonic != null) {
                            String mnemstr = mnemonic.getLongName() + " - " + ((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue();
                            update.setLabel(mnemstr, labelIndex);
                        } else {
                            update.setLabel(((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue(), labelIndex);
                        }
                        update.done();
                    }
                }, RegisterBitFieldLayoutNode.this.getExecutor());
            }
        });
    }

    protected void updateLabelInSessionThread(ILabelUpdate[] updates) {
        for (final ILabelUpdate update : updates) {
            final IRegisters.IBitFieldDMContext dmc = (IRegisters.IBitFieldDMContext)this.findDmcInPath(update.getElementPath(), IRegisters.IBitFieldDMContext.class);
            VMCacheManager.getVMCacheManager().getCache((Object)update.getPresentationContext()).getModelData((IDMService)this.getServicesTracker().getService(IRegisters.class), (IDMContext)dmc, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IBitFieldDMData>((Executor)this.getSession().getExecutor(), null){

                protected void handleCompleted() {
                    int idx;
                    if (!this.getStatus().isOK()) {
                        assert (this.getStatus().isOK() || this.getStatus().getCode() != 10005 || this.getStatus().getCode() != 10003);
                        RegisterBitFieldLayoutNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                    String[] localColumns = update.getPresentationContext().getColumns();
                    if (localColumns == null) {
                        localColumns = new String[]{"org.eclipse.dd.dsf.debug.ui.COLUMN_ID__NAME"};
                    }
                    boolean weAreExtractingFormattedData = false;
                    for (idx = 0; idx < localColumns.length; ++idx) {
                        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__NAME".equals(localColumns[idx])) {
                            update.setLabel(((IRegisters.IBitFieldDMData)this.getData()).getName(), idx);
                            continue;
                        }
                        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(localColumns[idx])) {
                            weAreExtractingFormattedData = true;
                            continue;
                        }
                        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__TYPE".equals(localColumns[idx])) {
                            IRegisters.IBitFieldDMData data = (IRegisters.IBitFieldDMData)this.getData();
                            String typeStr = "Unsigned";
                            String ReadAttrStr = "ReadNone";
                            String WriteAddrStr = "WriteNone";
                            if (data.isReadOnce()) {
                                ReadAttrStr = "ReadOnce";
                            } else if (data.isReadable()) {
                                ReadAttrStr = "Readable";
                            }
                            if (data.isReadOnce()) {
                                WriteAddrStr = "WriteOnce";
                            } else if (data.isReadable()) {
                                WriteAddrStr = "Writeable";
                            }
                            typeStr = typeStr + " - " + ReadAttrStr + "/" + WriteAddrStr;
                            update.setLabel(typeStr, idx);
                            continue;
                        }
                        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__DESCRIPTION".equals(localColumns[idx])) {
                            update.setLabel(((IRegisters.IBitFieldDMData)this.getData()).getDescription(), idx);
                            continue;
                        }
                        if (!"org.eclipse.dd.dsf.debug.ui.COLUMN_ID__EXPRESSION".equals(localColumns[idx])) continue;
                        IVMContext vmc = (IVMContext)update.getElement();
                        IExpression expression = (IExpression)vmc.getAdapter(IExpression.class);
                        if (expression != null) {
                            update.setLabel(expression.getExpressionText(), idx);
                            continue;
                        }
                        update.setLabel(((IRegisters.IBitFieldDMData)this.getData()).getName(), idx);
                    }
                    if (!weAreExtractingFormattedData) {
                        update.done();
                    } else {
                        for (idx = 0; idx < localColumns.length; ++idx) {
                            if (!"org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(localColumns[idx])) continue;
                            RegisterBitFieldLayoutNode.this.updateFormattedRegisterValue(update, idx, dmc, (IRegisters.IBitFieldDMData)this.getData());
                        }
                    }
                }
            }, this.getExecutor());
        }
    }

    protected void updateElementsInSessionThread(final IChildrenUpdate update) {
        IRegisters.IRegisterDMContext regDmc = (IRegisters.IRegisterDMContext)this.findDmcInPath(update.getElementPath(), IRegisters.IRegisterDMContext.class);
        if (regDmc == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        ((IRegisters)this.getServicesTracker().getService(IRegisters.class)).getBitFields((IDMContext)regDmc, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IBitFieldDMContext[]>((Executor)this.getSession().getExecutor(), null){

            protected void handleErrorOrCancel() {
                RegisterBitFieldLayoutNode.this.handleFailedUpdate((IViewerUpdate)update);
            }

            protected void handleOK() {
                RegisterBitFieldLayoutNode.this.fillUpdateWithVMCs(update, (IDMContext[])this.getData());
                update.done();
            }
        });
    }

    protected IVMContext createVMContext(IDMContext dmc) {
        return new BitFieldVMC(dmc);
    }

    protected int getNodeDeltaFlagsForDMEvent(IDMEvent<?> e) {
        if (e instanceof IRegisters.IBitFieldChangedDMEvent) {
            return 2048;
        }
        return 0;
    }

    protected void buildDeltaForDMEvent(IDMEvent<?> e, VMDelta parent, int nodeOffset, RequestMonitor rm) {
        if (e instanceof IRegisters.IBitFieldChangedDMEvent) {
            VMCacheManager.getVMCacheManager().flush((Object)super.getVMProvider().getPresentationContext());
            parent.addNode((Object)this.createVMContext(((IRegisters.IBitFieldChangedDMEvent)e).getDMContext()), 2048);
        }
        super.buildDeltaForDMEvent(e, parent, nodeOffset, rm);
    }

    public CellEditor getCellEditor(IPresentationContext context, String columnId, Object element, Composite parent) {
        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(columnId)) {
            IRegisters.IBitFieldDMData bitFieldData = this.fDataAccess.readBitField(element);
            if (bitFieldData != null && bitFieldData.isWriteable()) {
                IRegisters.IMnemonic[] mnemonics = bitFieldData.getMnemonics();
                if (mnemonics != null && mnemonics.length != 0) {
                    String[] StringValues = new String[mnemonics.length];
                    int idx = 0;
                    for (IRegisters.IMnemonic mnemonic : mnemonics) {
                        StringValues[idx++] = mnemonic.getLongName();
                    }
                    return new ComboBoxCellEditor(parent, StringValues);
                }
                return new TextCellEditor(parent);
            }
        } else if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__EXPRESSION".equals(columnId)) {
            return new TextCellEditor(parent);
        }
        return null;
    }

    public ICellModifier getCellModifier(IPresentationContext context, Object element) {
        IRegisters.IBitFieldDMData bitFieldData = this.fDataAccess.readBitField(element);
        if (bitFieldData != null && bitFieldData.isWriteable()) {
            IRegisters.IMnemonic[] mnemonics = bitFieldData.getMnemonics();
            if (mnemonics != null && mnemonics.length != 0) {
                return new RegisterBitFieldLayoutCellModifier(this.fFormattedPrefStore, RegisterBitFieldLayoutCellModifier.BitFieldEditorStyle.BITFIELDCOMBO, this.fDataAccess);
            }
            return new RegisterBitFieldLayoutCellModifier(this.fFormattedPrefStore, RegisterBitFieldLayoutCellModifier.BitFieldEditorStyle.BITFIELDTEXT, this.fDataAccess);
        }
        return null;
    }

    @Override
    protected void testContextForExpression(Object element, String expression, DataRequestMonitor<Boolean> rm) {
        if (!(element instanceof AbstractDMVMLayoutNode.DMVMContext)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10002, "Invalid context", null));
            rm.done();
            return;
        }
        IRegisters.IBitFieldDMContext dmc = (IRegisters.IBitFieldDMContext)DMContexts.getAncestorOfType((IDMContext)((AbstractDMVMLayoutNode.DMVMContext)element).getDMC(), IRegisters.IBitFieldDMContext.class);
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10002, "Invalid context", null));
            rm.done();
            return;
        }
        String bitFieldName = expression.substring(1);
        if (bitFieldName.equals(dmc.getName())) {
            rm.setData((Object)Boolean.TRUE);
        } else {
            rm.setData((Object)Boolean.FALSE);
        }
        rm.done();
    }

    @Override
    public int getExpressionLength(String expression) {
        if (expression.charAt(0) == '.' && Character.isLetterOrDigit(expression.charAt(1))) {
            int length;
            for (length = 1; length < expression.length() && Character.isLetterOrDigit(expression.charAt(length)); ++length) {
            }
            return length;
        }
        return -1;
    }

    @Override
    protected void associateExpression(Object element, IExpression expression) {
        if (element instanceof BitFieldVMC) {
            ((BitFieldVMC)element).setExpression(expression);
        }
    }

    @Override
    protected int getDeltaFlagsForExpressionPart(Object event) {
        if (event instanceof IRunControl.ISuspendedDMEvent) {
            return 1024;
        }
        return 0;
    }

    @Override
    public void buildDeltaForExpression(IExpression expression, int elementIdx, String expressionText, Object event, VMDelta parentDelta, TreePath path, RequestMonitor rm) {
        if (event instanceof IRunControl.ISuspendedDMEvent) {
            parentDelta.addFlags(1024);
        } else if (event instanceof IRegisters.IRegisterChangedDMEvent) {
            parentDelta.addFlags(1024);
        }
        super.buildDeltaForExpression(expression, elementIdx, expressionText, event, parentDelta, path, rm);
    }

    @Override
    protected void buildDeltaForExpressionElement(Object element, int elementIdx, Object event, VMDelta parentDelta, RequestMonitor rm) {
        if (event instanceof IRegisters.IBitFieldChangedDMEvent) {
            parentDelta.addNode(element, 2048);
        }
        super.buildDeltaForExpressionElement(element, elementIdx, event, parentDelta, rm);
    }

    protected class BitFieldExpressionFactory
    implements IWatchExpressionFactoryAdapterExtension {
        protected BitFieldExpressionFactory() {
        }

        public boolean canCreateWatchExpression(IVariable variable) {
            return variable instanceof BitFieldVMC;
        }

        public String createWatchExpression(IVariable variable) throws CoreException {
            IRegisters.IBitFieldDMContext bitFieldDmc;
            IRegisters.IRegisterDMContext registerDmc;
            BitFieldVMC bitFieldVmc = (BitFieldVMC)variable;
            StringBuffer exprBuf = new StringBuffer();
            IRegisters.IRegisterGroupDMContext groupDmc = (IRegisters.IRegisterGroupDMContext)DMContexts.getAncestorOfType((IDMContext)bitFieldVmc.getDMC(), IRegisters.IRegisterGroupDMContext.class);
            if (groupDmc != null) {
                exprBuf.append("$$\"");
                exprBuf.append(groupDmc.getName());
                exprBuf.append('\"');
            }
            if ((registerDmc = (IRegisters.IRegisterDMContext)DMContexts.getAncestorOfType((IDMContext)bitFieldVmc.getDMC(), IRegisters.IRegisterDMContext.class)) != null) {
                exprBuf.append('$');
                exprBuf.append(registerDmc.getName());
            }
            if ((bitFieldDmc = (IRegisters.IBitFieldDMContext)DMContexts.getAncestorOfType((IDMContext)bitFieldVmc.getDMC(), IRegisters.IBitFieldDMContext.class)) != null) {
                exprBuf.append('.');
                exprBuf.append(bitFieldDmc.getName());
            }
            return exprBuf.toString();
        }
    }

    protected class BitFieldVMC
    extends AbstractDMVMLayoutNode.DMVMContext
    implements IVariable,
    IFormattedValueVMContext {
        private IExpression fExpression;

        public BitFieldVMC(IDMContext dmc) {
            super((AbstractDMVMLayoutNode)RegisterBitFieldLayoutNode.this, dmc);
        }

        public IFormattedValuePreferenceStore getPreferenceStore() {
            return RegisterBitFieldLayoutNode.this.fFormattedPrefStore;
        }

        public void setExpression(IExpression expression) {
            this.fExpression = expression;
        }

        public Object getAdapter(Class adapter) {
            if (this.fExpression != null && adapter.isAssignableFrom(this.fExpression.getClass())) {
                return this.fExpression;
            }
            if (adapter.isAssignableFrom(IWatchExpressionFactoryAdapterExtension.class)) {
                return RegisterBitFieldLayoutNode.this.fBitFieldExpressionFactory;
            }
            return super.getAdapter(adapter);
        }

        public boolean equals(Object other) {
            if (other instanceof BitFieldVMC && super.equals(other)) {
                BitFieldVMC otherBitField = (BitFieldVMC)other;
                return otherBitField.fExpression == null && this.fExpression == null || otherBitField.fExpression != null && otherBitField.fExpression.equals(this.fExpression);
            }
            return false;
        }

        public int hashCode() {
            return super.hashCode() + (this.fExpression != null ? this.fExpression.hashCode() : 0);
        }

        public String getName() throws DebugException {
            return this.toString();
        }

        public String getReferenceTypeName() throws DebugException {
            return "";
        }

        public IValue getValue() throws DebugException {
            return null;
        }

        public boolean hasValueChanged() throws DebugException {
            return false;
        }

        public void setValue(IValue value) throws DebugException {
        }

        public void setValue(String expression) throws DebugException {
        }

        public boolean supportsValueModification() {
            return false;
        }

        public boolean verifyValue(IValue value) throws DebugException {
            return false;
        }

        public boolean verifyValue(String expression) throws DebugException {
            return false;
        }

        public IDebugTarget getDebugTarget() {
            return null;
        }

        public ILaunch getLaunch() {
            return null;
        }

        public String getModelIdentifier() {
            return "org.eclipse.dd.dsf.debug.ui";
        }
    }
}

