/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.ui.viewmodel.variable;

import java.util.ArrayList;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.MultiRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMService;
import org.eclipse.dd.dsf.debug.service.IExpressions;
import org.eclipse.dd.dsf.debug.service.IFormattedValues;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.IStack;
import org.eclipse.dd.dsf.debug.ui.viewmodel.expression.AbstractExpressionLayoutNode;
import org.eclipse.dd.dsf.debug.ui.viewmodel.formatsupport.IFormattedValuePreferenceStore;
import org.eclipse.dd.dsf.debug.ui.viewmodel.formatsupport.IFormattedValueVMContext;
import org.eclipse.dd.dsf.debug.ui.viewmodel.variable.SyncVariableDataAccess;
import org.eclipse.dd.dsf.debug.ui.viewmodel.variable.VariableLayoutValueCellModifier;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.IVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.IVMLayoutNode;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.dd.dsf.ui.viewmodel.dm.AbstractDMVMLayoutNode;
import org.eclipse.dd.dsf.ui.viewmodel.update.VMCacheManager;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementEditor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.actions.IWatchExpressionFactoryAdapterExtension;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableLayoutNode
extends AbstractExpressionLayoutNode
implements IElementEditor {
    private final IVMLayoutNode[] fChildLayoutNodes = new IVMLayoutNode[]{this};
    private static final int MAX_STRING_VALUE_LENGTH = 40;
    private final IFormattedValuePreferenceStore fFormattedPrefStore;
    private final SyncVariableDataAccess fSyncVariableDataAccess;
    protected final VariableExpressionFactory fVariableExpressionFactory = new VariableExpressionFactory();

    public IVMLayoutNode[] getChildLayoutNodes() {
        return this.fChildLayoutNodes;
    }

    public int getDeltaFlags(Object e) {
        if (e instanceof IRunControl.ISuspendedDMEvent) {
            return 1024;
        }
        if (e instanceof IExpressions.IExpressionChangedDMEvent) {
            return 2048;
        }
        return 0;
    }

    public void buildDelta(Object event, VMDelta parentDelta, int nodeOffset, RequestMonitor requestMonitor) {
        if (event instanceof IRunControl.ISuspendedDMEvent) {
            parentDelta.addFlags(1024);
        } else if (event instanceof IExpressions.IExpressionChangedDMEvent) {
            VMCacheManager.getVMCacheManager().flush((Object)super.getVMProvider().getPresentationContext());
            parentDelta.addNode((Object)this.createVMContext(((IExpressions.IExpressionChangedDMEvent)event).getDMContext()), 3072);
        }
        requestMonitor.done();
    }

    public VariableLayoutNode(IFormattedValuePreferenceStore prefStore, AbstractVMProvider provider, DsfSession session, SyncVariableDataAccess syncVariableDataAccess) {
        super(provider, session, IExpressions.IExpressionDMContext.class);
        this.fFormattedPrefStore = prefStore;
        this.fSyncVariableDataAccess = syncVariableDataAccess;
    }

    protected IVMContext createVMContext(IDMContext dmc) {
        return new VariableExpressionVMC(dmc);
    }

    protected void updateLabelInSessionThread(ILabelUpdate[] updates) {
        for (final ILabelUpdate update : updates) {
            final IExpressions.IExpressionDMContext dmc = (IExpressions.IExpressionDMContext)this.findDmcInPath(update.getElementPath(), IExpressions.IExpressionDMContext.class);
            VMCacheManager.getVMCacheManager().getCache((Object)update.getPresentationContext()).getModelData((IDMService)this.getServicesTracker().getService(IExpressions.class, null), (IDMContext)dmc, (DataRequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMData>((Executor)this.getSession().getExecutor(), null){

                protected void handleCompleted() {
                    int idx;
                    if (!this.getStatus().isOK()) {
                        assert (this.getStatus().isOK() || this.getStatus().getCode() != 10005 || this.getStatus().getCode() != 10003);
                        String[] localColumns = update.getPresentationContext().getColumns();
                        if (localColumns == null) {
                            localColumns = new String[]{"org.eclipse.dd.dsf.debug.ui.COLUMN_ID__NAME"};
                        }
                        for (int idx2 = 0; idx2 < localColumns.length; ++idx2) {
                            if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__NAME".equals(localColumns[idx2])) {
                                update.setLabel(dmc.getExpression(), idx2);
                                continue;
                            }
                            if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__TYPE".equals(localColumns[idx2])) {
                                update.setLabel("", idx2);
                                continue;
                            }
                            if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(localColumns[idx2])) {
                                update.setLabel("Error : " + this.getStatus().getMessage(), idx2);
                                continue;
                            }
                            if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__DESCRIPTION".equals(localColumns[idx2])) {
                                update.setLabel("", idx2);
                                continue;
                            }
                            if (!"org.eclipse.dd.dsf.debug.ui.COLUMN_ID__EXPRESSION".equals(localColumns[idx2])) continue;
                            update.setLabel(dmc.getExpression(), idx2);
                        }
                        update.done();
                        return;
                    }
                    String[] localColumns = update.getPresentationContext().getColumns();
                    if (localColumns == null) {
                        localColumns = new String[]{"org.eclipse.dd.dsf.debug.ui.COLUMN_ID__NAME"};
                    }
                    boolean weAreExtractingFormattedData = false;
                    for (idx = 0; idx < localColumns.length; ++idx) {
                        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__NAME".equals(localColumns[idx])) {
                            update.setLabel(((IExpressions.IExpressionDMData)this.getData()).getName(), idx);
                            continue;
                        }
                        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__TYPE".equals(localColumns[idx])) {
                            update.setLabel(((IExpressions.IExpressionDMData)this.getData()).getTypeName(), idx);
                            continue;
                        }
                        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(localColumns[idx])) {
                            weAreExtractingFormattedData = true;
                            continue;
                        }
                        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__DESCRIPTION".equals(localColumns[idx])) {
                            update.setLabel("", idx);
                            continue;
                        }
                        if (!"org.eclipse.dd.dsf.debug.ui.COLUMN_ID__EXPRESSION".equals(localColumns[idx])) continue;
                        update.setLabel(((IExpressions.IExpressionDMData)this.getData()).getName(), idx);
                    }
                    if (!weAreExtractingFormattedData) {
                        update.done();
                    } else {
                        for (idx = 0; idx < localColumns.length; ++idx) {
                            if (!"org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(localColumns[idx])) continue;
                            VariableLayoutNode.this.updateFormattedExpressionValue(update, idx, dmc, (IExpressions.IExpressionDMData)this.getData());
                        }
                    }
                }
            }, this.getExecutor());
        }
    }

    private void updateFormattedExpressionValue(final ILabelUpdate update, final int labelIndex, final IExpressions.IExpressionDMContext dmc, final IExpressions.IExpressionDMData expressionDMData) {
        final IExpressions expressionService = (IExpressions)this.getServicesTracker().getService(IExpressions.class);
        IPresentationContext context = update.getPresentationContext();
        final String preferencePageFormatId = this.fFormattedPrefStore.getCurrentNumericFormat(context);
        expressionService.getAvailableFormats((IFormattedValues.IFormattedDataDMContext)dmc, (DataRequestMonitor)new DataRequestMonitor<String[]>((Executor)this.getSession().getExecutor(), null){

            public void handleCompleted() {
                if (!this.getStatus().isOK()) {
                    VariableLayoutNode.this.handleFailedUpdate((IViewerUpdate)update);
                    return;
                }
                String[] formatIds = (String[])this.getData();
                String finalFormatId = "NATURAL.Format";
                boolean requestedFormatIsSupported = false;
                for (String fId : formatIds) {
                    if (!preferencePageFormatId.equals(fId)) continue;
                    finalFormatId = preferencePageFormatId;
                    requestedFormatIsSupported = true;
                    break;
                }
                if (!requestedFormatIsSupported) {
                    if (formatIds.length != 0) {
                        finalFormatId = formatIds[0];
                    } else {
                        VariableLayoutNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                }
                final IFormattedValues.FormattedValueDMContext valueDmc = expressionService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)dmc, finalFormatId);
                VMCacheManager.getVMCacheManager().getCache((Object)update.getPresentationContext()).getModelData((IDMService)expressionService, (IDMContext)valueDmc, (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)VariableLayoutNode.this.getSession().getExecutor(), null){

                    public void handleCompleted() {
                        String oldStringValue;
                        if (!this.getStatus().isOK()) {
                            VariableLayoutNode.this.handleFailedUpdate((IViewerUpdate)update);
                            return;
                        }
                        StringBuffer stringValueBuf = new StringBuffer(((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue());
                        String stringValue = expressionDMData.getStringValue();
                        if (stringValue != null && stringValue.length() > 0) {
                            stringValueBuf.append(" ");
                            stringValueBuf.append(stringValue.length() > 40 ? stringValue.substring(0, 40) : stringValue);
                        }
                        update.setLabel(stringValueBuf.toString(), labelIndex);
                        IFormattedValues.FormattedValueDMData oldData = (IFormattedValues.FormattedValueDMData)VMCacheManager.getVMCacheManager().getCache((Object)VariableLayoutNode.this.getVMProvider().getPresentationContext()).getArchivedModelData((IDMContext)valueDmc);
                        IExpressions.IExpressionDMData oldDMData = (IExpressions.IExpressionDMData)VMCacheManager.getVMCacheManager().getCache((Object)update.getPresentationContext()).getArchivedModelData((IDMContext)dmc);
                        String string = oldStringValue = oldDMData == null ? null : oldDMData.getStringValue();
                        if (oldData != null && !oldData.getFormattedValue().equals(((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue()) || oldStringValue != null && !oldStringValue.equals(stringValue)) {
                            update.setBackground(DebugUIPlugin.getPreferenceColor((String)"org.eclipse.debug.ui.PREF_CHANGED_VALUE_BACKGROUND").getRGB(), labelIndex);
                        }
                        update.done();
                    }
                }, VariableLayoutNode.this.getExecutor());
            }
        });
    }

    public CellEditor getCellEditor(IPresentationContext context, String columnId, Object element, Composite parent) {
        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(columnId)) {
            return new TextCellEditor(parent);
        }
        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__EXPRESSION".equals(columnId)) {
            return new TextCellEditor(parent);
        }
        return null;
    }

    public ICellModifier getCellModifier(IPresentationContext context, Object element) {
        return new VariableLayoutValueCellModifier(this.fFormattedPrefStore, this.fSyncVariableDataAccess);
    }

    @Override
    protected void getElementForExpressionPart(IChildrenUpdate update, String expressionPartText, DataRequestMonitor<Object> rm) {
        IStack.IFrameDMContext frameDmc = (IStack.IFrameDMContext)this.findDmcInPath(update.getElementPath(), IStack.IFrameDMContext.class);
        IExpressions expressionService = (IExpressions)this.getServicesTracker().getService(IExpressions.class);
        IExpressions.IExpressionDMContext expressionDMC = expressionService.createExpression((IDMContext)frameDmc, expressionPartText);
        IVMContext vmc = this.createVMContext((IDMContext)expressionDMC);
        rm.setData((Object)vmc);
        rm.done();
    }

    @Override
    protected void associateExpression(Object element, IExpression expression) {
        if (element instanceof VariableExpressionVMC) {
            ((VariableExpressionVMC)element).setExpression(expression);
        }
    }

    @Override
    protected int getDeltaFlagsForExpressionPart(Object event) {
        if (event instanceof IRunControl.ISuspendedDMEvent) {
            return 1024;
        }
        return 0;
    }

    @Override
    protected void testContextForExpression(Object element, String expression, DataRequestMonitor<Boolean> rm) {
    }

    @Override
    public int getExpressionLength(String expression) {
        return expression.length();
    }

    protected void updateElementsInSessionThread(IChildrenUpdate update) {
        IExpressions.IExpressionDMContext expressionDMC = (IExpressions.IExpressionDMContext)this.findDmcInPath(update.getElementPath(), IExpressions.IExpressionDMContext.class);
        if (expressionDMC != null) {
            this.getSubexpressionsUpdateElementsInSessionThread(update);
        } else {
            this.getLocalsUpdateElementsInSessionThread(update);
        }
    }

    private void getSubexpressionsUpdateElementsInSessionThread(final IChildrenUpdate update) {
        IExpressions.IExpressionDMContext expressionDMC = (IExpressions.IExpressionDMContext)this.findDmcInPath(update.getElementPath(), IExpressions.IExpressionDMContext.class);
        if (expressionDMC != null) {
            IExpressions expressionService = (IExpressions)this.getServicesTracker().getService(IExpressions.class);
            if (expressionService == null) {
                this.handleFailedUpdate((IViewerUpdate)update);
                return;
            }
            DsfExecutor dsfExecutor = this.getSession().getExecutor();
            DataRequestMonitor<IExpressions.IExpressionDMContext[]> rm = new DataRequestMonitor<IExpressions.IExpressionDMContext[]>((Executor)dsfExecutor, null){

                public void handleCompleted() {
                    if (!this.getStatus().isOK()) {
                        VariableLayoutNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                    VariableLayoutNode.this.fillUpdateWithVMCs(update, (IDMContext[])this.getData());
                    update.done();
                }
            };
            expressionService.getSubExpressions(expressionDMC, (DataRequestMonitor)rm);
        }
    }

    private void getLocalsUpdateElementsInSessionThread(final IChildrenUpdate update) {
        final IStack.IFrameDMContext frameDmc = (IStack.IFrameDMContext)this.findDmcInPath(update.getElementPath(), IStack.IFrameDMContext.class);
        final IExpressions expressionService = (IExpressions)this.getServicesTracker().getService(IExpressions.class);
        final IStack stackFrameService = (IStack)this.getServicesTracker().getService(IStack.class);
        if (frameDmc == null || expressionService == null || stackFrameService == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        final DsfExecutor dsfExecutor = this.getSession().getExecutor();
        DataRequestMonitor<IStack.IVariableDMContext[]> rm = new DataRequestMonitor<IStack.IVariableDMContext[]>((Executor)dsfExecutor, null){

            public void handleCompleted() {
                if (!this.getStatus().isOK()) {
                    VariableLayoutNode.this.handleFailedUpdate((IViewerUpdate)update);
                    return;
                }
                IStack.IVariableDMContext[] localsDMCs = (IStack.IVariableDMContext[])this.getData();
                if (localsDMCs == null) {
                    VariableLayoutNode.this.handleFailedUpdate((IViewerUpdate)update);
                    return;
                }
                if (localsDMCs.length == 0) {
                    update.done();
                    return;
                }
                final ArrayList localsDMData = new ArrayList();
                MultiRequestMonitor<DataRequestMonitor<IStack.IVariableDMData>> mrm = new MultiRequestMonitor<DataRequestMonitor<IStack.IVariableDMData>>((Executor)dsfExecutor, null){

                    public void handleCompleted() {
                        if (!this.getStatus().isOK()) {
                            VariableLayoutNode.this.handleFailedUpdate((IViewerUpdate)update);
                            return;
                        }
                        IExpressions.IExpressionDMContext[] expressionDMCs = new IExpressions.IExpressionDMContext[localsDMData.size()];
                        int i = 0;
                        for (IStack.IVariableDMData localDMData : localsDMData) {
                            expressionDMCs[i++] = expressionService.createExpression((IDMContext)frameDmc, localDMData.getName());
                        }
                        VariableLayoutNode.this.fillUpdateWithVMCs(update, (IDMContext[])expressionDMCs);
                        update.done();
                    }
                };
                for (IStack.IVariableDMContext localDMC : localsDMCs) {
                    DataRequestMonitor<IStack.IVariableDMData> rm = new DataRequestMonitor<IStack.IVariableDMData>((Executor)dsfExecutor, null, (MultiRequestMonitor)mrm){
                        final /* synthetic */ MultiRequestMonitor val$mrm;
                        {
                            this.val$mrm = multiRequestMonitor;
                            super(x0, x1);
                        }

                        public void handleCompleted() {
                            localsDMData.add(this.getData());
                            this.val$mrm.requestMonitorDone((RequestMonitor)this);
                        }
                    };
                    mrm.add((RequestMonitor)rm);
                    VMCacheManager.getVMCacheManager().getCache((Object)VariableLayoutNode.this.getVMProvider().getPresentationContext()).getModelData((IDMService)stackFrameService, (IDMContext)localDMC, (DataRequestMonitor)rm, VariableLayoutNode.this.getExecutor());
                }
            }
        };
        stackFrameService.getLocals((IDMContext)frameDmc, (DataRequestMonitor)rm);
    }

    protected class VariableExpressionFactory
    implements IWatchExpressionFactoryAdapterExtension {
        protected VariableExpressionFactory() {
        }

        public boolean canCreateWatchExpression(IVariable variable) {
            return variable instanceof VariableExpressionVMC;
        }

        public String createWatchExpression(IVariable variable) throws CoreException {
            VariableExpressionVMC exprVmc = (VariableExpressionVMC)variable;
            IExpressions.IExpressionDMContext exprDmc = (IExpressions.IExpressionDMContext)DMContexts.getAncestorOfType((IDMContext)exprVmc.getDMC(), IExpressions.IExpressionDMContext.class);
            if (exprDmc != null) {
                return exprDmc.getExpression();
            }
            return null;
        }
    }

    public class VariableExpressionVMC
    extends AbstractDMVMLayoutNode.DMVMContext
    implements IFormattedValueVMContext,
    IVariable {
        private IExpression fExpression;

        public VariableExpressionVMC(IDMContext dmc) {
            super((AbstractDMVMLayoutNode)VariableLayoutNode.this, dmc);
        }

        public IFormattedValuePreferenceStore getPreferenceStore() {
            return VariableLayoutNode.this.fFormattedPrefStore;
        }

        public void setExpression(IExpression expression) {
            this.fExpression = expression;
        }

        public Object getAdapter(Class adapter) {
            if (this.fExpression != null && adapter.isAssignableFrom(this.fExpression.getClass())) {
                return this.fExpression;
            }
            if (adapter.isAssignableFrom(IWatchExpressionFactoryAdapterExtension.class)) {
                return VariableLayoutNode.this.fVariableExpressionFactory;
            }
            return super.getAdapter(adapter);
        }

        public boolean equals(Object other) {
            if (other instanceof VariableExpressionVMC && super.equals(other)) {
                VariableExpressionVMC otherGroup = (VariableExpressionVMC)other;
                return otherGroup.fExpression == null && this.fExpression == null || otherGroup.fExpression != null && otherGroup.fExpression.equals(this.fExpression);
            }
            return false;
        }

        public int hashCode() {
            return super.hashCode() + (this.fExpression != null ? this.fExpression.hashCode() : 0);
        }

        public String getName() throws DebugException {
            return this.toString();
        }

        public String getReferenceTypeName() throws DebugException {
            return "";
        }

        public IValue getValue() throws DebugException {
            return null;
        }

        public boolean hasValueChanged() throws DebugException {
            return false;
        }

        public void setValue(IValue value) throws DebugException {
        }

        public void setValue(String expression) throws DebugException {
        }

        public boolean supportsValueModification() {
            return false;
        }

        public boolean verifyValue(IValue value) throws DebugException {
            return false;
        }

        public boolean verifyValue(String expression) throws DebugException {
            return false;
        }

        public IDebugTarget getDebugTarget() {
            return null;
        }

        public ILaunch getLaunch() {
            return null;
        }

        public String getModelIdentifier() {
            return "org.eclipse.dd.dsf.debug.ui";
        }
    }
}

