/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.ui.actions;

import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.Immutable;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.ui.DsfDebugUIPlugin;
import org.eclipse.dd.dsf.debug.ui.actions.DsfCommandRunnable;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;
import org.eclipse.debug.core.commands.IStepIntoHandler;

@Immutable
public class DsfStepReturnCommand
implements IStepIntoHandler {
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;

    public DsfStepReturnCommand(DsfSession session) {
        this.fExecutor = session.getExecutor();
        this.fTracker = new DsfServicesTracker(DsfDebugUIPlugin.getBundleContext(), session.getId());
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    public void canExecute(final IEnabledStateRequest request) {
        if (request.getElements().length != 1) {
            request.setEnabled(false);
            request.done();
            return;
        }
        this.fExecutor.submit((Runnable)((Object)new DsfCommandRunnable(this.fTracker, request.getElements()[0], (IDebugCommandRequest)request){

            public void doExecute() {
                request.setEnabled(this.getStepQueueMgr().canEnqueueStep(this.getContext()));
            }
        }));
    }

    public boolean execute(IDebugCommandRequest request) {
        if (request.getElements().length != 1) {
            request.done();
            return false;
        }
        this.fExecutor.submit((Runnable)((Object)new DsfCommandRunnable(this.fTracker, request.getElements()[0], request){

            public void doExecute() {
                this.getStepQueueMgr().enqueueStep(this.getContext(), IRunControl.StepType.STEP_RETURN);
            }
        }));
        return true;
    }
}

