/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.ui.sourcelookup;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.Query;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.IStack;
import org.eclipse.dd.dsf.debug.service.IStepQueueManager;
import org.eclipse.dd.dsf.debug.sourcelookup.DsfMISourceLookupParticipant;
import org.eclipse.dd.dsf.debug.ui.DsfDebugUIPlugin;
import org.eclipse.dd.dsf.debug.ui.sourcelookup.InstructionPointerManager;
import org.eclipse.dd.dsf.debug.ui.sourcelookup.SourceLookupResult;
import org.eclipse.dd.dsf.service.DsfServiceEventHandler;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.viewmodel.dm.AbstractDMVMLayoutNode;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.debug.ui.sourcelookup.CommonSourceNotFoundEditorInput;
import org.eclipse.debug.ui.sourcelookup.ISourceDisplay;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

@ThreadSafe
public class MISourceDisplayAdapter
implements ISourceDisplay {
    private DsfSession fSession;
    private DsfExecutor fExecutor;
    private DsfServicesTracker fServicesTracker;
    private IDMContext fPrevModelContext;
    private SourceLookupResult fPrevResult;
    private ISourceLookupDirector fSourceLookup;
    private DsfMISourceLookupParticipant fSourceLookupParticipant;
    private InstructionPointerManager fIPManager;
    private LookupJob fRunningLookupJob;
    private DisplayJob fRunningDisplayJob;
    private DisplayJob fPendingDisplayJob;
    private ClearingJob fRunningClearingJob;
    private List<IRunControl.IExecutionDMContext> fPendingExecDmcsToClear = new LinkedList<IRunControl.IExecutionDMContext>();

    public MISourceDisplayAdapter(DsfSession session, ISourceLookupDirector sourceLocator) {
        this.fSession = session;
        this.fExecutor = session.getExecutor();
        this.fServicesTracker = new DsfServicesTracker(DsfDebugUIPlugin.getBundleContext(), session.getId());
        this.fSourceLookup = sourceLocator;
        this.fSourceLookupParticipant = new DsfMISourceLookupParticipant(session);
        this.fSourceLookup.addParticipants(new ISourceLookupParticipant[]{this.fSourceLookupParticipant});
        this.fIPManager = new InstructionPointerManager();
        this.fSession.addServiceEventListener((Object)this, null);
    }

    public void dispose() {
        this.fSession.removeServiceEventListener((Object)this);
        this.fServicesTracker.dispose();
        this.fSourceLookup.removeParticipants(new ISourceLookupParticipant[]{this.fSourceLookupParticipant});
    }

    public void displaySource(Object context, final IWorkbenchPage page, final boolean force) {
        if (!(context instanceof AbstractDMVMLayoutNode.DMVMContext)) {
            return;
        }
        final IDMContext dmc = ((AbstractDMVMLayoutNode.DMVMContext)context).getDMC();
        if (!(dmc instanceof IStack.IFrameDMContext)) {
            return;
        }
        this.fExecutor.execute((Runnable)new DsfRunnable(){

            public void run() {
                if (!force && dmc.equals(MISourceDisplayAdapter.this.fPrevModelContext)) {
                    MISourceDisplayAdapter.this.fPrevResult.updateArtifact(dmc);
                    MISourceDisplayAdapter.this.startDisplayJob(MISourceDisplayAdapter.this.fPrevResult, page);
                } else {
                    MISourceDisplayAdapter.this.startLookupJob(dmc, page);
                }
            }
        });
    }

    private void executeFromJob(Runnable runnable) {
        try {
            this.fExecutor.execute(runnable);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    private void startLookupJob(IDMContext dmc, IWorkbenchPage page) {
        if (this.fRunningLookupJob != null) {
            this.fRunningLookupJob.cancel();
        }
        this.fRunningLookupJob = new LookupJob(dmc, page);
        this.fRunningLookupJob.schedule();
    }

    private void startDisplayJob(SourceLookupResult lookupResult, IWorkbenchPage page) {
        DisplayJob nextDisplayJob = new DisplayJob(lookupResult, page);
        if (this.fRunningDisplayJob != null) {
            this.fPendingDisplayJob = nextDisplayJob;
        } else if (this.fRunningClearingJob != null) {
            this.fPendingDisplayJob = nextDisplayJob;
        } else {
            this.fRunningDisplayJob = nextDisplayJob;
            this.fRunningDisplayJob.schedule();
        }
    }

    private void serviceDisplayAndClearingJobs() {
        if (!this.fPendingExecDmcsToClear.isEmpty()) {
            this.fRunningClearingJob = new ClearingJob(this.fPendingExecDmcsToClear);
            this.fRunningClearingJob.schedule();
            this.fPendingExecDmcsToClear = new LinkedList<IRunControl.IExecutionDMContext>();
        } else if (this.fPendingDisplayJob != null) {
            this.fRunningDisplayJob = this.fPendingDisplayJob;
            this.fRunningDisplayJob.schedule();
            this.fPendingDisplayJob = null;
        }
    }

    private void startAnnotationClearingJob(IRunControl.IExecutionDMContext execDmc) {
        this.fPendingExecDmcsToClear.add(execDmc);
        if (this.fRunningLookupJob != null && DMContexts.isAncestorOf((IDMContext)this.fRunningLookupJob.getDmc(), (IDMContext)execDmc)) {
            this.fRunningLookupJob.cancel();
            this.fRunningLookupJob = null;
        }
        if (this.fPendingDisplayJob != null && DMContexts.isAncestorOf((IDMContext)this.fPendingDisplayJob.getDmc(), (IDMContext)execDmc)) {
            this.fPendingDisplayJob = null;
        }
        if (this.fRunningClearingJob == null && this.fRunningDisplayJob == null) {
            this.fRunningClearingJob = new ClearingJob(this.fPendingExecDmcsToClear);
            this.fRunningClearingJob.schedule();
            this.fPendingExecDmcsToClear = new LinkedList<IRunControl.IExecutionDMContext>();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IResumedDMEvent e) {
        if (e.getReason() != IRunControl.StateChangeReason.STEP) {
            this.startAnnotationClearingJob((IRunControl.IExecutionDMContext)e.getDMContext());
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IExitedDMEvent e) {
        this.startAnnotationClearingJob(e.getExecutionContext());
    }

    @DsfServiceEventHandler
    public void eventDispatched(IStepQueueManager.ISteppingTimedOutEvent e) {
        this.startAnnotationClearingJob((IRunControl.IExecutionDMContext)e.getDMContext());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ClearingJob
    extends UIJob {
        List<IRunControl.IExecutionDMContext> fDmcsToClear;

        public ClearingJob(List<IRunControl.IExecutionDMContext> dmcs) {
            super("Debug Source Display");
            this.setSystem(true);
            this.setPriority(10);
            this.fDmcsToClear = dmcs;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            DsfRunnable clearingJobFinishedRunnable = new DsfRunnable(){

                public void run() {
                    assert (MISourceDisplayAdapter.this.fRunningClearingJob == ClearingJob.this);
                    MISourceDisplayAdapter.this.fRunningClearingJob = null;
                    MISourceDisplayAdapter.this.serviceDisplayAndClearingJobs();
                }
            };
            if (monitor.isCanceled()) {
                MISourceDisplayAdapter.this.executeFromJob((Runnable)clearingJobFinishedRunnable);
                return Status.CANCEL_STATUS;
            }
            for (IRunControl.IExecutionDMContext dmc : this.fDmcsToClear) {
                MISourceDisplayAdapter.this.fIPManager.removeAnnotations(dmc);
            }
            MISourceDisplayAdapter.this.executeFromJob((Runnable)clearingJobFinishedRunnable);
            return Status.OK_STATUS;
        }
    }

    class DisplayJob
    extends UIJob {
        private SourceLookupResult fResult;
        private IWorkbenchPage fPage;

        IDMContext getDmc() {
            return this.fResult.getDmc();
        }

        public DisplayJob(SourceLookupResult result, IWorkbenchPage page) {
            super("Debug Source Display");
            this.setSystem(true);
            this.setPriority(10);
            this.fResult = result;
            this.fPage = page;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            DsfRunnable displayJobFinishedRunnable = new DsfRunnable(){

                public void run() {
                    if (MISourceDisplayAdapter.this.fRunningDisplayJob == DisplayJob.this) {
                        MISourceDisplayAdapter.this.fRunningDisplayJob = null;
                        MISourceDisplayAdapter.this.serviceDisplayAndClearingJobs();
                    }
                }
            };
            if (monitor.isCanceled()) {
                MISourceDisplayAdapter.this.executeFromJob((Runnable)displayJobFinishedRunnable);
                return Status.CANCEL_STATUS;
            }
            IEditorPart editor = this.openEditor(this.fResult, this.fPage);
            if (editor == null) {
                MISourceDisplayAdapter.this.executeFromJob((Runnable)displayJobFinishedRunnable);
                return Status.OK_STATUS;
            }
            ITextEditor textEditor = null;
            textEditor = editor instanceof ITextEditor ? (ITextEditor)editor : (ITextEditor)editor.getAdapter(ITextEditor.class);
            if (textEditor != null) {
                this.positionEditor(textEditor, this.fResult.getDmc());
            }
            MISourceDisplayAdapter.this.executeFromJob((Runnable)displayJobFinishedRunnable);
            return Status.OK_STATUS;
        }

        private IEditorPart openEditor(SourceLookupResult result, IWorkbenchPage page) {
            IEditorInput input = result.getEditorInput();
            String id = result.getEditorId();
            if (input == null || id == null) {
                return null;
            }
            return this.openEditor(page, input, id);
        }

        private IEditorPart openEditor(final IWorkbenchPage page, final IEditorInput input, final String id) {
            final IEditorPart[] editor = new IEditorPart[]{null};
            Runnable r = new Runnable(){

                public void run() {
                    if (!page.getWorkbenchWindow().getWorkbench().isClosing()) {
                        try {
                            editor[0] = page.openEditor(input, id, false);
                        }
                        catch (PartInitException partInitException) {
                            // empty catch block
                        }
                    }
                }
            };
            BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)r);
            return editor[0];
        }

        private void positionEditor(ITextEditor editor, IDMContext dmc) {
            if (!(dmc instanceof IStack.IFrameDMContext)) {
                return;
            }
            final IStack.IFrameDMContext frameDmc = (IStack.IFrameDMContext)dmc;
            class FramePositioningData {
                int fLine;
                int fLevel;

                FramePositioningData() {
                }
            }
            Query<FramePositioningData> query = new Query<FramePositioningData>(){

                protected void execute(final DataRequestMonitor<FramePositioningData> rm) {
                    IStack stackService = (IStack)MISourceDisplayAdapter.this.fServicesTracker.getService(IStack.class);
                    if (stackService == null) {
                        this.doneException((Throwable)new CoreException((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", -1, "Stack data not available", null)));
                        return;
                    }
                    stackService.getFrameData(frameDmc, (DataRequestMonitor)new DataRequestMonitor<IStack.IFrameDMData>((Executor)MISourceDisplayAdapter.this.fExecutor, rm){

                        public void handleOK() {
                            FramePositioningData clientData = new FramePositioningData();
                            clientData.fLevel = frameDmc.getLevel();
                            clientData.fLine = ((IStack.IFrameDMData)this.getData()).getLine() - 1;
                            rm.setData((Object)clientData);
                            rm.done();
                        }
                    });
                }
            };
            try {
                MISourceDisplayAdapter.this.fExecutor.execute((Runnable)query);
                FramePositioningData framePositioningData = (FramePositioningData)query.get();
                if (framePositioningData == null || framePositioningData.fLevel < 0) {
                    return;
                }
                IRegion region = this.getLineInformation(editor, framePositioningData.fLine);
                if (region != null) {
                    editor.selectAndReveal(region.getOffset(), 0);
                    MISourceDisplayAdapter.this.fIPManager.addAnnotation(editor, frameDmc, new Position(region.getOffset(), region.getLength()), framePositioningData.fLevel == 0);
                }
            }
            catch (InterruptedException e) {
                assert (false) : "Interrupted exception in DSF thread";
            }
            catch (ExecutionException e) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IRegion getLineInformation(ITextEditor editor, int lineNumber) {
            IDocumentProvider provider = editor.getDocumentProvider();
            IEditorInput input = editor.getEditorInput();
            try {
                provider.connect((Object)input);
            }
            catch (CoreException e) {
                return null;
            }
            try {
                IDocument document = provider.getDocument((Object)input);
                if (document != null) {
                    IRegion iRegion = document.getLineInformation(lineNumber);
                    return iRegion;
                }
            }
            catch (BadLocationException e) {
            }
            finally {
                provider.disconnect((Object)input);
            }
            return null;
        }
    }

    class LookupJob
    extends Job {
        private IDMContext fDmc;
        private IWorkbenchPage fPage;

        public LookupJob(IDMContext dmc, IWorkbenchPage page) {
            super("DSF Source Lookup");
            this.setPriority(10);
            this.setSystem(true);
            this.fDmc = dmc;
            this.fPage = page;
        }

        IDMContext getDmc() {
            return this.fDmc;
        }

        protected IStatus run(final IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            final SourceLookupResult result = this.performLookup();
            MISourceDisplayAdapter.this.executeFromJob((Runnable)new DsfRunnable(){

                public void run() {
                    if (!monitor.isCanceled()) {
                        MISourceDisplayAdapter.this.fPrevResult = result;
                        MISourceDisplayAdapter.this.fPrevModelContext = LookupJob.this.fDmc;
                        MISourceDisplayAdapter.this.fRunningLookupJob = null;
                        MISourceDisplayAdapter.this.startDisplayJob(MISourceDisplayAdapter.this.fPrevResult, LookupJob.this.fPage);
                    }
                }
            });
            return Status.OK_STATUS;
        }

        private SourceLookupResult performLookup() {
            SourceLookupResult result = new SourceLookupResult(this.fDmc, null, null, null);
            String editorId = null;
            CommonSourceNotFoundEditorInput editorInput = null;
            Object sourceElement = MISourceDisplayAdapter.this.fSourceLookup.getSourceElement((Object)this.fDmc);
            if (sourceElement == null) {
                editorInput = new CommonSourceNotFoundEditorInput((Object)this.fDmc);
                editorId = "org.eclipse.debug.ui.sourcelookup.CommonSourceNotFoundEditor";
            } else if (sourceElement instanceof IFile) {
                editorId = this.getEditorIdForFilename(((IFile)sourceElement).getName());
                editorInput = new FileEditorInput((IFile)sourceElement);
            }
            result.setEditorInput((IEditorInput)editorInput);
            result.setEditorId(editorId);
            result.setSourceElement(sourceElement);
            return result;
        }

        private String getEditorIdForFilename(String filename) {
            IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
            IEditorDescriptor descriptor = registry.getDefaultEditor(filename);
            if (descriptor == null) {
                return "org.eclipse.ui.DefaultTextEditor";
            }
            return descriptor.getId();
        }
    }
}

