/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.ui.viewmodel.launch;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.IVMRootLayoutNode;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.dd.dsf.ui.viewmodel.VMRootLayoutNode;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardLaunchRootLayoutNode
extends VMRootLayoutNode
implements IVMRootLayoutNode {
    private final ILaunch fLaunch;

    public StandardLaunchRootLayoutNode(AbstractVMProvider provider, ILaunch launch) {
        super(provider);
        this.fLaunch = launch;
    }

    public int getDeltaFlags(Object e) {
        if (e instanceof DebugEvent) {
            DebugEvent de = (DebugEvent)e;
            if (de.getSource() instanceof IProcess && !((IProcess)de.getSource()).getLaunch().equals(this.fLaunch)) {
                return 0;
            }
            if (de.getSource() instanceof IDebugElement && !this.fLaunch.equals(((IDebugElement)de.getSource()).getLaunch())) {
                return 0;
            }
        }
        int flags = 0;
        if (e instanceof LaunchesEvent) {
            LaunchesEvent le = (LaunchesEvent)e;
            for (ILaunch launch : le.fLaunches) {
                if (this.fLaunch != launch) continue;
                if (le.fType == LaunchesEvent.Type.CHANGED) {
                    flags = 3072;
                    continue;
                }
                if (le.fType != LaunchesEvent.Type.TERMINATED) continue;
                flags = 3072;
            }
        }
        return flags | super.getDeltaFlags(e);
    }

    public void createDelta(Object event, DataRequestMonitor<IModelDelta> rm) {
        Map childNodeDeltas;
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        List<ILaunch> launchList = Arrays.asList(manager.getLaunches());
        VMDelta viewRootDelta = new VMDelta((Object)manager, 0, 0, launchList.size());
        VMDelta rootDelta = viewRootDelta.addNode(this.getRootObject(), launchList.indexOf(this.fLaunch), 0);
        if (event instanceof LaunchesEvent) {
            LaunchesEvent le = (LaunchesEvent)event;
            for (ILaunch launch : le.fLaunches) {
                if (this.fLaunch != launch) continue;
                if (le.fType == LaunchesEvent.Type.CHANGED) {
                    rootDelta.addFlags(3072);
                    continue;
                }
                if (le.fType != LaunchesEvent.Type.TERMINATED) continue;
                rootDelta.addFlags(3072);
            }
        }
        if ((childNodeDeltas = this.getChildNodesWithDeltaFlags(event)).size() != 0) {
            this.callChildNodesToBuildDelta(childNodeDeltas, rootDelta, event, new RequestMonitor((Executor)this.getExecutor(), (RequestMonitor)rm, (DataRequestMonitor)rm, viewRootDelta){
                final /* synthetic */ DataRequestMonitor val$rm;
                final /* synthetic */ VMDelta val$viewRootDelta;
                {
                    this.val$rm = dataRequestMonitor;
                    this.val$viewRootDelta = vMDelta;
                    super(x0, x1);
                }

                public void handleOK() {
                    if (StandardLaunchRootLayoutNode.this.isDisposed()) {
                        return;
                    }
                    this.val$rm.setData((Object)this.val$viewRootDelta);
                    this.val$rm.done();
                }
            });
        } else {
            rm.setData((Object)viewRootDelta);
            rm.done();
        }
    }

    public Object getRootObject() {
        return this.fLaunch;
    }

    public static class LaunchesEvent {
        public final ILaunch[] fLaunches;
        public final Type fType;

        public LaunchesEvent(ILaunch[] launches, Type type) {
            this.fLaunches = launches;
            this.fType = type;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            ADDED,
            REMOVED,
            CHANGED,
            TERMINATED;

        }
    }
}

