/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.ui.viewmodel.modules;

import java.util.concurrent.Executor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMEvent;
import org.eclipse.dd.dsf.debug.service.IModules;
import org.eclipse.dd.dsf.debug.service.IRegisters;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.ui.DsfDebugUIPlugin;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.dd.dsf.ui.viewmodel.dm.AbstractDMVMLayoutNode;
import org.eclipse.dd.dsf.ui.viewmodel.update.VMCacheManager;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModulesLayoutNode
extends AbstractDMVMLayoutNode {
    public ModulesLayoutNode(AbstractVMProvider provider, DsfSession session) {
        super(provider, session, IModules.IModuleDMContext.class);
    }

    protected void updateElementsInSessionThread(final IChildrenUpdate update) {
        if (!this.checkService(IRegisters.class, null, (IViewerUpdate)update)) {
            return;
        }
        IModules.ISymbolDMContext symDmc = (IModules.ISymbolDMContext)this.findDmcInPath(update.getElementPath(), IModules.ISymbolDMContext.class);
        if (symDmc != null) {
            ((IModules)this.getServicesTracker().getService(IModules.class)).getModules(symDmc, (DataRequestMonitor)new DataRequestMonitor<IModules.IModuleDMContext[]>((Executor)this.getSession().getExecutor(), null){

                public void handleCompleted() {
                    if (!this.getStatus().isOK()) {
                        update.done();
                        return;
                    }
                    ModulesLayoutNode.this.fillUpdateWithVMCs(update, (IDMContext[])this.getData());
                    update.done();
                }
            });
        } else {
            this.handleFailedUpdate((IViewerUpdate)update);
        }
    }

    protected void updateLabelInSessionThread(ILabelUpdate[] updates) {
        for (final ILabelUpdate update : updates) {
            final IModules.IModuleDMContext dmc = (IModules.IModuleDMContext)this.findDmcInPath(update.getElementPath(), IModules.IModuleDMContext.class);
            if (!this.checkDmc((IDMContext)dmc, (IViewerUpdate)update) || !this.checkService(IModules.class, null, (IViewerUpdate)update)) continue;
            update.setImageDescriptor(DsfDebugUIPlugin.getImageDescriptor("icons/library_syms_obj.gif"), 0);
            ((IModules)this.getServicesTracker().getService(IModules.class, null)).getModuleData(dmc, (DataRequestMonitor)new DataRequestMonitor<IModules.IModuleDMData>((Executor)this.getSession().getExecutor(), null){

                protected void handleCompleted() {
                    if (!this.getStatus().isOK()) {
                        assert (this.getStatus().isOK() || this.getStatus().getCode() != 10005 || this.getStatus().getCode() != 10003);
                        ModulesLayoutNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                    String[] localColumns = update.getPresentationContext().getColumns();
                    if (localColumns == null) {
                        localColumns = new String[]{null};
                    }
                    for (int i = 0; i < localColumns.length; ++i) {
                        ModulesLayoutNode.this.fillColumnLabel(dmc, (IModules.IModuleDMData)this.getData(), localColumns[i], i, update);
                    }
                    update.done();
                }
            });
        }
    }

    protected void fillColumnLabel(IModules.IModuleDMContext dmContext, IModules.IModuleDMData dmData, String columnId, int idx, ILabelUpdate update) {
        if (columnId == null) {
            update.setLabel(dmData.getName(), idx);
        }
    }

    protected int getNodeDeltaFlagsForDMEvent(IDMEvent<?> e) {
        if (e instanceof IRunControl.ISuspendedDMEvent) {
            return 1024;
        }
        if (e instanceof IRegisters.IGroupsChangedDMEvent) {
            return 1024;
        }
        if (e instanceof IRegisters.IGroupChangedDMEvent) {
            return 2048;
        }
        return 0;
    }

    protected void buildDeltaForDMEvent(IDMEvent<?> e, VMDelta parent, int nodeOffset, RequestMonitor rm) {
        if (e instanceof IRunControl.ISuspendedDMEvent) {
            parent.addFlags(1024);
        } else if (e instanceof IRegisters.IGroupsChangedDMEvent) {
            VMCacheManager.getVMCacheManager().flush((Object)super.getVMProvider().getPresentationContext());
            parent.addFlags(1024);
        } else if (e instanceof IRegisters.IGroupChangedDMEvent) {
            VMCacheManager.getVMCacheManager().flush((Object)super.getVMProvider().getPresentationContext());
            parent.addNode((Object)this.createVMContext(((IRegisters.IGroupChangedDMEvent)e).getDMContext()), 2048);
        }
        super.buildDeltaForDMEvent(e, parent, nodeOffset, rm);
    }
}

