/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.ui.viewmodel.register;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.Query;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;
import org.eclipse.dd.dsf.concurrent.ThreadSafeAndProhibitedFromDsfExecutor;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IFormattedValues;
import org.eclipse.dd.dsf.debug.service.IRegisters;
import org.eclipse.dd.dsf.debug.ui.DsfDebugUIPlugin;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.viewmodel.dm.AbstractDMVMLayoutNode;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

@ThreadSafeAndProhibitedFromDsfExecutor(value="fSession#getExecutor")
public class SyncRegisterDataAccess {
    private final DsfSession fSession;
    @ThreadSafe
    private ServiceTracker fServiceTracker;

    public SyncRegisterDataAccess(DsfSession session) {
        this.fSession = session;
    }

    @ThreadSafe
    private synchronized IRegisters getService() {
        if (this.fServiceTracker == null) {
            try {
                this.fServiceTracker = new ServiceTracker(DsfDebugUIPlugin.getBundleContext(), DsfDebugUIPlugin.getBundleContext().createFilter(this.getServiceFilter()), null);
                this.fServiceTracker.open();
            }
            catch (InvalidSyntaxException e) {
                return null;
            }
        }
        return (IRegisters)this.fServiceTracker.getService();
    }

    private String getServiceFilter() {
        StringBuffer filter = new StringBuffer();
        filter.append("(&");
        filter.append("(OBJECTCLASS=");
        filter.append(IRegisters.class.getName());
        filter.append(')');
        filter.append('(');
        filter.append("org.eclipse.dd.dsf.service.IService.session_id");
        filter.append('=');
        filter.append(this.fSession.getId());
        filter.append(')');
        filter.append(')');
        return filter.toString();
    }

    @ThreadSafe
    public synchronized void dispose() {
        if (this.fServiceTracker != null) {
            this.fServiceTracker.close();
        }
    }

    public IRegisters.IBitFieldDMContext getBitFieldDMC(Object element) {
        if (element instanceof AbstractDMVMLayoutNode.DMVMContext) {
            IDMContext dmc = ((AbstractDMVMLayoutNode.DMVMContext)element).getDMC();
            return (IRegisters.IBitFieldDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IRegisters.IBitFieldDMContext.class);
        }
        return null;
    }

    public IRegisters.IBitFieldDMData readBitField(Object element) {
        IRegisters.IBitFieldDMContext dmc = this.getBitFieldDMC(element);
        if (dmc == null) {
            return null;
        }
        DsfSession session = DsfSession.getSession((String)dmc.getSessionId());
        if (session == null) {
            return null;
        }
        GetBitFieldValueQuery query = new GetBitFieldValueQuery(dmc);
        session.getExecutor().execute((Runnable)((Object)query));
        try {
            return (IRegisters.IBitFieldDMData)query.get();
        }
        catch (InterruptedException e) {
            assert (false);
            return null;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public void writeBitField(Object element, String value, String formatId) {
        block6: {
            IRegisters.IBitFieldDMContext dmc = this.getBitFieldDMC(element);
            if (dmc == null) {
                return;
            }
            DsfSession session = DsfSession.getSession((String)dmc.getSessionId());
            if (session == null) {
                return;
            }
            SetBitFieldValueQuery query = new SetBitFieldValueQuery(dmc, value, formatId);
            session.getExecutor().execute((Runnable)((Object)query));
            try {
                query.get();
            }
            catch (InterruptedException e) {
                assert (false);
            }
            catch (ExecutionException e) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
    }

    public void writeBitField(Object element, IRegisters.IMnemonic mnemonic) {
        IRegisters.IBitFieldDMContext dmc = this.getBitFieldDMC(element);
        if (dmc == null) {
            return;
        }
        DsfSession session = DsfSession.getSession((String)dmc.getSessionId());
        if (session == null) {
            return;
        }
        SetBitFieldValueMnemonicQuery query = new SetBitFieldValueMnemonicQuery(dmc, mnemonic);
        session.getExecutor().execute((Runnable)((Object)query));
        try {
            query.get();
        }
        catch (InterruptedException e) {
            assert (false);
        }
        catch (ExecutionException e) {
            // empty catch block
        }
    }

    public IRegisters.IRegisterGroupDMContext getRegisterGroupDMC(Object element) {
        if (element instanceof AbstractDMVMLayoutNode.DMVMContext) {
            IDMContext dmc = ((AbstractDMVMLayoutNode.DMVMContext)element).getDMC();
            return (IRegisters.IRegisterGroupDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IRegisters.IRegisterGroupDMContext.class);
        }
        return null;
    }

    public IRegisters.IRegisterDMContext getRegisterDMC(Object element) {
        if (element instanceof AbstractDMVMLayoutNode.DMVMContext) {
            IDMContext dmc = ((AbstractDMVMLayoutNode.DMVMContext)element).getDMC();
            return (IRegisters.IRegisterDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IRegisters.IRegisterDMContext.class);
        }
        return null;
    }

    public IFormattedValues.IFormattedDataDMContext getFormattedDMC(Object element) {
        if (element instanceof AbstractDMVMLayoutNode.DMVMContext) {
            IDMContext dmc = ((AbstractDMVMLayoutNode.DMVMContext)element).getDMC();
            IRegisters.IRegisterDMContext regdmc = (IRegisters.IRegisterDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IRegisters.IRegisterDMContext.class);
            return (IFormattedValues.IFormattedDataDMContext)DMContexts.getAncestorOfType((IDMContext)regdmc, IFormattedValues.IFormattedDataDMContext.class);
        }
        return null;
    }

    public IRegisters.IRegisterGroupDMData readRegisterGroup(Object element) {
        IRegisters.IRegisterGroupDMContext dmc = this.getRegisterGroupDMC(element);
        if (dmc == null) {
            return null;
        }
        DsfSession session = DsfSession.getSession((String)dmc.getSessionId());
        if (session == null) {
            return null;
        }
        GetRegisterGroupValueQuery query = new GetRegisterGroupValueQuery(dmc);
        session.getExecutor().execute((Runnable)((Object)query));
        try {
            return (IRegisters.IRegisterGroupDMData)query.get();
        }
        catch (InterruptedException e) {
            assert (false);
            return null;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public IRegisters.IRegisterDMData readRegister(Object element) {
        IRegisters.IRegisterDMContext dmc = this.getRegisterDMC(element);
        if (dmc == null) {
            return null;
        }
        DsfSession session = DsfSession.getSession((String)dmc.getSessionId());
        if (session == null) {
            return null;
        }
        GetRegisterValueQuery query = new GetRegisterValueQuery(dmc);
        session.getExecutor().execute((Runnable)((Object)query));
        try {
            return (IRegisters.IRegisterDMData)query.get();
        }
        catch (InterruptedException e) {
            assert (false);
            return null;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public void writeRegister(Object element, String value, String formatId) {
        IRegisters.IRegisterDMContext dmc = this.getRegisterDMC(element);
        if (dmc == null) {
            return;
        }
        DsfSession session = DsfSession.getSession((String)dmc.getSessionId());
        if (session == null) {
            return;
        }
        SetRegisterValueQuery query = new SetRegisterValueQuery(dmc, value, formatId);
        session.getExecutor().execute((Runnable)((Object)query));
        try {
            query.get();
        }
        catch (InterruptedException e) {
            assert (false);
        }
        catch (ExecutionException e) {
            // empty catch block
        }
    }

    public String[] getSupportedFormats(Object element) {
        IFormattedValues.IFormattedDataDMContext dmc = null;
        if (element instanceof AbstractDMVMLayoutNode.DMVMContext) {
            IDMContext vmcdmc = ((AbstractDMVMLayoutNode.DMVMContext)element).getDMC();
            IRegisters.IRegisterDMContext regdmc = (IRegisters.IRegisterDMContext)DMContexts.getAncestorOfType((IDMContext)vmcdmc, IRegisters.IRegisterDMContext.class);
            dmc = (IFormattedValues.IFormattedDataDMContext)DMContexts.getAncestorOfType((IDMContext)regdmc, IFormattedValues.IFormattedDataDMContext.class);
        }
        if (dmc == null) {
            return null;
        }
        DsfSession session = DsfSession.getSession((String)dmc.getSessionId());
        if (session == null) {
            return null;
        }
        GetSupportFormatsValueQuery query = new GetSupportFormatsValueQuery(dmc);
        session.getExecutor().execute((Runnable)((Object)query));
        try {
            return (String[])query.get();
        }
        catch (InterruptedException e) {
            assert (false);
            return null;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public String getFormattedRegisterValue(Object element, String formatId) {
        IFormattedValues.IFormattedDataDMContext dmc = null;
        if (element instanceof AbstractDMVMLayoutNode.DMVMContext) {
            IDMContext vmcdmc = ((AbstractDMVMLayoutNode.DMVMContext)element).getDMC();
            IRegisters.IRegisterDMContext regdmc = (IRegisters.IRegisterDMContext)DMContexts.getAncestorOfType((IDMContext)vmcdmc, IRegisters.IRegisterDMContext.class);
            dmc = (IFormattedValues.IFormattedDataDMContext)DMContexts.getAncestorOfType((IDMContext)regdmc, IFormattedValues.IFormattedDataDMContext.class);
        }
        if (dmc == null) {
            return null;
        }
        DsfSession session = DsfSession.getSession((String)dmc.getSessionId());
        if (session == null) {
            return null;
        }
        GetFormattedValueValueQuery query = new GetFormattedValueValueQuery(dmc, formatId);
        session.getExecutor().execute((Runnable)((Object)query));
        try {
            return (String)query.get();
        }
        catch (InterruptedException e) {
            assert (false);
            return null;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public String getFormattedBitFieldValue(Object element, String formatId) {
        IFormattedValues.IFormattedDataDMContext dmc = null;
        if (element instanceof AbstractDMVMLayoutNode.DMVMContext) {
            IDMContext vmcdmc = ((AbstractDMVMLayoutNode.DMVMContext)element).getDMC();
            IRegisters.IBitFieldDMContext bitfielddmc = (IRegisters.IBitFieldDMContext)DMContexts.getAncestorOfType((IDMContext)vmcdmc, IRegisters.IBitFieldDMContext.class);
            dmc = (IFormattedValues.IFormattedDataDMContext)DMContexts.getAncestorOfType((IDMContext)bitfielddmc, IFormattedValues.IFormattedDataDMContext.class);
        }
        if (dmc == null) {
            return null;
        }
        DsfSession session = DsfSession.getSession((String)dmc.getSessionId());
        if (session == null) {
            return null;
        }
        GetFormattedValueValueQuery query = new GetFormattedValueValueQuery(dmc, formatId);
        session.getExecutor().execute((Runnable)((Object)query));
        try {
            return (String)query.get();
        }
        catch (InterruptedException e) {
            assert (false);
            return null;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GetBitFieldValueQuery
    extends Query<IRegisters.IBitFieldDMData> {
        private IRegisters.IBitFieldDMContext fDmc;

        public GetBitFieldValueQuery(IRegisters.IBitFieldDMContext dmc) {
            this.fDmc = dmc;
        }

        protected void execute(final DataRequestMonitor<IRegisters.IBitFieldDMData> rm) {
            final DsfSession session = DsfSession.getSession((String)this.fDmc.getSessionId());
            if (session == null) {
                this.cancel(false);
                return;
            }
            IRegisters service = SyncRegisterDataAccess.this.getService();
            if (service == null) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10001, "Service not available", null));
                rm.done();
                return;
            }
            service.getBitFieldData(this.fDmc, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IBitFieldDMData>((Executor)session.getExecutor(), rm){

                protected void handleCompleted() {
                    if (!DsfSession.isSessionActive((String)session.getId())) {
                        GetBitFieldValueQuery.this.cancel(false);
                        return;
                    }
                    super.handleCompleted();
                }

                protected void handleOK() {
                    rm.setData(this.getData());
                    rm.done();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GetFormattedValueValueQuery
    extends Query<Object> {
        private IFormattedValues.IFormattedDataDMContext fDmc;
        private String fFormatId;

        public GetFormattedValueValueQuery(IFormattedValues.IFormattedDataDMContext dmc, String formatId) {
            this.fDmc = dmc;
            this.fFormatId = formatId;
        }

        protected void execute(final DataRequestMonitor<Object> rm) {
            final DsfSession session = DsfSession.getSession((String)this.fDmc.getSessionId());
            if (session == null) {
                this.cancel(false);
                return;
            }
            IRegisters service = SyncRegisterDataAccess.this.getService();
            if (service == null) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10001, "Service unavailable", null));
                rm.done();
                return;
            }
            IFormattedValues.FormattedValueDMContext formDmc = service.getFormattedValueContext(this.fDmc, this.fFormatId);
            service.getFormattedExpressionValue(formDmc, (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)session.getExecutor(), rm){

                protected void handleCompleted() {
                    if (!DsfSession.isSessionActive((String)session.getId())) {
                        GetFormattedValueValueQuery.this.cancel(false);
                        return;
                    }
                    super.handleCompleted();
                }

                protected void handleOK() {
                    rm.setData((Object)((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue());
                    rm.done();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GetRegisterGroupValueQuery
    extends Query<IRegisters.IRegisterGroupDMData> {
        IRegisters.IRegisterGroupDMContext fDmc;

        public GetRegisterGroupValueQuery(IRegisters.IRegisterGroupDMContext dmc) {
            this.fDmc = dmc;
        }

        protected void execute(final DataRequestMonitor<IRegisters.IRegisterGroupDMData> rm) {
            final DsfSession session = DsfSession.getSession((String)this.fDmc.getSessionId());
            if (session == null) {
                this.cancel(false);
                return;
            }
            IRegisters service = SyncRegisterDataAccess.this.getService();
            if (service == null) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10001, "Service not available", null));
                rm.done();
                return;
            }
            service.getRegisterGroupData(this.fDmc, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterGroupDMData>((Executor)session.getExecutor(), rm){

                protected void handleCompleted() {
                    if (!DsfSession.isSessionActive((String)session.getId())) {
                        GetRegisterGroupValueQuery.this.cancel(false);
                        return;
                    }
                    super.handleCompleted();
                }

                protected void handleOK() {
                    rm.setData(this.getData());
                    rm.done();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GetRegisterValueQuery
    extends Query<IRegisters.IRegisterDMData> {
        IRegisters.IRegisterDMContext fDmc;

        public GetRegisterValueQuery(IRegisters.IRegisterDMContext dmc) {
            this.fDmc = dmc;
        }

        protected void execute(final DataRequestMonitor<IRegisters.IRegisterDMData> rm) {
            final DsfSession session = DsfSession.getSession((String)this.fDmc.getSessionId());
            if (session == null) {
                this.cancel(false);
                return;
            }
            IRegisters service = SyncRegisterDataAccess.this.getService();
            if (service == null) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10001, "Service not available", null));
                rm.done();
                return;
            }
            service.getRegisterData(this.fDmc, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterDMData>((Executor)session.getExecutor(), rm){

                protected void handleCompleted() {
                    if (!DsfSession.isSessionActive((String)session.getId())) {
                        GetRegisterValueQuery.this.cancel(false);
                        return;
                    }
                    super.handleCompleted();
                }

                protected void handleOK() {
                    rm.setData(this.getData());
                    rm.done();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GetSupportFormatsValueQuery
    extends Query<Object> {
        IFormattedValues.IFormattedDataDMContext fDmc;

        public GetSupportFormatsValueQuery(IFormattedValues.IFormattedDataDMContext dmc) {
            this.fDmc = dmc;
        }

        protected void execute(final DataRequestMonitor<Object> rm) {
            final DsfSession session = DsfSession.getSession((String)this.fDmc.getSessionId());
            if (session == null) {
                this.cancel(false);
                return;
            }
            IRegisters service = SyncRegisterDataAccess.this.getService();
            if (service == null) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10001, "Service unavailable", null));
                rm.done();
                return;
            }
            service.getAvailableFormats(this.fDmc, (DataRequestMonitor)new DataRequestMonitor<String[]>((Executor)session.getExecutor(), rm){

                protected void handleCompleted() {
                    if (!DsfSession.isSessionActive((String)session.getId())) {
                        GetSupportFormatsValueQuery.this.cancel(false);
                        return;
                    }
                    super.handleCompleted();
                }

                protected void handleOK() {
                    rm.setData(new Object());
                    rm.done();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SetBitFieldValueMnemonicQuery
    extends Query<Object> {
        IRegisters.IBitFieldDMContext fDmc;
        IRegisters.IMnemonic fMnemonic;

        public SetBitFieldValueMnemonicQuery(IRegisters.IBitFieldDMContext dmc, IRegisters.IMnemonic mnemonic) {
            this.fDmc = dmc;
            this.fMnemonic = mnemonic;
        }

        protected void execute(final DataRequestMonitor<Object> rm) {
            final DsfSession session = DsfSession.getSession((String)this.fDmc.getSessionId());
            if (session == null) {
                this.cancel(false);
                return;
            }
            IRegisters service = SyncRegisterDataAccess.this.getService();
            if (service == null) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10001, "Service unavailable", null));
                rm.done();
                return;
            }
            service.writeBitField(this.fDmc, this.fMnemonic, (RequestMonitor)new DataRequestMonitor<IRegisters.IBitFieldDMData>((Executor)session.getExecutor(), rm){

                protected void handleCompleted() {
                    if (!DsfSession.isSessionActive((String)session.getId())) {
                        SetBitFieldValueMnemonicQuery.this.cancel(false);
                        return;
                    }
                    super.handleCompleted();
                }

                protected void handleOK() {
                    rm.setData(new Object());
                    rm.done();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SetBitFieldValueQuery
    extends Query<Object> {
        private IRegisters.IBitFieldDMContext fDmc;
        private String fValue;
        private String fFormatId;

        public SetBitFieldValueQuery(IRegisters.IBitFieldDMContext dmc, String value, String formatId) {
            this.fDmc = dmc;
            this.fValue = value;
            this.fFormatId = formatId;
        }

        protected void execute(final DataRequestMonitor<Object> rm) {
            final DsfSession session = DsfSession.getSession((String)this.fDmc.getSessionId());
            if (session == null) {
                this.cancel(false);
                return;
            }
            IRegisters service = SyncRegisterDataAccess.this.getService();
            if (service == null) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10001, "Service unavailable", null));
                rm.done();
                return;
            }
            service.writeBitField(this.fDmc, this.fValue, this.fFormatId, (RequestMonitor)new DataRequestMonitor<IRegisters.IBitFieldDMData>((Executor)session.getExecutor(), rm){

                protected void handleCompleted() {
                    if (!DsfSession.isSessionActive((String)session.getId())) {
                        SetBitFieldValueQuery.this.cancel(false);
                        return;
                    }
                    super.handleCompleted();
                }

                protected void handleOK() {
                    rm.setData(new Object());
                    rm.done();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SetRegisterValueQuery
    extends Query<Object> {
        private IRegisters.IRegisterDMContext fDmc;
        private String fValue;
        private String fFormatId;

        public SetRegisterValueQuery(IRegisters.IRegisterDMContext dmc, String value, String formatId) {
            this.fDmc = dmc;
            this.fValue = value;
            this.fFormatId = formatId;
        }

        protected void execute(final DataRequestMonitor<Object> rm) {
            final DsfSession session = DsfSession.getSession((String)this.fDmc.getSessionId());
            if (session == null) {
                this.cancel(false);
                return;
            }
            IRegisters service = SyncRegisterDataAccess.this.getService();
            if (service == null) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10001, "Service unavailable", null));
                rm.done();
                return;
            }
            service.writeRegister(this.fDmc, this.fValue, this.fFormatId, (RequestMonitor)new DataRequestMonitor<IRegisters.IBitFieldDMData>((Executor)session.getExecutor(), rm){

                protected void handleCompleted() {
                    if (!DsfSession.isSessionActive((String)session.getId())) {
                        SetRegisterValueQuery.this.cancel(false);
                        return;
                    }
                    super.handleCompleted();
                }

                protected void handleOK() {
                    rm.setData(new Object());
                    rm.done();
                }
            });
        }
    }
}

