/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.ui.viewmodel.variable;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.Query;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;
import org.eclipse.dd.dsf.concurrent.ThreadSafeAndProhibitedFromDsfExecutor;
import org.eclipse.dd.dsf.debug.service.IExpressions;
import org.eclipse.dd.dsf.debug.service.IFormattedValues;
import org.eclipse.dd.dsf.debug.ui.DsfDebugUIPlugin;
import org.eclipse.dd.dsf.service.DsfSession;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

@ThreadSafeAndProhibitedFromDsfExecutor(value="fSession#getExecutor")
public class SyncVariableDataAccess {
    private final DsfSession fSession;
    @ThreadSafe
    private ServiceTracker fServiceTracker;

    public SyncVariableDataAccess(DsfSession session) {
        this.fSession = session;
    }

    @ThreadSafe
    private synchronized IExpressions getService() {
        if (this.fServiceTracker == null) {
            try {
                this.fServiceTracker = new ServiceTracker(DsfDebugUIPlugin.getBundleContext(), DsfDebugUIPlugin.getBundleContext().createFilter(this.getServiceFilter()), null);
                this.fServiceTracker.open();
            }
            catch (InvalidSyntaxException e) {
                return null;
            }
        }
        return (IExpressions)this.fServiceTracker.getService();
    }

    private String getServiceFilter() {
        StringBuffer filter = new StringBuffer();
        filter.append("(&");
        filter.append("(OBJECTCLASS=");
        filter.append(IExpressions.class.getName());
        filter.append(')');
        filter.append('(');
        filter.append("org.eclipse.dd.dsf.service.IService.session_id");
        filter.append('=');
        filter.append(this.fSession.getId());
        filter.append(')');
        filter.append(')');
        return filter.toString();
    }

    @ThreadSafe
    public synchronized void dispose() {
        if (this.fServiceTracker != null) {
            this.fServiceTracker.close();
        }
    }

    public IExpressions.IExpressionDMContext getVariableDMC(Object element) {
        if (element instanceof IAdaptable) {
            return (IExpressions.IExpressionDMContext)((IAdaptable)element).getAdapter(IExpressions.IExpressionDMContext.class);
        }
        return null;
    }

    public IExpressions.IExpressionDMContext getExpressionDMC(Object element) {
        if (element instanceof IAdaptable) {
            return (IExpressions.IExpressionDMContext)((IAdaptable)element).getAdapter(IExpressions.IExpressionDMContext.class);
        }
        return null;
    }

    public IExpressions.IExpressionDMData readVariable(Object element) {
        IExpressions.IExpressionDMContext dmc = this.getExpressionDMC(element);
        if (dmc == null) {
            return null;
        }
        DsfSession session = DsfSession.getSession((String)dmc.getSessionId());
        if (session == null) {
            return null;
        }
        GetVariableValueQuery query = new GetVariableValueQuery(dmc);
        session.getExecutor().execute((Runnable)((Object)query));
        try {
            return (IExpressions.IExpressionDMData)query.get();
        }
        catch (InterruptedException e) {
            assert (false);
            return null;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public void writeVariable(Object element, String value, String formatId) {
        IExpressions.IExpressionDMContext dmc = this.getExpressionDMC(element);
        if (dmc == null) {
            return;
        }
        DsfSession session = DsfSession.getSession((String)dmc.getSessionId());
        if (session == null) {
            return;
        }
        SetVariableValueQuery query = new SetVariableValueQuery(dmc, value, formatId);
        session.getExecutor().execute((Runnable)((Object)query));
        try {
            query.get();
        }
        catch (InterruptedException e) {
            assert (false);
        }
        catch (ExecutionException e) {
            // empty catch block
        }
    }

    public IFormattedValues.IFormattedDataDMContext getFormattedDMC(Object element) {
        if (element instanceof IAdaptable) {
            return (IFormattedValues.IFormattedDataDMContext)((IAdaptable)element).getAdapter(IFormattedValues.IFormattedDataDMContext.class);
        }
        return null;
    }

    public String[] getSupportedFormats(Object element) {
        IFormattedValues.IFormattedDataDMContext dmc = this.getFormattedDMC(element);
        if (dmc == null) {
            return null;
        }
        DsfSession session = DsfSession.getSession((String)dmc.getSessionId());
        if (session == null) {
            return null;
        }
        GetSupportFormatsValueQuery query = new GetSupportFormatsValueQuery(dmc);
        session.getExecutor().execute((Runnable)((Object)query));
        try {
            return (String[])query.get();
        }
        catch (InterruptedException e) {
            assert (false);
            return null;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public String getFormattedValue(Object element, String formatId) {
        IFormattedValues.IFormattedDataDMContext dmc = this.getFormattedDMC(element);
        if (dmc == null) {
            return null;
        }
        DsfSession session = DsfSession.getSession((String)dmc.getSessionId());
        if (session == null) {
            return null;
        }
        GetFormattedValueValueQuery query = new GetFormattedValueValueQuery(dmc, formatId);
        session.getExecutor().execute((Runnable)((Object)query));
        try {
            return (String)query.get();
        }
        catch (InterruptedException e) {
            assert (false);
            return null;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GetFormattedValueValueQuery
    extends Query<Object> {
        private IFormattedValues.IFormattedDataDMContext fDmc;
        private String fFormatId;

        public GetFormattedValueValueQuery(IFormattedValues.IFormattedDataDMContext dmc, String formatId) {
            this.fDmc = dmc;
            this.fFormatId = formatId;
        }

        protected void execute(final DataRequestMonitor<Object> rm) {
            final DsfSession session = DsfSession.getSession((String)this.fDmc.getSessionId());
            if (session == null) {
                this.cancel(false);
                return;
            }
            IExpressions service = SyncVariableDataAccess.this.getService();
            if (service == null) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10001, "Service unavailable", null));
                rm.done();
                return;
            }
            IFormattedValues.FormattedValueDMContext formDmc = service.getFormattedValueContext(this.fDmc, this.fFormatId);
            service.getFormattedExpressionValue(formDmc, (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)session.getExecutor(), rm){

                protected void handleCompleted() {
                    if (!DsfSession.isSessionActive((String)session.getId())) {
                        GetFormattedValueValueQuery.this.cancel(false);
                        return;
                    }
                    super.handleCompleted();
                }

                protected void handleOK() {
                    rm.setData((Object)((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue());
                    rm.done();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GetSupportFormatsValueQuery
    extends Query<Object> {
        IFormattedValues.IFormattedDataDMContext fDmc;

        public GetSupportFormatsValueQuery(IFormattedValues.IFormattedDataDMContext dmc) {
            this.fDmc = dmc;
        }

        protected void execute(final DataRequestMonitor<Object> rm) {
            final DsfSession session = DsfSession.getSession((String)this.fDmc.getSessionId());
            if (session == null) {
                this.cancel(false);
                return;
            }
            IExpressions service = SyncVariableDataAccess.this.getService();
            if (service == null) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10001, "Service unavailable", null));
                rm.done();
                return;
            }
            service.getAvailableFormats(this.fDmc, (DataRequestMonitor)new DataRequestMonitor<String[]>((Executor)session.getExecutor(), rm){

                protected void handleCompleted() {
                    if (!DsfSession.isSessionActive((String)session.getId())) {
                        GetSupportFormatsValueQuery.this.cancel(false);
                        return;
                    }
                    super.handleCompleted();
                }

                protected void handleOK() {
                    rm.setData(new Object());
                    rm.done();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GetVariableValueQuery
    extends Query<IExpressions.IExpressionDMData> {
        private IExpressions.IExpressionDMContext fDmc;

        public GetVariableValueQuery(IExpressions.IExpressionDMContext dmc) {
            this.fDmc = dmc;
        }

        protected void execute(final DataRequestMonitor<IExpressions.IExpressionDMData> rm) {
            final DsfSession session = DsfSession.getSession((String)this.fDmc.getSessionId());
            if (session == null) {
                this.cancel(false);
                return;
            }
            IExpressions service = SyncVariableDataAccess.this.getService();
            if (service == null) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10001, "Service not available", null));
                rm.done();
                return;
            }
            service.getExpressionData(this.fDmc, (DataRequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMData>((Executor)session.getExecutor(), rm){

                protected void handleCompleted() {
                    if (!DsfSession.isSessionActive((String)session.getId())) {
                        GetVariableValueQuery.this.cancel(false);
                        return;
                    }
                    super.handleCompleted();
                }

                protected void handleOK() {
                    rm.setData(this.getData());
                    rm.done();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SetVariableValueQuery
    extends Query<Object> {
        private IExpressions.IExpressionDMContext fDmc;
        private String fValue;
        private String fFormatId;

        public SetVariableValueQuery(IExpressions.IExpressionDMContext dmc, String value, String formatId) {
            this.fDmc = dmc;
            this.fValue = value;
            this.fFormatId = formatId;
        }

        protected void execute(final DataRequestMonitor<Object> rm) {
            final DsfSession session = DsfSession.getSession((String)this.fDmc.getSessionId());
            if (session == null) {
                this.cancel(false);
                return;
            }
            IExpressions service = SyncVariableDataAccess.this.getService();
            if (service == null) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10001, "Service unavailable", null));
                rm.done();
                return;
            }
            service.writeExpression(this.fDmc, this.fValue, this.fFormatId, (RequestMonitor)new DataRequestMonitor<IExpressions.IExpressionDMData>((Executor)session.getExecutor(), rm){

                protected void handleCompleted() {
                    if (!DsfSession.isSessionActive((String)session.getId())) {
                        SetVariableValueQuery.this.cancel(false);
                        return;
                    }
                    super.handleCompleted();
                }

                protected void handleOK() {
                    rm.setData(new Object());
                    rm.done();
                }
            });
        }
    }
}

