/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.ui.viewmodel.launch;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.IRootVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.RootVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchRootVMNode
extends RootVMNode
implements IRootVMNode {
    public LaunchRootVMNode(AbstractVMProvider provider) {
        super(provider);
    }

    public boolean isDeltaEvent(Object rootObject, Object e) {
        if (e instanceof DebugEvent) {
            DebugEvent de = (DebugEvent)e;
            if (de.getSource() instanceof IProcess && !((IProcess)de.getSource()).getLaunch().equals(rootObject)) {
                return false;
            }
            if (de.getSource() instanceof IDebugElement && !rootObject.equals(((IDebugElement)de.getSource()).getLaunch())) {
                return false;
            }
        }
        return super.isDeltaEvent(rootObject, e);
    }

    public int getDeltaFlags(Object e) {
        int flags = 0;
        if (e instanceof LaunchesEvent) {
            LaunchesEvent le = (LaunchesEvent)e;
            if (le.fType == LaunchesEvent.Type.CHANGED || le.fType == LaunchesEvent.Type.TERMINATED) {
                flags = 3072;
            }
        }
        return flags;
    }

    public void createRootDelta(Object rootObject, Object event, DataRequestMonitor<VMDelta> rm) {
        if (!(rootObject instanceof ILaunch)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10001, "Invalid root element configured with launch root node.", null));
            return;
        }
        ILaunch rootLaunch = (ILaunch)rootObject;
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        List<ILaunch> launchList = Arrays.asList(manager.getLaunches());
        VMDelta viewRootDelta = new VMDelta((Object)manager, 0, 0, launchList.size());
        VMDelta rootDelta = viewRootDelta.addNode((Object)rootLaunch, launchList.indexOf(rootLaunch), 0);
        if (event instanceof LaunchesEvent) {
            LaunchesEvent le = (LaunchesEvent)event;
            for (ILaunch launch : le.fLaunches) {
                if (rootLaunch != launch) continue;
                if (le.fType == LaunchesEvent.Type.CHANGED) {
                    rootDelta.setFlags(rootDelta.getFlags() | 0x800 | 0x400);
                    continue;
                }
                if (le.fType != LaunchesEvent.Type.TERMINATED) continue;
                rootDelta.setFlags(rootDelta.getFlags() | 0x800 | 0x400);
            }
        }
        rm.setData((Object)rootDelta);
        rm.done();
    }

    public static class LaunchesEvent {
        public final ILaunch[] fLaunches;
        public final Type fType;

        public LaunchesEvent(ILaunch[] launches, Type type) {
            this.fLaunches = launches;
            this.fType = type;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            ADDED,
            REMOVED,
            CHANGED,
            TERMINATED;

        }
    }
}

