/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.ui.viewmodel.update.actions;

import org.eclipse.dd.dsf.debug.ui.viewmodel.actions.AbstractVMProviderActionDelegate;
import org.eclipse.dd.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.update.ICachingVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.update.IVMUpdatePolicy;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IViewPart;

public class SelectUpdatePolicyAction
extends AbstractVMProviderActionDelegate
implements IMenuCreator {
    public Menu getMenu(Control parent) {
        return null;
    }

    public void init(IViewPart view) {
        super.init(view);
        this.getAction().setEnabled(this.getVMProvider() instanceof ICachingVMProvider);
    }

    public void init(IAction action) {
        super.init(action);
        action.setMenuCreator((IMenuCreator)this);
    }

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (action != this.getAction()) {
            action.setMenuCreator((IMenuCreator)this);
        }
        super.selectionChanged(action, selection);
        this.getAction().setEnabled(this.getVMProvider() instanceof ICachingVMProvider);
    }

    public void debugContextChanged(DebugContextEvent event) {
        super.debugContextChanged(event);
        this.getAction().setEnabled(this.getVMProvider() instanceof ICachingVMProvider);
    }

    public Menu getMenu(Menu parent) {
        Menu menu = new Menu(parent);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Menu m = (Menu)e.widget;
                MenuItem[] items = m.getItems();
                for (int i = 0; i < items.length; ++i) {
                    items[i].dispose();
                }
                SelectUpdatePolicyAction.this.fillMenu(m);
            }
        });
        return menu;
    }

    private void fillMenu(Menu menu) {
        IVMUpdatePolicy[] updatePolicies = new IVMUpdatePolicy[]{};
        IVMUpdatePolicy activePolicy = null;
        IVMProvider provider = this.getVMProvider();
        if (provider instanceof ICachingVMProvider) {
            ICachingVMProvider cachingProvider = (ICachingVMProvider)provider;
            updatePolicies = cachingProvider.getAvailableUpdatePolicies();
            activePolicy = cachingProvider.getActiveUpdatePolicy();
            for (IVMUpdatePolicy updatePolicy : updatePolicies) {
                SelectPolicy action = new SelectPolicy(cachingProvider, updatePolicy);
                if (updatePolicy.equals(activePolicy)) {
                    action.setChecked(true);
                }
                ActionContributionItem item = new ActionContributionItem((IAction)action);
                item.fill(menu, -1);
            }
        }
    }

    class SelectPolicy
    extends Action {
        private ICachingVMProvider fVMProvider;
        private IVMUpdatePolicy fUpdatePolicy;

        public void run() {
            if (this.isChecked()) {
                this.fVMProvider.setActiveUpdatePolicy(this.fUpdatePolicy);
            }
        }

        public SelectPolicy(ICachingVMProvider provider, IVMUpdatePolicy updatePolicy) {
            super(updatePolicy.getName(), 8);
            this.fVMProvider = provider;
            this.fUpdatePolicy = updatePolicy;
        }
    }
}

