/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.ui.viewmodel.actions;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.dd.dsf.ui.viewmodel.IVMAdapter;
import org.eclipse.dd.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public abstract class AbstractVMProviderActionDelegate
implements IViewActionDelegate,
IDebugContextListener,
IActionDelegate2 {
    private IViewPart fView = null;
    private IAction fAction = null;
    private ISelection fDebugContext;

    public void init(IViewPart view) {
        this.fView = view;
        IDebugContextService debugContextService = DebugUITools.getDebugContextManager().getContextService(view.getSite().getWorkbenchWindow());
        debugContextService.addPostDebugContextListener((IDebugContextListener)this);
        this.fDebugContext = debugContextService.getActiveContext();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.fAction != action) {
            this.fAction = action;
        }
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void init(IAction action) {
        this.fAction = action;
    }

    public void dispose() {
        DebugUITools.getDebugContextManager().getContextService(this.getView().getSite().getWorkbenchWindow()).removePostDebugContextListener((IDebugContextListener)this);
    }

    public void debugContextChanged(DebugContextEvent event) {
        this.fDebugContext = event.getContext();
    }

    protected IViewPart getView() {
        return this.fView;
    }

    protected IAction getAction() {
        return this.fAction;
    }

    protected Object getViewerInput() {
        if (this.fDebugContext instanceof IStructuredSelection) {
            return ((IStructuredSelection)this.fDebugContext).getFirstElement();
        }
        return null;
    }

    protected IVMProvider getVMProvider() {
        IVMAdapter adapter;
        Object viewerInput = this.getViewerInput();
        IPresentationContext presentationContext = this.getPresentationContext();
        if (viewerInput instanceof IAdaptable && presentationContext != null && (adapter = (IVMAdapter)((IAdaptable)viewerInput).getAdapter(IVMAdapter.class)) != null) {
            return adapter.getVMProvider(presentationContext);
        }
        return null;
    }

    protected IPresentationContext getPresentationContext() {
        if (this.fView instanceof AbstractDebugView && ((AbstractDebugView)this.fView).getViewer() instanceof TreeModelViewer) {
            return ((TreeModelViewer)((AbstractDebugView)this.fView).getViewer()).getPresentationContext();
        }
        return null;
    }
}

