/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.ui.viewmodel.register;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMService;
import org.eclipse.dd.dsf.debug.service.IFormattedValues;
import org.eclipse.dd.dsf.debug.service.IRegisters;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.ui.viewmodel.expression.AbstractExpressionVMNode;
import org.eclipse.dd.dsf.debug.ui.viewmodel.numberformat.IFormattedValuePreferenceStore;
import org.eclipse.dd.dsf.debug.ui.viewmodel.numberformat.IFormattedValueVMContext;
import org.eclipse.dd.dsf.debug.ui.viewmodel.register.RegisterCellModifier;
import org.eclipse.dd.dsf.debug.ui.viewmodel.register.SyncRegisterDataAccess;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.viewmodel.IVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.IVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.AbstractDMVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.update.AbstractCachingVMProvider;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementEditor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.actions.IWatchExpressionFactoryAdapter2;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisterVMNode
extends AbstractExpressionVMNode
implements IElementEditor,
IElementLabelProvider {
    protected final RegisterExpressionFactory fRegisterExpressionFactory = new RegisterExpressionFactory();
    private final SyncRegisterDataAccess fSyncRegisterDataAccess;
    private final IFormattedValuePreferenceStore fFormattedPrefStore;

    public RegisterVMNode(IFormattedValuePreferenceStore prefStore, AbstractDMVMProvider provider, DsfSession session, SyncRegisterDataAccess syncDataAccess) {
        super(provider, session, IRegisters.IRegisterDMContext.class);
        this.fSyncRegisterDataAccess = syncDataAccess;
        this.fFormattedPrefStore = prefStore;
    }

    protected SyncRegisterDataAccess getSyncRegisterDataAccess() {
        return this.fSyncRegisterDataAccess;
    }

    public IFormattedValuePreferenceStore getPreferenceStore() {
        return this.fFormattedPrefStore;
    }

    private void updateFormattedRegisterValue(final ILabelUpdate update, final int labelIndex, final IRegisters.IRegisterDMContext dmc) {
        final IRegisters regService = (IRegisters)this.getServicesTracker().getService(IRegisters.class);
        IPresentationContext context = update.getPresentationContext();
        final String preferencePageFormatId = this.fFormattedPrefStore.getCurrentNumericFormat(context);
        regService.getAvailableFormats((IFormattedValues.IFormattedDataDMContext)dmc, (DataRequestMonitor)new DataRequestMonitor<String[]>((Executor)this.getSession().getExecutor(), null){

            public void handleCompleted() {
                if (!this.getStatus().isOK()) {
                    RegisterVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                    return;
                }
                String[] formatIds = (String[])this.getData();
                String finalFormatId = "NATURAL.Format";
                boolean requestedFormatIsSupported = false;
                for (String fId : formatIds) {
                    if (!preferencePageFormatId.equals(fId)) continue;
                    finalFormatId = preferencePageFormatId;
                    requestedFormatIsSupported = true;
                    break;
                }
                if (!requestedFormatIsSupported) {
                    if (formatIds.length != 0) {
                        finalFormatId = formatIds[0];
                    } else {
                        RegisterVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                }
                final IFormattedValues.FormattedValueDMContext valueDmc = regService.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)dmc, finalFormatId);
                RegisterVMNode.this.getDMVMProvider().getModelData((IVMNode)RegisterVMNode.this, (IViewerUpdate)update, (IDMService)regService, (IDMContext)valueDmc, (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)RegisterVMNode.this.getSession().getExecutor(), null){

                    public void handleCompleted() {
                        if (!this.getStatus().isOK()) {
                            RegisterVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                            return;
                        }
                        update.setLabel(((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue(), labelIndex);
                        IFormattedValues.FormattedValueDMData oldData = (IFormattedValues.FormattedValueDMData)RegisterVMNode.this.getDMVMProvider().getArchivedModelData((IVMNode)RegisterVMNode.this, (IViewerUpdate)update, (IDMContext)valueDmc);
                        if (oldData != null && !oldData.getFormattedValue().equals(((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue())) {
                            update.setBackground(DebugUIPlugin.getPreferenceColor((String)"org.eclipse.debug.ui.PREF_CHANGED_VALUE_BACKGROUND").getRGB(), labelIndex);
                        }
                        update.done();
                    }
                }, (Executor)RegisterVMNode.this.getSession().getExecutor());
            }
        });
    }

    public void update(final ILabelUpdate[] updates) {
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    RegisterVMNode.this.updateLabelInSessionThread(updates);
                }
            });
        }
        catch (RejectedExecutionException e) {
            for (ILabelUpdate update : updates) {
                this.handleFailedUpdate((IViewerUpdate)update);
            }
        }
    }

    protected void updateLabelInSessionThread(ILabelUpdate[] updates) {
        for (final ILabelUpdate update : updates) {
            final IRegisters.IRegisterDMContext dmc = (IRegisters.IRegisterDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IRegisters.IRegisterDMContext.class);
            if (!this.checkDmc((IDMContext)dmc, (IViewerUpdate)update) || !this.checkService(IRegisters.class, null, (IViewerUpdate)update)) continue;
            this.getDMVMProvider().getModelData((IVMNode)this, (IViewerUpdate)update, (IDMService)this.getServicesTracker().getService(IRegisters.class), (IDMContext)dmc, (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterDMData>((Executor)this.getSession().getExecutor(), null){

                protected void handleCompleted() {
                    int idx;
                    if (!this.getStatus().isOK()) {
                        assert (this.getStatus().isOK() || this.getStatus().getCode() != 10005 || this.getStatus().getCode() != 10003);
                        RegisterVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                    String[] localColumns = update.getPresentationContext().getColumns();
                    if (localColumns == null) {
                        localColumns = new String[]{"org.eclipse.dd.dsf.debug.ui.COLUMN_ID__NAME"};
                    }
                    boolean weAreExtractingFormattedData = false;
                    for (idx = 0; idx < localColumns.length; ++idx) {
                        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__NAME".equals(localColumns[idx])) {
                            update.setLabel(((IRegisters.IRegisterDMData)this.getData()).getName(), idx);
                            update.setImageDescriptor(DebugPluginImages.getImageDescriptor((String)"IMG_OBJS_REGISTER"), idx);
                            continue;
                        }
                        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(localColumns[idx])) {
                            weAreExtractingFormattedData = true;
                            continue;
                        }
                        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__TYPE".equals(localColumns[idx])) {
                            IRegisters.IRegisterDMData data = (IRegisters.IRegisterDMData)this.getData();
                            String typeStr = "Unsigned";
                            String ReadAttrStr = "ReadNone";
                            String WriteAddrStr = "WriteNone";
                            if (data.isFloat()) {
                                typeStr = "Floating Point";
                            }
                            if (data.isReadOnce()) {
                                ReadAttrStr = "ReadOnce";
                            } else if (data.isReadable()) {
                                ReadAttrStr = "Readable";
                            }
                            if (data.isReadOnce()) {
                                WriteAddrStr = "WriteOnce";
                            } else if (data.isReadable()) {
                                WriteAddrStr = "Writeable";
                            }
                            typeStr = typeStr + " - " + ReadAttrStr + "/" + WriteAddrStr;
                            update.setLabel(typeStr, idx);
                            continue;
                        }
                        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__DESCRIPTION".equals(localColumns[idx])) {
                            update.setLabel(((IRegisters.IRegisterDMData)this.getData()).getDescription(), idx);
                            continue;
                        }
                        if (!"org.eclipse.dd.dsf.debug.ui.COLUMN_ID__EXPRESSION".equals(localColumns[idx])) continue;
                        IVMContext vmc = (IVMContext)update.getElement();
                        IExpression expression = (IExpression)vmc.getAdapter(IExpression.class);
                        if (expression != null) {
                            update.setLabel(expression.getExpressionText(), idx);
                            continue;
                        }
                        update.setLabel(((IRegisters.IRegisterDMData)this.getData()).getName(), idx);
                    }
                    if (!weAreExtractingFormattedData) {
                        update.done();
                    } else {
                        for (idx = 0; idx < localColumns.length; ++idx) {
                            if (!"org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(localColumns[idx])) continue;
                            RegisterVMNode.this.updateFormattedRegisterValue(update, idx, dmc);
                        }
                    }
                }
            }, (Executor)this.getSession().getExecutor());
        }
    }

    protected void updateElementsInSessionThread(final IChildrenUpdate update) {
        ((IRegisters)this.getServicesTracker().getService(IRegisters.class)).getRegisters(this.createCompositeDMVMContext((IViewerUpdate)update), (DataRequestMonitor)new DataRequestMonitor<IRegisters.IRegisterDMContext[]>((Executor)this.getSession().getExecutor(), null){

            public void handleCompleted() {
                if (!this.getStatus().isOK()) {
                    RegisterVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                    return;
                }
                RegisterVMNode.this.fillUpdateWithVMCs(update, (IDMContext[])this.getData());
                update.done();
            }
        });
    }

    protected IDMVMContext createVMContext(IDMContext dmc) {
        return new RegisterVMC(dmc);
    }

    public int getDeltaFlags(Object e) {
        if (e instanceof IRunControl.ISuspendedDMEvent) {
            return 1024;
        }
        if (e instanceof IRegisters.IRegistersChangedDMEvent) {
            return 1024;
        }
        if (e instanceof IRegisters.IRegisterChangedDMEvent) {
            return 1024;
        }
        if (e instanceof PropertyChangeEvent && ((PropertyChangeEvent)e).getProperty() == "CurrentNumericStyle") {
            return 1024;
        }
        return 0;
    }

    public void buildDelta(Object e, VMDelta parentDelta, int nodeOffset, RequestMonitor rm) {
        if (e instanceof IRunControl.ISuspendedDMEvent) {
            parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        }
        if (e instanceof IRegisters.IRegistersChangedDMEvent) {
            parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        }
        if (e instanceof IRegisters.IRegisterChangedDMEvent) {
            parentDelta.addNode((Object)this.createVMContext(((IRegisters.IRegisterChangedDMEvent)e).getDMContext()), 3072);
        }
        if (e instanceof PropertyChangeEvent && ((PropertyChangeEvent)e).getProperty() == "CurrentNumericStyle") {
            parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        }
        rm.done();
    }

    @Override
    public boolean canParseExpression(IExpression expression) {
        return this.parseExpressionForRegisterName(expression.getExpressionText()) != null;
    }

    private String parseExpressionForRegisterName(String expression) {
        String registerSubString;
        int secondQuoteIdx;
        if (expression.startsWith("$$\"") && (secondQuoteIdx = expression.indexOf(34, "$$\"".length())) > 0 && (registerSubString = expression.substring(secondQuoteIdx + 1)).length() != 0 && registerSubString.charAt(0) == '$' && Character.isLetterOrDigit(registerSubString.charAt(1))) {
            int registerEnd;
            for (registerEnd = 1; registerEnd < registerSubString.length() && Character.isLetterOrDigit(registerSubString.charAt(registerEnd)); ++registerEnd) {
            }
            return registerSubString.substring(1, registerEnd);
        }
        return null;
    }

    public int getExpressionLength(String expression) {
        if (expression.charAt(0) == '$' && Character.isLetterOrDigit(expression.charAt(1))) {
            int length;
            for (length = 1; length < expression.length() && Character.isLetterOrDigit(expression.charAt(length)); ++length) {
            }
            return length;
        }
        return -1;
    }

    @Override
    protected void testElementForExpression(Object element, IExpression expression, DataRequestMonitor<Boolean> rm) {
        if (!(element instanceof IDMVMContext)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10002, "Invalid context", null));
            rm.done();
            return;
        }
        IRegisters.IRegisterDMContext dmc = (IRegisters.IRegisterDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)element).getDMContext(), IRegisters.IRegisterDMContext.class);
        if (dmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.dsf.debug.ui", 10002, "Invalid context", null));
            rm.done();
            return;
        }
        String regName = this.parseExpressionForRegisterName(expression.getExpressionText());
        if (dmc.getName().equals(regName)) {
            rm.setData((Object)Boolean.TRUE);
        } else {
            rm.setData((Object)Boolean.FALSE);
        }
        rm.done();
    }

    @Override
    protected void associateExpression(Object element, IExpression expression) {
        if (element instanceof RegisterVMC) {
            ((RegisterVMC)element).setExpression(expression);
        }
    }

    @Override
    public int getDeltaFlagsForExpression(IExpression expression, Object event) {
        if (event instanceof IRunControl.ISuspendedDMEvent) {
            return 1024;
        }
        if (event instanceof PropertyChangeEvent && ((PropertyChangeEvent)event).getProperty() == "CurrentNumericStyle") {
            return 1024;
        }
        return 0;
    }

    @Override
    public void buildDeltaForExpression(IExpression expression, int elementIdx, Object event, VMDelta parentDelta, TreePath path, RequestMonitor rm) {
        if (event instanceof IRunControl.ISuspendedDMEvent) {
            parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        }
        rm.done();
    }

    @Override
    public void buildDeltaForExpressionElement(Object element, int elementIdx, Object event, VMDelta parentDelta, RequestMonitor rm) {
        if (event instanceof IRegisters.IRegisterChangedDMEvent) {
            parentDelta.addNode(element, 2048);
        }
        if (event instanceof IRegisters.IRegistersChangedDMEvent) {
            parentDelta.addNode(element, 2048);
        }
        if (event instanceof PropertyChangeEvent && ((PropertyChangeEvent)event).getProperty() == "CurrentNumericStyle") {
            parentDelta.addNode(element, 1024);
        }
        rm.done();
    }

    public CellEditor getCellEditor(IPresentationContext context, String columnId, Object element, Composite parent) {
        IRegisters.IRegisterDMData regData;
        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__EXPRESSION".equals(columnId)) {
            return new TextCellEditor(parent);
        }
        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(columnId) && (regData = this.fSyncRegisterDataAccess.readRegister(element)) != null && regData.isWriteable()) {
            return new TextCellEditor(parent);
        }
        return null;
    }

    public ICellModifier getCellModifier(IPresentationContext context, Object element) {
        return new RegisterCellModifier((AbstractCachingVMProvider)this.getDMVMProvider(), this.fFormattedPrefStore, this.fSyncRegisterDataAccess);
    }

    protected class RegisterExpressionFactory
    implements IWatchExpressionFactoryAdapter2 {
        protected RegisterExpressionFactory() {
        }

        public boolean canCreateWatchExpression(Object element) {
            return element instanceof RegisterVMC;
        }

        public String createWatchExpression(Object element) throws CoreException {
            IRegisters.IRegisterDMContext registerDmc;
            RegisterVMC registerVmc = (RegisterVMC)element;
            StringBuffer exprBuf = new StringBuffer();
            IRegisters.IRegisterGroupDMContext groupDmc = (IRegisters.IRegisterGroupDMContext)DMContexts.getAncestorOfType((IDMContext)registerVmc.getDMContext(), IRegisters.IRegisterGroupDMContext.class);
            if (groupDmc != null) {
                exprBuf.append("$$\"");
                exprBuf.append(groupDmc.getName());
                exprBuf.append('\"');
            }
            if ((registerDmc = (IRegisters.IRegisterDMContext)DMContexts.getAncestorOfType((IDMContext)registerVmc.getDMContext(), IRegisters.IRegisterDMContext.class)) != null) {
                exprBuf.append('$');
                exprBuf.append(registerDmc.getName());
                return exprBuf.toString();
            }
            return null;
        }
    }

    protected class RegisterVMC
    extends AbstractDMVMNode.DMVMContext
    implements IFormattedValueVMContext {
        private IExpression fExpression;

        public RegisterVMC(IDMContext dmc) {
            super((AbstractDMVMNode)RegisterVMNode.this, dmc);
        }

        public void setExpression(IExpression expression) {
            this.fExpression = expression;
        }

        public Object getAdapter(Class adapter) {
            if (this.fExpression != null && adapter.isAssignableFrom(this.fExpression.getClass())) {
                return this.fExpression;
            }
            if (adapter.isAssignableFrom(IWatchExpressionFactoryAdapter2.class)) {
                return RegisterVMNode.this.fRegisterExpressionFactory;
            }
            return super.getAdapter(adapter);
        }

        public boolean equals(Object other) {
            if (other instanceof RegisterVMC && super.equals(other)) {
                RegisterVMC otherReg = (RegisterVMC)other;
                return otherReg.fExpression == null && this.fExpression == null || otherReg.fExpression != null && otherReg.fExpression.equals(this.fExpression);
            }
            return false;
        }

        public int hashCode() {
            return super.hashCode() + (this.fExpression != null ? this.fExpression.hashCode() : 0);
        }

        public IFormattedValuePreferenceStore getPreferenceStore() {
            return RegisterVMNode.this.fFormattedPrefStore;
        }
    }
}

