/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.launch;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMService;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.IStack;
import org.eclipse.dd.dsf.debug.service.StepQueueManager;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.viewmodel.IVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.IVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.ModelProxyInstalledEvent;
import org.eclipse.dd.dsf.ui.viewmodel.VMChildrenUpdate;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.AbstractDMVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.DebugUITools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackFramesVMNode
extends AbstractDMVMNode
implements IElementLabelProvider {
    public IVMContext[] fCachedOldFrameVMCs;

    public StackFramesVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session, IStack.IFrameDMContext.class);
    }

    protected void updateHasElementsInSessionThread(IHasChildrenUpdate update) {
        IRunControl runControl = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
        IRunControl.IExecutionDMContext execCtx = (IRunControl.IExecutionDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IRunControl.IExecutionDMContext.class);
        if (runControl == null || execCtx == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        update.setHasChilren(runControl.isSuspended(execCtx) || runControl.isStepping(execCtx));
        update.done();
    }

    protected void updateElementsInSessionThread(final IChildrenUpdate update) {
        if (this.getServicesTracker().getService(IStack.class) == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        final IRunControl.IExecutionDMContext execDmc = (IRunControl.IExecutionDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IRunControl.IExecutionDMContext.class);
        if (execDmc == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        ((IStack)this.getServicesTracker().getService(IStack.class)).getFrames((IDMContext)execDmc, (DataRequestMonitor)new DataRequestMonitor<IStack.IFrameDMContext[]>((Executor)this.getSession().getExecutor(), null){

            public void handleCompleted() {
                if (!this.isSuccess()) {
                    if (StackFramesVMNode.this.getServicesTracker().getService(IRunControl.class) == null) {
                        StackFramesVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                    if (((IRunControl)StackFramesVMNode.this.getServicesTracker().getService(IRunControl.class)).isStepping(execDmc)) {
                        StackFramesVMNode.this.getElementsTopStackFrameOnly(update);
                    } else {
                        update.done();
                    }
                    return;
                }
                StackFramesVMNode.this.fCachedOldFrameVMCs = StackFramesVMNode.this.dmcs2vmcs((IDMContext[])this.getData());
                for (int i = 0; i < StackFramesVMNode.this.fCachedOldFrameVMCs.length; ++i) {
                    update.setChild((Object)StackFramesVMNode.this.fCachedOldFrameVMCs[i], i);
                }
                update.done();
            }
        });
    }

    private void getElementsTopStackFrameOnly(final IChildrenUpdate update) {
        final IRunControl.IExecutionDMContext execDmc = (IRunControl.IExecutionDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IRunControl.IExecutionDMContext.class);
        if (execDmc == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    if (StackFramesVMNode.this.getServicesTracker().getService(IStack.class) == null) {
                        StackFramesVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                    ((IStack)StackFramesVMNode.this.getServicesTracker().getService(IStack.class)).getTopFrame((IDMContext)execDmc, (DataRequestMonitor)new DataRequestMonitor<IStack.IFrameDMContext>((Executor)StackFramesVMNode.this.getExecutor(), null){

                        public void handleCompleted() {
                            if (!this.isSuccess()) {
                                StackFramesVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                                return;
                            }
                            IDMVMContext topFrameVmc = StackFramesVMNode.this.createVMContext((IDMContext)this.getData());
                            update.setChild((Object)topFrameVmc, 0);
                            if (StackFramesVMNode.this.fCachedOldFrameVMCs != null && StackFramesVMNode.this.fCachedOldFrameVMCs.length >= 1) {
                                StackFramesVMNode.this.fCachedOldFrameVMCs[0] = topFrameVmc;
                                for (int i = 0; i < StackFramesVMNode.this.fCachedOldFrameVMCs.length; ++i) {
                                    update.setChild((Object)StackFramesVMNode.this.fCachedOldFrameVMCs[i], i);
                                }
                            } else {
                                update.setChild((Object)topFrameVmc, 0);
                            }
                            update.done();
                        }
                    });
                }
            });
        }
        catch (RejectedExecutionException e) {
            update.done();
        }
    }

    public void update(final ILabelUpdate[] updates) {
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    StackFramesVMNode.this.updateLabelInSessionThread(updates);
                }
            });
        }
        catch (RejectedExecutionException e) {
            for (ILabelUpdate update : updates) {
                this.handleFailedUpdate((IViewerUpdate)update);
            }
        }
    }

    protected void updateLabelInSessionThread(ILabelUpdate[] updates) {
        for (final ILabelUpdate update : updates) {
            final IStack.IFrameDMContext dmc = (IStack.IFrameDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IStack.IFrameDMContext.class);
            if (dmc == null) {
                this.handleFailedUpdate((IViewerUpdate)update);
                continue;
            }
            if (this.getServicesTracker().getService(IStack.class) == null) {
                this.handleFailedUpdate((IViewerUpdate)update);
                continue;
            }
            this.getDMVMProvider().getModelData((IVMNode)this, (IViewerUpdate)update, (IDMService)this.getServicesTracker().getService(IStack.class, null), (IDMContext)dmc, (DataRequestMonitor)new DataRequestMonitor<IStack.IFrameDMData>((Executor)this.getSession().getExecutor(), null){

                protected void handleCompleted() {
                    if (!this.isSuccess()) {
                        assert (this.getStatus().isOK() || this.getStatus().getCode() != 10005 || this.getStatus().getCode() != 10003);
                        StackFramesVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                    String[] localColumns = update.getColumnIds();
                    if (localColumns == null) {
                        localColumns = new String[]{null};
                    }
                    for (int i = 0; i < localColumns.length; ++i) {
                        StackFramesVMNode.this.fillColumnLabel(dmc, (IStack.IFrameDMData)this.getData(), localColumns[i], i, update);
                    }
                    update.done();
                }
            }, (Executor)this.getExecutor());
        }
    }

    protected void fillColumnLabel(IStack.IFrameDMContext dmContext, IStack.IFrameDMData dmData, String columnId, int idx, ILabelUpdate update) {
        if (idx != 0) {
            return;
        }
        IRunControl.IExecutionDMContext execDmc = (IRunControl.IExecutionDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IRunControl.IExecutionDMContext.class);
        IRunControl runControlService = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
        StepQueueManager stepQueueMgrService = (StepQueueManager)this.getServicesTracker().getService(StepQueueManager.class);
        if (execDmc == null || runControlService == null || stepQueueMgrService == null) {
            return;
        }
        String imageKey = null;
        imageKey = runControlService.isSuspended(execDmc) || runControlService.isStepping(execDmc) && !stepQueueMgrService.isSteppingTimedOut(execDmc) ? "IMG_OBJS_STACKFRAME" : "IMG_OBJS_STACKFRAME_RUNNING";
        update.setImageDescriptor(DebugUITools.getImageDescriptor((String)imageKey), 0);
        StringBuilder label = new StringBuilder();
        if (this.fCachedOldFrameVMCs != null) {
            label.append(this.fCachedOldFrameVMCs.length - dmContext.getLevel());
        }
        if (dmData.getFunction() != null && dmData.getFunction().length() != 0) {
            label.append(" ");
            label.append(dmData.getFunction());
            label.append("()");
        }
        if (dmData.getFile() != null && dmData.getFile().length() != 0) {
            label.append(" at ");
            label.append(dmData.getFile());
        }
        if (dmData.getLine() >= 0) {
            label.append(":");
            label.append(dmData.getLine());
            label.append(" ");
        }
        if (dmData.getAddress() != null) {
            label.append(dmData.getAddress());
        }
        update.setLabel(label.toString(), 0);
    }

    protected void handleFailedUpdate(IViewerUpdate update) {
        if (update instanceof ILabelUpdate) {
            update.done();
        } else {
            super.handleFailedUpdate(update);
        }
    }

    public void getContextsForEvent(VMDelta parentDelta, Object e, final DataRequestMonitor<IVMContext[]> rm) {
        if (e instanceof ModelProxyInstalledEvent) {
            this.getElementsTopStackFrameOnly((IChildrenUpdate)new VMChildrenUpdate((IModelDelta)parentDelta, this.getVMProvider().getPresentationContext(), -1, -1, (DataRequestMonitor)new DataRequestMonitor<List<Object>>((Executor)this.getExecutor(), null){

                public void handleCompleted() {
                    if (this.isSuccess() && ((List)this.getData()).size() != 0) {
                        rm.setData((Object)new IVMContext[]{(IVMContext)((List)this.getData()).get(0)});
                    } else {
                        rm.setData((Object)new IVMContext[0]);
                    }
                    rm.done();
                }
            }));
            return;
        }
        super.getContextsForEvent(parentDelta, e, rm);
    }

    public int getDeltaFlags(Object e) {
        if (e instanceof IRunControl.ISuspendedDMEvent) {
            return 0x300400;
        }
        if (e instanceof IRunControl.IResumedDMEvent) {
            if (((IRunControl.IResumedDMEvent)e).getReason() == IRunControl.StateChangeReason.STEP) {
                return 2048;
            }
            return 1024;
        }
        if (e instanceof StepQueueManager.ISteppingTimedOutEvent) {
            return 1024;
        }
        if (e instanceof ModelProxyInstalledEvent) {
            return 0x300000;
        }
        return 0;
    }

    public void buildDelta(Object e, VMDelta parent, int nodeOffset, RequestMonitor rm) {
        if (e instanceof IRunControl.IContainerSuspendedDMEvent) {
            IRunControl.IExecutionDMContext triggeringCtx;
            IRunControl.IContainerSuspendedDMEvent csEvent = (IRunControl.IContainerSuspendedDMEvent)e;
            IRunControl.IExecutionDMContext iExecutionDMContext = triggeringCtx = csEvent.getTriggeringContexts().length != 0 ? csEvent.getTriggeringContexts()[0] : null;
            if (parent.getElement() instanceof IDMVMContext) {
                IRunControl.IExecutionDMContext threadDmc = null;
                threadDmc = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)parent.getElement()).getDMContext(), IRunControl.IExecutionDMContext.class);
                this.buildDeltaForSuspendedEvent((IRunControl.ISuspendedDMEvent)e, threadDmc, triggeringCtx, parent, nodeOffset, rm);
            } else {
                rm.done();
            }
        } else if (e instanceof IRunControl.ISuspendedDMEvent) {
            IRunControl.IExecutionDMContext execDmc = (IRunControl.IExecutionDMContext)((IRunControl.ISuspendedDMEvent)e).getDMContext();
            this.buildDeltaForSuspendedEvent((IRunControl.ISuspendedDMEvent)e, execDmc, execDmc, parent, nodeOffset, rm);
        } else if (e instanceof IRunControl.IResumedDMEvent) {
            this.buildDeltaForResumedEvent((IRunControl.IResumedDMEvent)e, parent, nodeOffset, rm);
        } else if (e instanceof StepQueueManager.ISteppingTimedOutEvent) {
            this.buildDeltaForSteppingTimedOutEvent((StepQueueManager.ISteppingTimedOutEvent)e, parent, nodeOffset, rm);
        } else if (e instanceof ModelProxyInstalledEvent) {
            this.buildDeltaForModelProxyInstalledEvent(parent, nodeOffset, rm);
        } else {
            rm.done();
        }
    }

    private void buildDeltaForSuspendedEvent(IRunControl.ISuspendedDMEvent e, IRunControl.IExecutionDMContext executionCtx, IRunControl.IExecutionDMContext triggeringCtx, final VMDelta parentDelta, int nodeOffset, final RequestMonitor rm) {
        IRunControl runControlService = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
        IStack stackService = (IStack)this.getServicesTracker().getService(IStack.class);
        if (stackService == null || runControlService == null) {
            rm.done();
            return;
        }
        if (triggeringCtx == null || !runControlService.isStepping(triggeringCtx)) {
            parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        }
        if (executionCtx.equals(triggeringCtx)) {
            parentDelta.setFlags(parentDelta.getFlags() | 0x100000);
            this.getElementsTopStackFrameOnly((IChildrenUpdate)new VMChildrenUpdate((IModelDelta)parentDelta, this.getVMProvider().getPresentationContext(), -1, -1, (DataRequestMonitor)new DataRequestMonitor<List<Object>>((Executor)this.getExecutor(), null){

                public void handleCompleted() {
                    if (this.isSuccess() && ((List)this.getData()).size() != 0) {
                        parentDelta.addNode(((List)this.getData()).get(0), 0, 0x200800);
                        if (((List)this.getData()).size() >= 2) {
                            parentDelta.addNode(((List)this.getData()).get(1), 1, 2048);
                        }
                    }
                    rm.done();
                }
            }));
        } else {
            rm.done();
        }
    }

    private void buildDeltaForResumedEvent(IRunControl.IResumedDMEvent e, VMDelta parentDelta, int nodeOffset, RequestMonitor rm) {
        IStack stackService = (IStack)this.getServicesTracker().getService(IStack.class);
        if (stackService == null) {
            rm.done();
            return;
        }
        IRunControl.IResumedDMEvent resumedEvent = e;
        if (resumedEvent.getReason() != IRunControl.StateChangeReason.STEP) {
            parentDelta.setFlags(parentDelta.getFlags() | 0x400);
            this.fCachedOldFrameVMCs = null;
        }
        rm.done();
    }

    private void buildDeltaForSteppingTimedOutEvent(StepQueueManager.ISteppingTimedOutEvent e, VMDelta parentDelta, int nodeOffset, RequestMonitor rm) {
        parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        rm.done();
    }

    private void buildDeltaForModelProxyInstalledEvent(final VMDelta parentDelta, int nodeOffset, final RequestMonitor rm) {
        this.getElementsTopStackFrameOnly((IChildrenUpdate)new VMChildrenUpdate((IModelDelta)parentDelta, this.getVMProvider().getPresentationContext(), -1, -1, (DataRequestMonitor)new DataRequestMonitor<List<Object>>((Executor)this.getExecutor(), null){

            public void handleCompleted() {
                if (this.isSuccess() && ((List)this.getData()).size() != 0) {
                    parentDelta.addNode(((List)this.getData()).get(0), 0, 0x300000);
                }
                rm.done();
            }
        }));
    }
}

