/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.launch;

import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.IVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.IVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.provisional.ILabelRequestMonitor;
import org.eclipse.jface.viewers.TreePath;

public class StandardProcessVMNode
extends AbstractVMNode {
    public StandardProcessVMNode(AbstractVMProvider provider) {
        super(provider);
    }

    public void update(IChildrenUpdate[] updates) {
        for (IChildrenUpdate update : updates) {
            ILaunch launch = this.findLaunch(update.getElementPath());
            if (launch == null) {
                assert (false);
                update.done();
                continue;
            }
            IProcess[] processes = launch.getProcesses();
            for (int i = 0; i < processes.length; ++i) {
                update.setChild((Object)new VMC(processes[i]), i);
            }
            update.done();
        }
    }

    public void update(IChildrenCountUpdate[] updates) {
        for (IChildrenCountUpdate update : updates) {
            if (!this.checkUpdate((IViewerUpdate)update)) continue;
            ILaunch launch = this.findLaunch(update.getElementPath());
            if (launch == null) {
                assert (false);
                update.setChildCount(0);
                update.done();
                return;
            }
            update.setChildCount(launch.getProcesses().length);
            update.done();
        }
    }

    public void update(IHasChildrenUpdate[] updates) {
        for (IHasChildrenUpdate update : updates) {
            ILaunch launch = this.findLaunch(update.getElementPath());
            if (launch == null) {
                assert (false);
                update.setHasChilren(false);
                update.done();
                return;
            }
            update.setHasChilren(launch.getProcesses().length != 0);
            update.done();
        }
    }

    public void updateLabel(IVMContext vmc, ILabelRequestMonitor result, String[] columns) {
        assert (false);
        result.done();
    }

    private ILaunch findLaunch(TreePath path) {
        for (int i = path.getSegmentCount() - 1; i >= 0; --i) {
            if (!(path.getSegment(i) instanceof ILaunch)) continue;
            return (ILaunch)path.getSegment(i);
        }
        return null;
    }

    public int getDeltaFlags(Object e) {
        DebugEvent de;
        int myFlags = 0;
        if (e instanceof DebugEvent && (de = (DebugEvent)e).getSource() instanceof IProcess && (de.getKind() == 16 || de.getKind() == 4 || de.getKind() == 8)) {
            myFlags = 2048;
        }
        return myFlags;
    }

    public void buildDelta(Object e, VMDelta parent, int nodeOffset, RequestMonitor requestMonitor) {
        if (e instanceof DebugEvent && ((DebugEvent)e).getSource() instanceof IProcess) {
            DebugEvent de = (DebugEvent)e;
            if (de.getKind() == 16) {
                this.handleChange(de, (ModelDelta)parent);
            } else if (de.getKind() == 4) {
                this.handleCreate(de, (ModelDelta)parent);
            } else if (de.getKind() == 8) {
                this.handleTerminate(de, (ModelDelta)parent);
            }
        }
        requestMonitor.done();
    }

    protected void handleChange(DebugEvent event, ModelDelta parent) {
        parent.addNode((Object)new VMC((IProcess)event.getSource()), 2048);
    }

    protected void handleCreate(DebugEvent event, ModelDelta parent) {
        parent.setFlags(parent.getFlags() | 0x400);
    }

    protected void handleTerminate(DebugEvent event, ModelDelta parent) {
        this.handleChange(event, parent);
    }

    private class VMC
    extends AbstractVMContext
    implements IProcess {
        private final IProcess fProcess;

        VMC(IProcess process) {
            super((IVMNode)StandardProcessVMNode.this);
            this.fProcess = process;
        }

        public IVMNode getVMNode() {
            return StandardProcessVMNode.this;
        }

        public Object getAdapter(Class adapter) {
            Object vmcAdapter = super.getAdapter(adapter);
            if (vmcAdapter != null) {
                return vmcAdapter;
            }
            return this.fProcess.getAdapter(adapter);
        }

        public String toString() {
            return "IProcess " + this.fProcess.toString();
        }

        public String getAttribute(String key) {
            return this.fProcess.getAttribute(key);
        }

        public int getExitValue() throws DebugException {
            return this.fProcess.getExitValue();
        }

        public String getLabel() {
            return this.fProcess.getLabel();
        }

        public ILaunch getLaunch() {
            return this.fProcess.getLaunch();
        }

        public IStreamsProxy getStreamsProxy() {
            return this.fProcess.getStreamsProxy();
        }

        public void setAttribute(String key, String value) {
            this.fProcess.setAttribute(key, value);
        }

        public boolean canTerminate() {
            return this.fProcess.canTerminate();
        }

        public boolean isTerminated() {
            return this.fProcess.isTerminated();
        }

        public void terminate() throws DebugException {
            this.fProcess.terminate();
        }

        public boolean equals(Object other) {
            return other instanceof VMC && this.fProcess.equals(((VMC)((Object)other)).fProcess);
        }

        public int hashCode() {
            return this.fProcess.hashCode();
        }
    }
}

