/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.ui.disassembly;

import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.model.ICAddressBreakpoint;
import org.eclipse.cdt.internal.ui.dnd.TextViewerDragAdapter;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfExecutor;
import org.eclipse.dd.dsf.concurrent.Query;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.internal.ui.DsfDebugUIPlugin;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.AddressRulerColumn;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.DisassemblyDropAdapter;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.DisassemblyImageRegistry;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.DisassemblyMessages;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.DisassemblyRulerColumn;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.DisassemblyViewer;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.DisassemblyViewerConfiguration;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.EditionFinderJob;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.FunctionOffsetRulerColumn;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.IDisassemblyPart;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.SourceColorerJob;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.actions.AbstractDisassemblyAction;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.actions.ActionGotoAddress;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.actions.ActionGotoProgramCounter;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.actions.ActionGotoSymbol;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.actions.ActionOpenPreferences;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.actions.TextOperationAction;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.model.Addr2Line;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.model.AddressRangePosition;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.model.BreakpointsAnnotationModel;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.model.DisassemblyDocument;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.model.DisassemblyPosition;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.model.ErrorPosition;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.model.LabelPosition;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.model.SourceFileInfo;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.model.SourcePosition;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.presentation.DisassemblyIPAnnotation;
import org.eclipse.dd.dsf.debug.internal.ui.disassembly.util.HSL;
import org.eclipse.dd.dsf.debug.service.IDisassembly;
import org.eclipse.dd.dsf.debug.service.IExpressions;
import org.eclipse.dd.dsf.debug.service.IFormattedValues;
import org.eclipse.dd.dsf.debug.service.IInstruction;
import org.eclipse.dd.dsf.debug.service.IMixedInstruction;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.ISourceLookup;
import org.eclipse.dd.dsf.debug.service.IStack;
import org.eclipse.dd.dsf.service.DsfServiceEventHandler;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.IVerticalRulerExtension;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.WorkbenchPart;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DisassemblyPart
extends WorkbenchPart
implements IDisassemblyPart,
IViewportListener,
ITextPresentationListener {
    private static final boolean DEBUG = DsfDebugUIPlugin.getDefault().isDebugging();
    private static final String BREAKPOINT_ANNOTATIONS = "breakpoints";
    private static final BigInteger PC_UNKNOWN = BigInteger.valueOf(-1L);
    private static final BigInteger PC_RUNNING = BigInteger.valueOf(-2L);
    private static final String CURRENT_LINE = "currentLine";
    private static final String CURRENT_LINE_COLOR = "currentLineColor";
    protected static final int VERTICAL_RULER_WIDTH = 12;
    private static final int fgHighWaterMark = 500;
    private static final int fgLowWaterMark = 100;
    private static final String COMMAND_ID_GOTO_ADDRESS = "org.eclipse.dd.dsf.debug.ui.disassembly.commands.gotoAddress";
    private static final String COMMAND_ID_GOTO_PC = "org.eclipse.dd.dsf.debug.ui.disassembly.commands.gotoPC";
    private static final String COMMAND_ID_GOTO_SYMBOL = "org.eclipse.dd.dsf.debug.ui.disassembly.commands.gotoSymbol";
    private static final String KEY_BINDING_CONTEXT_DISASSEMBLY = "org.eclipse.dd.dsf.debug.ui.disassembly.context";
    protected DisassemblyViewer fViewer;
    protected AbstractDisassemblyAction fActionGotoPC;
    protected AbstractDisassemblyAction fActionGotoAddress;
    private AbstractDisassemblyAction fActionGotoSymbol;
    private AbstractDisassemblyAction fActionToggleBreakpoint;
    protected AbstractDisassemblyAction fActionToggleSource;
    private AbstractDisassemblyAction fActionToggleFunctionColumn;
    private AbstractDisassemblyAction fActionToggleSymbols;
    private AbstractDisassemblyAction fActionRefreshView;
    private Action fActionOpenPreferences;
    private AbstractDisassemblyAction fActionToggleAddressColumn;
    private AbstractDisassemblyAction fActionToggleBreakpointEnablement;
    protected DisassemblyDocument fDocument;
    private IAnnotationAccess fAnnotationAccess;
    private AnnotationRulerColumn fAnnotationRulerColumn;
    private MarkerAnnotationPreferences fAnnotationPreferences;
    private IPreferenceStore fPreferenceStore;
    private IOverviewRuler fOverviewRuler;
    private final ListenerList fRulerContextMenuListeners = new ListenerList(1);
    private SourceViewerDecorationSupport fDecorationSupport;
    private Font fFont;
    private IVerticalRuler fVerticalRuler;
    private IFindReplaceTarget fFindReplaceTarget;
    private IPropertyChangeListener fPropertyChangeListener = new PropertyChangeListener();
    private Color fInstructionColor;
    private Color fErrorColor;
    private Color fSourceColor;
    private Color fLabelColor;
    private Control fRedrawControl;
    private RGB fPCAnnotationRGB;
    private Composite fComposite;
    private DropTarget fDropTarget;
    private DragSource fDragSource;
    private TextViewerDragAdapter fDragSourceAdapter;
    private DisassemblyDropAdapter fDropTargetAdapter;
    private FunctionOffsetRulerColumn fOpcodeRulerColumn;
    private AddressRulerColumn fAddressRulerColumn;
    private BigInteger fStartAddress;
    private BigInteger fEndAddress;
    private int fAddressSize = 32;
    private volatile boolean fUpdatePending;
    private BigInteger fPCAddress;
    private BigInteger fGotoAddressPending = PC_UNKNOWN;
    private BigInteger fFocusAddress = PC_UNKNOWN;
    private int fBufferZone;
    private IRunControl.IExecutionDMContext fTargetContext;
    private String fDebugSessionId;
    private int fTargetFrame;
    private DisassemblyIPAnnotation fPCAnnotation;
    private DisassemblyIPAnnotation fSecondaryPCAnnotation;
    private boolean fPCAnnotationUpdatePending;
    private ArrayList<BigInteger> fPendingPCUpdates = new ArrayList(5);
    private Position fScrollPos;
    private int fScrollLine;
    private Position fFocusPos;
    private BigInteger fFrameAddress = PC_UNKNOWN;
    protected Map<String, Action> fGlobalActions = new HashMap<String, Action>();
    private List<Action> fSelectionActions = new ArrayList<Action>();
    private List<AbstractDisassemblyAction> fStateDependentActions = new ArrayList<AbstractDisassemblyAction>();
    private boolean fSourceOnlyMode;
    private boolean fShowSource;
    private boolean fShowOpcodes;
    private boolean fShowSymbols;
    private Map<String, Object> fFile2Storage = new HashMap<String, Object>();
    private boolean fShowDisassembly;
    private LinkedList<AddressRangePosition> fPCHistory = new LinkedList();
    private int fPCHistorySizeMax = 4;
    private boolean fGotoFramePending;
    private String fPCAnnotationColorKey;
    private ArrayList<Runnable> fRunnableQueue = new ArrayList();
    protected IPartListener2 fPartListener = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
            if (partRef.getPart(false) == DisassemblyPart.this) {
                DisassemblyPart.this.setActive(false);
            }
        }

        public void partVisible(IWorkbenchPartReference partRef) {
            if (partRef.getPart(false) == DisassemblyPart.this) {
                DisassemblyPart.this.setActive(true);
            }
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }
    };
    private boolean fActive = true;
    private boolean fDoPendingPosted;
    private boolean fUpdateBeforeFocus;
    private boolean fRefreshAll;
    private IMarker fGotoMarkerPending;
    private boolean fUpdateTitlePending;
    private boolean fRefreshViewPending;
    private boolean fUpdateSourcePending;
    private ArrayList<IHandlerActivation> fHandlerActivations;
    private IContextActivation fContextActivation;
    private DsfServicesTracker fServicesTracker;
    private IStack.IFrameDMContext fTargetFrameContext;
    protected IStack.IFrameDMData fTargetFrameData;

    public DisassemblyPart() {
        this.fAnnotationPreferences = new MarkerAnnotationPreferences();
        this.setPreferenceStore((IPreferenceStore)new ChainedPreferenceStore(new IPreferenceStore[]{DsfDebugUIPlugin.getDefault().getPreferenceStore(), EditorsUI.getPreferenceStore()}));
        this.fPCAddress = this.fFrameAddress = PC_UNKNOWN;
        this.fTargetFrame = -1;
        this.fBufferZone = 32;
        this.fPCAnnotation = new DisassemblyIPAnnotation(true, 0);
        this.fSecondaryPCAnnotation = new DisassemblyIPAnnotation(false, 0);
        IPreferenceStore prefs = this.getPreferenceStore();
        this.fStartAddress = new BigInteger(prefs.getString("startAddress"));
        String endAddressString = prefs.getString("endAddress");
        this.fEndAddress = endAddressString.startsWith("0x") ? new BigInteger(endAddressString.substring(2), 16) : new BigInteger(endAddressString, 16);
        this.fSourceOnlyMode = false;
        this.fShowSource = this.fSourceOnlyMode || prefs.getBoolean("showSource");
        this.fShowDisassembly = !this.fSourceOnlyMode || !this.fShowSource;
        this.fShowOpcodes = prefs.getBoolean("showOpcodeRuler");
        this.fShowSymbols = prefs.getBoolean("showSymbols");
        this.fUpdateBeforeFocus = !prefs.getBoolean("avoidReadBeforePC");
        this.fPCHistorySizeMax = prefs.getInt("pcHistorySize");
    }

    public void logWarning(String message, Throwable error) {
        DsfDebugUIPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.dd.dsf.debug.ui", message, error));
    }

    public Object getAdapter(Class required) {
        if (IVerticalRulerInfo.class.equals((Object)required)) {
            if (this.fVerticalRuler != null) {
                return this.fVerticalRuler;
            }
        } else {
            if (IDisassemblyPart.class.equals((Object)required)) {
                return this;
            }
            if (IFindReplaceTarget.class.equals((Object)required)) {
                if (this.fFindReplaceTarget == null) {
                    this.fFindReplaceTarget = this.fViewer == null ? null : this.fViewer.getFindReplaceTarget();
                }
                return this.fFindReplaceTarget;
            }
            if (ITextOperationTarget.class.equals((Object)required)) {
                return this.fViewer == null ? null : this.fViewer.getTextOperationTarget();
            }
            if (Control.class.equals((Object)required)) {
                return this.fViewer != null ? this.fViewer.getTextWidget() : null;
            }
            if (IGotoMarker.class.equals((Object)required)) {
                return new IGotoMarker(){

                    public void gotoMarker(IMarker marker) {
                        DisassemblyPart.this.gotoMarker(marker);
                    }
                };
            }
            if (IToggleBreakpointsTarget.class.equals((Object)required)) {
                return new IToggleBreakpointsTarget(){

                    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
                        ITextSelection textSelection = (ITextSelection)selection;
                        int line = textSelection.getStartLine();
                        IBreakpoint[] bp = DisassemblyPart.this.getBreakpointsAtLine(line);
                        if (bp == null || bp.length == 0) {
                            DisassemblyPart.this.insertBreakpoint(line, false);
                        } else {
                            for (int i = 0; i < bp.length; ++i) {
                                bp[i].delete();
                            }
                        }
                    }

                    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
                        return DisassemblyPart.this.fDebugSessionId != null;
                    }

                    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
                    }

                    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
                        return false;
                    }

                    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
                    }

                    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
                        return false;
                    }
                };
            }
            if (IRunToLineTarget.class.equals((Object)required)) {
                return new IRunToLineTarget(){

                    public void runToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) throws CoreException {
                    }

                    public boolean canRunToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) {
                        return DisassemblyPart.this.fTargetContext != null && DisassemblyPart.this.isSuspended(DisassemblyPart.this.fTargetContext);
                    }
                };
            }
        }
        return super.getAdapter(required);
    }

    private void setPreferenceStore(IPreferenceStore store) {
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener(this.fPropertyChangeListener);
        }
        this.fPreferenceStore = store;
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.addPropertyChangeListener(this.fPropertyChangeListener);
        }
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        if (this.fViewer == null) {
            return;
        }
        String property = event.getProperty();
        IPreferenceStore store = this.getPreferenceStore();
        if (this.getFontPropertyPreferenceKey().equals(property)) {
            this.initializeViewerFont((ISourceViewer)this.fViewer);
        } else if (property.equals("showAddressRuler")) {
            this.fActionToggleAddressColumn.update();
            if (this.isAddressRulerVisible()) {
                this.showAddressRuler();
            } else {
                this.hideAddressRuler();
            }
        } else if (property.equals("addressRadix")) {
            if (this.fAddressRulerColumn != null) {
                this.hideAddressRuler();
                this.showAddressRuler();
            }
        } else if (property.equals("showAddressRadix")) {
            if (this.fAddressRulerColumn != null) {
                this.hideAddressRuler();
                this.showAddressRuler();
            }
        } else if (property.equals("showSource")) {
            this.sourceModeChanged(store.getBoolean(property));
        } else if (property.equals("instructionRadix")) {
            Runnable doit = new Runnable(){

                public void run() {
                    DisassemblyPart.this.fDocument.invalidateAddressRange(DisassemblyPart.this.fStartAddress, DisassemblyPart.this.fEndAddress, true);
                    if (!DisassemblyPart.this.fShowDisassembly) {
                        DisassemblyPart.this.fDocument.invalidateDisassemblyWithSource(true);
                    }
                    DisassemblyPart.this.fDocument.setMaxOpcodeLength(0);
                    DisassemblyPart.this.fGotoFramePending = true;
                }
            };
            this.doScrollLocked(doit);
        } else if (property.equals("showSymbols")) {
            boolean showSymbols = store.getBoolean(property);
            if (this.fShowSymbols == showSymbols) {
                return;
            }
            this.fShowSymbols = showSymbols;
            Runnable doit = new Runnable(){

                public void run() {
                    DisassemblyPart.this.fDocument.invalidateAddressRange(DisassemblyPart.this.fStartAddress, DisassemblyPart.this.fEndAddress, true);
                    if (!DisassemblyPart.this.fShowDisassembly) {
                        DisassemblyPart.this.fDocument.invalidateDisassemblyWithSource(true);
                    }
                    DisassemblyPart.this.fGotoFramePending = true;
                }
            };
            this.doScrollLocked(doit);
        } else if (property.equals("useSourceOnlyMode")) {
            this.fSourceOnlyMode = store.getBoolean(property);
            if (this.fDebugSessionId != null) {
                this.disassemblyModeChanged(this.isDissemblyMixedModeOn());
            }
        } else if (property.equals("showOpcodeRuler")) {
            this.fShowOpcodes = store.getBoolean(property);
            this.fActionToggleFunctionColumn.update();
            if (this.isOpcodeRulerVisible()) {
                this.showOpcodeRuler();
            } else {
                this.hideOpcodeRuler();
            }
        } else if (property.equals("avoidReadBeforePC")) {
            this.fUpdateBeforeFocus = !store.getBoolean(property);
            this.updateVisibleArea();
        } else if (property.equals(this.fPCAnnotationColorKey)) {
            this.fPCAnnotationRGB = PreferenceConverter.getColor((IPreferenceStore)store, (String)this.fPCAnnotationColorKey);
            for (AddressRangePosition pos : this.fPCHistory) {
                this.fViewer.invalidateTextPresentation(pos.offset, pos.length);
            }
        } else if (property.equals("pcHistorySize")) {
            this.fPCHistorySizeMax = store.getInt(property);
        }
    }

    public void createPartControl(Composite parent) {
        this.fComposite = parent;
        FillLayout layout = new FillLayout();
        layout.marginHeight = 2;
        parent.setLayout((Layout)layout);
        this.fVerticalRuler = this.createVerticalRuler();
        int styles = 68354;
        this.fViewer = new DisassemblyViewer(parent, this.fVerticalRuler, this.getOverviewRuler(), true, styles);
        DisassemblyViewerConfiguration sourceViewerConfig = new DisassemblyViewerConfiguration(this);
        this.fViewer.addTextPresentationListener(this);
        this.fViewer.configure((SourceViewerConfiguration)sourceViewerConfig);
        this.fDecorationSupport = new SourceViewerDecorationSupport((ISourceViewer)this.fViewer, this.getOverviewRuler(), this.getAnnotationAccess(), this.getSharedColors());
        this.configureSourceViewerDecorationSupport(this.fDecorationSupport);
        this.fDecorationSupport.install(this.getPreferenceStore());
        this.fPCAnnotationRGB = this.fPCAnnotationColorKey != null ? PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)this.fPCAnnotationColorKey) : parent.getDisplay().getSystemColor(26).getRGB();
        this.initializeViewerFont((ISourceViewer)this.fViewer);
        this.createActions();
        this.hookRulerContextMenu();
        this.hookContextMenu();
        this.contributeToActionBars();
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DisassemblyPart.this.updateSelectionDependentActions();
            }
        });
        this.fDocument = this.createDocument();
        this.fViewer.setDocument((IDocument)this.fDocument, (IAnnotationModel)new AnnotationModel());
        JFaceResources.getFontRegistry().addListener(this.fPropertyChangeListener);
        this.fErrorColor = this.getSharedColors().getColor(new RGB(96, 0, 0));
        this.fInstructionColor = this.getSharedColors().getColor(new RGB(0, 0, 96));
        this.fSourceColor = this.getSharedColors().getColor(new RGB(64, 0, 80));
        this.fLabelColor = this.getSharedColors().getColor(new RGB(0, 0, 96));
        if (this.isAddressRulerVisible()) {
            this.showAddressRuler();
        }
        if (this.isOpcodeRulerVisible()) {
            this.showOpcodeRuler();
        }
        this.initDragAndDrop();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.fViewer.getControl(), "org.eclipse.dd.dsf.debug.ui.disassembly_view");
        this.updateTitle();
        this.updateStateDependentActions();
        if (this.fDebugSessionId != null) {
            this.debugContextChanged();
        } else {
            this.updateDebugContext();
        }
    }

    protected void setSite(IWorkbenchPartSite site) {
        super.setSite(site);
        site.getPage().addPartListener(this.fPartListener);
    }

    private DisassemblyDocument createDocument() {
        DisassemblyDocument doc = new DisassemblyDocument();
        return doc;
    }

    public void dispose() {
        IWorkbenchPartSite site = this.getSite();
        site.setSelectionProvider(null);
        site.getPage().removePartListener(this.fPartListener);
        if (this.fHandlerActivations != null) {
            IHandlerService handlerService = (IHandlerService)site.getService(IHandlerService.class);
            handlerService.deactivateHandlers(this.fHandlerActivations);
            this.fHandlerActivations = null;
        }
        if (this.fContextActivation != null) {
            IContextService ctxService = (IContextService)site.getService(IContextService.class);
            ctxService.deactivateContext(this.fContextActivation);
        }
        this.fViewer = null;
        this.fDebugSessionId = null;
        this.fTargetContext = null;
        if (this.fServicesTracker != null) {
            this.fServicesTracker.dispose();
            this.fServicesTracker = null;
        }
        this.fAnnotationAccess = null;
        this.fAnnotationPreferences = null;
        this.fAnnotationRulerColumn = null;
        this.fComposite = null;
        if (this.fDecorationSupport != null) {
            this.fDecorationSupport.uninstall();
            this.fDecorationSupport = null;
        }
        if (this.fFont != null) {
            this.fFont.dispose();
            this.fFont = null;
        }
        if (this.fDropTarget != null) {
            this.fDropTarget.dispose();
            this.fDropTarget = null;
            this.fDragSource.dispose();
            this.fDragSource = null;
        }
        if (this.fPropertyChangeListener != null) {
            if (this.fPreferenceStore != null) {
                this.fPreferenceStore.removePropertyChangeListener(this.fPropertyChangeListener);
                this.fPreferenceStore = null;
            }
            this.fPropertyChangeListener = null;
        }
        this.fDocument.dispose();
        this.fDocument = null;
        super.dispose();
    }

    private void initDragAndDrop() {
        if (this.fDropTarget == null) {
            StyledText dropControl;
            Transfer[] dropTypes = new Transfer[]{FileTransfer.getInstance(), TextTransfer.getInstance()};
            Transfer[] dragTypes = new Transfer[]{TextTransfer.getInstance()};
            StyledText dragControl = dropControl = this.getSourceViewer().getTextWidget();
            int dropOps = 17;
            int dragOps = 17;
            this.fDropTarget = new DropTarget((Control)dropControl, dropOps);
            this.fDropTarget.setTransfer(dropTypes);
            this.fDropTargetAdapter = new DisassemblyDropAdapter(this);
            this.fDropTarget.addDropListener((DropTargetListener)this.fDropTargetAdapter);
            this.fDragSource = new DragSource((Control)dragControl, dragOps);
            this.fDragSource.setTransfer(dragTypes);
            this.fDragSourceAdapter = new TextViewerDragAdapter((ITextViewer)this.getSourceViewer());
            this.fDragSource.addDragListener((DragSourceListener)this.fDragSourceAdapter);
        }
    }

    private ISourceViewer getSourceViewer() {
        return this.fViewer;
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        for (AnnotationPreference pref : this.fAnnotationPreferences.getAnnotationPreferences()) {
            support.setAnnotationPreference(pref);
            if (!pref.getAnnotationType().equals(this.fPCAnnotation.getType())) continue;
            this.fPCAnnotationColorKey = pref.getColorPreferenceKey();
        }
        support.setCursorLinePainterPreferenceKeys(CURRENT_LINE, CURRENT_LINE_COLOR);
        support.setSymbolicFontName(this.getFontPropertyPreferenceKey());
    }

    private String getSymbolicFontName() {
        if (this.getConfigurationElement() != null) {
            return this.getConfigurationElement().getAttribute("symbolicFontName");
        }
        return null;
    }

    protected final String getFontPropertyPreferenceKey() {
        String symbolicFontName = this.getSymbolicFontName();
        if (symbolicFontName != null) {
            return symbolicFontName;
        }
        return "org.eclipse.jface.textfont";
    }

    private void initializeViewerFont(ISourceViewer viewer) {
        FontData data;
        boolean isSharedFont = true;
        Font font = null;
        String symbolicFontName = this.getSymbolicFontName();
        if (symbolicFontName != null) {
            font = JFaceResources.getFont((String)symbolicFontName);
        } else if (this.fPreferenceStore != null && this.fPreferenceStore.contains("org.eclipse.jface.textfont") && !this.fPreferenceStore.isDefault("org.eclipse.jface.textfont") && (data = PreferenceConverter.getFontData((IPreferenceStore)this.fPreferenceStore, (String)"org.eclipse.jface.textfont")) != null) {
            isSharedFont = false;
            font = new Font((Device)viewer.getTextWidget().getDisplay(), data);
        }
        if (font == null) {
            font = JFaceResources.getTextFont();
        }
        this.setFont(viewer, font);
        if (this.fFont != null) {
            this.fFont.dispose();
            this.fFont = null;
        }
        if (!isSharedFont) {
            this.fFont = font;
        }
    }

    private void setFont(ISourceViewer sourceViewer, Font font) {
        if (sourceViewer.getDocument() != null) {
            StyledText styledText;
            Point selection = sourceViewer.getSelectedRange();
            int topIndex = sourceViewer.getTopIndex();
            StyledText parent = styledText = sourceViewer.getTextWidget();
            if (sourceViewer instanceof ITextViewerExtension) {
                ITextViewerExtension extension = (ITextViewerExtension)sourceViewer;
                parent = extension.getControl();
            }
            parent.setRedraw(false);
            styledText.setFont(font);
            if (this.fVerticalRuler instanceof IVerticalRulerExtension) {
                IVerticalRulerExtension e = (IVerticalRulerExtension)this.fVerticalRuler;
                e.setFont(font);
            }
            sourceViewer.setSelectedRange(selection.x, selection.y);
            sourceViewer.setTopIndex(topIndex);
            if (parent instanceof Composite) {
                Composite composite = (Composite)parent;
                composite.layout(true);
            }
            parent.setRedraw(true);
        } else {
            StyledText styledText = sourceViewer.getTextWidget();
            styledText.setFont(font);
            if (this.fVerticalRuler instanceof IVerticalRulerExtension) {
                IVerticalRulerExtension e = (IVerticalRulerExtension)this.fVerticalRuler;
                e.setFont(font);
            }
        }
    }

    protected IVerticalRuler createVerticalRuler() {
        CompositeRuler ruler = this.createCompositeRuler();
        IPreferenceStore store = this.getPreferenceStore();
        if (ruler != null && store != null) {
            Iterator iter = ruler.getDecoratorIterator();
            while (iter.hasNext()) {
                IVerticalRulerColumn column = (IVerticalRulerColumn)iter.next();
                if (!(column instanceof AnnotationRulerColumn)) continue;
                this.fAnnotationRulerColumn = (AnnotationRulerColumn)column;
                for (AnnotationPreference preference : this.fAnnotationPreferences.getAnnotationPreferences()) {
                    String key = preference.getVerticalRulerPreferenceKey();
                    boolean showAnnotation = true;
                    if (key != null && store.contains(key)) {
                        showAnnotation = store.getBoolean(key);
                    }
                    if (!showAnnotation) continue;
                    this.fAnnotationRulerColumn.addAnnotationType(preference.getAnnotationType());
                }
                this.fAnnotationRulerColumn.addAnnotationType((Object)"org.eclipse.text.annotation.unknown");
                break;
            }
        }
        return ruler;
    }

    protected IVerticalRuler getVerticalRuler() {
        return this.fVerticalRuler;
    }

    protected IOverviewRuler getOverviewRuler() {
        if (this.fOverviewRuler == null) {
            this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        }
        return this.fOverviewRuler;
    }

    protected ISharedTextColors getSharedColors() {
        return EditorsUI.getSharedTextColors();
    }

    protected IOverviewRuler createOverviewRuler(ISharedTextColors sharedColors) {
        OverviewRuler ruler = new OverviewRuler(this.getAnnotationAccess(), 12, sharedColors);
        for (AnnotationPreference preference : this.fAnnotationPreferences.getAnnotationPreferences()) {
            if (!preference.contributesToHeader()) continue;
            ruler.addHeaderAnnotationType(preference.getAnnotationType());
        }
        return ruler;
    }

    protected IVerticalRulerColumn createAddressRulerColumn() {
        this.fAddressRulerColumn = new AddressRulerColumn();
        this.initializeRulerColumn(this.fAddressRulerColumn, "addressColor");
        IPreferenceStore prefs = this.getPreferenceStore();
        this.fAddressRulerColumn.setRadix(prefs.getInt("addressRadix"));
        this.fAddressRulerColumn.setShowRadixPrefix(prefs.getBoolean("showAddressRadix"));
        return this.fAddressRulerColumn;
    }

    protected IVerticalRulerColumn createOpcodeRulerColumn() {
        this.fOpcodeRulerColumn = new FunctionOffsetRulerColumn();
        this.initializeRulerColumn(this.fOpcodeRulerColumn, "opcodeColor");
        return this.fOpcodeRulerColumn;
    }

    protected void initializeRulerColumn(DisassemblyRulerColumn rulerColumn, String colorPrefKey) {
        ISharedTextColors sharedColors = this.getSharedColors();
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            RGB rgb = null;
            if (store.contains(colorPrefKey)) {
                rgb = store.isDefault(colorPrefKey) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)colorPrefKey) : PreferenceConverter.getColor((IPreferenceStore)store, (String)colorPrefKey);
            }
            if (rgb == null) {
                rgb = new RGB(0, 0, 0);
            }
            rulerColumn.setForeground(sharedColors.getColor(rgb));
            rgb = null;
            rulerColumn.redraw();
        }
    }

    private IPreferenceStore getPreferenceStore() {
        return this.fPreferenceStore;
    }

    protected CompositeRuler createCompositeRuler() {
        CompositeRuler ruler = new CompositeRuler();
        ruler.addDecorator(0, (IVerticalRulerColumn)new AnnotationRulerColumn(12, this.getAnnotationAccess()));
        return ruler;
    }

    private boolean isAddressRulerVisible() {
        return this.getPreferenceStore().getBoolean("showAddressRuler");
    }

    private void showAddressRuler() {
        IVerticalRuler v;
        if (this.fAddressRulerColumn == null && (v = this.getVerticalRuler()) instanceof CompositeRuler) {
            CompositeRuler c = (CompositeRuler)v;
            c.addDecorator(1, this.createAddressRulerColumn());
        }
    }

    private void hideAddressRuler() {
        if (this.fAddressRulerColumn != null) {
            IVerticalRuler v = this.getVerticalRuler();
            if (v instanceof CompositeRuler) {
                CompositeRuler c = (CompositeRuler)v;
                c.removeDecorator((IVerticalRulerColumn)this.fAddressRulerColumn);
            }
            this.fAddressRulerColumn = null;
        }
    }

    private boolean isOpcodeRulerVisible() {
        return this.fShowOpcodes;
    }

    private void showOpcodeRuler() {
        IVerticalRuler v;
        if (this.fOpcodeRulerColumn == null && (v = this.getVerticalRuler()) instanceof CompositeRuler) {
            CompositeRuler c = (CompositeRuler)v;
            c.addDecorator(2, this.createOpcodeRulerColumn());
        }
    }

    private void hideOpcodeRuler() {
        if (this.fOpcodeRulerColumn != null) {
            IVerticalRuler v = this.getVerticalRuler();
            if (v instanceof CompositeRuler) {
                CompositeRuler c = (CompositeRuler)v;
                c.removeDecorator((IVerticalRulerColumn)this.fOpcodeRulerColumn);
            }
            this.fOpcodeRulerColumn = null;
        }
    }

    protected IAnnotationAccess getAnnotationAccess() {
        if (this.fAnnotationAccess == null) {
            this.fAnnotationAccess = this.createAnnotationAccess();
        }
        return this.fAnnotationAccess;
    }

    protected IAnnotationAccess createAnnotationAccess() {
        return new DefaultMarkerAnnotationAccess();
    }

    private void hookContextMenu() {
        String id = "#DisassemblyPartContext";
        MenuManager menuMgr = new MenuManager(id, id);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DisassemblyPart.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.fViewer.getTextWidget());
        this.fViewer.getTextWidget().setMenu(menu);
        this.getSite().registerContextMenu(id, menuMgr, (ISelectionProvider)this.fViewer);
    }

    private void hookRulerContextMenu() {
        String id = "#DisassemblyPartRulerContext";
        MenuManager menuMgr = new MenuManager(id, id);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                DisassemblyPart.this.fillRulerContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fVerticalRuler.getControl());
        this.fVerticalRuler.getControl().setMenu(menu);
        this.getSite().registerContextMenu(id, menuMgr, (ISelectionProvider)this.fViewer);
    }

    private void contributeToActionBars() {
        IWorkbenchPartSite site = this.getSite();
        site.setSelectionProvider((ISelectionProvider)this.fViewer);
        IContextService ctxService = (IContextService)site.getService(IContextService.class);
        this.fContextActivation = ctxService.activateContext(KEY_BINDING_CONTEXT_DISASSEMBLY);
        this.contributeToActionBars(this.getActionBars());
    }

    protected abstract IActionBars getActionBars();

    protected void contributeToActionBars(IActionBars bars) {
        for (String key : this.fGlobalActions.keySet()) {
            IAction action = (IAction)this.fGlobalActions.get(key);
            bars.setGlobalActionHandler(key, action);
        }
        IMenuManager menu = bars.getMenuManager();
        IMenuManager navigateMenu = menu.findMenuUsingPath("navigate");
        if (navigateMenu != null) {
            navigateMenu.appendToGroup("additions", (IAction)this.fActionGotoPC);
            navigateMenu.appendToGroup("additions", (IAction)this.fActionGotoAddress);
            navigateMenu.appendToGroup("additions", (IAction)this.fActionGotoSymbol);
        }
        bars.updateActionBars();
    }

    protected void fillContextMenu(IMenuManager manager) {
        Point cursorLoc = this.getSite().getShell().getDisplay().getCursorLocation();
        this.fViewer.getTextWidget().toControl(cursorLoc);
        this.fActionToggleSource.update();
        this.fActionToggleSymbols.update();
        manager.add((IContributionItem)new GroupMarker("group.top"));
        manager.add((IContributionItem)new Separator("group.breakpoints"));
        manager.add((IContributionItem)new Separator("goTo"));
        manager.add((IAction)this.fActionGotoPC);
        manager.add((IAction)this.fActionGotoAddress);
        manager.add((IAction)this.fActionGotoSymbol);
        manager.add((IContributionItem)new Separator("group.debug"));
        manager.add((IContributionItem)new Separator("group.edit"));
        manager.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.COPY));
        manager.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.SELECT_ALL));
        manager.add((IContributionItem)new Separator("settings"));
        manager.add((IAction)this.fActionToggleSource);
        manager.add((IAction)this.fActionToggleSymbols);
        manager.add((IAction)this.fActionOpenPreferences);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fActionRefreshView);
        manager.add((IContributionItem)new Separator("additions"));
    }

    protected void fillRulerContextMenu(IMenuManager manager) {
        this.fActionToggleBreakpoint.update();
        this.fActionToggleBreakpointEnablement.update();
        this.fActionToggleAddressColumn.update();
        this.fActionToggleFunctionColumn.update();
        manager.add((IContributionItem)new GroupMarker("group.top"));
        manager.add((IContributionItem)new Separator("group.breakpoints"));
        manager.add((IAction)this.fActionToggleBreakpoint);
        manager.add((IAction)this.fActionToggleBreakpointEnablement);
        manager.add((IContributionItem)new GroupMarker("debug"));
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new GroupMarker("restore"));
        manager.add((IContributionItem)new Separator("add"));
        manager.add((IContributionItem)new Separator("rulers"));
        manager.add((IAction)this.fActionToggleAddressColumn);
        manager.add((IAction)this.fActionToggleFunctionColumn);
        manager.add((IContributionItem)new Separator("group.rest"));
        for (Object listener : this.fRulerContextMenuListeners.getListeners()) {
            ((IMenuListener)listener).menuAboutToShow(manager);
        }
        manager.add((IContributionItem)new Separator("group.edit"));
        manager.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.COPY));
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.fActionGotoPC);
        manager.add((IAction)this.fActionGotoAddress);
    }

    protected void updateSelectionDependentActions() {
        for (IUpdate iUpdate : this.fSelectionActions) {
            iUpdate.update();
        }
    }

    protected void updateStateDependentActions() {
        for (IUpdate iUpdate : this.fStateDependentActions) {
            iUpdate.update();
        }
    }

    protected void createActions() {
        TextOperationAction action = new TextOperationAction((ITextViewer)this.fViewer, 4);
        action.setText(DisassemblyMessages.Disassembly_action_Copy_label);
        action.setImageDescriptor(DisassemblyImageRegistry.getImageDescriptor(DisassemblyImageRegistry.ICON_Copy_enabled));
        action.setDisabledImageDescriptor(DisassemblyImageRegistry.getImageDescriptor(DisassemblyImageRegistry.ICON_Copy_disabled));
        action.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.fGlobalActions.put(ITextEditorActionConstants.COPY, action);
        this.fSelectionActions.add(action);
        action = new TextOperationAction((ITextViewer)this.fViewer, 7);
        action.setText(DisassemblyMessages.Disassembly_action_SelectAll_label);
        action.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
        this.fGlobalActions.put(ITextEditorActionConstants.SELECT_ALL, action);
        action = new TextOperationAction((ITextViewer)this.fViewer, 10);
        action.setActionDefinitionId("org.eclipse.ui.file.print");
        this.fGlobalActions.put(ITextEditorActionConstants.PRINT, action);
        this.fActionGotoPC = new ActionGotoProgramCounter(this);
        this.fActionGotoPC.setActionDefinitionId(COMMAND_ID_GOTO_PC);
        this.fStateDependentActions.add(this.fActionGotoPC);
        this.registerWithHandlerService((IAction)this.fActionGotoPC);
        this.fActionGotoAddress = new ActionGotoAddress(this);
        this.fActionGotoAddress.setActionDefinitionId(COMMAND_ID_GOTO_ADDRESS);
        this.fStateDependentActions.add(this.fActionGotoAddress);
        this.registerWithHandlerService((IAction)this.fActionGotoAddress);
        this.fActionGotoSymbol = new ActionGotoSymbol(this);
        this.fActionGotoSymbol.setActionDefinitionId(COMMAND_ID_GOTO_SYMBOL);
        this.fStateDependentActions.add(this.fActionGotoSymbol);
        this.registerWithHandlerService((IAction)this.fActionGotoSymbol);
        this.fActionToggleSource = new ActionToggleSource();
        this.fStateDependentActions.add(this.fActionToggleSource);
        this.fActionToggleBreakpoint = new ActionToggleBreakpoint();
        this.fVerticalRuler.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                DisassemblyPart.this.fActionToggleBreakpoint.update();
                if (DisassemblyPart.this.fActionToggleBreakpoint.isEnabled()) {
                    DisassemblyPart.this.fActionToggleBreakpoint.run();
                }
            }
        });
        this.fActionToggleBreakpointEnablement = new ActionToggleBreakpointEnablement();
        this.fActionToggleAddressColumn = new ActionToggleAddressColumn();
        this.fActionToggleFunctionColumn = new ActionToggleFunctionColumn();
        this.fActionToggleSymbols = new ActionToggleSymbols();
        this.fActionRefreshView = new ActionRefreshView();
        this.fStateDependentActions.add(this.fActionRefreshView);
        this.fGlobalActions.put(ActionFactory.REFRESH.getId(), this.fActionRefreshView);
        this.fActionOpenPreferences = new ActionOpenPreferences(this.getSite().getShell());
    }

    private void registerWithHandlerService(IAction action) {
        if (this.fHandlerActivations == null) {
            this.fHandlerActivations = new ArrayList(5);
        }
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.fHandlerActivations.add(handlerService.activateHandler(action.getActionDefinitionId(), (IHandler)new ActionHandler(action)));
    }

    private void gotoFrame(IStack.IFrameDMContext frame) {
        if (this.fActive) {
            this.gotoFrame(frame.getLevel(), PC_UNKNOWN);
        }
    }

    private void gotoFrame(int frame) {
        if (this.fActive) {
            this.gotoFrame(frame, PC_UNKNOWN);
        }
    }

    @Override
    public final void gotoProgramCounter() {
        if (this.fPCAddress != PC_RUNNING) {
            this.updatePC(this.fPCAddress);
        }
    }

    @Override
    public final void gotoAddress(BigInteger address) {
        this.fFocusAddress = address;
        if (this.fDebugSessionId == null) {
            return;
        }
        if (DEBUG) {
            System.out.println("gotoAddress " + DisassemblyPart.getAddressText(address));
        }
        if (this.fGotoAddressPending == PC_UNKNOWN) {
            this.fGotoAddressPending = address;
        }
        if (this.fUpdatePending) {
            return;
        }
        AddressRangePosition pos = this.getPositionOfAddress(address);
        if (pos != null) {
            if (pos.fValid) {
                Object previousPos = null;
                if (previousPos == null || previousPos.fValid) {
                    if (this.fGotoAddressPending.equals(address)) {
                        this.fGotoAddressPending = PC_UNKNOWN;
                    }
                    this.gotoPosition(pos, false);
                } else {
                    int lines = this.fBufferZone + 3;
                    BigInteger endAddress = pos.fAddressOffset;
                    BigInteger startAddress = previousPos.fAddressOffset.max(endAddress.subtract(BigInteger.valueOf(lines * this.fDocument.getMeanSizeOfInstructions())));
                    this.retrieveDisassembly(startAddress, endAddress, lines);
                }
            } else {
                int lines = this.fBufferZone + 3;
                BigInteger endAddress = pos.fAddressOffset.add(pos.fAddressLength).min(address.add(BigInteger.valueOf(lines * this.fDocument.getMeanSizeOfInstructions())));
                this.retrieveDisassembly(address, endAddress, lines);
            }
        }
    }

    @Override
    public final void gotoSymbol(String symbol) {
        if (!this.fActive || !this.isSuspended() || this.fTargetFrameContext == null) {
            return;
        }
        final IExpressions expressions = this.getService(IExpressions.class);
        if (expressions == null) {
            return;
        }
        IExpressions.IExpressionDMContext exprDmc = expressions.createExpression((IDMContext)this.fTargetContext, '&' + symbol);
        final IFormattedValues.FormattedValueDMContext valueDmc = expressions.getFormattedValueContext((IFormattedValues.IFormattedDataDMContext)exprDmc, "HEX.Format");
        final DsfExecutor executor = this.getSession().getExecutor();
        executor.submit(new Runnable(){

            public void run() {
                expressions.getFormattedExpressionValue(valueDmc, (DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)executor, null){

                    protected void handleSuccess() {
                        IFormattedValues.FormattedValueDMData data = (IFormattedValues.FormattedValueDMData)this.getData();
                        String value = data.getFormattedValue();
                        final BigInteger address = DisassemblyPart.decodeAddress(value);
                        if (address != null) {
                            DisassemblyPart.this.asyncExec(new Runnable(){

                                public void run() {
                                    DisassemblyPart.this.gotoAddress(address);
                                }
                            });
                        }
                    }

                    protected void handleError() {
                        DisassemblyPart.this.asyncExec(new Runnable(){

                            public void run() {
                                ErrorDialog.openError((Shell)DisassemblyPart.this.getSite().getShell(), (String)"Error", null, (IStatus)this.getStatus());
                            }
                        });
                    }
                });
            }
        });
    }

    private void gotoPosition(Position pos, boolean select) {
        if (this.fViewer == null) {
            return;
        }
        this.setFocusPosition(pos);
        this.fViewer.setSelectedRange(pos.offset, select ? Math.max(pos.length - 1, 0) : 0);
        int revealOffset = pos.offset;
        boolean onTop = false;
        if (pos.offset > 0) {
            try {
                AddressRangePosition previousPos = this.fDocument.getModelPosition(pos.offset - 1);
                if (previousPos instanceof LabelPosition) {
                    revealOffset = previousPos.offset;
                    onTop = true;
                } else if (!previousPos.fValid) {
                    onTop = true;
                }
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
        this.fViewer.revealOffset(revealOffset, onTop);
    }

    private void gotoMarker(IMarker marker) {
        if (marker == null) {
            return;
        }
        if (this.fDebugSessionId == null || this.fUpdatePending) {
            this.fGotoMarkerPending = marker;
            return;
        }
        this.fGotoMarkerPending = null;
    }

    public void viewportChanged(int verticalOffset) {
        if (this.fDebugSessionId != null && this.fGotoAddressPending == PC_UNKNOWN && this.fScrollPos == null && !this.fUpdatePending && !this.fRefreshViewPending) {
            this.fUpdatePending = true;
            this.invokeLater(new Runnable(){

                public void run() {
                    assert (DisassemblyPart.this.fUpdatePending);
                    if (DisassemblyPart.this.fUpdatePending) {
                        DisassemblyPart.this.fUpdatePending = false;
                        DisassemblyPart.this.updateVisibleArea();
                    }
                }
            });
        }
    }

    private void updateVisibleArea() {
        boolean isScrollingUp;
        if (!this.fActive || this.fUpdatePending || this.fViewer == null || this.fDebugSessionId == null) {
            return;
        }
        if (this.fTargetContext == null || !this.isSuspended(this.fTargetContext) || this.fFrameAddress == PC_UNKNOWN) {
            return;
        }
        StyledText styledText = this.fViewer.getTextWidget();
        Rectangle clientArea = styledText.getClientArea();
        this.fBufferZone = Math.max(8, clientArea.height / styledText.getLineHeight());
        int topIndex = this.fViewer.getTopIndex();
        int bottomIndex = this.fViewer.getBottomIndex();
        int focusIndex = -1;
        boolean focusVisible = false;
        boolean bl = isScrollingUp = this.fViewer.isUserTriggeredScrolling() && this.fViewer.getLastTopPixel() >= styledText.getTopPixel();
        if (this.fFocusPos != null) {
            try {
                int focusOffset = this.fFocusPos.offset;
                focusIndex = this.fDocument.getLineOfOffset(focusOffset);
                boolean bl2 = focusVisible = focusIndex >= topIndex && focusIndex <= bottomIndex;
                if (!focusVisible) {
                    Point selection = this.fViewer.getSelectedRange();
                    if (selection.x == focusOffset && selection.y > 0) {
                        this.fViewer.setSelectedRange(selection.x, 0);
                    }
                }
            }
            catch (BadLocationException e) {
                this.setFocusPosition(null);
            }
        }
        if (!focusVisible) {
            focusIndex = topIndex + this.fScrollLine;
        }
        BigInteger focusAddress = this.getAddressOfLine(focusIndex);
        bottomIndex += 2;
        AddressRangePosition bestPosition = null;
        int bestLine = -1;
        BigInteger bestDistance = null;
        for (AddressRangePosition p : this.fDocument.getInvalidAddressRanges()) {
            try {
                int line = this.fDocument.getLineOfOffset(p.offset);
                if (line < topIndex || line > bottomIndex || !(p instanceof DisassemblyPosition) && p.fAddressLength.compareTo(BigInteger.valueOf(this.fBufferZone * 2)) > 0 && !isScrollingUp && !this.fUpdateBeforeFocus && p.fAddressOffset.compareTo(focusAddress) < 0) continue;
                BigInteger distance = p.fAddressOffset.subtract(focusAddress).abs();
                if (bestDistance != null && distance.compareTo(bestDistance) >= 0) continue;
                bestPosition = p;
                bestLine = line;
                bestDistance = distance;
                if (bestDistance.compareTo(BigInteger.valueOf(this.fBufferZone * 2)) > 0) continue;
                break;
            }
            catch (BadLocationException e) {
            }
        }
        if (bestPosition != null) {
            int lines = this.fBufferZone + 3;
            BigInteger startAddress = bestPosition.fAddressOffset;
            BigInteger endAddress = bestPosition.fAddressOffset.add(bestPosition.fAddressLength);
            BigInteger addressRange = BigInteger.valueOf(lines * this.fDocument.getMeanSizeOfInstructions());
            if (bestLine > focusIndex || bestLine == focusIndex && startAddress.compareTo(focusAddress) >= 0) {
                if (endAddress.subtract(startAddress).compareTo(addressRange) < 0) {
                    Iterator<AddressRangePosition> iter = this.fDocument.getModelPositionIterator(endAddress);
                    while (iter.hasNext()) {
                        AddressRangePosition p = iter.next();
                        if (p.fValid && (endAddress = endAddress.add(p.fAddressLength)).subtract(startAddress).compareTo(addressRange) < 0) continue;
                        break;
                    }
                }
            } else {
                startAddress = startAddress.max(endAddress.subtract(addressRange));
                lines = endAddress.subtract(startAddress).intValue();
            }
            this.retrieveDisassembly(startAddress, endAddress, lines);
        }
        this.scheduleDoPending();
    }

    private void asyncExec(Runnable runnable) {
        if (this.fViewer != null) {
            this.fViewer.getControl().getDisplay().asyncExec(runnable);
        }
    }

    private void invokeLater(Runnable runnable) {
        this.invokeLater(10, runnable);
    }

    private void invokeLater(int delay, Runnable runnable) {
        if (this.fViewer != null) {
            this.fViewer.getControl().getDisplay().timerExec(delay, runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateInvalidSource() {
        if (this.fViewer == null) {
            return;
        }
        boolean unlock = false;
        try {
            if (this.fScrollPos == null) {
                if (this.fUpdatePending) {
                    this.fUpdateSourcePending = true;
                    return;
                }
                this.fUpdateSourcePending = false;
                unlock = true;
                this.fUpdatePending = true;
                this.lockScroller();
            }
            ArrayList<SourcePosition> copy = new ArrayList<SourcePosition>(this.fDocument.getInvalidSource());
            for (SourcePosition p : copy) {
                if (!p.fValid) {
                    this.insertSource(p);
                    continue;
                }
                if (!DEBUG || !this.fDocument.getInvalidSource().remove((Object)p)) continue;
                System.err.println("!!! valid source position in invalid source list at " + DisassemblyPart.getAddressText(p.fAddressOffset));
            }
        }
        finally {
            if (unlock) {
                this.fUpdatePending = false;
                this.unlockScroller();
                this.doPending();
            }
        }
    }

    void retrieveDisassembly(final String file, final int lines, final boolean mixed) {
        if (this.fDebugSessionId == null) {
            return;
        }
        if (this.fUpdatePending) {
            this.invokeLater(new Runnable(){

                public void run() {
                    DisassemblyPart.this.retrieveDisassembly(file, lines, mixed);
                }
            });
            return;
        }
        if (DEBUG) {
            System.out.println("retrieveDisassembly " + file);
        }
        String debuggerPath = file;
        final ISourceLookup lookup = this.getService(ISourceLookup.class);
        final ISourceLookup.ISourceLookupDMContext ctx = (ISourceLookup.ISourceLookupDMContext)DMContexts.getAncestorOfType((IDMContext)this.fTargetContext, ISourceLookup.ISourceLookupDMContext.class);
        final DsfExecutor executor = this.getSession().getExecutor();
        Query<String> query = new Query<String>(){

            protected void execute(final DataRequestMonitor<String> rm) {
                DataRequestMonitor<String> request = new DataRequestMonitor<String>((Executor)executor, rm){

                    protected void handleSuccess() {
                        rm.setData(this.getData());
                        rm.done();
                    }
                };
                lookup.getDebuggerPath(ctx, (Object)file, (DataRequestMonitor)request);
            }
        };
        try {
            this.getSession().getExecutor().execute((Runnable)query);
            debuggerPath = (String)query.get();
        }
        catch (InterruptedException exc) {
            DisassemblyPart.internalError(exc);
        }
        catch (ExecutionException exc) {
            DisassemblyPart.internalError(exc);
        }
        final IDisassembly disassembly = (IDisassembly)this.fServicesTracker.getService(IDisassembly.class);
        final IDisassembly.IDisassemblyDMContext context = (IDisassembly.IDisassemblyDMContext)DMContexts.getAncestorOfType((IDMContext)this.fTargetContext, IDisassembly.IDisassemblyDMContext.class);
        final String finalFile = debuggerPath;
        DataRequestMonitor<IMixedInstruction[]> disassemblyRequest = new DataRequestMonitor<IMixedInstruction[]>((Executor)executor, null){

            public void handleCompleted() {
                final IMixedInstruction[] data = (IMixedInstruction[])this.getData();
                if (!this.isCanceled() && data != null) {
                    DisassemblyPart.this.asyncExec(new Runnable(){

                        public void run() {
                            if (!DisassemblyPart.this.insertDisassembly(null, data)) {
                                DisassemblyPart.this.retrieveDisassembly(file, lines, false);
                            }
                        }
                    });
                } else {
                    IStatus status = this.getStatus();
                    if (status != null && !status.isOK()) {
                        DisassemblyPart.this.asyncExec(new Runnable(){

                            public void run() {
                                ErrorDialog.openError((Shell)DisassemblyPart.this.getSite().getShell(), (String)"Error", null, (IStatus)this.getStatus());
                            }
                        });
                    }
                    DisassemblyPart.this.fUpdatePending = false;
                }
            }
        };
        assert (!this.fUpdatePending);
        this.fUpdatePending = true;
        executor.submit(new Runnable((DataRequestMonitor)disassemblyRequest){
            final /* synthetic */ DataRequestMonitor val$disassemblyRequest;
            {
                this.val$disassemblyRequest = dataRequestMonitor;
            }

            public void run() {
                disassembly.getMixedInstructions(context, finalFile, 1, lines, this.val$disassemblyRequest);
            }
        });
    }

    private void retrieveDisassembly(BigInteger startAddress, BigInteger endAddress, int lines) {
        if (this.fDebugSessionId == null) {
            return;
        }
        if (DEBUG) {
            System.out.println("retrieveDisassembly " + DisassemblyPart.getAddressText(startAddress) + " " + lines + " lines");
        }
        this.retrieveDisassembly(startAddress, endAddress, lines, true);
    }

    private void retrieveDisassembly(final BigInteger startAddress, BigInteger endAddress, final int linesHint, boolean mixed) {
        assert (!this.fUpdatePending);
        this.fUpdatePending = true;
        final int lines = linesHint + 2;
        BigInteger addressLength = BigInteger.valueOf(lines * 4);
        if (endAddress.subtract(startAddress).compareTo(addressLength) > 0) {
            endAddress = startAddress.add(addressLength);
        }
        boolean insideActiveFrame = startAddress.equals(this.fFrameAddress);
        String file = null;
        int lineNumber = -1;
        if (insideActiveFrame && this.fTargetFrameData != null) {
            file = this.fTargetFrameData.getFile();
            if (file != null && file.trim().length() == 0) {
                file = null;
            }
            lineNumber = this.fTargetFrameData.getLine();
        }
        final String finalFile = file;
        final int finalLineNumber = lineNumber;
        final BigInteger finalEndAddress = endAddress;
        DsfExecutor executor = this.getSession().getExecutor();
        final IDisassembly disassembly = (IDisassembly)this.fServicesTracker.getService(IDisassembly.class);
        final IDisassembly.IDisassemblyDMContext context = (IDisassembly.IDisassemblyDMContext)DMContexts.getAncestorOfType((IDMContext)this.fTargetContext, IDisassembly.IDisassemblyDMContext.class);
        if (mixed) {
            DataRequestMonitor<IMixedInstruction[]> disassemblyRequest = new DataRequestMonitor<IMixedInstruction[]>((Executor)executor, null){

                public void handleCompleted() {
                    final IMixedInstruction[] data = (IMixedInstruction[])this.getData();
                    if (!this.isCanceled() && data != null) {
                        DisassemblyPart.this.asyncExec(new Runnable(){

                            public void run() {
                                if (!DisassemblyPart.this.insertDisassembly(startAddress, data)) {
                                    DisassemblyPart.this.retrieveDisassembly(startAddress, finalEndAddress, linesHint, false);
                                }
                            }
                        });
                    } else {
                        final IStatus status = this.getStatus();
                        if (status != null && !status.isOK()) {
                            DisassemblyPart.this.asyncExec(new Runnable(){

                                public void run() {
                                    DisassemblyPart.this.doScrollLocked(new Runnable(){

                                        public void run() {
                                            DisassemblyPart.this.insertError(startAddress, status.getMessage());
                                        }
                                    });
                                }
                            });
                        }
                        DisassemblyPart.this.fUpdatePending = false;
                    }
                }
            };
            if (file != null) {
                executor.submit(new Runnable((DataRequestMonitor)disassemblyRequest){
                    final /* synthetic */ DataRequestMonitor val$disassemblyRequest;
                    {
                        this.val$disassemblyRequest = dataRequestMonitor;
                    }

                    public void run() {
                        disassembly.getMixedInstructions(context, finalFile, finalLineNumber, lines * 2, this.val$disassemblyRequest);
                    }
                });
            } else {
                executor.submit(new Runnable((DataRequestMonitor)disassemblyRequest){
                    final /* synthetic */ DataRequestMonitor val$disassemblyRequest;
                    {
                        this.val$disassemblyRequest = dataRequestMonitor;
                    }

                    public void run() {
                        disassembly.getMixedInstructions(context, startAddress, finalEndAddress, this.val$disassemblyRequest);
                    }
                });
            }
        } else {
            DataRequestMonitor<IInstruction[]> disassemblyRequest = new DataRequestMonitor<IInstruction[]>((Executor)executor, null){

                public void handleCompleted() {
                    if (!this.isCanceled() && this.getData() != null) {
                        DisassemblyPart.this.asyncExec(new Runnable(){

                            public void run() {
                                DisassemblyPart.this.insertDisassembly(startAddress, (IInstruction[])this.getData());
                            }
                        });
                    } else {
                        final IStatus status = this.getStatus();
                        if (status != null && !status.isOK()) {
                            DisassemblyPart.this.asyncExec(new Runnable(){

                                public void run() {
                                    DisassemblyPart.this.doScrollLocked(new Runnable(){

                                        public void run() {
                                            DisassemblyPart.this.insertError(startAddress, status.getMessage());
                                        }
                                    });
                                }
                            });
                        }
                        DisassemblyPart.this.fUpdatePending = false;
                    }
                }
            };
            if (file != null) {
                executor.submit(new Runnable((DataRequestMonitor)disassemblyRequest){
                    final /* synthetic */ DataRequestMonitor val$disassemblyRequest;
                    {
                        this.val$disassemblyRequest = dataRequestMonitor;
                    }

                    public void run() {
                        disassembly.getInstructions(context, finalFile, finalLineNumber, lines, this.val$disassemblyRequest);
                    }
                });
            } else {
                executor.submit(new Runnable((DataRequestMonitor)disassemblyRequest){
                    final /* synthetic */ DataRequestMonitor val$disassemblyRequest;
                    {
                        this.val$disassemblyRequest = dataRequestMonitor;
                    }

                    public void run() {
                        disassembly.getInstructions(context, startAddress, finalEndAddress, this.val$disassemblyRequest);
                    }
                });
            }
        }
    }

    private void insertError(BigInteger address, String message) {
        AddressRangePosition p = null;
        p = this.getPositionOfAddress(address);
        if (p.fValid) {
            return;
        }
        try {
            this.fDocument.insertErrorLine(p, address, BigInteger.ONE, message);
        }
        catch (BadLocationException exc) {
            DisassemblyPart.internalError(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertDisassembly(BigInteger startAddress, IInstruction[] instructions) {
        if (this.fViewer == null || this.fDebugSessionId == null) {
            return;
        }
        if (DEBUG) {
            System.out.println("insertDisassembly " + DisassemblyPart.getAddressText(startAddress));
        }
        assert (this.fUpdatePending);
        if (!this.fUpdatePending) {
            return;
        }
        try {
            this.lockScroller();
            AddressRangePosition p = null;
            for (int j = 0; j < instructions.length; ++j) {
                IInstruction instruction = instructions[j];
                BigInteger address = instruction.getAdress();
                if (startAddress == null || startAddress.compareTo(BigInteger.ZERO) < 0) {
                    this.fGotoAddressPending = startAddress = address;
                }
                if (p == null || !p.containsAddress(address)) {
                    p = this.getPositionOfAddress(address);
                }
                if (p instanceof ErrorPosition && p.fValid) {
                    p.fValid = false;
                    this.fDocument.getInvalidAddressRanges().add(p);
                } else if (p == null || p.fValid) {
                    if (DEBUG) {
                        System.out.println("Excess disassembly lines at " + DisassemblyPart.getAddressText(address));
                    }
                    return;
                }
                boolean hasSource = false;
                String compilationPath = null;
                String functionName = instruction.getFuntionName();
                if (functionName != null && functionName.length() > 0 && instruction.getOffset() == 0L) {
                    p = this.fDocument.insertLabel(p, address, functionName, this.fShowSymbols && (!hasSource || this.fShowDisassembly));
                }
                BigInteger instrLength = null;
                if (j < instructions.length - 1) {
                    instrLength = instructions[j + 1].getAdress().subtract(instruction.getAdress()).abs();
                } else if (instructions.length == 1 && p.fAddressLength.compareTo(BigInteger.valueOf(8L)) <= 0) {
                    instrLength = p.fAddressLength;
                }
                if (instrLength == null) {
                } else {
                    String opCode = functionName != null && functionName.length() > 0 ? functionName + '+' + instruction.getOffset() : "";
                    if ((p = this.fDocument.insertDisassemblyLine(p, address, instrLength.intValue(), opCode, instruction.getInstruction(), compilationPath, -1)) != null) continue;
                }
                break;
            }
        }
        catch (BadLocationException e) {
            DisassemblyPart.internalError(e);
        }
        finally {
            this.fUpdatePending = false;
            this.updateInvalidSource();
            this.unlockScroller();
            this.doPending();
            this.updateVisibleArea();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insertDisassembly(BigInteger startAddress, IMixedInstruction[] mixedInstructions) {
        if (this.fViewer == null || this.fDebugSessionId == null) {
            return true;
        }
        if (DEBUG) {
            System.out.println("insertDisassembly " + DisassemblyPart.getAddressText(startAddress));
        }
        assert (this.fUpdatePending);
        if (!this.fUpdatePending) {
            return true;
        }
        boolean success = false;
        try {
            this.lockScroller();
            AddressRangePosition p = null;
            block7: for (int i = 0; i < mixedInstructions.length; ++i) {
                IMixedInstruction mixedInstruction = mixedInstructions[i];
                String file = mixedInstruction.getFileName();
                int lineNumber = mixedInstruction.getLineNumber() - 1;
                IInstruction[] instructions = mixedInstruction.getInstructions();
                for (int j = 0; j < instructions.length; ++j) {
                    String functionName;
                    IInstruction instruction = instructions[j];
                    BigInteger address = instruction.getAdress();
                    if (startAddress == null || startAddress.compareTo(BigInteger.ZERO) < 0) {
                        this.fGotoAddressPending = startAddress = address;
                    }
                    if (p == null || !p.containsAddress(address)) {
                        p = this.getPositionOfAddress(address);
                    }
                    if (p instanceof ErrorPosition && p.fValid) {
                        p.fValid = false;
                        this.fDocument.getInvalidAddressRanges().add(p);
                    } else {
                        boolean bl;
                        if (p == null) {
                            if (DEBUG) {
                                System.out.println("Excess disassembly lines at " + DisassemblyPart.getAddressText(address));
                            }
                            bl = success;
                            return bl;
                        }
                        if (p.fValid) {
                            if (DEBUG) {
                                System.out.println("Excess disassembly lines at " + DisassemblyPart.getAddressText(address));
                            }
                            if (file != null && lineNumber >= 0 || p.fAddressLength == BigInteger.ONE) {
                                p.fValid = false;
                                this.fDocument.getInvalidAddressRanges().add(p);
                            } else {
                                bl = success;
                                return bl;
                            }
                        }
                    }
                    boolean hasSource = false;
                    if (file != null && lineNumber >= 0) {
                        p = this.insertSource(p, address, file, lineNumber);
                        boolean bl = hasSource = this.fFile2Storage.get(file) != null;
                    }
                    if ((functionName = instruction.getFuntionName()) != null && functionName.length() > 0 && instruction.getOffset() == 0L) {
                        p = this.fDocument.insertLabel(p, address, functionName, this.fShowSymbols && (!hasSource || this.fShowDisassembly));
                    }
                    BigInteger instrLength = null;
                    if (j < instructions.length - 1) {
                        instrLength = instructions[j + 1].getAdress().subtract(instruction.getAdress()).abs();
                    } else if (i < mixedInstructions.length - 1) {
                        int nextSrcLineIdx;
                        for (nextSrcLineIdx = i + 1; nextSrcLineIdx < mixedInstructions.length; ++nextSrcLineIdx) {
                            IInstruction[] nextInstrs = mixedInstructions[nextSrcLineIdx].getInstructions();
                            if (nextInstrs.length <= 0) continue;
                            instrLength = nextInstrs[0].getAdress().subtract(instruction.getAdress()).abs();
                            break;
                        }
                        if (nextSrcLineIdx >= mixedInstructions.length) {
                            continue block7;
                        }
                    } else if (instructions.length == 1 && p.fAddressLength.compareTo(BigInteger.valueOf(8L)) <= 0) {
                        instrLength = p.fAddressLength;
                    }
                    if (instrLength == null) continue block7;
                    String opCode = functionName != null && functionName.length() > 0 ? functionName + '+' + instruction.getOffset() : "";
                    success = success || address.compareTo(startAddress) == 0;
                    if ((p = this.fDocument.insertDisassemblyLine(p, address, instrLength.intValue(), opCode, instruction.getInstruction(), file, lineNumber)) == null && success) continue block7;
                }
            }
        }
        catch (BadLocationException e) {
            DisassemblyPart.internalError(e);
        }
        finally {
            this.fUpdatePending = false;
            if (success) {
                this.updateInvalidSource();
                this.unlockScroller();
                this.doPending();
                this.updateVisibleArea();
            } else {
                this.unlockScroller();
            }
        }
        return success;
    }

    private void retrieveFrameAddress(final IRunControl.IExecutionDMContext targetContext, final int frame) {
        if (targetContext != null && this.isSuspended(targetContext)) {
            if (this.fUpdatePending) {
                this.gotoFrame(frame);
                return;
            }
            if (DEBUG) {
                System.out.println("retrieveFrameAddress " + frame);
            }
            this.fUpdatePending = true;
            final IStack stack = (IStack)this.fServicesTracker.getService(IStack.class);
            DsfExecutor executor = this.getSession().getExecutor();
            if (this.fTargetFrameContext == null) {
                if (frame == 0) {
                    DataRequestMonitor<IStack.IFrameDMContext> request = new DataRequestMonitor<IStack.IFrameDMContext>((Executor)executor, null){

                        protected void handleCompleted() {
                            DisassemblyPart.this.fUpdatePending = false;
                            DisassemblyPart.this.fTargetFrameContext = (IStack.IFrameDMContext)this.getData();
                            if (DisassemblyPart.this.fTargetFrameContext != null) {
                                DisassemblyPart.this.retrieveFrameAddress(targetContext, frame);
                            }
                        }
                    };
                    executor.submit(new Runnable((DataRequestMonitor)request){
                        final /* synthetic */ DataRequestMonitor val$request;
                        {
                            this.val$request = dataRequestMonitor;
                        }

                        public void run() {
                            stack.getTopFrame((IDMContext)targetContext, this.val$request);
                        }
                    });
                }
                return;
            }
            DataRequestMonitor<IStack.IFrameDMData> request = new DataRequestMonitor<IStack.IFrameDMData>((Executor)executor, null){

                protected void handleCompleted() {
                    if (!this.isCanceled()) {
                        IStack.IFrameDMData frameData;
                        DisassemblyPart.this.fUpdatePending = false;
                        DisassemblyPart.this.fTargetFrameData = frameData = (IStack.IFrameDMData)this.getData();
                        final IAddress address = frameData.getAddress();
                        final BigInteger addressValue = address.getValue();
                        if (DEBUG) {
                            System.out.println("retrieveFrameAddress done " + DisassemblyPart.getAddressText(addressValue));
                        }
                        DisassemblyPart.this.asyncExec(new Runnable(){

                            public void run() {
                                if (address.getSize() * 4 > DisassemblyPart.this.fAddressSize) {
                                    DisassemblyPart.this.addressSizeChanged(address.getSize() * 4);
                                }
                                if (frame == 0) {
                                    DisassemblyPart.this.updatePC(addressValue);
                                } else {
                                    DisassemblyPart.this.gotoFrame(frame, addressValue);
                                }
                            }
                        });
                    }
                }
            };
            executor.submit(new Runnable((DataRequestMonitor)request){
                final /* synthetic */ DataRequestMonitor val$request;
                {
                    this.val$request = dataRequestMonitor;
                }

                public void run() {
                    stack.getFrameData(DisassemblyPart.this.fTargetFrameContext, this.val$request);
                }
            });
        }
    }

    private void addressSizeChanged(int addressSize) {
        BigInteger oldEndAddress = this.fEndAddress;
        this.fEndAddress = BigInteger.ONE.shiftLeft(addressSize);
        int oldAddressSize = this.fAddressSize;
        this.fAddressSize = addressSize;
        if (addressSize < oldAddressSize) {
            this.fDocument.deleteDisassemblyRange(this.fEndAddress, oldEndAddress, true, true);
            List<AddressRangePosition> positions = this.fDocument.getInvalidAddressRanges();
            ArrayList<AddressRangePosition> toRemove = new ArrayList<AddressRangePosition>();
            for (AddressRangePosition position : positions) {
                if (position.fAddressOffset.compareTo(this.fEndAddress) >= 0) {
                    try {
                        this.fDocument.replace(position, position.length, "");
                        this.fDocument.removeModelPosition(position);
                        toRemove.add(position);
                    }
                    catch (BadLocationException exc) {
                        DisassemblyPart.internalError(exc);
                    }
                    continue;
                }
                if (!position.containsAddress(this.fEndAddress)) continue;
                position.fAddressLength = this.fEndAddress.subtract(position.fAddressOffset);
            }
            positions.removeAll(toRemove);
        } else if (addressSize > oldAddressSize) {
            this.fDocument.insertInvalidAddressRange(this.fDocument.getLength(), 0, oldEndAddress, this.fEndAddress);
        } else {
            return;
        }
        if (this.fAddressRulerColumn != null) {
            this.fAddressRulerColumn.setAddressSize(addressSize);
            if (this.fComposite != null) {
                this.fComposite.layout(true);
            }
        }
    }

    private AddressRangePosition getPositionOfAddress(BigInteger address) {
        if (address == null || address.compareTo(BigInteger.ZERO) < 0) {
            return null;
        }
        AddressRangePosition pos = this.fDocument.getPositionOfAddress(address);
        assert (!(pos instanceof SourcePosition));
        assert (pos != null || address.compareTo(this.fStartAddress) < 0 || address.compareTo(this.fEndAddress) >= 0);
        return pos;
    }

    private BigInteger getAddressOfLine(int line) {
        return this.fDocument.getAddressOfLine(line);
    }

    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }

    protected void setActive(boolean active) {
        if (DEBUG) {
            System.out.println("setActive(" + active + ")");
        }
        this.fActive = active;
        if (this.fActive) {
            if (this.fRefreshAll) {
                this.fRefreshAll = false;
                this.refreshView(0);
            } else {
                this.doPendingPCUpdates();
                if (this.fTargetContext != null) {
                    int frame = this.getActiveStackFrame();
                    if (frame < 0 && this.isSuspended(this.fTargetContext)) {
                        frame = 0;
                    }
                    if (frame != this.fTargetFrame) {
                        this.gotoFrame(frame);
                    }
                }
            }
        } else {
            this.fGotoAddressPending = this.fFocusAddress = PC_UNKNOWN;
        }
        this.firePropertyChange(1285);
    }

    private int getActiveStackFrame() {
        if (this.fTargetFrameContext != null) {
            return this.fTargetFrameContext.getLevel();
        }
        return -1;
    }

    protected void updateDebugContext() {
        IAdaptable debugContext = DebugUITools.getDebugContext();
        if (debugContext instanceof IDMVMContext) {
            this.setDebugContext((IDMVMContext)debugContext);
        }
    }

    protected void setDebugContext(IDMVMContext vmContext) {
        if (vmContext != null) {
            IDMContext dmContext = vmContext.getDMContext();
            String sessionId = dmContext.getSessionId();
            if (!sessionId.equals(this.fDebugSessionId)) {
                IStack.IFrameDMContext frame;
                IRunControl.IExecutionDMContext executionContext;
                if (DEBUG) {
                    System.out.println("DisassemblyPart.setDebugContext() " + sessionId);
                }
                this.fTargetContext = null;
                if (dmContext instanceof IStack.IFrameDMContext && (executionContext = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)(frame = (IStack.IFrameDMContext)dmContext), IRunControl.IExecutionDMContext.class)) != null) {
                    this.fTargetContext = executionContext;
                    this.fTargetFrameContext = frame;
                    this.fTargetFrame = frame.getLevel();
                }
                if (this.fTargetContext != null) {
                    this.fDebugSessionId = sessionId;
                    if (this.fServicesTracker != null) {
                        this.fServicesTracker.dispose();
                    }
                    this.fServicesTracker = new DsfServicesTracker(DsfDebugUIPlugin.getBundleContext(), sessionId);
                    if (this.fViewer != null) {
                        this.debugContextChanged();
                    }
                }
            } else if (dmContext instanceof IStack.IFrameDMContext) {
                IDMContext[] parents;
                IStack.IFrameDMContext frame = (IStack.IFrameDMContext)dmContext;
                for (IDMContext context : parents = frame.getParents()) {
                    if (!(context instanceof IRunControl.IExecutionDMContext)) continue;
                    this.fTargetContext = (IRunControl.IExecutionDMContext)context;
                    this.fTargetFrameContext = frame;
                    this.gotoFrame(frame);
                    break;
                }
            }
        } else if (this.fDebugSessionId != null) {
            if (this.getSession() != null) {
                this.getSession().removeServiceEventListener((Object)this);
            }
            this.fDebugSessionId = null;
            this.fTargetContext = null;
            if (this.fViewer != null) {
                this.debugContextChanged();
            }
        }
    }

    private void debugContextChanged() {
        if (DEBUG) {
            System.out.println("DisassemblyPart.debugContextChanged()");
        }
        this.fRunnableQueue.clear();
        this.fUpdatePending = false;
        this.resetViewer();
        if (this.fDebugSessionId != null) {
            final DsfSession session = this.getSession();
            session.addServiceEventListener((Object)this, null);
            DsfSession.addSessionEndedListener((DsfSession.SessionEndedListener)new DsfSession.SessionEndedListener(){

                public void sessionEnded(DsfSession endedSsession) {
                    if (session == endedSsession) {
                        DsfSession.removeSessionEndedListener((DsfSession.SessionEndedListener)this);
                        DisassemblyPart.this.asyncExec(new Runnable(){

                            public void run() {
                                DisassemblyPart.this.setDebugContext(null);
                            }
                        });
                    }
                }
            });
            this.updatePC(PC_UNKNOWN);
            if (this.fGotoAddressPending != PC_UNKNOWN) {
                this.gotoAddress(this.fGotoAddressPending);
            }
            if (this.fGotoMarkerPending != null) {
                this.gotoMarker(this.fGotoMarkerPending);
            }
            this.fViewer.addViewportListener(this);
        } else {
            this.fViewer.removeViewportListener(this);
            this.fGotoMarkerPending = null;
        }
        this.updateTitle();
        this.updateStateDependentActions();
        this.firePropertyChange(1286);
        this.firePropertyChange(1287);
    }

    @DsfServiceEventHandler
    public void handleEvent(IRunControl.IExitedDMEvent event) {
        if (((IRunControl.IExecutionDMContext)event.getDMContext()).equals(this.fTargetContext) || DMContexts.isAncestorOf((IDMContext)event.getDMContext(), (IDMContext)this.fTargetContext)) {
            this.setDebugContext(null);
        }
    }

    @DsfServiceEventHandler
    public void handleEvent(IRunControl.ISuspendedDMEvent event) {
        if (((IRunControl.IExecutionDMContext)event.getDMContext()).equals(this.fTargetContext) || DMContexts.isAncestorOf((IDMContext)event.getDMContext(), (IDMContext)this.fTargetContext)) {
            this.updatePC(PC_UNKNOWN);
            this.firePropertyChange(1287);
        }
    }

    @DsfServiceEventHandler
    public void handleEvent(IRunControl.IResumedDMEvent event) {
        if (((IRunControl.IExecutionDMContext)event.getDMContext()).equals(this.fTargetContext) || DMContexts.isAncestorOf((IDMContext)event.getDMContext(), (IDMContext)this.fTargetContext)) {
            this.updatePC(PC_RUNNING);
            this.firePropertyChange(1287);
        }
    }

    private void attachBreakpointsAnnotationModel() {
        IAnnotationModel annotationModel = this.fViewer.getAnnotationModel();
        if (annotationModel instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension ame = (IAnnotationModelExtension)annotationModel;
            ame.addAnnotationModel((Object)BREAKPOINT_ANNOTATIONS, (IAnnotationModel)new BreakpointsAnnotationModel());
        }
    }

    private void refreshView(int delay) {
        if (this.fViewer == null || this.fRefreshViewPending || this.fRefreshAll) {
            return;
        }
        this.fRunnableQueue.clear();
        this.fRefreshViewPending = true;
        final long refreshViewScheduled = System.currentTimeMillis() + (long)delay;
        final Runnable refresh = new Runnable(){

            public void run() {
                DisassemblyPart.this.fRefreshViewPending = false;
                long now = System.currentTimeMillis();
                if (now >= refreshViewScheduled) {
                    if (DEBUG) {
                        System.err.println("*** refreshing view ***");
                    }
                    DisassemblyPart.this.fFocusAddress = PC_UNKNOWN;
                    int targetFrame = DisassemblyPart.this.fTargetFrame;
                    DisassemblyPart.this.resetViewer();
                    if (DisassemblyPart.this.fScrollPos != null) {
                        ((DisassemblyPart)DisassemblyPart.this).fScrollPos.isDeleted = true;
                    }
                    DisassemblyPart.this.gotoFrame(targetFrame);
                } else {
                    DisassemblyPart.this.refreshView((int)(refreshViewScheduled - now));
                }
            }
        };
        if (delay > 0) {
            this.invokeLater(delay, new Runnable(){

                public void run() {
                    DisassemblyPart.this.doScrollLocked(refresh);
                }
            });
        } else {
            this.doScrollLocked(refresh);
        }
    }

    private void resetViewer() {
        this.fPCAnnotationUpdatePending = false;
        this.fGotoFramePending = false;
        this.fPCAddress = this.fFrameAddress = PC_RUNNING;
        this.fTargetFrame = -1;
        this.fGotoAddressPending = this.fFocusAddress;
        this.fFocusAddress = PC_UNKNOWN;
        this.setFocusPosition(null);
        this.fPCHistory.clear();
        this.fPendingPCUpdates.clear();
        this.fFile2Storage.clear();
        DisassemblyDocument doc = this.fDocument;
        this.fDocument = this.createDocument();
        this.fViewer.setDocument((IDocument)this.fDocument, (IAnnotationModel)new AnnotationModel());
        doc.dispose();
        if (this.fDebugSessionId != null) {
            this.attachBreakpointsAnnotationModel();
            this.fDocument.insertInvalidAddressRange(0, 0, this.fStartAddress, this.fEndAddress);
        }
    }

    private AddressRangePosition getPCPosition(BigInteger address) {
        if (address.compareTo(BigInteger.ZERO) < 0) {
            return null;
        }
        AddressRangePosition pos = this.getPositionOfAddress(address);
        if (pos == null || !pos.fValid) {
            return null;
        }
        if (pos.length > 0) {
            return pos;
        }
        if (!(pos instanceof DisassemblyPosition)) {
            return pos;
        }
        String srcFile = ((DisassemblyPosition)pos).getFile();
        if (srcFile == null) {
            return pos;
        }
        SourceFileInfo fi = this.fDocument.getSourceInfo(srcFile);
        if (fi == null) {
            return pos;
        }
        if (fi.fSource == null) {
            if (fi.fError != null) {
                return pos;
            }
            return null;
        }
        try {
            int stmtLine = ((DisassemblyPosition)pos).getLine();
            if (stmtLine < 0) {
                return pos;
            }
            BigInteger stmtAddress = fi.fLine2Addr[stmtLine];
            if (stmtAddress.compareTo(BigInteger.ZERO) < 0) {
                return pos;
            }
            SourcePosition srcPos = this.fDocument.getSourcePosition(stmtAddress);
            if (srcPos == null) {
                return pos;
            }
            if (!srcPos.fValid) {
                return null;
            }
            assert (stmtLine >= srcPos.fLine);
            int baseOffset = fi.fSource.getLineOffset(srcPos.fLine);
            IRegion stmtLineRegion = fi.fSource.getLineInformation(stmtLine);
            int lineOffset = stmtLineRegion.getOffset();
            int offset = srcPos.offset + lineOffset - baseOffset;
            int length = stmtLineRegion.getLength() + 1;
            if (offset >= srcPos.offset && offset < srcPos.offset + srcPos.length) {
                return new AddressRangePosition(offset, length, address, BigInteger.ZERO);
            }
        }
        catch (BadLocationException e) {
            DisassemblyPart.internalError(e);
        }
        return pos;
    }

    private AddressRangePosition updateAddressAnnotation(Annotation annotation, BigInteger address) {
        IAnnotationModel annotationModel = this.fViewer.getAnnotationModel();
        annotationModel.removeAnnotation(annotation);
        AddressRangePosition pos = this.getPCPosition(address);
        if (pos != null) {
            annotationModel.addAnnotation(annotation, new Position(pos.offset, Math.max(0, pos.length - 1)));
        }
        return pos;
    }

    public IBreakpoint[] getBreakpointsAtLine(int line) {
        IAnnotationModelExtension ame;
        BreakpointsAnnotationModel bpModel = null;
        IAnnotationModel am = this.fViewer.getAnnotationModel();
        if (am instanceof IAnnotationModelExtension && (bpModel = (BreakpointsAnnotationModel)(ame = (IAnnotationModelExtension)am).getAnnotationModel((Object)BREAKPOINT_ANNOTATIONS)) != null) {
            IRegion lineRegion;
            try {
                lineRegion = this.fDocument.getLineInformation(line);
            }
            catch (BadLocationException exc) {
                return null;
            }
            int offset = lineRegion.getOffset();
            int length = lineRegion.getLength();
            Iterator it = bpModel.getAnnotationIterator(offset, length, true, true);
            ArrayList<IBreakpoint> bpList = new ArrayList<IBreakpoint>(5);
            IBreakpointManager bpMgr = DebugPlugin.getDefault().getBreakpointManager();
            while (it.hasNext()) {
                SimpleMarkerAnnotation annotation = (SimpleMarkerAnnotation)it.next();
                IBreakpoint bp = bpMgr.getBreakpoint(annotation.getMarker());
                if (bp == null) continue;
                bpList.add(bp);
            }
            if (bpList.size() > 0) {
                return bpList.toArray(new IBreakpoint[bpList.size()]);
            }
        }
        return null;
    }

    private void gotoFrame(int frame, BigInteger address) {
        if (DEBUG) {
            System.out.println("gotoFrame " + frame + " " + DisassemblyPart.getAddressText(address));
        }
        this.fTargetFrame = frame;
        this.fFrameAddress = address;
        if (this.fTargetFrame == -1) {
            this.fTargetFrame = this.getActiveStackFrame();
            if (this.fTargetFrame < 0 && this.isSuspended(this.fTargetContext)) {
                this.fTargetFrame = 0;
            }
            if (this.fTargetFrame == -1) {
                this.fGotoFramePending = false;
                return;
            }
        }
        this.fGotoFramePending = true;
        if (frame == 0) {
            this.fPCAddress = this.fFrameAddress;
        }
        if (this.fFrameAddress.compareTo(PC_UNKNOWN) == 0) {
            if (!this.fUpdatePending) {
                this.fGotoFramePending = false;
                this.retrieveFrameAddress(this.fTargetContext, this.fTargetFrame);
            }
            return;
        }
        AddressRangePosition pcPos = this.updatePCAnnotation();
        if (pcPos == null && this.fFrameAddress.compareTo(BigInteger.ZERO) >= 0 && (pcPos = this.getPCPosition(this.fFrameAddress)) == null) {
            this.gotoAddress(this.fFrameAddress);
            return;
        }
        if (pcPos != null) {
            if (frame == 0) {
                this.addToPCHistory(pcPos);
            }
            this.fGotoFramePending = false;
            if (this.fGotoAddressPending == this.fFrameAddress) {
                this.fGotoAddressPending = PC_UNKNOWN;
            }
            this.gotoPosition(pcPos, false);
            this.updateVisibleArea();
        } else {
            this.fGotoFramePending = false;
            this.fGotoAddressPending = PC_UNKNOWN;
        }
        this.doPendingPCUpdates();
    }

    @Override
    public final boolean isActive() {
        return this.fActive;
    }

    @Override
    public final boolean isConnected() {
        return this.fDebugSessionId != null && this.fTargetContext != null;
    }

    @Override
    public final boolean isSuspended() {
        return this.isConnected() && this.isSuspended(this.fTargetContext);
    }

    @Override
    public final ISourceViewer getTextViewer() {
        return this.fViewer;
    }

    @Override
    public final void addRulerContextMenuListener(IMenuListener listener) {
        this.fRulerContextMenuListeners.add((Object)listener);
    }

    @Override
    public final void removeRulerContextMenuListener(IMenuListener listener) {
        this.fRulerContextMenuListeners.remove((Object)listener);
    }

    private boolean isSuspended(IRunControl.IExecutionDMContext targetContext) {
        return this.getRunControl().isSuspended(targetContext);
    }

    private IRunControl getRunControl() {
        return this.getService(IRunControl.class);
    }

    DsfSession getSession() {
        return DsfSession.getSession((String)this.fDebugSessionId);
    }

    <V> V getService(Class<V> serviceClass) {
        if (this.fServicesTracker != null) {
            return (V)this.fServicesTracker.getService(serviceClass);
        }
        return null;
    }

    IStack.IFrameDMContext getTargetFrameContext() {
        return this.fTargetFrameContext;
    }

    synchronized Object retrieveModuleTimestamp(BigInteger address) {
        return null;
    }

    private void setFocusPosition(Position pcPos) {
        if (this.fFocusPos != null) {
            this.fDocument.removePosition(this.fFocusPos);
            this.fFocusPos = null;
        }
        if (pcPos != null) {
            this.fFocusPos = new Position(pcPos.offset, pcPos.length);
            try {
                this.fDocument.addPosition(this.fFocusPos);
            }
            catch (BadLocationException e) {
                DisassemblyPart.internalError(e);
            }
        } else {
            this.fFocusAddress = PC_UNKNOWN;
        }
    }

    private void doPendingPCUpdates() {
        BigInteger pc;
        if (this.fPendingPCUpdates.isEmpty()) {
            return;
        }
        while ((pc = this.fPendingPCUpdates.remove(0)).compareTo(BigInteger.ZERO) < 0 && !this.fPendingPCUpdates.isEmpty()) {
        }
        this.gotoFrame(0, pc);
    }

    private void addToPCHistory(AddressRangePosition pcPos) {
        if (DEBUG) {
            System.out.println("addToPCHistory " + DisassemblyPart.getAddressText(pcPos.fAddressOffset));
        }
        if (this.fPCHistorySizeMax <= 1) {
            return;
        }
        AddressRangePosition first = null;
        if (this.fPCHistory.size() > 0) {
            first = this.fPCHistory.getFirst();
            if (first.fAddressOffset == pcPos.fAddressOffset) {
                if (first.offset != pcPos.offset || first.length != pcPos.length) {
                    this.fPCHistory.removeFirst();
                    this.fViewer.invalidateTextPresentation(first.offset, first.length);
                } else {
                    return;
                }
            }
        }
        pcPos = new AddressRangePosition(pcPos.offset, pcPos.length, pcPos.fAddressOffset, BigInteger.ZERO);
        this.fPCHistory.addFirst(pcPos);
        try {
            this.fDocument.addPosition(pcPos);
        }
        catch (BadLocationException e) {
            DisassemblyPart.internalError(e);
        }
        if (this.fPCHistory.size() > this.fPCHistorySizeMax) {
            AddressRangePosition last = this.fPCHistory.removeLast();
            this.fDocument.removePosition(last);
            this.fViewer.invalidateTextPresentation(last.offset, last.length);
        }
        for (AddressRangePosition pos : this.fPCHistory) {
            this.fViewer.invalidateTextPresentation(pos.offset, pos.length);
        }
    }

    private void updatePC(BigInteger pc) {
        BigInteger last;
        if (!this.fPendingPCUpdates.isEmpty() && (last = this.fPendingPCUpdates.get(this.fPendingPCUpdates.size() - 1)).compareTo(BigInteger.ZERO) < 0) {
            this.fPendingPCUpdates.remove(this.fPendingPCUpdates.size() - 1);
        }
        this.fPendingPCUpdates.add(pc);
        if (this.fPendingPCUpdates.size() > this.fPCHistorySizeMax) {
            if (!this.fActive) {
                this.fPendingPCUpdates.remove(0);
            }
            this.fGotoFramePending = false;
        }
        if (this.fActive) {
            if (this.fGotoFramePending) {
                if (!this.fUpdatePending) {
                    this.gotoFrame(0, this.fFrameAddress);
                }
            } else {
                this.doPendingPCUpdates();
            }
        }
    }

    private AddressRangePosition updatePCAnnotation() {
        AddressRangePosition pos;
        if (this.fUpdatePending) {
            this.fPCAnnotationUpdatePending = true;
            return null;
        }
        if (this.fTargetFrame == 0) {
            this.updateAddressAnnotation(this.fSecondaryPCAnnotation, PC_UNKNOWN);
            pos = this.updateAddressAnnotation(this.fPCAnnotation, this.fPCAddress);
        } else {
            this.updateAddressAnnotation(this.fPCAnnotation, PC_UNKNOWN);
            pos = this.updateAddressAnnotation(this.fSecondaryPCAnnotation, this.fFrameAddress);
        }
        this.fPCAnnotationUpdatePending = pos == null && this.fFrameAddress.compareTo(BigInteger.ZERO) >= 0;
        return pos;
    }

    private void scheduleDoPending() {
        if (!this.fUpdatePending && !this.fDoPendingPosted) {
            this.fDoPendingPosted = true;
            this.invokeLater(new Runnable(){

                public void run() {
                    DisassemblyPart.this.doPending();
                    DisassemblyPart.this.fDoPendingPosted = false;
                }
            });
        }
    }

    private void doPending() {
        boolean sourceValid;
        if (this.fViewer == null || this.fDocument == null) {
            return;
        }
        if (this.fUpdateSourcePending) {
            this.updateInvalidSource();
        }
        if (((sourceValid = this.fDocument.getInvalidSource().isEmpty()) || this.fShowDisassembly) && this.fGotoFramePending) {
            this.gotoFrame(this.fTargetFrame, this.fFrameAddress);
        }
        if (sourceValid) {
            if (this.fGotoAddressPending != PC_UNKNOWN) {
                this.gotoAddress(this.fGotoAddressPending);
            } else if (this.fGotoMarkerPending != null) {
                this.gotoMarker(this.fGotoMarkerPending);
            }
            if (this.fPCAnnotationUpdatePending && !this.fGotoFramePending) {
                this.updatePCAnnotation();
            }
            if (this.fUpdateTitlePending) {
                this.updateTitle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doScrollLocked(Runnable doit) {
        if (this.fViewer == null || this.fDebugSessionId == null) {
            return;
        }
        if (!this.fActive) {
            this.fRefreshViewPending = false;
            this.fRefreshAll = true;
            return;
        }
        if (doit != null) {
            this.fRunnableQueue.add(doit);
        }
        if (this.fUpdatePending) {
            if (this.fRunnableQueue.size() == 1) {
                Runnable doitlater = new Runnable(){

                    public void run() {
                        DisassemblyPart.this.doScrollLocked(null);
                    }
                };
                this.invokeLater(doitlater);
            }
        } else {
            this.fUpdatePending = true;
            this.lockScroller();
            try {
                ArrayList<Runnable> copy = new ArrayList<Runnable>(this.fRunnableQueue);
                this.fRunnableQueue.clear();
                for (Runnable doitnow : copy) {
                    try {
                        doitnow.run();
                    }
                    catch (Exception e) {
                        DisassemblyPart.internalError(e);
                    }
                }
            }
            finally {
                this.fUpdatePending = false;
                this.unlockScroller();
                this.doPending();
                this.updateVisibleArea();
            }
        }
    }

    private void lockScroller() {
        assert (this.fScrollPos == null);
        this.fRedrawControl = this.isOpcodeRulerVisible() ? this.fViewer.getControl() : this.fViewer.getTextWidget();
        this.fRedrawControl.setRedraw(false);
        try {
            int focusLine;
            int focusOffset;
            int topOffset = this.fViewer.getTopIndexStartOffset();
            int topIndex = this.fViewer.getTopIndex();
            int bottomIndex = this.fViewer.getBottomIndex();
            int bottomOffset = this.fViewer.getBottomIndexEndOffset();
            if (this.fFocusPos != null && this.fFocusPos.isDeleted) {
                this.fFocusPos = null;
            }
            if (this.fFocusPos != null && this.fFocusPos.offset >= topOffset && this.fFocusPos.offset <= bottomOffset) {
                focusOffset = this.fFocusPos.offset;
                focusLine = this.fDocument.getLineOfOffset(focusOffset);
            } else {
                focusLine = Math.max(0, (topIndex + bottomIndex) / 2);
                focusOffset = this.fDocument.getLineOffset(focusLine);
                AddressRangePosition pos = this.fDocument.getDisassemblyPosition(focusOffset);
                if (pos != null && !pos.fValid) {
                    focusOffset = pos.offset + pos.length;
                    focusLine = this.fDocument.getLineOfOffset(focusOffset);
                }
            }
            this.fScrollPos = new Position(focusOffset);
            this.fScrollLine = focusLine - topIndex;
            this.fDocument.addPosition(this.fScrollPos);
        }
        catch (BadLocationException e) {
            DisassemblyPart.internalError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockScroller() {
        try {
            if (this.fScrollPos == null) {
                return;
            }
            if (this.fScrollPos.isDeleted) {
                this.fScrollPos.isDeleted = false;
                if (this.fScrollPos.offset >= this.fDocument.getLength()) {
                    this.fScrollPos.offset = 0;
                    this.fScrollLine = 0;
                }
            }
            if (this.fFocusPos != null && (this.fFocusPos.isDeleted || this.fFocusPos.length == 0) && this.fFocusAddress.compareTo(BigInteger.ZERO) >= 0) {
                this.fGotoAddressPending = this.fFocusAddress;
                this.setFocusPosition(this.getPositionOfAddress(this.fFocusAddress));
            }
            int topLine = this.fDocument.getLineOfOffset(this.fScrollPos.offset) - this.fScrollLine;
            int lineCount = this.fDocument.getNumberOfLines();
            if (lineCount > 500 * this.fBufferZone) {
                int startLine = Math.max(0, topLine - 50 * this.fBufferZone);
                int endLine = Math.min(lineCount - 1, topLine + 50 * this.fBufferZone);
                this.fDocument.deleteLineRange(endLine, lineCount - 1);
                this.fDocument.deleteLineRange(0, startLine);
            }
            int lineHeight = this.fViewer.getTextWidget().getLineHeight();
            int topPixel = topLine * lineHeight;
            if (Math.abs(this.fViewer.getTextWidget().getTopPixel() - topPixel) >= lineHeight) {
                this.fViewer.setTopIndex(topLine);
            }
        }
        catch (BadLocationException e) {
            DisassemblyPart.internalError(e);
        }
        finally {
            if (this.fScrollPos != null && this.fDocument != null) {
                this.fDocument.removePosition(this.fScrollPos);
                this.fScrollPos = null;
            }
            if (this.fViewer != null) {
                this.fRedrawControl.setRedraw(true);
                this.getVerticalRuler().update();
                this.getOverviewRuler().update();
            }
        }
    }

    private void insertSource(SourcePosition pos) {
        if (!this.fShowSource) {
            this.fDocument.insertSource(pos, "", pos.fLine, true);
            return;
        }
        SourceFileInfo fi = pos.fFileInfo;
        BigInteger address = pos.fAddressOffset;
        int lineNr = pos.fLine;
        if (fi.fError == null) {
            if (fi.fValid) {
                Addr2Line a2l = fi.fAddr2Line[Addr2Line.hash(address, fi.fAddr2Line.length)];
                while (a2l != null && !a2l.addr.equals(address)) {
                    a2l = a2l.next;
                }
                if (a2l != null) {
                    String source;
                    int first;
                    int line;
                    for (line = first = a2l.first; line <= a2l.last; ++line) {
                        if (fi.fLine2Addr[line].equals(address)) continue;
                        if (line > first) {
                            source = fi.getLines(first, line - 1);
                            pos = this.fDocument.insertSource(pos, source, first, false);
                        }
                        first = line + 1;
                    }
                    if (line > first) {
                        source = fi.getLines(first, line - 1);
                        this.fDocument.insertSource(pos, source, first, true);
                        if (source.length() == 0) {
                            this.fDocument.removeSourcePosition(pos);
                        }
                    } else if (first > a2l.first) {
                        this.fDocument.insertSource(pos, "", first, true);
                        this.fDocument.removeSourcePosition(pos);
                    }
                } else {
                    this.fDocument.insertSource(pos, "", lineNr, true);
                    this.fDocument.removeSourcePosition(pos);
                }
            } else if (fi.fLinesNode == null && fi.fSource != null) {
                fi.fError = new Error();
            }
        }
        if (fi.fError != null && !pos.fValid) {
            if (fi.fSource != null) {
                if (fi.fSource != null && lineNr >= 0 && lineNr < fi.fSource.getNumberOfLines()) {
                    String sourceLine;
                    fi.fStartAddress = fi.fStartAddress.min(pos.fAddressOffset);
                    fi.fEndAddress = fi.fEndAddress.max(pos.fAddressOffset.add(pos.fAddressLength));
                    if (fi.fLine2Addr[lineNr] == null || fi.fLine2Addr[lineNr].compareTo(BigInteger.ZERO) < 0) {
                        fi.fLine2Addr[lineNr] = pos.fAddressOffset;
                        sourceLine = fi.getLine(lineNr);
                        this.fDocument.insertSource(pos, sourceLine, lineNr, true);
                    } else if (fi.fLine2Addr[lineNr].compareTo(pos.fAddressOffset) > 0) {
                        SourcePosition oldPos = this.fDocument.getSourcePosition(fi.fLine2Addr[lineNr]);
                        if (oldPos != null) {
                            try {
                                this.fDocument.replace(oldPos, oldPos.length, null);
                            }
                            catch (BadLocationException e) {
                                DisassemblyPart.internalError(e);
                            }
                            this.fDocument.removeSourcePosition(oldPos);
                        }
                        fi.fLine2Addr[lineNr] = pos.fAddressOffset;
                        String sourceLine2 = fi.getLine(lineNr);
                        this.fDocument.insertSource(pos, sourceLine2, lineNr, true);
                    } else if (fi.fLine2Addr[lineNr].equals(pos.fAddressOffset)) {
                        sourceLine = fi.getLine(lineNr);
                        this.fDocument.insertSource(pos, sourceLine, lineNr, true);
                    } else {
                        this.fDocument.insertSource(pos, "", lineNr, true);
                        this.fDocument.removeSourcePosition(pos);
                    }
                }
            } else {
                this.fDocument.insertSource(pos, "", lineNr, true);
                this.fDocument.removeSourcePosition(pos);
            }
        }
    }

    private void updateTitle() {
        if (this.fDebugSessionId == null) {
            String descr = DisassemblyMessages.Disassembly_message_notConnected;
            String title = this.getConfigurationElement().getAttribute("name");
            this.setPartName(title);
            this.setContentDescription(descr);
            this.setTitleToolTip(title);
        } else {
            this.setContentDescription("");
        }
    }

    private boolean isDissemblyMixedModeOn() {
        return true;
    }

    protected abstract void closePart();

    public void applyTextPresentation(TextPresentation textPresentation) {
        Iterator<Position> it;
        IRegion coverage = textPresentation.getExtent();
        if (coverage == null) {
            coverage = new Region(0, this.fDocument.getLength());
        }
        int startOffset = coverage.getOffset();
        int length = coverage.getLength();
        int endOffset = startOffset + length;
        try {
            AddressRangePosition pos = this.fDocument.getModelPosition(startOffset);
            assert (pos != null);
            if (pos == null) {
                return;
            }
            it = this.fDocument.getPositionIterator("category_model", pos.offset);
        }
        catch (BadPositionCategoryException e) {
            return;
        }
        catch (BadLocationException e) {
            return;
        }
        ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
        while (it.hasNext()) {
            AddressRangePosition pos = (AddressRangePosition)it.next();
            if (pos.offset >= endOffset) break;
            if (pos.offset + pos.length <= startOffset || !pos.fValid || pos.length <= 0) continue;
            if (pos instanceof DisassemblyPosition) {
                DisassemblyPosition disPos = (DisassemblyPosition)pos;
                styleRanges.add(new StyleRange(pos.offset, disPos.length, this.fInstructionColor, null, 0));
                continue;
            }
            if (pos instanceof ErrorPosition) {
                styleRanges.add(new StyleRange(pos.offset, pos.length, this.fErrorColor, null, 0));
                continue;
            }
            if (pos instanceof LabelPosition) {
                styleRanges.add(new StyleRange(pos.offset, pos.length, this.fLabelColor, null, 1));
                continue;
            }
            if (!(pos instanceof SourcePosition)) continue;
            SourcePosition srcPos = (SourcePosition)pos;
            TextPresentation presentation = null;
            if (srcPos.fFileInfo.fSource != null) {
                presentation = srcPos.fFileInfo.getPresentation(srcPos.fFileInfo.getRegion(srcPos.fLine, pos.length));
            }
            if (presentation != null) {
                int start = Math.max(startOffset, srcPos.offset);
                int end = Math.min(endOffset, srcPos.offset + srcPos.length);
                int srcOffset = srcPos.fFileInfo.getLineOffset(srcPos.fLine);
                int clipOffset = start - srcPos.offset;
                presentation.setResultWindow((IRegion)new Region(srcOffset + clipOffset, end - start));
                Iterator iter = presentation.getNonDefaultStyleRangeIterator();
                while (iter.hasNext()) {
                    StyleRange styleRange = (StyleRange)iter.next();
                    styleRange.start += srcPos.offset + clipOffset;
                    styleRanges.add(styleRange);
                }
                continue;
            }
            styleRanges.add(new StyleRange(pos.offset, pos.length, this.fSourceColor, null, 0));
        }
        if (styleRanges.size() > 0) {
            Iterator iter = styleRanges.iterator();
            while (iter.hasNext()) {
                textPresentation.addStyleRange((StyleRange)iter.next());
            }
        }
        if (this.fPCHistory.size() > 1) {
            HSL hsv = new HSL(this.fPCAnnotationRGB);
            double luminanceStep = (1.0 - hsv.luminance) / (double)(this.fPCHistorySizeMax + 1);
            hsv.luminance = 1.0 - luminanceStep * (double)(this.fPCHistorySizeMax - this.fPCHistory.size());
            ListIterator<AddressRangePosition> listIt = this.fPCHistory.listIterator(this.fPCHistory.size());
            while (listIt.hasPrevious()) {
                AddressRangePosition pcPos = listIt.previous();
                hsv.luminance -= luminanceStep;
                if (pcPos.isDeleted) {
                    listIt.remove();
                    continue;
                }
                if (!pcPos.fValid || !pcPos.overlapsWith(startOffset, length)) continue;
                RGB rgb = hsv.toRGB();
                Color pcColor = this.getSharedColors().getColor(rgb);
                Color textColor = null;
                textPresentation.mergeStyleRange(new StyleRange(pcPos.offset, pcPos.length, textColor, pcColor));
            }
        }
    }

    private IBreakpoint insertBreakpoint(int line, boolean edit) throws CoreException {
        ICAddressBreakpoint bp;
        boolean lineBreakpoint;
        SourcePosition srcPos = null;
        try {
            int lineOffset = this.fDocument.getLineOffset(line);
            srcPos = this.fDocument.getSourcePosition(lineOffset);
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        boolean bl = lineBreakpoint = srcPos != null && srcPos.length > 0;
        if (lineBreakpoint) {
            SourceFileInfo srcInfo = srcPos.fFileInfo;
            String filePath = null;
            IResource resource = (IResource)srcInfo.fFile.getAdapter(IResource.class);
            if (resource != null) {
                IPath location = resource.getLocation();
                if (location == null) {
                    return null;
                }
                filePath = location.toOSString();
            } else {
                resource = ResourcesPlugin.getWorkspace().getRoot();
                filePath = srcInfo.fFile.getFullPath().toOSString();
            }
            BigInteger address = srcPos.fAddressOffset;
            AddressRangePosition pos = this.fDocument.getDisassemblyPosition(address);
            int srcLine = -1;
            if (pos instanceof DisassemblyPosition) {
                srcLine = ((DisassemblyPosition)pos).getLine();
            }
            bp = CDIDebugModel.createLineBreakpoint((String)filePath, (IResource)resource, (int)(srcLine + 1), (boolean)true, (int)0, (String)"", (boolean)true);
        } else {
            IWorkspaceRoot resource = ResourcesPlugin.getWorkspace().getRoot();
            BigInteger address = this.getAddressOfLine(line);
            bp = CDIDebugModel.createAddressBreakpoint(null, null, (IResource)resource, (IAddress)new Addr64(address), (boolean)true, (int)0, (String)"", (boolean)true);
        }
        return bp;
    }

    private AddressRangePosition insertSource(AddressRangePosition pos, BigInteger address, final String file, int lineNr) {
        Object sourceElement = null;
        if (this.fFile2Storage.containsKey(file)) {
            sourceElement = this.fFile2Storage.get(file);
        } else {
            final ISourceLookup lookup = this.getService(ISourceLookup.class);
            final ISourceLookup.ISourceLookupDMContext ctx = (ISourceLookup.ISourceLookupDMContext)DMContexts.getAncestorOfType((IDMContext)this.fTargetContext, ISourceLookup.ISourceLookupDMContext.class);
            final DsfExecutor executor = this.getSession().getExecutor();
            Query<Object> query = new Query<Object>(){

                protected void execute(final DataRequestMonitor<Object> rm) {
                    DataRequestMonitor<Object> request = new DataRequestMonitor<Object>((Executor)executor, rm){

                        protected void handleSuccess() {
                            rm.setData(this.getData());
                            rm.done();
                        }
                    };
                    lookup.getSource(ctx, file, (DataRequestMonitor)request);
                }
            };
            try {
                this.getSession().getExecutor().execute((Runnable)query);
                sourceElement = query.get();
            }
            catch (InterruptedException exc) {
                DisassemblyPart.internalError(exc);
            }
            catch (ExecutionException exc) {
                DisassemblyPart.internalError(exc);
            }
            if (sourceElement instanceof File) {
                sourceElement = new LocalFileStorage((File)sourceElement);
            }
            if (sourceElement instanceof IStorage) {
                this.fFile2Storage.put(file, sourceElement);
            } else {
                this.fFile2Storage.put(file, null);
                this.logWarning(DisassemblyMessages.Disassembly_log_error_locateFile + file, null);
            }
        }
        if (sourceElement instanceof IStorage) {
            SourceFileInfo fi = this.fDocument.getSourceInfo((IStorage)sourceElement);
            if (fi == null) {
                IStorage storage = (IStorage)sourceElement;
                Display display = this.getSite().getShell().getDisplay();
                SourceColorerJob done = new SourceColorerJob(display, storage, this);
                fi = this.fDocument.createSourceInfo(file, storage, done);
                EditionFinderJob editionJob = null;
                if (storage instanceof IFile) {
                    editionJob = new EditionFinderJob(fi, address, this);
                    editionJob.schedule();
                }
                fi.fReadingJob.schedule();
            }
            pos = this.fDocument.insertInvalidSource(pos, address, fi, lineNr);
        }
        return pos;
    }

    private void disassemblyModeChanged(boolean isDisassemblyOn) {
        if (this.fShowDisassembly == isDisassemblyOn) {
            return;
        }
        if (this.fShowDisassembly && !this.fSourceOnlyMode) {
            return;
        }
        this.fShowDisassembly = isDisassemblyOn;
        if (!this.fShowDisassembly) {
            this.sourceModeChanged(true);
        }
        this.fActionToggleSource.update();
        Runnable doit = new Runnable(){

            public void run() {
                DisassemblyPart.this.fDocument.invalidateDisassemblyWithSource(!DisassemblyPart.this.fShowDisassembly);
                DisassemblyPart.this.fGotoFramePending = true;
            }
        };
        this.doScrollLocked(doit);
    }

    private void sourceModeChanged(boolean isSourceModeOn) {
        if (this.fShowSource == isSourceModeOn) {
            return;
        }
        this.fShowSource = isSourceModeOn;
        this.fActionToggleSource.update();
        this.fDocument.invalidateSource();
        if (!this.fShowSource && !this.fShowDisassembly) {
            this.disassemblyModeChanged(true);
        } else {
            this.fPCAnnotationUpdatePending = true;
            this.updateInvalidSource();
        }
    }

    public static BigInteger decodeAddress(String string) {
        if (string.startsWith("0x")) {
            return new BigInteger(string.substring(2), 16);
        }
        return new BigInteger(string);
    }

    private static String getAddressText(BigInteger address) {
        if (address == null) {
            return "<null>";
        }
        if (address.compareTo(BigInteger.ZERO) < 0) {
            return address.toString();
        }
        String hex = address.toString(16);
        return "0x" + "0000000000000000".substring(hex.length() + (address.bitLength() <= 32 ? 8 : 0)) + hex;
    }

    static void internalError(Throwable e) {
        if (DEBUG) {
            System.err.println("Disassembly: Internal error");
            e.printStackTrace();
        }
    }

    private final class ActionRefreshView
    extends AbstractDisassemblyAction {
        public ActionRefreshView() {
            super(DisassemblyPart.this);
            this.setText(DisassemblyMessages.Disassembly_action_RefreshView_label);
            this.setImageDescriptor(DisassemblyImageRegistry.getImageDescriptor(DisassemblyImageRegistry.ICON_Refresh_enabled));
            this.setDisabledImageDescriptor(DisassemblyImageRegistry.getImageDescriptor(DisassemblyImageRegistry.ICON_Refresh_disabled));
        }

        public void run() {
            DisassemblyPart.this.refreshView(10);
        }
    }

    private final class ActionToggleAddressColumn
    extends AbstractDisassemblyAction {
        ActionToggleAddressColumn() {
            super(DisassemblyPart.this);
            this.setText(DisassemblyMessages.Disassembly_action_ShowAddresses_label);
        }

        public void run() {
            IPreferenceStore store = DsfDebugUIPlugin.getDefault().getPreferenceStore();
            store.setValue("showAddressRuler", !DisassemblyPart.this.isAddressRulerVisible());
        }

        public void update() {
            this.setChecked(DisassemblyPart.this.isAddressRulerVisible());
        }
    }

    private final class ActionToggleBreakpoint
    extends AbstractDisassemblyAction {
        private IBreakpoint fBreakpoint;
        private int fLine;

        public ActionToggleBreakpoint() {
            super(DisassemblyPart.this);
            this.setText(DisassemblyMessages.Disassembly_action_AddBreakpoint_label);
            this.setImageDescriptor(DisassemblyImageRegistry.getImageDescriptor(DisassemblyImageRegistry.ICON_ToggleBreakpoint));
        }

        public void run() {
            try {
                if (this.fBreakpoint != null) {
                    this.fBreakpoint.delete();
                } else {
                    DisassemblyPart.this.insertBreakpoint(this.fLine, false);
                }
            }
            catch (CoreException e) {
                DsfDebugUIPlugin.getDefault().getLog().log(e.getStatus());
            }
        }

        public void update() {
            super.update();
            if (this.isEnabled()) {
                this.fLine = DisassemblyPart.this.fVerticalRuler.getLineOfLastMouseButtonActivity();
                IBreakpoint[] bps = DisassemblyPart.this.getBreakpointsAtLine(this.fLine);
                if (bps == null) {
                    this.fBreakpoint = null;
                    this.setText(DisassemblyMessages.Disassembly_action_AddBreakpoint_label);
                } else {
                    this.fBreakpoint = bps[0];
                    this.setText(DisassemblyMessages.Disassembly_action_RemoveBreakpoint_label);
                }
            }
        }
    }

    private final class ActionToggleBreakpointEnablement
    extends AbstractDisassemblyAction {
        private IBreakpoint fBreakpoint;

        public ActionToggleBreakpointEnablement() {
            super(DisassemblyPart.this);
            this.setText(DisassemblyMessages.Disassembly_action_EnableBreakpoint_label);
        }

        public void run() {
            try {
                this.fBreakpoint.setEnabled(!this.fBreakpoint.isEnabled());
            }
            catch (CoreException e) {
                DisassemblyPart.internalError(e);
            }
        }

        public void update() {
            super.update();
            if (this.isEnabled()) {
                int line = DisassemblyPart.this.fVerticalRuler.getLineOfLastMouseButtonActivity();
                IBreakpoint[] bps = DisassemblyPart.this.getBreakpointsAtLine(line);
                if (bps == null || bps.length == 0) {
                    this.setEnabled(false);
                } else {
                    this.fBreakpoint = bps[0];
                    try {
                        if (this.fBreakpoint.isEnabled()) {
                            this.setText(DisassemblyMessages.Disassembly_action_DisableBreakpoint_label);
                        } else {
                            this.setText(DisassemblyMessages.Disassembly_action_EnableBreakpoint_label);
                        }
                    }
                    catch (CoreException e) {
                        this.setEnabled(false);
                    }
                }
            }
        }
    }

    private final class ActionToggleFunctionColumn
    extends AbstractDisassemblyAction {
        ActionToggleFunctionColumn() {
            super(DisassemblyPart.this);
            this.setText(DisassemblyMessages.Disassembly_action_ShowFunctionOffsets_label);
        }

        public void run() {
            IPreferenceStore store = DsfDebugUIPlugin.getDefault().getPreferenceStore();
            store.setValue("showOpcodeRuler", !DisassemblyPart.this.isOpcodeRulerVisible());
        }

        public void update() {
            this.setChecked(DisassemblyPart.this.isOpcodeRulerVisible());
        }
    }

    private final class ActionToggleSource
    extends AbstractDisassemblyAction {
        public ActionToggleSource() {
            super(DisassemblyPart.this);
            this.setText(DisassemblyMessages.Disassembly_action_ShowSource_label);
        }

        public void run() {
            IPreferenceStore store = DsfDebugUIPlugin.getDefault().getPreferenceStore();
            boolean showSourceEnabled = store.getBoolean("showSource");
            if (showSourceEnabled == DisassemblyPart.this.fShowSource) {
                store.setValue("showSource", !DisassemblyPart.this.fShowSource);
            } else {
                DisassemblyPart.this.sourceModeChanged(!DisassemblyPart.this.fShowSource);
            }
        }

        public void update() {
            super.update();
            if (this.isEnabled()) {
                this.setEnabled(DisassemblyPart.this.fShowDisassembly);
            }
            this.setChecked(DisassemblyPart.this.fShowSource);
        }
    }

    private final class ActionToggleSymbols
    extends AbstractDisassemblyAction {
        public ActionToggleSymbols() {
            super(DisassemblyPart.this);
            this.setText(DisassemblyMessages.Disassembly_action_ShowSymbols_label);
        }

        public void run() {
            IPreferenceStore store = DsfDebugUIPlugin.getDefault().getPreferenceStore();
            store.setValue("showSymbols", !DisassemblyPart.this.fShowSymbols);
        }

        public void update() {
            super.update();
            this.setChecked(DisassemblyPart.this.fShowSymbols);
        }
    }

    class PropertyChangeListener
    implements IPropertyChangeListener {
        PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            DisassemblyPart.this.handlePreferenceStoreChanged(event);
        }
    }
}

