/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.ui.viewmodel.detailsupport;

import org.eclipse.dd.dsf.debug.internal.ui.DsfDebugUIPlugin;
import org.eclipse.dd.dsf.debug.internal.ui.viewmodel.detailsupport.MessagesForDetailPane;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class DetailPaneMaxLengthDialog
extends TrayDialog {
    private static final String SETTINGS_ID = "org.eclipse.dd.dsf.debug.ui.MAX_DETAILS_LENGTH_DIALOG";
    private Text fTextWidget;
    private Text fErrorTextWidget;
    private String fErrorMessage;
    private String fValue;
    private IInputValidator fValidator;

    public DetailPaneMaxLengthDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fValue = Integer.toString(DsfDebugUIPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.dd.dsf.debug.ui.max_detail_length"));
        this.fValidator = new IInputValidator(){

            public String isValid(String newText) {
                try {
                    int num = Integer.parseInt(newText);
                    if (num < 0) {
                        return MessagesForDetailPane.PaneMaxLengthDialog_IntegerCannotBeNegative;
                    }
                }
                catch (NumberFormatException e) {
                    return MessagesForDetailPane.PaneMaxLengthDialog_EnterAnInteger;
                }
                return null;
            }
        };
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = DsfDebugUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(SETTINGS_ID);
        if (section == null) {
            section = settings.addNewSection(SETTINGS_ID);
        }
        return section;
    }

    protected Control createContents(Composite parent) {
        this.getShell().setText(MessagesForDetailPane.PaneMaxLengthDialog_ConfigureDetails);
        Control contents = super.createContents(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getDialogArea(), "org.eclipse.debug.ui.detail_pane_max_length_action_context");
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label label = new Label(composite, 64);
        label.setText(MessagesForDetailPane.PaneMaxLengthDialog_MaxCharactersToDisplay);
        GridData data = new GridData(1796);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)data);
        label.setFont(parent.getFont());
        this.fTextWidget = new Text(composite, 2052);
        this.fTextWidget.setLayoutData((Object)new GridData(768));
        this.fTextWidget.setText(this.fValue);
        this.fTextWidget.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DetailPaneMaxLengthDialog.this.validateInput();
                DetailPaneMaxLengthDialog.this.fValue = DetailPaneMaxLengthDialog.this.fTextWidget.getText();
            }
        });
        this.fErrorTextWidget = new Text(composite, 8);
        this.fErrorTextWidget.setLayoutData((Object)new GridData(768));
        this.fErrorTextWidget.setBackground(this.fErrorTextWidget.getDisplay().getSystemColor(22));
        this.setErrorMessage(this.fErrorMessage);
        DetailPaneMaxLengthDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void okPressed() {
        String text = this.getValue();
        try {
            DsfDebugUIPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.debug.ui.max_detail_length", Integer.parseInt(text));
        }
        catch (NumberFormatException e) {
            DsfDebugUIPlugin.log(e);
        }
        super.okPressed();
    }

    public String getValue() {
        return this.fValue;
    }

    private void validateInput() {
        String errorMessage = null;
        if (this.fValidator != null) {
            errorMessage = this.fValidator.isValid(this.fTextWidget.getText());
        }
        this.setErrorMessage(errorMessage);
    }

    public void setErrorMessage(String errorMessage) {
        this.fErrorMessage = errorMessage;
        if (this.fErrorTextWidget != null && !this.fErrorTextWidget.isDisposed()) {
            this.fErrorTextWidget.setText(errorMessage == null ? "" : errorMessage);
            this.fErrorTextWidget.getParent().update();
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled(errorMessage == null);
            }
        }
    }
}

