/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.expression;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.expression.ExpressionColumnPresentation;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.expression.ExpressionManagerVMNode;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.expression.ExpressionVMProviderContentStragegy;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.expression.ExpressionVMProviderModelProxyStrategy;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.expression.IExpressionUpdate;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.expression.IExpressionVMNode;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.numberformat.FormattedValuePreferenceStore;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.numberformat.IFormattedValuePreferenceStore;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.register.RegisterBitFieldVMNode;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.register.RegisterGroupVMNode;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.register.RegisterVMNode;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.register.SyncRegisterDataAccess;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.update.BreakpointHitUpdatePolicy;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.variable.SyncVariableDataAccess;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.variable.VariableVMNode;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMAdapter;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.DefaultVMContentProviderStrategy;
import org.eclipse.dd.dsf.ui.viewmodel.IRootVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.IVMModelProxy;
import org.eclipse.dd.dsf.ui.viewmodel.IVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.RootDMVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.update.AutomaticUpdatePolicy;
import org.eclipse.dd.dsf.ui.viewmodel.update.IVMUpdatePolicy;
import org.eclipse.dd.dsf.ui.viewmodel.update.ManualUpdatePolicy;
import org.eclipse.dd.dsf.ui.viewmodel.update.UserEditEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionsListener;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.internal.core.IExpressionsListener2;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentation;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.TreePath;

public class ExpressionVMProvider
extends AbstractDMVMProvider
implements IPropertyChangeListener,
IExpressionsListener2 {
    private IExpressionVMNode[] fExpressionNodes;

    public ExpressionVMProvider(AbstractVMAdapter adapter, IPresentationContext context, DsfSession session) {
        super(adapter, context, session);
        context.addPropertyChangeListener((IPropertyChangeListener)this);
        DebugPlugin.getDefault().getExpressionManager().addExpressionListener((IExpressionsListener)this);
        this.configureLayout();
    }

    protected DefaultVMContentProviderStrategy createContentStrategy() {
        return new ExpressionVMProviderContentStragegy(this);
    }

    protected IVMModelProxy createModelProxyStrategy(Object rootElement) {
        return new ExpressionVMProviderModelProxyStrategy(this, rootElement);
    }

    public void update(IExpressionUpdate update) {
        ((ExpressionVMProviderContentStragegy)this.getContentStrategy()).update(update);
    }

    public int getDeltaFlagsForExpression(IExpression expression, Object event) {
        if (!this.getActiveModelProxies().isEmpty()) {
            return ((ExpressionVMProviderModelProxyStrategy)((Object)this.getActiveModelProxies().get(0))).getDeltaFlagsForExpression(expression, event);
        }
        return 0;
    }

    public void buildDeltaForExpression(IExpression expression, int expressionElementIdx, Object event, VMDelta parentDelta, TreePath path, RequestMonitor rm) {
        if (!this.getActiveModelProxies().isEmpty()) {
            ((ExpressionVMProviderModelProxyStrategy)((Object)this.getActiveModelProxies().get(0))).buildDeltaForExpression(expression, expressionElementIdx, event, parentDelta, path, rm);
        } else {
            rm.done();
        }
    }

    protected void setExpressionNodes(IExpressionVMNode[] nodes) {
        this.fExpressionNodes = nodes;
        for (IExpressionVMNode node : nodes) {
            this.addNode(node);
        }
    }

    public IExpressionVMNode[] getExpressionNodes() {
        return this.fExpressionNodes;
    }

    protected void configureLayout() {
        IFormattedValuePreferenceStore prefStore = FormattedValuePreferenceStore.getDefault();
        SyncRegisterDataAccess syncRegDataAccess = new SyncRegisterDataAccess(this.getSession());
        SyncVariableDataAccess syncvarDataAccess = new SyncVariableDataAccess(this.getSession());
        RootDMVMNode rootNode = new RootDMVMNode((AbstractVMProvider)this);
        ExpressionManagerVMNode expressionManagerNode = new ExpressionManagerVMNode(this);
        this.addChildNodes((IVMNode)rootNode, new IVMNode[]{expressionManagerNode});
        RegisterGroupVMNode registerGroupNode = new RegisterGroupVMNode((AbstractDMVMProvider)this, this.getSession(), syncRegDataAccess);
        RegisterVMNode registerNode = new RegisterVMNode(prefStore, this, this.getSession(), syncRegDataAccess);
        this.addChildNodes(registerGroupNode, new IExpressionVMNode[]{registerNode});
        RegisterBitFieldVMNode bitFieldNode = new RegisterBitFieldVMNode(prefStore, this, this.getSession(), syncRegDataAccess);
        this.addChildNodes(registerNode, new IVMNode[]{bitFieldNode});
        VariableVMNode variableNode = new VariableVMNode(prefStore, this, this.getSession(), syncvarDataAccess);
        this.addChildNodes(variableNode, new IExpressionVMNode[]{variableNode});
        this.setExpressionNodes(new IExpressionVMNode[]{registerGroupNode, variableNode});
        this.setRootNode((IRootVMNode)rootNode);
    }

    public IExpressionVMNode findNodeToParseExpression(IExpressionVMNode parentNode, IExpression expression) {
        IExpressionVMNode[] childNOdes = parentNode == null ? this.getExpressionNodes() : this.getChildVMNodes(parentNode);
        for (IExpressionVMNode childNode : childNOdes) {
            IExpressionVMNode matchingNode;
            if (!(childNode instanceof IExpressionVMNode)) continue;
            IExpressionVMNode childExpressionNode = childNode;
            if (childExpressionNode.canParseExpression(expression)) {
                return childExpressionNode;
            }
            if (childExpressionNode.equals(parentNode) || (matchingNode = this.findNodeToParseExpression(childExpressionNode, expression)) == null) continue;
            return matchingNode;
        }
        return null;
    }

    public void dispose() {
        DebugPlugin.getDefault().getExpressionManager().removeExpressionListener((IExpressionsListener)this);
        this.getPresentationContext().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    public IColumnPresentation createColumnPresentation(IPresentationContext context, Object element) {
        return new ExpressionColumnPresentation();
    }

    public String getColumnPresentationId(IPresentationContext context, Object element) {
        return "org.eclipse.dd.dsf.debug.ui.EXPRESSION_COLUMN_PRESENTATION_ID";
    }

    protected IVMUpdatePolicy[] createUpdateModes() {
        return new IVMUpdatePolicy[]{new AutomaticUpdatePolicy(), new ManualUpdatePolicy(), new BreakpointHitUpdatePolicy()};
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.handleEvent(event);
    }

    public void expressionsAdded(IExpression[] expressions) {
        this.expressionsListChanged(ExpressionsChangedEvent.Type.ADDED);
    }

    public void expressionsRemoved(IExpression[] expressions) {
        this.expressionsListChanged(ExpressionsChangedEvent.Type.REMOVED);
    }

    public void expressionsInserted(IExpression[] expressions, int index) {
        this.expressionsListChanged(ExpressionsChangedEvent.Type.INSERTED);
    }

    public void expressionsMoved(IExpression[] expressions, int index) {
        this.expressionsListChanged(ExpressionsChangedEvent.Type.MOVED);
    }

    public void expressionsChanged(IExpression[] expressions) {
        HashSet<Object> expressionsSet = new HashSet<Object>();
        expressionsSet.addAll(Arrays.asList(expressions));
        this.handleEvent((Object)new ExpressionsChangedEvent(ExpressionsChangedEvent.Type.CHANGED, expressionsSet));
    }

    private void expressionsListChanged(ExpressionsChangedEvent.Type type) {
        HashSet<Object> rootElements = new HashSet<Object>();
        for (IVMModelProxy proxy : this.getActiveModelProxies()) {
            rootElements.add(proxy.getRootElement());
        }
        this.handleEvent((Object)new ExpressionsChangedEvent(type, rootElements));
    }

    protected boolean canSkipHandlingEvent(Object newEvent, Object eventToSkip) {
        return newEvent instanceof IRunControl.ISuspendedDMEvent;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExpressionsChangedEvent
    extends UserEditEvent {
        public final Type fType;

        public ExpressionsChangedEvent(Type type, Set<Object> elements) {
            super(elements);
            this.fType = type;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum Type {
            ADDED,
            CHANGED,
            REMOVED,
            MOVED,
            INSERTED;

        }
    }
}

