/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.modules;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.internal.ui.DsfDebugUIPlugin;
import org.eclipse.dd.dsf.debug.service.IModules;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.AbstractDMVMNode;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;

public class ModulesVMNode
extends AbstractDMVMNode
implements IElementLabelProvider {
    public ModulesVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session, IModules.IModuleDMContext.class);
    }

    protected void updateElementsInSessionThread(final IChildrenUpdate update) {
        IModules modulesService = (IModules)this.getServicesTracker().getService(IModules.class);
        IModules.ISymbolDMContext symDmc = (IModules.ISymbolDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IModules.ISymbolDMContext.class);
        if (modulesService == null || symDmc == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
        }
        modulesService.getModules(symDmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IModules.IModuleDMContext[]>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

            public void handleCompleted() {
                if (!this.isSuccess()) {
                    update.done();
                    return;
                }
                ModulesVMNode.this.fillUpdateWithVMCs(update, (IDMContext[])this.getData());
                update.done();
            }
        });
    }

    protected IDMVMContext createVMContext(IDMContext dmc) {
        return new ModuleVMContext(dmc);
    }

    public void update(final ILabelUpdate[] updates) {
        try {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    ModulesVMNode.this.updateLabelInSessionThread(updates);
                }
            });
        }
        catch (RejectedExecutionException e) {
            for (ILabelUpdate update : updates) {
                this.handleFailedUpdate((IViewerUpdate)update);
            }
        }
    }

    protected void updateLabelInSessionThread(ILabelUpdate[] updates) {
        for (final ILabelUpdate update : updates) {
            IModules modulesService = (IModules)this.getServicesTracker().getService(IModules.class);
            final IModules.IModuleDMContext dmc = (IModules.IModuleDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IModules.IModuleDMContext.class);
            if (modulesService == null || dmc == null) {
                this.handleFailedUpdate((IViewerUpdate)update);
                continue;
            }
            update.setImageDescriptor(DsfDebugUIPlugin.getImageDescriptor("icons/library_syms_obj.gif"), 0);
            modulesService.getModuleData(dmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IModules.IModuleDMData>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

                protected void handleCompleted() {
                    if (!this.isSuccess()) {
                        assert (this.getStatus().isOK() || this.getStatus().getCode() != 10005 || this.getStatus().getCode() != 10003);
                        ModulesVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                    String[] localColumns = update.getColumnIds();
                    if (localColumns == null) {
                        localColumns = new String[]{null};
                    }
                    for (int i = 0; i < localColumns.length; ++i) {
                        ModulesVMNode.this.fillColumnLabel(dmc, (IModules.IModuleDMData)this.getData(), localColumns[i], i, update);
                    }
                    update.done();
                }
            });
        }
    }

    protected void fillColumnLabel(IModules.IModuleDMContext dmContext, IModules.IModuleDMData dmData, String columnId, int idx, ILabelUpdate update) {
        if (columnId == null) {
            update.setLabel(dmData.getName(), idx);
        }
    }

    public int getDeltaFlags(Object e) {
        if (e instanceof IRunControl.ISuspendedDMEvent) {
            return 1024;
        }
        return 0;
    }

    public void buildDelta(Object e, VMDelta parentDelta, int nodeOffset, RequestMonitor rm) {
        if (e instanceof IRunControl.ISuspendedDMEvent) {
            parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        }
        rm.done();
    }

    public class ModuleVMContext
    extends AbstractDMVMNode.DMVMContext {
        protected ModuleVMContext(IDMContext dmc) {
            super((AbstractDMVMNode)ModulesVMNode.this, dmc);
        }
    }
}

