/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.expression;

import java.util.Map;
import org.eclipse.dd.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.expression.ExpressionVMProvider;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.expression.IExpressionVMNode;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.expression.VMExpressionUpdate;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.DefaultVMModelProxyStrategy;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.jface.viewers.TreePath;

public class ExpressionVMProviderModelProxyStrategy
extends DefaultVMModelProxyStrategy {
    public ExpressionVMProviderModelProxyStrategy(ExpressionVMProvider provider, Object rootElement) {
        super((AbstractVMProvider)provider, rootElement);
    }

    private ExpressionVMProvider getExpressionVMProvider() {
        return (ExpressionVMProvider)this.getVMProvider();
    }

    public int getDeltaFlagsForExpression(IExpression expression, Object event) {
        IExpressionVMNode matchingNode = this.getExpressionVMProvider().findNodeToParseExpression(null, expression);
        if (matchingNode != null) {
            return this.getNodeDeltaFlagsForExpression(matchingNode, expression, event);
        }
        return 0;
    }

    private int getNodeDeltaFlagsForExpression(IExpressionVMNode node, IExpression expression, Object event) {
        int flags = node.getDeltaFlagsForExpression(expression, event);
        IExpressionVMNode matchingNode = this.getExpressionVMProvider().findNodeToParseExpression(node, expression);
        if (matchingNode != null && !matchingNode.equals(node)) {
            flags |= this.getNodeDeltaFlagsForExpression(matchingNode, expression, event);
        }
        return flags;
    }

    public void buildDeltaForExpression(IExpression expression, int expressionElementIdx, Object event, VMDelta parentDelta, TreePath path, RequestMonitor rm) {
        IExpressionVMNode matchingNode = this.getExpressionVMProvider().findNodeToParseExpression(null, expression);
        if (matchingNode != null) {
            this.buildNodeDeltaForExpression(matchingNode, expression, expressionElementIdx, event, parentDelta, path, rm);
        } else {
            rm.done();
        }
    }

    private void buildNodeDeltaForExpression(final IExpressionVMNode node, final IExpression expression, final int expressionElementIdx, final Object event, final VMDelta parentDelta, final TreePath path, final RequestMonitor rm) {
        node.buildDeltaForExpression(expression, expressionElementIdx, event, parentDelta, path, new RequestMonitor(this.getVMProvider().getExecutor(), rm){

            protected void handleSuccess() {
                IExpressionVMNode matchingNode = ExpressionVMProviderModelProxyStrategy.this.getExpressionVMProvider().findNodeToParseExpression(node, expression);
                if (matchingNode != null && !matchingNode.equals(node)) {
                    ExpressionVMProviderModelProxyStrategy.this.buildNodeDeltaForExpression(matchingNode, expression, expressionElementIdx, event, parentDelta, path, rm);
                } else {
                    ExpressionVMProviderModelProxyStrategy.this.getExpressionVMProvider().update(new VMExpressionUpdate((IModelDelta)parentDelta, ExpressionVMProviderModelProxyStrategy.this.getVMProvider().getPresentationContext(), expression, new DataRequestMonitor<Object>(ExpressionVMProviderModelProxyStrategy.this.getVMProvider().getExecutor(), rm){

                        protected void handleSuccess() {
                            ExpressionVMProviderModelProxyStrategy.this.buildDeltaForExpressionElement(node, this.getData(), expressionElementIdx, event, parentDelta, path, rm);
                        }

                        protected void handleErrorOrWarning() {
                            rm.done();
                        }
                    }));
                }
            }
        });
    }

    private void buildDeltaForExpressionElement(IExpressionVMNode node, Object expressionElement, int expressionElementIdx, Object event, VMDelta parentDelta, TreePath path, RequestMonitor rm) {
        CountingRequestMonitor multiRm = new CountingRequestMonitor(this.getVMProvider().getExecutor(), rm);
        int multiRmCount = 0;
        node.buildDeltaForExpressionElement(expressionElement, expressionElementIdx, event, parentDelta, (RequestMonitor)multiRm);
        ++multiRmCount;
        Map childNodesWithDeltaFlags = this.getChildNodesWithDeltaFlags(node, (ModelDelta)parentDelta, event);
        if (childNodesWithDeltaFlags.size() != 0) {
            this.callChildNodesToBuildDelta(node, childNodesWithDeltaFlags, parentDelta.addNode(expressionElement, expressionElementIdx, 0), event, (RequestMonitor)multiRm);
            ++multiRmCount;
        }
        multiRm.setDoneCount(multiRmCount);
    }
}

