/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.register;

import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.expression.WatchExpressionCellModifier;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.numberformat.IFormattedValuePreferenceStore;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.register.SyncRegisterDataAccess;
import org.eclipse.dd.dsf.debug.service.IRegisters;
import org.eclipse.dd.dsf.ui.viewmodel.IVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.update.AbstractCachingVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.update.UserEditEvent;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;

public class RegisterCellModifier
extends WatchExpressionCellModifier {
    private AbstractCachingVMProvider fProvider;
    private SyncRegisterDataAccess fDataAccess = null;
    private IFormattedValuePreferenceStore fFormattedValuePreferenceStore;

    public RegisterCellModifier(AbstractCachingVMProvider provider, IFormattedValuePreferenceStore formattedValuePreferenceStore, SyncRegisterDataAccess access) {
        this.fProvider = provider;
        this.fDataAccess = access;
        this.fFormattedValuePreferenceStore = formattedValuePreferenceStore;
    }

    public SyncRegisterDataAccess getRegisterDataAccess() {
        return this.fDataAccess;
    }

    public IFormattedValuePreferenceStore getPreferenceStore() {
        return this.fFormattedValuePreferenceStore;
    }

    protected IRegisters.IRegisterDMContext getRegisterDMC(Object element) {
        if (element instanceof IDMVMContext) {
            IDMContext dmc = ((IDMVMContext)element).getDMContext();
            return (IRegisters.IRegisterDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IRegisters.IRegisterDMContext.class);
        }
        return null;
    }

    public boolean canModify(Object element, String property) {
        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(property)) {
            if (this.getRegisterDMC(element) == null) {
                return false;
            }
            IRegisters.IRegisterDMData regData = this.fDataAccess.readRegister(element);
            return regData == null || regData.isWriteable();
        }
        return super.canModify(element, property);
    }

    public Object getValue(Object element, String property) {
        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(property)) {
            String formatId;
            if (element instanceof IVMContext) {
                IVMContext ctx = (IVMContext)element;
                IPresentationContext presCtx = ctx.getVMNode().getVMProvider().getPresentationContext();
                formatId = this.fFormattedValuePreferenceStore.getCurrentNumericFormat(presCtx);
            } else {
                formatId = "NATURAL.Format";
            }
            String value = this.fDataAccess.getFormattedRegisterValue(element, formatId);
            if (value == null) {
                return "...";
            }
            return value;
        }
        return super.getValue(element, property);
    }

    public void modify(Object element, String property, Object value) {
        if ("org.eclipse.dd.dsf.debug.ui.COLUMN_ID__VALUE".equals(property)) {
            if (value instanceof String) {
                String formatId;
                if (element instanceof IVMContext) {
                    IVMContext ctx = (IVMContext)element;
                    IPresentationContext presCtx = ctx.getVMNode().getVMProvider().getPresentationContext();
                    formatId = this.fFormattedValuePreferenceStore.getCurrentNumericFormat(presCtx);
                } else {
                    formatId = "NATURAL.Format";
                }
                this.fDataAccess.writeRegister(element, (String)value, formatId);
                this.fProvider.handleEvent((Object)new UserEditEvent(element));
            }
        } else {
            super.modify(element, property, value);
        }
    }
}

