/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.ui.viewmodel.actions;

import java.util.ArrayList;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.actions.VMHandlerUtils;
import org.eclipse.dd.dsf.debug.internal.ui.viewmodel.actions.MessagesForVMActions;
import org.eclipse.dd.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.update.ICachingVMProviderExtension;
import org.eclipse.dd.dsf.ui.viewmodel.update.IVMUpdateScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class UpdateScopesContribution
extends CompoundContributionItem
implements IWorkbenchContribution {
    private IServiceLocator fServiceLocator;
    private static IContributionItem[] NO_BREAKPOINT_TYPES_CONTRIBUTION_ITEMS = new IContributionItem[]{new ContributionItem(){

        public void fill(Menu menu, int index) {
            MenuItem item = new MenuItem(menu, 0);
            item.setEnabled(false);
            item.setText(MessagesForVMActions.UpdateScopesContribution_EmptyScopesList_label);
        }

        public boolean isEnabled() {
            return false;
        }
    }};

    protected IContributionItem[] getContributionItems() {
        IVMProvider provider = VMHandlerUtils.getActiveVMProvider(this.fServiceLocator);
        if (provider == null || !(provider instanceof ICachingVMProviderExtension)) {
            return NO_BREAKPOINT_TYPES_CONTRIBUTION_ITEMS;
        }
        ICachingVMProviderExtension cachingProvider = (ICachingVMProviderExtension)provider;
        IVMUpdateScope[] scopes = cachingProvider.getAvailableUpdateScopes();
        IVMUpdateScope activeScope = cachingProvider.getActiveUpdateScope();
        ArrayList<SelectUpdateScopeAction> actions = new ArrayList<SelectUpdateScopeAction>(scopes.length);
        for (IVMUpdateScope scope : scopes) {
            SelectUpdateScopeAction action = new SelectUpdateScopeAction(cachingProvider, scope);
            if (scope.getID().equals(activeScope.getID())) {
                action.setChecked(true);
            }
            actions.add(action);
        }
        if (actions.isEmpty()) {
            return NO_BREAKPOINT_TYPES_CONTRIBUTION_ITEMS;
        }
        IContributionItem[] items = new IContributionItem[actions.size()];
        for (int i = 0; i < actions.size(); ++i) {
            items[i] = new ActionContributionItem((IAction)actions.get(i));
        }
        return items;
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.fServiceLocator = serviceLocator;
    }

    private class SelectUpdateScopeAction
    extends Action {
        private final ICachingVMProviderExtension fProvider;
        private final IVMUpdateScope fScope;

        SelectUpdateScopeAction(ICachingVMProviderExtension provider, IVMUpdateScope scope) {
            super(scope.getName(), 8);
            this.fProvider = provider;
            this.fScope = scope;
        }

        public void run() {
            if (this.isChecked()) {
                this.fProvider.setActiveUpdateScope(this.fScope);
            }
        }
    }
}

