/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.service;

import java.math.BigInteger;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMData;
import org.eclipse.dd.dsf.datamodel.IDMEvent;
import org.eclipse.dd.dsf.datamodel.IDMService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IModules
extends IDMService {
    public void getModules(IDMContext<?> var1, DataRequestMonitor<IModuleDMContext[]> var2);

    public void calcLineInfo(IDMContext<?> var1, IAddress var2, DataRequestMonitor<LineInfo[]> var3);

    public void calcAddressInfo(IDMContext<?> var1, String var2, int var3, int var4, DataRequestMonitor<AddressRange[]> var5);

    public static interface AddressRange {
        public IAddress getStartAddress();

        public IAddress getEndAddress();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IModuleDMContext
    extends IDMContext<IModuleDMData> {
    }

    public static interface IModuleDMData
    extends IDMData {
        public String getName();

        public String getFile();

        public long getTimeStamp();

        public Section[] getSections();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ISymbolDMContext
    extends IDMContext<ISymbolDMData> {
    }

    public static interface ISymbolDMData
    extends IDMData {
        public long convertToRT(ModuleSectionOffset var1);

        public ModuleSectionOffset convertFromRT(IAddress var1);
    }

    public static interface LineInfo {
        public IAddress getAddress();

        public String getSourceFile();

        public int getStartLine();

        public int getStartColumn();

        public int getEndLine();

        public int getEndColumn();
    }

    public static interface ModuleLoadedDMEvent
    extends ModulesChangedDMEvent {
        public IModuleDMContext getLoadedModuleContext();
    }

    public static final class ModuleSectionOffset {
        private final IModuleDMContext fModule;
        private final Section fSection;
        private final BigInteger fOffset;

        public IModuleDMContext getModule() {
            return this.fModule;
        }

        public Section getSection() {
            return this.fSection;
        }

        public BigInteger getOffset() {
            return this.fOffset;
        }

        public ModuleSectionOffset(IModuleDMContext module, Section section, BigInteger offset) {
            this.fModule = module;
            this.fSection = section;
            this.fOffset = offset;
        }

        public int hashCode() {
            return this.fModule.hashCode() + this.fSection.hashCode() + this.fOffset.intValue();
        }

        public boolean equals(Object o) {
            if (!(o instanceof ModuleSectionOffset)) {
                return false;
            }
            ModuleSectionOffset mso = (ModuleSectionOffset)o;
            return this.fModule.equals(mso.fModule) && this.fSection.equals(mso.fSection) && this.fOffset.equals(mso.fOffset);
        }
    }

    public static interface ModuleUnloadedDMEvent
    extends ModulesChangedDMEvent {
        public IModuleDMContext getUnloadedModuleContext();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ModulesChangedDMEvent
    extends IDMEvent<ISymbolDMContext> {
    }

    public static interface Section {
        public String getName();

        public IAddress getStartAddress();

        public BigInteger getCount();
    }
}

