/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.service;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.IDMEvent;
import org.eclipse.dd.dsf.debug.internal.DsfDebugPlugin;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.service.AbstractDsfService;
import org.eclipse.dd.dsf.service.DsfServiceEventHandler;
import org.eclipse.dd.dsf.service.DsfSession;
import org.osgi.framework.BundleContext;

public class StepQueueManager
extends AbstractDsfService {
    public static final int STEPPING_TIMEOUT = 500;
    public static final int STEP_QUEUE_DEPTH = 3;
    private IRunControl fRunControl;
    private int fQueueDepth = 3;
    private Map<IRunControl.IExecutionDMContext, List<StepRequest>> fStepQueues = new HashMap<IRunControl.IExecutionDMContext, List<StepRequest>>();
    private Map<IRunControl.IExecutionDMContext, Boolean> fTimedOutFlags = new HashMap<IRunControl.IExecutionDMContext, Boolean>();
    private Map<IRunControl.IExecutionDMContext, ScheduledFuture<?>> fTimedOutFutures = new HashMap();

    public StepQueueManager(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            protected void handleOK() {
                StepQueueManager.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.fRunControl = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
        this.getSession().addServiceEventListener((Object)this, null);
        this.register(new String[]{StepQueueManager.class.getName()}, new Hashtable());
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        this.getSession().removeServiceEventListener((Object)this);
        super.shutdown(requestMonitor);
    }

    protected BundleContext getBundleContext() {
        return DsfDebugPlugin.getBundleContext();
    }

    public boolean canEnqueueStep(IRunControl.IExecutionDMContext execCtx) {
        return this.fRunControl.isSuspended(execCtx) && this.fRunControl.canStep(execCtx) || this.fRunControl.isStepping(execCtx) && !this.isSteppingTimedOut(execCtx);
    }

    public boolean canEnqueueInstructionStep(IRunControl.IExecutionDMContext execCtx) {
        return this.fRunControl.isSuspended(execCtx) && this.fRunControl.canInstructionStep(execCtx) || this.fRunControl.isStepping(execCtx) && !this.isSteppingTimedOut(execCtx);
    }

    public int getPendingStepCount(IRunControl.IExecutionDMContext execCtx) {
        List<StepRequest> stepQueue = this.fStepQueues.get(execCtx);
        if (stepQueue == null) {
            return 0;
        }
        return stepQueue.size();
    }

    public void enqueueStep(IRunControl.IExecutionDMContext execCtx, IRunControl.StepType stepType) {
        if (this.fRunControl.canStep(execCtx)) {
            this.fRunControl.step(execCtx, stepType, new RequestMonitor((Executor)this.getExecutor(), null));
        } else if (this.canEnqueueStep(execCtx)) {
            List<StepRequest> stepQueue = this.fStepQueues.get(execCtx);
            if (stepQueue == null) {
                stepQueue = new LinkedList<StepRequest>();
                this.fStepQueues.put(execCtx, stepQueue);
            }
            if (stepQueue.size() < this.fQueueDepth) {
                stepQueue.add(new StepRequest(stepType, false));
            }
        }
    }

    public void enqueueInstructionStep(IRunControl.IExecutionDMContext execCtx, IRunControl.StepType stepType) {
        if (this.fRunControl.canInstructionStep(execCtx)) {
            this.fRunControl.instructionStep(execCtx, stepType, new RequestMonitor((Executor)this.getExecutor(), null));
        } else if (this.canEnqueueInstructionStep(execCtx)) {
            List<StepRequest> stepQueue = this.fStepQueues.get(execCtx);
            if (stepQueue == null) {
                stepQueue = new LinkedList<StepRequest>();
                this.fStepQueues.put(execCtx, stepQueue);
            }
            if (stepQueue.size() < this.fQueueDepth) {
                stepQueue.add(new StepRequest(stepType, true));
            }
        }
    }

    public boolean isSteppingTimedOut(IRunControl.IExecutionDMContext execCtx) {
        return this.fTimedOutFlags.containsKey(execCtx) ? this.fTimedOutFlags.get(execCtx) : false;
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        this.fTimedOutFlags.remove(e.getDMContext());
        ScheduledFuture<?> future = this.fTimedOutFutures.remove(e.getDMContext());
        if (future != null) {
            future.cancel(false);
        }
        if (this.fStepQueues.containsKey(e.getDMContext())) {
            List<StepRequest> queue = this.fStepQueues.get(e.getDMContext());
            StepRequest request = queue.remove(queue.size() - 1);
            if (queue.isEmpty()) {
                this.fStepQueues.remove(e.getDMContext());
            }
            if (request.fIsInstructionStep) {
                if (this.fRunControl.canInstructionStep((IRunControl.IExecutionDMContext)e.getDMContext())) {
                    this.fRunControl.instructionStep((IRunControl.IExecutionDMContext)e.getDMContext(), request.fStepType, new RequestMonitor((Executor)this.getExecutor(), null));
                } else {
                    this.fStepQueues.remove(e.getDMContext());
                }
            } else if (this.fRunControl.canStep((IRunControl.IExecutionDMContext)e.getDMContext())) {
                this.fRunControl.step((IRunControl.IExecutionDMContext)e.getDMContext(), request.fStepType, new RequestMonitor((Executor)this.getExecutor(), null));
            } else {
                this.fStepQueues.remove(e.getDMContext());
            }
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(final IRunControl.IResumedDMEvent e) {
        if (e.getReason().equals((Object)IRunControl.StateChangeReason.STEP)) {
            this.fTimedOutFlags.put((IRunControl.IExecutionDMContext)e.getDMContext(), Boolean.FALSE);
            assert (!this.fTimedOutFutures.containsKey(e.getDMContext()));
            this.fTimedOutFutures.put((IRunControl.IExecutionDMContext)e.getDMContext(), this.getExecutor().schedule((Runnable)new DsfRunnable(){

                public void run() {
                    StepQueueManager.this.fTimedOutFutures.remove(e.getDMContext());
                    StepQueueManager.this.getSession().dispatchEvent((Object)new ISteppingTimedOutEvent(){

                        public IRunControl.IExecutionDMContext getDMContext() {
                            return (IRunControl.IExecutionDMContext)e.getDMContext();
                        }
                    }, StepQueueManager.this.getProperties());
                }
            }, 500L, TimeUnit.MILLISECONDS));
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(ISteppingTimedOutEvent e) {
        this.fTimedOutFlags.put((IRunControl.IExecutionDMContext)e.getDMContext(), Boolean.TRUE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ISteppingTimedOutEvent
    extends IDMEvent<IRunControl.IExecutionDMContext> {
    }

    private static class StepRequest {
        IRunControl.StepType fStepType;
        boolean fIsInstructionStep;

        StepRequest(IRunControl.StepType type, boolean instruction) {
            this.fStepType = type;
            this.fIsInstructionStep = instruction;
        }
    }
}

