/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.gdb.ui;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.dd.dsf.concurrent.Immutable;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;
import org.eclipse.dd.dsf.debug.ui.actions.DsfResumeCommand;
import org.eclipse.dd.dsf.debug.ui.actions.DsfStepIntoCommand;
import org.eclipse.dd.dsf.debug.ui.actions.DsfStepOverCommand;
import org.eclipse.dd.dsf.debug.ui.actions.DsfStepReturnCommand;
import org.eclipse.dd.dsf.debug.ui.actions.DsfSuspendCommand;
import org.eclipse.dd.dsf.debug.ui.actions.DsfTerminateCommand;
import org.eclipse.dd.dsf.debug.ui.sourcelookup.MISourceDisplayAdapter;
import org.eclipse.dd.dsf.gdb.launching.GdbLaunch;
import org.eclipse.dd.dsf.gdb.ui.GdbViewModelAdapter;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.commands.IResumeHandler;
import org.eclipse.debug.core.commands.IStepIntoHandler;
import org.eclipse.debug.core.commands.IStepOverHandler;
import org.eclipse.debug.core.commands.IStepReturnHandler;
import org.eclipse.debug.core.commands.ISuspendHandler;
import org.eclipse.debug.core.commands.ITerminateHandler;
import org.eclipse.debug.core.model.IDebugModelProvider;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentationFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxyFactory;
import org.eclipse.debug.ui.sourcelookup.ISourceDisplay;

@ThreadSafe
public class GdbAdapterFactory
implements IAdapterFactory,
DsfSession.SessionEndedListener,
ILaunchesListener2 {
    private Map<String, SessionAdapterSet> fSessionAdapterSetMap = Collections.synchronizedMap(new HashMap());

    public GdbAdapterFactory() {
        DsfSession.addSessionEndedListener((DsfSession.SessionEndedListener)this);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAdapter(Object adaptableObject, Class adapterType) {
        SessionAdapterSet adapterSet;
        if (!(adaptableObject instanceof GdbLaunch)) {
            return null;
        }
        GdbLaunch launch = (GdbLaunch)adaptableObject;
        DsfSession session = launch.getSession();
        if (session == null) {
            return null;
        }
        Map<String, SessionAdapterSet> map = this.fSessionAdapterSetMap;
        synchronized (map) {
            adapterSet = this.fSessionAdapterSetMap.get(session.getId());
            if (adapterSet == null) {
                adapterSet = new SessionAdapterSet(session, launch);
                this.fSessionAdapterSetMap.put(session.getId(), adapterSet);
            }
        }
        if (adapterType.equals(IElementContentProvider.class)) {
            return adapterSet.fViewModelAdapter;
        }
        if (adapterType.equals(IModelProxyFactory.class)) {
            return adapterSet.fViewModelAdapter;
        }
        if (adapterType.equals(IColumnPresentationFactory.class)) {
            return adapterSet.fViewModelAdapter;
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{IElementContentProvider.class, IModelProxyFactory.class, IColumnPresentationFactory.class};
    }

    public void sessionEnded(DsfSession session) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchesRemoved(ILaunch[] launches) {
        for (ILaunch launch : launches) {
            if (!(launch instanceof GdbLaunch)) continue;
            DsfSession session = ((GdbLaunch)launch).getSession();
            Map<String, SessionAdapterSet> map = this.fSessionAdapterSetMap;
            synchronized (map) {
                if (this.fSessionAdapterSetMap.containsKey(session.getId())) {
                    this.fSessionAdapterSetMap.get(session.getId()).dispose();
                    this.fSessionAdapterSetMap.remove(session);
                }
            }
        }
    }

    public void launchesTerminated(ILaunch[] launches) {
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    @Immutable
    class SessionAdapterSet {
        private final DsfSession fSession;
        final GdbViewModelAdapter fViewModelAdapter;
        final MISourceDisplayAdapter fSourceDisplayAdapter;
        final DsfStepIntoCommand fStepIntoCommand;
        final DsfStepOverCommand fStepOverCommand;
        final DsfStepReturnCommand fStepReturnCommand;
        final DsfSuspendCommand fSuspendCommand;
        final DsfResumeCommand fResumeCommand;
        final DsfTerminateCommand fTerminateCommand;
        final IDebugModelProvider fDebugModelProvider;
        final GdbLaunch fLaunch;

        SessionAdapterSet(DsfSession session, GdbLaunch launch) {
            this.fSession = session;
            this.fViewModelAdapter = new GdbViewModelAdapter(session, launch);
            this.fSourceDisplayAdapter = launch.getSourceLocator() instanceof ISourceLookupDirector ? new MISourceDisplayAdapter(session, (ISourceLookupDirector)launch.getSourceLocator()) : null;
            session.registerModelAdapter(ISourceDisplay.class, (Object)this.fSourceDisplayAdapter);
            this.fStepIntoCommand = new DsfStepIntoCommand(session);
            this.fStepOverCommand = new DsfStepOverCommand(session);
            this.fStepReturnCommand = new DsfStepReturnCommand(session);
            this.fSuspendCommand = new DsfSuspendCommand(session);
            this.fResumeCommand = new DsfResumeCommand(session);
            this.fTerminateCommand = new DsfTerminateCommand(session);
            session.registerModelAdapter(IStepIntoHandler.class, (Object)this.fStepIntoCommand);
            session.registerModelAdapter(IStepOverHandler.class, (Object)this.fStepOverCommand);
            session.registerModelAdapter(IStepReturnHandler.class, (Object)this.fStepReturnCommand);
            session.registerModelAdapter(ISuspendHandler.class, (Object)this.fSuspendCommand);
            session.registerModelAdapter(IResumeHandler.class, (Object)this.fResumeCommand);
            session.registerModelAdapter(ITerminateHandler.class, (Object)this.fTerminateCommand);
            this.fDebugModelProvider = new IDebugModelProvider(){

                public String[] getModelIdentifiers() {
                    return new String[]{CDIDebugModel.getPluginIdentifier()};
                }
            };
            session.registerModelAdapter(IDebugModelProvider.class, (Object)this.fDebugModelProvider);
            this.fLaunch = launch;
            session.registerModelAdapter(ILaunch.class, (Object)this.fLaunch);
        }

        void dispose() {
            this.fViewModelAdapter.dispose();
            this.fSession.unregisterModelAdapter(ISourceDisplay.class);
            if (this.fSourceDisplayAdapter != null) {
                this.fSourceDisplayAdapter.dispose();
            }
            this.fSession.unregisterModelAdapter(IStepIntoHandler.class);
            this.fSession.unregisterModelAdapter(IStepOverHandler.class);
            this.fSession.unregisterModelAdapter(IStepReturnHandler.class);
            this.fSession.unregisterModelAdapter(ISuspendHandler.class);
            this.fSession.unregisterModelAdapter(IResumeHandler.class);
            this.fSession.unregisterModelAdapter(ITerminateHandler.class);
            this.fStepIntoCommand.dispose();
            this.fStepOverCommand.dispose();
            this.fStepReturnCommand.dispose();
            this.fSuspendCommand.dispose();
            this.fResumeCommand.dispose();
            this.fTerminateCommand.dispose();
        }
    }
}

