/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.gdb.ui.viewmodel.launch;

import java.util.concurrent.Executor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMEvent;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.gdb.service.GDBRunControl;
import org.eclipse.dd.dsf.gdb.service.control.GDBControl;
import org.eclipse.dd.dsf.gdb.service.control.GDBControlDMContext;
import org.eclipse.dd.dsf.mi.event.DsfMIInferiorExitEvent;
import org.eclipse.dd.dsf.mi.event.DsfMIInferiorSignalExitEvent;
import org.eclipse.dd.dsf.mi.service.control.AbstractMIControl;
import org.eclipse.dd.dsf.mi.service.control.MIControlDMContext;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.dd.dsf.ui.viewmodel.dm.AbstractDMVMLayoutNode;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.DebugUITools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerLayoutNode
extends AbstractDMVMLayoutNode {
    public ContainerLayoutNode(AbstractVMProvider provider, DsfSession session) {
        super(provider, session, IRunControl.IExecutionDMContext.class);
    }

    protected void updateElementsInSessionThread(IChildrenUpdate update) {
        if (!this.checkService(AbstractMIControl.class, null, (IViewerUpdate)update)) {
            return;
        }
        MIControlDMContext containerCtx = ((AbstractMIControl)this.getServicesTracker().getService(AbstractMIControl.class)).getControlDMContext();
        update.setChild((Object)new AbstractDMVMLayoutNode.DMVMContext((AbstractDMVMLayoutNode)this, (IDMContext)containerCtx), 0);
        update.done();
    }

    protected void updateLabelInSessionThread(ILabelUpdate[] updates) {
        for (final ILabelUpdate update : updates) {
            if (!this.checkService(GDBRunControl.class, null, (IViewerUpdate)update)) continue;
            GDBRunControl runControl = (GDBRunControl)this.getServicesTracker().getService(GDBRunControl.class);
            GDBControlDMContext dmc = (GDBControlDMContext)this.findDmcInPath(update.getElementPath(), GDBControlDMContext.class);
            String imageKey = null;
            imageKey = runControl.isSuspended((IRunControl.IExecutionDMContext)dmc) ? "IMG_OBJS_THREAD_SUSPENDED" : "IMG_OBJS_THREAD_RUNNING";
            update.setImageDescriptor(DebugUITools.getImageDescriptor((String)imageKey), 0);
            runControl.getProcessData(dmc, (DataRequestMonitor)new DataRequestMonitor<GDBRunControl.GDBProcessData>((Executor)this.getExecutor(), null){

                public void handleCompleted() {
                    if (!this.getStatus().isOK()) {
                        update.done();
                        return;
                    }
                    update.setLabel(((GDBRunControl.GDBProcessData)this.getData()).getName(), 0);
                    update.done();
                }
            });
        }
    }

    protected int getNodeDeltaFlagsForDMEvent(IDMEvent<?> e) {
        if (e instanceof IRunControl.IStartedDMEvent || e instanceof IRunControl.IExitedDMEvent) {
            return 1024;
        }
        if (e instanceof IRunControl.IContainerResumedDMEvent || e instanceof IRunControl.IContainerSuspendedDMEvent) {
            return 2048;
        }
        if (e instanceof GDBControl.ExitedEvent || e instanceof DsfMIInferiorExitEvent || e instanceof DsfMIInferiorSignalExitEvent) {
            return 1024;
        }
        return 0;
    }

    protected void buildDeltaForDMEvent(IDMEvent<?> e, VMDelta parentDelta, int nodeOffset, RequestMonitor requestMonitor) {
        if (e instanceof IRunControl.IContainerResumedDMEvent || e instanceof IRunControl.IContainerSuspendedDMEvent) {
            parentDelta.addNode((Object)new AbstractDMVMLayoutNode.DMVMContext((AbstractDMVMLayoutNode)this, e.getDMContext()), 2048);
        } else if (e instanceof IRunControl.IStartedDMEvent || e instanceof IRunControl.IExitedDMEvent) {
            parentDelta.addNode((Object)new AbstractDMVMLayoutNode.DMVMContext((AbstractDMVMLayoutNode)this, e.getDMContext()), 1024);
        } else if (e instanceof GDBControl.ExitedEvent || e instanceof DsfMIInferiorExitEvent || e instanceof DsfMIInferiorSignalExitEvent) {
            parentDelta.addNode((Object)new AbstractDMVMLayoutNode.DMVMContext((AbstractDMVMLayoutNode)this, e.getDMContext()), 1024);
        }
        super.buildDeltaForDMEvent(e, parentDelta, nodeOffset, requestMonitor);
    }
}

