/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.gdb.ui.viewmodel.launch;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.MultiRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMEvent;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.gdb.service.GDBRunControl;
import org.eclipse.dd.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMLayoutNode;
import org.eclipse.dd.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.dd.dsf.ui.viewmodel.IVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.VMDelta;
import org.eclipse.dd.dsf.ui.viewmodel.dm.AbstractDMVMLayoutNode;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.DebugUITools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadLayoutNode
extends AbstractDMVMLayoutNode {
    public ThreadLayoutNode(AbstractVMProvider provider, DsfSession session) {
        super(provider, session, IRunControl.IExecutionDMContext.class);
    }

    protected void updateElementsInSessionThread(final IChildrenUpdate update) {
        if (!this.checkService(IRunControl.class, null, (IViewerUpdate)update)) {
            return;
        }
        IRunControl.IContainerDMContext contDmc = (IRunControl.IContainerDMContext)this.findDmcInPath(update.getElementPath(), IRunControl.IContainerDMContext.class);
        if (contDmc == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        ((IRunControl)this.getServicesTracker().getService(IRunControl.class)).getExecutionContexts(contDmc, (DataRequestMonitor)new DataRequestMonitor<IRunControl.IExecutionDMContext[]>((Executor)this.getSession().getExecutor(), null){

            public void handleCompleted() {
                if (!this.getStatus().isOK()) {
                    ThreadLayoutNode.this.handleFailedUpdate((IViewerUpdate)update);
                    return;
                }
                ThreadLayoutNode.this.fillUpdateWithVMCs(update, (IDMContext[])this.getData());
                update.done();
            }
        });
    }

    protected void updateLabelInSessionThread(ILabelUpdate[] updates) {
        for (final ILabelUpdate update : updates) {
            if (!this.checkService(GDBRunControl.class, null, (IViewerUpdate)update)) continue;
            final GDBRunControl runControl = (GDBRunControl)this.getServicesTracker().getService(GDBRunControl.class);
            final IMIExecutionDMContext dmc = (IMIExecutionDMContext)this.findDmcInPath(update.getElementPath(), IMIExecutionDMContext.class);
            String imageKey = null;
            imageKey = ((IRunControl)this.getServicesTracker().getService(IRunControl.class)).isSuspended((IRunControl.IExecutionDMContext)dmc) ? "IMG_OBJS_THREAD_SUSPENDED" : "IMG_OBJS_THREAD_RUNNING";
            update.setImageDescriptor(DebugUITools.getImageDescriptor((String)imageKey), 0);
            runControl.getExecutionData((IRunControl.IExecutionDMContext)dmc, (DataRequestMonitor)new DataRequestMonitor<IRunControl.IExecutionDMData>((Executor)this.getSession().getExecutor(), null){

                public void handleCompleted() {
                    if (!this.getStatus().isOK()) {
                        ThreadLayoutNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                    if (!ThreadLayoutNode.this.checkService(GDBRunControl.class, null, (IViewerUpdate)update)) {
                        return;
                    }
                    if (((IRunControl.IExecutionDMData)this.getData()).getStateChangeReason() != null) {
                        final IRunControl.StateChangeReason reason = ((IRunControl.IExecutionDMData)this.getData()).getStateChangeReason();
                        runControl.getThreadData(dmc, (DataRequestMonitor)new DataRequestMonitor<GDBRunControl.GDBThreadData>((Executor)ThreadLayoutNode.this.getSession().getExecutor(), null){

                            public void handleCompleted() {
                                if (!this.getStatus().isOK()) {
                                    update.done();
                                    return;
                                }
                                StringBuilder builder = new StringBuilder("Thread[");
                                builder.append(dmc.getThreadId());
                                builder.append("] ");
                                builder.append(((GDBRunControl.GDBThreadData)this.getData()).getId());
                                builder.append(((GDBRunControl.GDBThreadData)this.getData()).getName());
                                if (((IRunControl)ThreadLayoutNode.this.getServicesTracker().getService(IRunControl.class)).isSuspended((IRunControl.IExecutionDMContext)dmc)) {
                                    builder.append(" (Suspended");
                                } else {
                                    builder.append(" (Running");
                                }
                                if (reason != null) {
                                    builder.append(" : ");
                                    builder.append(reason);
                                }
                                builder.append(")");
                                update.setLabel(builder.toString(), 0);
                                update.done();
                            }
                        });
                    }
                }
            });
        }
    }

    protected int getNodeDeltaFlagsForDMEvent(IDMEvent<?> e) {
        if (e instanceof IRunControl.IContainerResumedDMEvent || e instanceof IRunControl.IContainerSuspendedDMEvent || e instanceof IRunControl.IStartedDMEvent || e instanceof IRunControl.IExitedDMEvent) {
            return 1024;
        }
        if (e instanceof IRunControl.IResumedDMEvent || e instanceof IRunControl.ISuspendedDMEvent) {
            return 2048;
        }
        return 0;
    }

    protected void buildDeltaForDMEvent(final IDMEvent<?> e, final VMDelta parentDelta, final int nodeOffset, final RequestMonitor requestMonitor) {
        if (e instanceof IRunControl.IContainerResumedDMEvent || e instanceof IRunControl.IContainerSuspendedDMEvent) {
            final Map childNodeDeltas = this.getChildNodesWithDeltaFlags(e);
            if (childNodeDeltas.size() == 0) {
                requestMonitor.done();
                return;
            }
            this.updateElements((IChildrenUpdate)new AbstractVMLayoutNode.ElementsUpdate((AbstractVMLayoutNode)this, (DataRequestMonitor)new DataRequestMonitor<List<Object>>((Executor)this.getExecutor(), null){

                protected void handleCompleted() {
                    if (ThreadLayoutNode.this.isDisposed()) {
                        return;
                    }
                    if (!this.getStatus().isOK() || ((List)this.getData()).isEmpty()) {
                        requestMonitor.done();
                        return;
                    }
                    MultiRequestMonitor<RequestMonitor> elementsDeltasMultiRequestMon = new MultiRequestMonitor<RequestMonitor>((Executor)ThreadLayoutNode.this.getExecutor(), null){

                        protected void handleCompleted() {
                            if (ThreadLayoutNode.this.isDisposed()) {
                                return;
                            }
                            requestMonitor.done();
                        }
                    };
                    for (int i = 0; i < ((List)this.getData()).size(); ++i) {
                        IVMContext vmc = (IVMContext)((List)this.getData()).get(i);
                        VMDelta delta = parentDelta.addNode((Object)vmc, nodeOffset + i, 2048);
                        ThreadLayoutNode.this.callChildNodesToBuildDelta(childNodeDeltas, delta, e, elementsDeltasMultiRequestMon.add(new RequestMonitor((Executor)ThreadLayoutNode.this.getExecutor(), null, (MultiRequestMonitor)elementsDeltasMultiRequestMon){
                            final /* synthetic */ MultiRequestMonitor val$elementsDeltasMultiRequestMon;
                            {
                                this.val$elementsDeltasMultiRequestMon = multiRequestMonitor;
                                super(x0, x1);
                            }

                            protected void handleCompleted() {
                                this.val$elementsDeltasMultiRequestMon.requestMonitorDone((RequestMonitor)this);
                            }
                        }));
                    }
                }
            }, (IModelDelta)parentDelta));
            return;
        }
        if (e instanceof IRunControl.IResumedDMEvent || e instanceof IRunControl.ISuspendedDMEvent) {
            parentDelta.addNode((Object)new AbstractDMVMLayoutNode.DMVMContext((AbstractDMVMLayoutNode)this, e.getDMContext()), 2048);
            super.buildDeltaForDMEvent(e, parentDelta, nodeOffset, requestMonitor);
        } else {
            super.buildDeltaForDMEvent(e, parentDelta, nodeOffset, requestMonitor);
        }
    }
}

