/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.gdb.service;

import java.util.Hashtable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.AbstractDMContext;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.datamodel.IDMData;
import org.eclipse.dd.dsf.datamodel.IDMService;
import org.eclipse.dd.dsf.datamodel.ServiceDMContext;
import org.eclipse.dd.dsf.debug.service.INativeProcesses;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandControl;
import org.eclipse.dd.dsf.gdb.service.control.GDBControl;
import org.eclipse.dd.dsf.mi.core.command.DsfMIGDBExit;
import org.eclipse.dd.dsf.mi.core.output.DsfMIInfo;
import org.eclipse.dd.dsf.mi.service.MIRunControl;
import org.eclipse.dd.dsf.service.AbstractDsfService;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.gdb.DsfGdbPlugin;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GdbProcesses
extends AbstractDsfService
implements INativeProcesses {
    private IDMContext<GdbProcesses> fServiceContext;
    private GDBProcessDMC fProcessDMC;
    private ICommandControl fConnection;
    private MIRunControl fRunControl;

    public GdbProcesses(DsfSession session) {
        super(session);
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor(this.getExecutor(), requestMonitor){

            public void handleOK() {
                GdbProcesses.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.register(new String[]{INativeProcesses.class.getName(), GdbProcesses.class.getName()}, new Hashtable());
        this.fConnection = (ICommandControl)this.getServicesTracker().getService(ICommandControl.class);
        this.fRunControl = (MIRunControl)this.getServicesTracker().getService(MIRunControl.class);
        this.fServiceContext = new ServiceDMContext((IDMService)this, "#native_processes");
        this.fProcessDMC = new GDBProcessDMC(this);
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        super.shutdown(requestMonitor);
    }

    public IDMContext<?> getServiceContext() {
        return this.fServiceContext;
    }

    public boolean isValid() {
        return true;
    }

    public <V extends IDMData> void getModelData(IDMContext<V> dmc, DataRequestMonitor<V> rm) {
        if (dmc == this.fProcessDMC) {
            rm.setData((Object)this.getProcessData());
        } else if (dmc == this.fServiceContext) {
            rm.setData((Object)this);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10002, "Unknown DMC type", null));
        }
        rm.done();
    }

    protected BundleContext getBundleContext() {
        return DsfGdbPlugin.getBundleContext();
    }

    public void getProcessesBeingDebugged(DataRequestMonitor<INativeProcesses.IProcessDMContext[]> rm) {
        rm.setData((Object)new INativeProcesses.IProcessDMContext[]{this.fProcessDMC});
        rm.done();
    }

    private GDBProcessData getProcessData() {
        return new GDBProcessData();
    }

    public INativeProcesses.IThreadDMContext getThreadForExecutionContext(IRunControl.IExecutionDMContext execCtx) {
        if (execCtx.equals(this.fRunControl.getExecutionDMC())) {
            return this.fProcessDMC;
        }
        return null;
    }

    public void canTerminate(INativeProcesses.IThreadDMContext thread, DataRequestMonitor<Boolean> rm) {
        if (thread.equals((Object)this.fProcessDMC)) {
            rm.setData((Object)Boolean.TRUE);
        } else {
            rm.setData((Object)Boolean.FALSE);
        }
        rm.done();
    }

    public void terminate(INativeProcesses.IThreadDMContext thread, final RequestMonitor rm) {
        if (thread.equals((Object)this.fProcessDMC)) {
            DsfMIGDBExit cmd = new DsfMIGDBExit();
            this.fConnection.queueCommand((ICommand)cmd, (DataRequestMonitor)new DataRequestMonitor<DsfMIInfo>(this.getExecutor(), rm){

                public void handleOK() {
                    rm.done();
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10002, "Invalid thread context", null));
            rm.done();
        }
    }

    public void attachDebuggerToProcess(INativeProcesses.IProcessDMContext procCtx, RequestMonitor rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10003, "Operation not supported", null));
        rm.done();
    }

    public void debugNewProcess(String file, DataRequestMonitor<INativeProcesses.IProcessDMContext> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10003, "Operation not supported", null));
        rm.done();
    }

    public void getRunningProcesses(DataRequestMonitor<INativeProcesses.IProcessDMContext[]> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10003, "Operation not supported", null));
        rm.done();
    }

    public void runNewProcess(String file, DataRequestMonitor<INativeProcesses.IProcessDMContext> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10003, "Operation not supported", null));
        rm.done();
    }

    public INativeProcesses.IProcessDMContext getProcessDMC() {
        return this.fProcessDMC;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GDBProcessDMC
    extends AbstractDMContext<INativeProcesses.IThreadDMData>
    implements INativeProcesses.IProcessDMContext {
        public GDBProcessDMC(GdbProcesses service) {
            super((IDMService)service, new IDMContext[]{service.getServiceContext()});
        }

        public String toString() {
            return this.baseToString() + ".debug_process";
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        public int hashCode() {
            return ((Object)((Object)this)).getClass().hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GDBProcessData
    implements INativeProcesses.IThreadDMData {
        GDBProcessData() {
        }

        public boolean isValid() {
            return GdbProcesses.this.getServicesTracker() != null && GdbProcesses.this.getServicesTracker().getService(GDBControl.class) != null;
        }

        public String getName() {
            GDBControl gdb = (GDBControl)GdbProcesses.this.getServicesTracker().getService(GDBControl.class);
            if (gdb != null) {
                return gdb.getExecutablePath().lastSegment();
            }
            return "Default Target Core";
        }

        public String getId() {
            return "";
        }

        public boolean isDebuggerAttached() {
            return true;
        }

        public IDMContext<?> getDebuggingContext() {
            return GdbProcesses.this.fRunControl.getExecutionDMC();
        }
    }
}

