/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.gdb.service.control;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;
import org.eclipse.dd.dsf.debug.service.INativeProcesses;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandControl;
import org.eclipse.dd.dsf.debug.service.command.ICommandListener;
import org.eclipse.dd.dsf.debug.service.command.ICommandResult;
import org.eclipse.dd.dsf.debug.service.command.IEventListener;
import org.eclipse.dd.dsf.gdb.service.GdbProcesses;
import org.eclipse.dd.dsf.gdb.service.control.GDBControl;
import org.eclipse.dd.dsf.gdb.service.control.GDBEventProcessor;
import org.eclipse.dd.dsf.mi.core.command.DsfCLICommand;
import org.eclipse.dd.dsf.mi.core.command.DsfMIInterpreterExecConsole;
import org.eclipse.dd.dsf.mi.core.command.DsfRawCommand;
import org.eclipse.dd.dsf.mi.core.output.DsfMIConsoleStreamOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMILogStreamOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIOOBRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMIOutput;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.gdb.DsfGdbPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class CLIProcess
extends Process
implements IEventListener,
ICommandListener {
    public static final String PRIMARY_PROMPT = "(gdb)";
    public static final String SECONDARY_PROMPT = ">";
    private final DsfSession fSession;
    private final DsfServicesTracker fServicesTracker;
    private final OutputStream fOutputStream;
    private final PipedInputStream fMIInConsolePipe;
    private final PipedOutputStream fMIOutConsolePipe;
    private final PipedInputStream fMIInLogPipe;
    private final PipedOutputStream fMIOutLogPipe;
    private final boolean fUseExecConsole;
    private List<DsfMIOOBRecord> fAccumulatedOutput;
    private int fPrompt;

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    public CLIProcess(GDBControl gdb, boolean useExecConsole) throws IOException {
        PipedOutputStream miOutLogPipe;
        PipedInputStream miInLogPipe;
        PipedOutputStream miOutConsolePipe;
        PipedInputStream miInConsolePipe;
        block2: {
            this.fOutputStream = new CLIOutputStream();
            this.fAccumulatedOutput = new ArrayList<DsfMIOOBRecord>();
            this.fPrompt = 1;
            this.fSession = gdb.getSession();
            this.fUseExecConsole = useExecConsole;
            this.fServicesTracker = new DsfServicesTracker(DsfGdbPlugin.getBundleContext(), this.fSession.getId());
            gdb.addEventListener(this);
            gdb.addCommandListener(this);
            miInConsolePipe = null;
            miOutConsolePipe = null;
            miInLogPipe = null;
            miOutLogPipe = null;
            try {
                miOutConsolePipe = new PipedOutputStream();
                miInConsolePipe = new PipedInputStream(miOutConsolePipe);
                miOutLogPipe = new PipedOutputStream();
                miInLogPipe = new PipedInputStream(miOutLogPipe);
            }
            catch (IOException e) {
                ILog log = DsfGdbPlugin.getDefault().getLog();
                if (log == null) break block2;
                log.log((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, "Error when creating log pipes", (Throwable)e));
            }
        }
        this.fMIOutConsolePipe = miOutConsolePipe;
        this.fMIInConsolePipe = miInConsolePipe;
        this.fMIOutLogPipe = miOutLogPipe;
        this.fMIInLogPipe = miInLogPipe;
    }

    @Override
    public void destroy() {
        try {
            this.fSession.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    if (!DsfSession.isSessionActive((String)CLIProcess.this.fSession.getId())) {
                        return;
                    }
                    GdbProcesses processesService = (GdbProcesses)CLIProcess.this.fServicesTracker.getService(GdbProcesses.class);
                    if (processesService == null) {
                        return;
                    }
                    processesService.terminate((INativeProcesses.IThreadDMContext)processesService.getProcessDMC(), new RequestMonitor(CLIProcess.this.fSession.getExecutor(), null));
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Override
    public int exitValue() {
        block5: {
            if (!DsfSession.isSessionActive((String)this.fSession.getId())) {
                return 0;
            }
            try {
                return (Integer)this.fSession.getExecutor().submit((Callable)new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        if (!DsfSession.isSessionActive((String)CLIProcess.this.fSession.getId())) {
                            return new Integer(-1);
                        }
                        GDBControl gdb = (GDBControl)CLIProcess.this.fServicesTracker.getService(GDBControl.class);
                        if (gdb == null) {
                            return new Integer(-1);
                        }
                        if (!gdb.isGDBExited()) {
                            throw new IllegalThreadStateException("GDB Process has not exited");
                        }
                        return gdb.getGDBExitCode();
                    }
                }).get();
            }
            catch (RejectedExecutionException e) {
            }
            catch (InterruptedException e) {
            }
            catch (ExecutionException e) {
                if (!(e.getCause() instanceof RuntimeException)) break block5;
                throw (RuntimeException)e.getCause();
            }
        }
        return 0;
    }

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    protected void connectionShutDown(GDBControl gdb) {
        gdb.removeEventListener(this);
        gdb.removeCommandListener(this);
        this.fServicesTracker.dispose();
        this.closeIO();
    }

    private void closeIO() {
        try {
            this.fMIOutConsolePipe.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.fMIInConsolePipe.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.fMIOutLogPipe.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.fMIInLogPipe.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public InputStream getErrorStream() {
        return this.fMIInLogPipe;
    }

    @Override
    public InputStream getInputStream() {
        return this.fMIInConsolePipe;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.fOutputStream;
    }

    @Override
    public int waitFor() throws InterruptedException {
        if (!DsfSession.isSessionActive((String)this.fSession.getId())) {
            return 0;
        }
        Process process = null;
        try {
            process = (Process)this.fSession.getExecutor().submit((Callable)new Callable<Process>(){

                @Override
                public Process call() throws Exception {
                    GDBControl gdb = (GDBControl)CLIProcess.this.fServicesTracker.getService(GDBControl.class);
                    if (gdb == null) {
                        return null;
                    }
                    return gdb.getGDBProcess();
                }
            }).get();
        }
        catch (RejectedExecutionException e) {
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        if (process == null) {
            return 0;
        }
        return process.waitFor();
    }

    public void eventReceived(Object output) {
        this.fAccumulatedOutput.addAll(Arrays.asList(((DsfMIOutput)output).getMIOOBRecords()));
    }

    public void commandQueued(ICommand<? extends ICommandResult> command) {
    }

    public void commandSent(ICommand<? extends ICommandResult> command) {
    }

    public void commandRemoved(ICommand<? extends ICommandResult> command) {
    }

    public void commandDone(ICommand<? extends ICommandResult> command, ICommandResult result) {
        for (DsfMIOOBRecord oobr : this.fAccumulatedOutput) {
            String str;
            DsfMIConsoleStreamOutput out;
            if (oobr instanceof DsfMIConsoleStreamOutput && (command instanceof ProcessCLICommand || command instanceof ProcessMIInterpreterExecConsole)) {
                out = (DsfMIConsoleStreamOutput)oobr;
                str = out.getString();
                this.setPrompt(str);
                try {
                    this.fMIOutConsolePipe.write(str.getBytes());
                    this.fMIOutConsolePipe.flush();
                }
                catch (IOException e) {}
                continue;
            }
            if (!(oobr instanceof DsfMILogStreamOutput) || (str = (out = (DsfMILogStreamOutput)oobr).getString()) == null) continue;
            try {
                this.fMIOutLogPipe.write(str.getBytes());
                this.fMIOutLogPipe.flush();
            }
            catch (IOException e) {}
        }
        this.fAccumulatedOutput.clear();
    }

    void setPrompt(String line) {
        this.fPrompt = 0;
        if (line == null) {
            return;
        }
        if ((line = line.trim()).equals(PRIMARY_PROMPT)) {
            this.fPrompt = 1;
        } else if (line.equals(SECONDARY_PROMPT)) {
            this.fPrompt = 2;
        }
    }

    public boolean inPrimaryPrompt() {
        return this.fPrompt == 1;
    }

    public boolean inSecondaryPrompt() {
        return this.fPrompt == 2;
    }

    private class CLIOutputStream
    extends OutputStream {
        private final StringBuffer buf = new StringBuffer();

        private CLIOutputStream() {
        }

        public void write(int b) throws IOException {
            this.buf.append((char)b);
            if (b == 10) {
                final String bufString = this.buf.toString().trim();
                this.buf.setLength(0);
                try {
                    CLIProcess.this.fSession.getExecutor().execute((Runnable)new DsfRunnable(){

                        public void run() {
                            try {
                                CLIOutputStream.this.post(bufString);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    });
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
        }

        public void post(String str) throws IOException {
            final ICommandControl connectionService = (ICommandControl)CLIProcess.this.fServicesTracker.getService(ICommandControl.class);
            if (connectionService == null) {
                return;
            }
            Object cmd = null;
            boolean secondary = CLIProcess.this.inSecondaryPrompt();
            cmd = secondary ? new DsfRawCommand(str) : (CLIProcess.this.fUseExecConsole && !GDBEventProcessor.isSteppingOperation(str) ? new ProcessMIInterpreterExecConsole(str) : new ProcessCLICommand(str));
            DsfRawCommand finalCmd = cmd;
            connectionService.getExecutor().execute((Runnable)new DsfRunnable((ICommand)finalCmd){
                final /* synthetic */ ICommand val$finalCmd;
                {
                    this.val$finalCmd = iCommand;
                }

                public void run() {
                    connectionService.queueCommand(this.val$finalCmd, null);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProcessCLICommand
    extends DsfCLICommand<DsfMIInfo> {
        public ProcessCLICommand(String oper) {
            super(oper);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProcessMIInterpreterExecConsole
    extends DsfMIInterpreterExecConsole<DsfMIInfo> {
        public ProcessMIInterpreterExecConsole(String cmd) {
            super(cmd);
        }
    }
}

