/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.gdb.service.control;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.cdt.utils.spawner.Spawner;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.service.AbstractDsfService;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.gdb.DsfGdbPlugin;
import org.osgi.framework.BundleContext;

public class GDBProcessMonitor
extends AbstractDsfService {
    public static final String ATTR_GDB_PROGRAM = "org.eclipse.dd.gdb.ATTR_GDB_PROGRAM";
    private MonitorJob fMonitorJob;
    private IPath fGdbPath;
    private IPath fExecPath;
    private Process fProcess;
    private int fExitValue;

    public GDBProcessMonitor(DsfSession session, IPath gdbPath, IPath execPath) {
        super(session);
        this.fGdbPath = gdbPath;
        this.fExecPath = execPath;
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor(this.getExecutor(), requestMonitor){

            public void handleOK() {
                GDBProcessMonitor.this.doInitialize(requestMonitor);
            }
        });
    }

    public boolean canInterrupt() {
        return this.fProcess instanceof Spawner;
    }

    public void interrupt(RequestMonitor requestMonitor) {
        if (this.fProcess instanceof Spawner) {
            Spawner gdbSpawner = (Spawner)this.fProcess;
            gdbSpawner.interrupt();
        }
        requestMonitor.done();
    }

    private void doInitialize(final RequestMonitor requestMonitor) {
        final RequestMonitor startProcessJobRequestMonitor = new RequestMonitor(this.getExecutor(), requestMonitor){

            public void handleOK() {
                GDBProcessMonitor.this.doneStartProcess(requestMonitor);
            }
        };
        new Job("Start GDB Process Job"){

            protected IStatus run(IProgressMonitor monitor) {
                ArrayList<String> commandList = new ArrayList<String>();
                commandList.add(GDBProcessMonitor.this.fGdbPath.toOSString());
                if (GDBProcessMonitor.this.fExecPath != null) {
                    commandList.add("--interpreter");
                    commandList.add("mi");
                    commandList.add(GDBProcessMonitor.this.fExecPath.toOSString());
                }
                String[] commandLine = commandList.toArray(new String[commandList.size()]);
                try {
                    GDBProcessMonitor.this.fProcess = ProcessFactory.getFactory().exec(commandLine);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.abort(MessageFormat.format("Error while launching command", ((Object)commandList).toString()), e);
                    return Status.CANCEL_STATUS;
                }
                startProcessJobRequestMonitor.setStatus(Status.OK_STATUS);
                startProcessJobRequestMonitor.done();
                return Status.OK_STATUS;
            }

            void abort(String message, Throwable e) {
                startProcessJobRequestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", -1, message, e));
                startProcessJobRequestMonitor.done();
            }
        }.schedule();
    }

    private void doneStartProcess(final RequestMonitor requestMonitor) {
        this.fMonitorJob = new MonitorJob(this.fProcess, new DsfRunnable(){

            public void run() {
                GDBProcessMonitor.this.register(new String[0], new Hashtable());
                requestMonitor.done();
            }
        });
        this.fMonitorJob.schedule();
    }

    public void shutdown(final RequestMonitor requestMonitor) {
        this.unregister();
        if (this.fMonitorJob == null || this.fProcess == null) {
            assert (false);
            requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10005, "Process not started.", null));
            requestMonitor.done();
            return;
        }
        if (this.fMonitorJob.fExited) {
            requestMonitor.done();
            return;
        }
        final RequestMonitor terminateRequestMonitor = new RequestMonitor(this.getExecutor(), null){

            public void handleCompleted() {
                if (this.getStatus().isOK()) {
                    assert (((GDBProcessMonitor)GDBProcessMonitor.this).fMonitorJob.fExited);
                    requestMonitor.done();
                } else {
                    GDBProcessMonitor.this.fMonitorJob.kill();
                    requestMonitor.setStatus(this.getStatus());
                    requestMonitor.done();
                }
                GDBProcessMonitor.this.fMonitorJob = null;
                GDBProcessMonitor.this.fProcess = null;
            }
        };
        new Job("Terminating GDB process."){

            protected IStatus run(IProgressMonitor monitor) {
                if (GDBProcessMonitor.this.fProcess == null) {
                    GDBProcessMonitor.this.fProcess.destroy();
                }
                for (int attempts = 0; attempts < 10; ++attempts) {
                    try {
                        GDBProcessMonitor.this.fExitValue = GDBProcessMonitor.this.fProcess.exitValue();
                        terminateRequestMonitor.done();
                        return Status.OK_STATUS;
                    }
                    catch (IllegalThreadStateException ie) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                requestMonitor.setStatus((IStatus)new Status(4, "org.eclipse.dd.gdb", 10004, "Process terminate failed", null));
                requestMonitor.done();
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public Process getProcess() {
        return this.fProcess;
    }

    public boolean isExited() {
        return this.fMonitorJob != null && this.fMonitorJob.fExited;
    }

    public int getExitValue() {
        return this.fExitValue;
    }

    public IPath getExecutablePath() {
        return this.fExecPath;
    }

    protected BundleContext getBundleContext() {
        return DsfGdbPlugin.getBundleContext();
    }

    public static interface ExitedEvent {
    }

    private class MonitorJob
    extends Job {
        boolean fExited;
        DsfRunnable fMonitorStarted;
        Process fMonProcess;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Process process = this.fMonProcess;
            synchronized (process) {
                GDBProcessMonitor.this.getExecutor().submit((Runnable)this.fMonitorStarted);
                while (!this.fExited) {
                    try {
                        this.fMonProcess.waitFor();
                        GDBProcessMonitor.this.fExitValue = this.fMonProcess.exitValue();
                        this.fExited = true;
                    }
                    catch (InterruptedException ie) {
                        try {
                            Thread.interrupted();
                            this.fExited = true;
                        }
                        catch (Throwable throwable) {
                            this.fExited = true;
                            GDBProcessMonitor.this.getSession().dispatchEvent((Object)new ExitedEvent(){}, GDBProcessMonitor.this.getProperties());
                            throw throwable;
                        }
                        GDBProcessMonitor.this.getSession().dispatchEvent((Object)new /* invalid duplicate definition of identical inner class */, GDBProcessMonitor.this.getProperties());
                        continue;
                    }
                    GDBProcessMonitor.this.getSession().dispatchEvent((Object)new /* invalid duplicate definition of identical inner class */, GDBProcessMonitor.this.getProperties());
                }
            }
            return Status.OK_STATUS;
        }

        MonitorJob(Process process, DsfRunnable monitorStarted) {
            super("GDB process monitor job.");
            this.fExited = false;
            this.fMonProcess = process;
            this.fMonitorStarted = monitorStarted;
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void kill() {
            Process process = this.fMonProcess;
            synchronized (process) {
                if (!this.fExited) {
                    this.getThread().interrupt();
                }
            }
        }
    }
}

