/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.gdb.launching;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.ThreadSafe;
import org.eclipse.dd.dsf.debug.model.DsfMemoryBlockRetrieval;
import org.eclipse.dd.dsf.debug.service.IMemory;
import org.eclipse.dd.dsf.gdb.launching.GdbLaunch;
import org.eclipse.dd.dsf.gdb.launching.LaunchSequence;
import org.eclipse.dd.dsf.gdb.service.control.GDBControl;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.gdb.DsfGdbPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate2;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.IPersistableSourceLocator2;

@ThreadSafe
public class GdbLaunchDelegate
extends AbstractCLaunchDelegate
implements ILaunchConfigurationDelegate2 {
    public static final String GDB_DEBUG_MODEL_ID = "org.eclipse.dd.dsf.gdb";

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (mode.equals("debug")) {
            this.launchDebugger(config, launch, monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launchDebugger(ILaunchConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Launching debugger session", 10);
        if (monitor.isCanceled()) {
            return;
        }
        try {
            String debugMode = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
            if (debugMode.equals("run")) {
                this.launchLocalDebugSession(config, launch, monitor);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void launchLocalDebugSession(ILaunchConfiguration config, ILaunch l, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return;
        }
        final GdbLaunch launch = (GdbLaunch)l;
        monitor.subTask("Debugging local C/C++ application");
        IPath exePath = this.verifyProgramPath(config);
        ICProject project = this.verifyCProject(config);
        if (exePath != null) {
            this.verifyBinary(project, exePath);
        }
        this.setDefaultSourceLocator((ILaunch)launch, config);
        monitor.worked(1);
        LaunchSequence launchSequence = new LaunchSequence(launch.getSession(), launch, exePath);
        launch.getSession().getExecutor().execute((Runnable)((Object)launchSequence));
        try {
            launchSequence.get();
        }
        catch (InterruptedException e1) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.dd.gdb", 5013, "Interrupted Exception in dispatch thread", (Throwable)e1));
        }
        catch (ExecutionException e1) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.dd.gdb", 5012, "Error in launch sequence", e1.getCause()));
        }
        launch.initializeControl();
        final AtomicReference cliProcessRef = new AtomicReference();
        final AtomicReference inferiorProcessRef = new AtomicReference();
        try {
            launch.getDsfExecutor().submit((Callable)new Callable<Object>(){

                @Override
                public Object call() throws CoreException {
                    DsfServicesTracker tracker = new DsfServicesTracker(DsfGdbPlugin.getBundleContext(), launch.getSession().getId());
                    GDBControl gdb = (GDBControl)tracker.getService(GDBControl.class);
                    if (gdb != null) {
                        cliProcessRef.set(gdb.getCLIProcess());
                        inferiorProcessRef.set(gdb.getInferiorProcess());
                    }
                    tracker.dispose();
                    return null;
                }
            }).get();
            launch.addProcess(DebugPlugin.newProcess((ILaunch)launch, (Process)((Process)cliProcessRef.get()), (String)"gdb"));
            launch.addProcess(DebugPlugin.newProcess((ILaunch)launch, (Process)((Process)inferiorProcessRef.get()), (String)exePath.lastSegment()));
        }
        catch (InterruptedException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dd.gdb", 0, "Interrupted while waiting for get process callable.", (Throwable)e));
        }
        catch (ExecutionException e) {
            throw (CoreException)e.getCause();
        }
        catch (RejectedExecutionException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dd.gdb", 0, "Debugger shut down before launch was completed.", (Throwable)e));
        }
        try {
            launch.getDsfExecutor().submit((Callable)new Callable<Object>(){

                @Override
                public Object call() throws CoreException {
                    DsfServicesTracker tracker = new DsfServicesTracker(DsfGdbPlugin.getBundleContext(), launch.getSession().getId());
                    GDBControl gdbControl = (GDBControl)tracker.getService(GDBControl.class);
                    if (gdbControl != null) {
                        DsfMemoryBlockRetrieval memRetrieval = new DsfMemoryBlockRetrieval(GdbLaunchDelegate.GDB_DEBUG_MODEL_ID, (IMemory.IMemoryDMContext)gdbControl.getControlDMContext());
                        launch.getSession().registerModelAdapter(IMemoryBlockRetrieval.class, (Object)memRetrieval);
                    }
                    tracker.dispose();
                    return null;
                }
            }).get();
        }
        catch (InterruptedException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dd.gdb", 0, "Interrupted while waiting for get process callable.", (Throwable)e));
        }
        catch (ExecutionException e) {
            throw (CoreException)e.getCause();
        }
        catch (RejectedExecutionException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dd.gdb", 0, "Debugger shut down before launch was completed.", (Throwable)e));
        }
    }

    protected String getPluginID() {
        return LaunchUIPlugin.getUniqueIdentifier();
    }

    protected Process exec(String[] cmdLine, String[] environ, File workingDirectory, boolean usePty) throws CoreException {
        Process p;
        block4: {
            p = null;
            try {
                p = workingDirectory == null ? ProcessFactory.getFactory().exec(cmdLine, environ) : (usePty && PTY.isSupported() ? ProcessFactory.getFactory().exec(cmdLine, environ, workingDirectory, new PTY()) : ProcessFactory.getFactory().exec(cmdLine, environ, workingDirectory));
            }
            catch (IOException e) {
                if (p != null) {
                    p.destroy();
                }
                this.abort("Error starting process.", e, 150);
            }
            catch (NoSuchMethodError e) {
                Object result;
                Status status = new Status(4, LaunchUIPlugin.getUniqueIdentifier(), 100, LaunchMessages.getString((String)"LocalDsfLaunchDelegate.9"), (Throwable)e);
                IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
                if (handler == null || !((result = handler.handleStatus((IStatus)status, (Object)this)) instanceof Boolean) || !((Boolean)result).booleanValue()) break block4;
                p = this.exec(cmdLine, environ, null, usePty);
            }
        }
        return p;
    }

    public boolean preLaunchCheck(ILaunchConfiguration config, String mode, IProgressMonitor monitor) throws CoreException {
        if (mode.equals("debug") && "core".equals(config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run"))) {
            return true;
        }
        return super.preLaunchCheck(config, mode, monitor);
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return false;
    }

    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        return true;
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        ISourceLocator locator = this.getSourceLocator(configuration);
        return new GdbLaunch(configuration, mode, locator);
    }

    private ISourceLocator getSourceLocator(ILaunchConfiguration configuration) throws CoreException {
        String type = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, (String)null);
        if (type == null) {
            type = configuration.getType().getSourceLocatorId();
        }
        if (type != null) {
            IPersistableSourceLocator locator = DebugPlugin.getDefault().getLaunchManager().newSourceLocator(type);
            String memento = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, (String)null);
            if (memento == null) {
                locator.initializeDefaults(configuration);
            } else if (locator instanceof IPersistableSourceLocator2) {
                ((IPersistableSourceLocator2)locator).initializeFromMemento(memento, configuration);
            } else {
                locator.initializeFromMemento(memento);
            }
            return locator;
        }
        return null;
    }
}

