/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.core.command;

import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMIInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DsfMICommand<V extends DsfMIInfo>
implements ICommand<V> {
    static final String[] empty = new String[0];
    String[] fOptions = empty;
    String[] fParameters = empty;
    String fOperation = new String();
    IDMContext fCtx;

    public DsfMICommand(String operation) {
        this(operation, empty, empty);
    }

    public DsfMICommand(IDMContext ctx, String operation) {
        this(ctx, operation, empty, empty);
    }

    public DsfMICommand(String operation, String[] options) {
        this(operation, options, empty);
    }

    public DsfMICommand(IDMContext ctx, String operation, String[] options) {
        this(ctx, operation, options, empty);
    }

    public DsfMICommand(IDMContext ctx, String operation, String[] options, String[] params) {
        assert (ctx != null);
        this.fCtx = ctx;
        this.fOperation = operation;
        this.fOptions = options;
        this.fParameters = params;
    }

    public DsfMICommand(String operation, String[] options, String[] params) {
        this.fCtx = null;
        this.fOperation = operation;
        this.fOptions = options;
        this.fParameters = params;
    }

    public String getOperation() {
        return this.fOperation;
    }

    public String[] getOptions() {
        return this.fOptions;
    }

    public void setOptions(String[] options) {
        this.fOptions = options;
    }

    public String[] getParameters() {
        return this.fParameters;
    }

    public void setParameters(String[] params) {
        this.fParameters = params;
    }

    public String constructCommand() {
        String p;
        StringBuffer command = new StringBuffer(this.getOperation());
        String opt = this.optionsToString();
        if (opt.length() > 0) {
            command.append(' ').append(opt);
        }
        if ((p = this.parametersToString()).length() > 0) {
            command.append(' ').append(p);
        }
        command.append('\n');
        return command.toString();
    }

    public ICommand<? extends ICommandResult> coalesceWith(ICommand<? extends ICommandResult> command) {
        return null;
    }

    public IDMContext getContext() {
        return this.fCtx;
    }

    public DsfMIInfo getResult(DsfMIOutput MIresult) {
        return new DsfMIInfo(MIresult);
    }

    protected String optionsToString() {
        String[] options = this.getOptions();
        StringBuffer sb = new StringBuffer();
        if (options != null && options.length > 0) {
            for (int i = 0; i < options.length; ++i) {
                String option = options[i];
                if (option.indexOf(34) != -1 || option.indexOf(92) != -1) {
                    StringBuffer buf = new StringBuffer();
                    for (int j = 0; j < option.length(); ++j) {
                        char c = option.charAt(j);
                        if (c == '\"' || c == '\\') {
                            buf.append('\\');
                        }
                        buf.append(c);
                    }
                    option = buf.toString();
                }
                if (option.indexOf(9) != -1 || option.indexOf(32) != -1) {
                    sb.append(' ').append('\"').append(option).append('\"');
                    continue;
                }
                sb.append(' ').append(option);
            }
        }
        return sb.toString().trim();
    }

    protected String parametersToString() {
        String[] parameters = this.getParameters();
        String[] options = this.getOptions();
        StringBuffer buffer = new StringBuffer();
        if (parameters != null && parameters.length > 0) {
            if (options != null && options.length > 0) {
                for (int i = 0; i < parameters.length; ++i) {
                    if (!parameters[i].startsWith("-")) continue;
                    buffer.append('-').append('-');
                    break;
                }
            }
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < parameters.length; ++i) {
                sb.setLength(0);
                String param = parameters[i];
                for (int j = 0; j < param.length(); ++j) {
                    char c = param.charAt(j);
                    if (c == '\"' || c == '\\') {
                        sb.append('\\');
                    }
                    sb.append(c);
                }
                if (this.containsWhitespace(param)) {
                    sb.insert(0, '\"');
                    sb.append('\"');
                }
                buffer.append(' ').append(sb);
            }
        }
        return buffer.toString().trim();
    }

    protected boolean containsWhitespace(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isWhitespace(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DsfMICommand) {
            DsfMICommand otherCmd = (DsfMICommand)obj;
            return (this.fCtx == null && otherCmd.fCtx == null || this.fCtx != null && this.fCtx.equals(otherCmd.fCtx)) && this.constructCommand().equals(otherCmd.constructCommand());
        }
        return false;
    }

    public int hashCode() {
        return this.constructCommand().hashCode();
    }

    public String toString() {
        return this.constructCommand();
    }
}

