/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.core.output;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dd.dsf.mi.core.output.DsfMIConst;
import org.eclipse.dd.dsf.mi.core.output.DsfMIInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIList;
import org.eclipse.dd.dsf.mi.core.output.DsfMIOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResultRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMITuple;
import org.eclipse.dd.dsf.mi.core.output.DsfMIValue;
import org.eclipse.dd.dsf.mi.core.output.DsfMIVar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DsfMIVarListChildrenInfo
extends DsfMIInfo {
    DsfMIVar[] children;
    int numchild;

    public DsfMIVarListChildrenInfo(DsfMIOutput record) {
        super(record);
        DsfMIOutput out;
        DsfMIResultRecord rr;
        ArrayList<DsfMIVar> aList = new ArrayList<DsfMIVar>();
        if (this.isDone() && (rr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            DsfMIResult[] results = rr.getMIResults();
            for (int i = 0; i < results.length; ++i) {
                String var = results[i].getVariable();
                DsfMIValue value = results[i].getMIValue();
                if (var.equals("numchild")) {
                    if (!(value instanceof DsfMIConst)) continue;
                    String str = ((DsfMIConst)value).getString();
                    try {
                        this.numchild = Integer.parseInt(str.trim());
                    }
                    catch (NumberFormatException e) {}
                    continue;
                }
                if (!var.equals("children")) continue;
                this.parseChildren(value, aList);
            }
        }
        this.children = aList.toArray(new DsfMIVar[aList.size()]);
    }

    public DsfMIVar[] getMIVars() {
        return this.children;
    }

    private void parseChildren(DsfMIValue val, List<DsfMIVar> aList) {
        DsfMIResult[] results = null;
        if (val instanceof DsfMITuple) {
            results = ((DsfMITuple)val).getMIResults();
        } else if (val instanceof DsfMIList) {
            results = ((DsfMIList)val).getMIResults();
        }
        if (results != null) {
            for (int i = 0; i < results.length; ++i) {
                DsfMIValue value;
                String var = results[i].getVariable();
                if (!var.equals("child") || !((value = results[i].getMIValue()) instanceof DsfMITuple)) continue;
                aList.add(new DsfMIVar((DsfMITuple)value));
            }
        }
    }
}

