/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.event;

import org.eclipse.dd.dsf.mi.core.output.DsfMIConst;
import org.eclipse.dd.dsf.mi.core.output.DsfMIExecAsyncOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResultRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMIValue;
import org.eclipse.dd.dsf.mi.event.DsfMIDestroyedEvent;

public class DsfMIInferiorSignalExitEvent
extends DsfMIDestroyedEvent {
    private static final long serialVersionUID = -2082361907303377658L;
    String sigName = "";
    String sigMeaning = "";
    DsfMIExecAsyncOutput exec = null;
    DsfMIResultRecord rr = null;

    public DsfMIInferiorSignalExitEvent(DsfMIExecAsyncOutput async) {
        super(async.getToken());
        this.exec = async;
        this.parse();
    }

    public DsfMIInferiorSignalExitEvent(DsfMIResultRecord record) {
        super(record.getToken());
        this.rr = record;
        this.parse();
    }

    public String getName() {
        return this.sigName;
    }

    public String getMeaning() {
        return this.sigMeaning;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("signal-name=" + this.sigName + "\n");
        buffer.append("signal-meaning=" + this.sigMeaning + "\n");
        return buffer.toString();
    }

    void parse() {
        DsfMIResult[] results = null;
        if (this.exec != null) {
            results = this.exec.getMIResults();
        } else if (this.rr != null) {
            results = this.rr.getMIResults();
        }
        if (results != null) {
            for (int i = 0; i < results.length; ++i) {
                String var = results[i].getVariable();
                DsfMIValue value = results[i].getMIValue();
                String str = "";
                if (value instanceof DsfMIConst) {
                    str = ((DsfMIConst)value).getString();
                }
                if (var.equals("signal-name")) {
                    this.sigName = str;
                    continue;
                }
                if (!var.equals("signal-meaning")) continue;
                this.sigMeaning = str;
            }
        }
    }
}

