/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.event;

import org.eclipse.dd.dsf.mi.core.output.DsfMIConst;
import org.eclipse.dd.dsf.mi.core.output.DsfMIExecAsyncOutput;
import org.eclipse.dd.dsf.mi.core.output.DsfMIFrame;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResult;
import org.eclipse.dd.dsf.mi.core.output.DsfMIResultRecord;
import org.eclipse.dd.dsf.mi.core.output.DsfMITuple;
import org.eclipse.dd.dsf.mi.core.output.DsfMIValue;
import org.eclipse.dd.dsf.mi.event.DsfMIStoppedEvent;

public class DsfMIWatchpointTriggerEvent
extends DsfMIStoppedEvent {
    private static final long serialVersionUID = -7866742991260470299L;
    int number;
    String exp = "";
    String oldValue = "";
    String newValue = "";

    public DsfMIWatchpointTriggerEvent(DsfMIExecAsyncOutput async) {
        super(async);
        this.parse();
    }

    public DsfMIWatchpointTriggerEvent(DsfMIResultRecord record) {
        super(record);
        this.parse();
    }

    public int getNumber() {
        return this.number;
    }

    public String getExpression() {
        return this.exp;
    }

    public String getOldValue() {
        return this.oldValue;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("number=").append(this.number).append('\n');
        buffer.append("expression=" + this.exp + "\n");
        buffer.append("old=" + this.oldValue + "\n");
        buffer.append("new=" + this.newValue + "\n");
        buffer.append("thread-id=").append(this.getThreadId()).append('\n');
        DsfMIFrame f = this.getFrame();
        if (f != null) {
            buffer.append(f.toString());
        }
        return buffer.toString();
    }

    void parse() {
        DsfMIResult[] results = null;
        DsfMIExecAsyncOutput exec = this.getMIExecAsyncOutput();
        DsfMIResultRecord rr = this.getMIResultRecord();
        if (exec != null) {
            results = exec.getMIResults();
        } else if (rr != null) {
            results = rr.getMIResults();
        }
        if (results != null) {
            for (int i = 0; i < results.length; ++i) {
                String var = results[i].getVariable();
                DsfMIValue value = results[i].getMIValue();
                if (var.equals("wpt") || var.equals("hw-awpt") || var.equals("hw-rwpt")) {
                    if (!(value instanceof DsfMITuple)) continue;
                    this.parseWPT((DsfMITuple)value);
                    continue;
                }
                if (var.equals("value")) {
                    if (!(value instanceof DsfMITuple)) continue;
                    this.parseValue((DsfMITuple)value);
                    continue;
                }
                if (var.equals("thread-id")) {
                    if (!(value instanceof DsfMIConst)) continue;
                    String str = ((DsfMIConst)value).getString();
                    try {
                        int id = Integer.parseInt(str.trim());
                        this.setThreadId(id);
                    }
                    catch (NumberFormatException e) {}
                    continue;
                }
                if (!var.equals("frame") || !(value instanceof DsfMITuple)) continue;
                DsfMIFrame f = new DsfMIFrame((DsfMITuple)value);
                this.setFrame(f);
            }
        }
    }

    void parseWPT(DsfMITuple tuple) {
        DsfMIResult[] results = tuple.getMIResults();
        for (int i = 0; i < results.length; ++i) {
            String var = results[i].getVariable();
            DsfMIValue value = results[i].getMIValue();
            if (var.equals("number")) {
                if (!(value instanceof DsfMIConst)) continue;
                String str = ((DsfMIConst)value).getString();
                try {
                    this.number = Integer.parseInt(str);
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (!var.equals("exp") || !(value instanceof DsfMIConst)) continue;
            this.exp = ((DsfMIConst)value).getString();
        }
    }

    void parseValue(DsfMITuple tuple) {
        DsfMIResult[] results = tuple.getMIResults();
        for (int i = 0; i < results.length; ++i) {
            String var = results[i].getVariable();
            DsfMIValue value = results[i].getMIValue();
            String str = "";
            if (value instanceof DsfMIConst) {
                str = ((DsfMIConst)value).getString();
            }
            if (var.equals("old")) {
                this.oldValue = str;
                continue;
            }
            if (var.equals("new")) {
                this.newValue = str;
                continue;
            }
            if (!var.equals("value")) continue;
            this.oldValue = this.newValue = str;
        }
    }
}

