/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.mi.service;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.IExpressions;
import org.eclipse.dd.dsf.debug.service.IFormattedValues;
import org.eclipse.dd.dsf.debug.service.IStack;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandControl;
import org.eclipse.dd.dsf.debug.service.command.ICommandListener;
import org.eclipse.dd.dsf.debug.service.command.ICommandResult;
import org.eclipse.dd.dsf.debug.service.command.IEventListener;
import org.eclipse.dd.dsf.mi.DsfMIPlugin;
import org.eclipse.dd.dsf.mi.core.command.DsfExprMetaGetChildCount;
import org.eclipse.dd.dsf.mi.core.command.DsfExprMetaGetChildren;
import org.eclipse.dd.dsf.mi.core.command.DsfExprMetaGetValue;
import org.eclipse.dd.dsf.mi.core.command.DsfExprMetaGetVar;
import org.eclipse.dd.dsf.mi.core.command.DsfMIDataEvaluateExpression;
import org.eclipse.dd.dsf.mi.core.command.DsfMIVarAssign;
import org.eclipse.dd.dsf.mi.core.command.DsfMIVarCreate;
import org.eclipse.dd.dsf.mi.core.command.DsfMIVarDelete;
import org.eclipse.dd.dsf.mi.core.command.DsfMIVarEvaluateExpression;
import org.eclipse.dd.dsf.mi.core.command.DsfMIVarListChildren;
import org.eclipse.dd.dsf.mi.core.command.DsfMIVarSetFormat;
import org.eclipse.dd.dsf.mi.core.command.DsfMIVarUpdate;
import org.eclipse.dd.dsf.mi.core.output.DsfExprMetaGetChildCountInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfExprMetaGetChildrenInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfExprMetaGetValueInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfExprMetaGetVarInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIVar;
import org.eclipse.dd.dsf.mi.core.output.DsfMIVarCreateInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIVarDeleteInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIVarEvaluateExpressionInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIVarListChildrenInfo;
import org.eclipse.dd.dsf.mi.core.output.DsfMIVarUpdateInfo;
import org.eclipse.dd.dsf.mi.service.ExpressionService;
import org.eclipse.dd.dsf.mi.service.MIRunControl;
import org.eclipse.dd.dsf.mi.service.MIStack;
import org.eclipse.dd.dsf.service.AbstractDsfService;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.dsf.service.DsfSession;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIVariableManager
extends AbstractDsfService
implements ICommandControl {
    private final ICommandControl commandControl;
    private final IStack stackService;
    private final List<ICommandListener> fCommandProcessors = new ArrayList<ICommandListener>();
    Map<String, MIVariableObject> lruVariableList = new LRUVariableCache();

    public MIVariableManager(DsfSession session, DsfServicesTracker tracker) {
        super(session);
        this.commandControl = (ICommandControl)tracker.getService(ICommandControl.class);
        this.stackService = (IStack)tracker.getService(IStack.class);
    }

    private void getVariable(final IDMContext dmc, final DataRequestMonitor<MIVariableObject> rm) {
        if (DMContexts.getAncestorOfType((IDMContext)dmc, MIRunControl.MIContainerDMC.class) == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Container dmc is not found", null));
            rm.done();
            return;
        }
        final IExpressions.IExpressionDMContext exprCxt = (IExpressions.IExpressionDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IExpressions.IExpressionDMContext.class);
        if (exprCxt == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Expression dmc is not found", null));
            rm.done();
            return;
        }
        this.generateUniqueExpressionId(exprCxt, new DataRequestMonitor<String>((Executor)this.getExecutor(), rm){

            protected void handleOK() {
                final String internalName = (String)this.getData();
                MIVariableObject varObj = MIVariableManager.this.lruVariableList.get(internalName);
                if (varObj != null) {
                    varObj.addCreationListener((DataRequestMonitor<MIVariableObject>)rm);
                    return;
                }
                final MIVariableObject newVarObj = new MIVariableObject(internalName);
                newVarObj.addCreationListener((DataRequestMonitor<MIVariableObject>)rm);
                MIVariableManager.this.lruVariableList.put(internalName, newVarObj);
                MIVariableManager.this.commandControl.queueCommand((ICommand)new DsfMIVarCreate(dmc, exprCxt.getExpression()), (DataRequestMonitor)new DataRequestMonitor<DsfMIVarCreateInfo>((Executor)MIVariableManager.this.getExecutor(), null){

                    protected void handleCompleted() {
                        if (this.getStatus().isOK()) {
                            newVarObj.setGdbName(((DsfMIVarCreateInfo)this.getData()).getName());
                            newVarObj.setExpressionData(exprCxt.getExpression(), ((DsfMIVarCreateInfo)this.getData()).getType(), ((DsfMIVarCreateInfo)this.getData()).getNumChildren());
                            newVarObj.creationCompleted(true);
                        } else {
                            newVarObj.creationCompleted(false);
                            MIVariableManager.this.lruVariableList.remove(internalName);
                        }
                    }
                });
            }
        });
    }

    private void getValue(final IFormattedValues.FormattedValueDMContext dmc, final MIVariableObject varObj, final DataRequestMonitor<IFormattedValues.FormattedValueDMData> rm) {
        varObj.executeWhenReady(new Runnable(){

            public void run() {
                varObj.lock();
                MIVariableManager.this.commandControl.queueCommand((ICommand)new DsfMIVarUpdate(varObj.getGdbName()), (DataRequestMonitor)new DataRequestMonitor<DsfMIVarUpdateInfo>((Executor)MIVariableManager.this.getExecutor(), (RequestMonitor)rm){

                    protected void handleCompleted() {
                        if (this.getStatus().isOK()) {
                            if (dmc.getFormatID().equals(varObj.getFormat())) {
                                boolean changed;
                                boolean bl = changed = ((DsfMIVarUpdateInfo)this.getData()).getMIVarChanges().length != 0;
                                if (changed || varObj.getValue() == null) {
                                    MIVariableManager.this.evaluate(varObj, (DataRequestMonitor<IFormattedValues.FormattedValueDMData>)rm);
                                } else {
                                    rm.setData((Object)new IFormattedValues.FormattedValueDMData(varObj.getValue()));
                                    rm.done();
                                    varObj.unlock();
                                }
                            } else {
                                MIVariableManager.this.commandControl.queueCommand((ICommand)new DsfMIVarSetFormat(varObj.getGdbName(), dmc.getFormatID()), (DataRequestMonitor)new DataRequestMonitor<DsfMIInfo>((Executor)MIVariableManager.this.getExecutor(), (RequestMonitor)rm){

                                    protected void handleCompleted() {
                                        if (this.getStatus().isOK()) {
                                            varObj.setFormat(dmc.getFormatID());
                                            MIVariableManager.this.evaluate(varObj, (DataRequestMonitor<IFormattedValues.FormattedValueDMData>)rm);
                                        } else {
                                            varObj.unlock();
                                            this.handleErrorOrCancel();
                                        }
                                    }
                                });
                            }
                        } else {
                            varObj.unlock();
                            this.handleErrorOrCancel();
                        }
                    }
                });
            }
        });
    }

    private void getChildren(final MIVariableObject varObj, final DataRequestMonitor<DsfMIVar[]> rm) {
        this.commandControl.queueCommand((ICommand)new DsfMIVarListChildren(varObj.getGdbName()), (DataRequestMonitor)new DataRequestMonitor<DsfMIVarListChildrenInfo>((Executor)this.getExecutor(), rm){

            protected void handleOK() {
                DsfMIVar[] children = ((DsfMIVarListChildrenInfo)this.getData()).getMIVars();
                final ArrayList<DsfMIVar> realChildren = new ArrayList<DsfMIVar>();
                final CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)MIVariableManager.this.getExecutor(), null){

                    public void handleCompleted() {
                        if (this.getStatus().isOK()) {
                            rm.setData((Object)realChildren.toArray(new DsfMIVar[realChildren.size()]));
                        }
                        rm.done();
                    }
                };
                int numSubRequests = 0;
                for (DsfMIVar child : children) {
                    MIVariableObject childVarObj = MIVariableManager.this.addChildVariable(child, varObj);
                    if (MIVariableManager.this.isAccessQualifier(child.getExp())) {
                        ++numSubRequests;
                        MIVariableManager.this.getChildren(childVarObj, (DataRequestMonitor<DsfMIVar[]>)((DataRequestMonitor)new DataRequestMonitor<DsfMIVar[]>((Executor)MIVariableManager.this.getExecutor(), (RequestMonitor)countingRm){

                            protected void handleOK() {
                                DsfMIVar[] vars;
                                for (DsfMIVar realChild : vars = (DsfMIVar[])this.getData()) {
                                    realChildren.add(realChild);
                                }
                                countingRm.done();
                            }
                        }));
                        continue;
                    }
                    realChildren.add(child);
                }
                countingRm.setDoneCount(numSubRequests);
            }
        });
    }

    private void getChildrenCount(MIVariableObject varObj, DataRequestMonitor<Integer> rm) {
        rm.setData((Object)varObj.getNumChildren());
        rm.done();
    }

    public void writeValue(IDMContext expressionContext, final String expressionValue, final String formatId, final RequestMonitor rm) {
        this.getVariable(expressionContext, new DataRequestMonitor<MIVariableObject>((Executor)this.getExecutor(), rm){

            protected void handleOK() {
                MIVariableManager.this.writeValue((MIVariableObject)this.getData(), expressionValue, formatId, rm);
            }
        });
    }

    private void writeValue(final MIVariableObject varObj, String value, String formatId, final RequestMonitor rm) {
        if (formatId.equals("HEX.Format")) {
            if (!value.startsWith("0x")) {
                value = "0x" + value;
            }
        } else if (formatId.equals("OCTAL.Format")) {
            if (!value.startsWith("0")) {
                value = "0" + value;
            }
        } else if (formatId.equals("BINARY.Format")) {
            if (value.startsWith("0b")) {
                value = value.substring(2, value.length());
            }
            try {
                value = Integer.toString(Integer.parseInt(value, 2));
            }
            catch (NumberFormatException e) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Invalid binary number: " + value, (Throwable)e));
                rm.done();
                return;
            }
        } else if (!formatId.equals("DECIMAL.Format") && !formatId.equals("NATURAL.Format")) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Unknown format: " + formatId, null));
            rm.done();
            return;
        }
        final String finalVal = value;
        varObj.executeWhenReady(new Runnable(){

            public void run() {
                MIVariableManager.this.commandControl.queueCommand((ICommand)new DsfMIVarAssign(varObj.getGdbName(), finalVal), (DataRequestMonitor)new DataRequestMonitor<DsfMIInfo>((Executor)MIVariableManager.this.getExecutor(), rm){

                    protected void handleOK() {
                        rm.setStatus(this.getStatus());
                        rm.done();
                    }
                });
            }
        });
    }

    private String generateChildInternalName(String childExp, String parentName) {
        if (parentName.endsWith(".public")) {
            parentName = parentName.substring(0, parentName.lastIndexOf(".public"));
        } else if (parentName.endsWith(".private")) {
            parentName = parentName.substring(0, parentName.lastIndexOf(".private"));
        } else if (parentName.endsWith(".protected")) {
            parentName = parentName.substring(0, parentName.lastIndexOf(".protected"));
        }
        childExp = childExp.replaceAll("^([0-9]+)$", "\\[$1\\]");
        if (childExp.startsWith("[")) {
            return parentName + childExp;
        }
        return parentName + "." + childExp;
    }

    private MIVariableObject addChildVariable(DsfMIVar child, MIVariableObject parentObj) {
        String childInternalName = this.generateChildInternalName(child.getExp(), parentObj.getInternalName());
        MIVariableObject varObj = this.lruVariableList.get(childInternalName);
        if (varObj == null) {
            varObj = new MIVariableObject(childInternalName);
            this.lruVariableList.put(childInternalName, varObj);
            varObj.setGdbName(child.getVarName());
            varObj.setExpressionData(child.getExp(), child.getType(), child.getNumChild());
            varObj.creationCompleted(true);
        }
        return varObj;
    }

    private boolean isAccessQualifier(String str) {
        return str.equals("private") || str.equals("public") || str.equals("protected");
    }

    private void deleteVariable(final MIVariableObject varObj) {
        this.commandControl.queueCommand((ICommand)new DsfMIVarDelete(varObj.getGdbName()), (DataRequestMonitor)new DataRequestMonitor<DsfMIVarDeleteInfo>((Executor)this.getExecutor(), null){

            protected void handleOK() {
                MIVariableManager.this.lruVariableList.remove(varObj.getInternalName());
            }
        });
    }

    private void evaluate(final MIVariableObject varObj, final DataRequestMonitor<IFormattedValues.FormattedValueDMData> rm) {
        this.commandControl.queueCommand((ICommand)new DsfMIVarEvaluateExpression(varObj.getGdbName()), (DataRequestMonitor)new DataRequestMonitor<DsfMIVarEvaluateExpressionInfo>((Executor)this.getExecutor(), rm){

            protected void handleCompleted() {
                if (this.getStatus().isOK()) {
                    varObj.setValue(((DsfMIVarEvaluateExpressionInfo)this.getData()).getValue());
                    rm.setData((Object)new IFormattedValues.FormattedValueDMData(((DsfMIVarEvaluateExpressionInfo)this.getData()).getValue()));
                }
                rm.done();
                varObj.unlock();
            }
        });
    }

    private void generateUniqueExpressionId(IExpressions.IExpressionDMContext exprCtx, final DataRequestMonitor<String> drm) {
        MIStack.MIFrameDMC frameCtx;
        String expressionId = exprCtx.getExpression().replaceAll(" ", "").trim();
        MIRunControl.MIExecutionDMC execCtx = (MIRunControl.MIExecutionDMC)DMContexts.getAncestorOfType((IDMContext)exprCtx, MIRunControl.MIExecutionDMC.class);
        if (execCtx != null) {
            expressionId = "t_" + execCtx.getThreadId() + "_" + expressionId;
        }
        if ((frameCtx = (MIStack.MIFrameDMC)DMContexts.getAncestorOfType((IDMContext)exprCtx, MIStack.MIFrameDMC.class)) != null) {
            final String finalExprId = expressionId;
            this.stackService.getStackDepth((DataRequestMonitor)new DataRequestMonitor<Integer>((Executor)this.getExecutor(), drm){

                public void handleOK() {
                    final int depth = (Integer)this.getData() - frameCtx.getLevel();
                    MIVariableManager.this.stackService.getFrameData((IStack.IFrameDMContext)frameCtx, (DataRequestMonitor)new DataRequestMonitor<IStack.IFrameDMData>((Executor)MIVariableManager.this.getExecutor(), (RequestMonitor)drm){

                        public void handleOK() {
                            String stackExprId = "f_" + depth + "_" + ((IStack.IFrameDMData)this.getData()).getFile() + "_" + ((IStack.IFrameDMData)this.getData()).getFunction() + "_" + finalExprId;
                            drm.setData((Object)stackExprId);
                            drm.done();
                        }
                    });
                }
            });
        } else {
            drm.setData((Object)expressionId);
            drm.done();
        }
    }

    public <V extends ICommandResult> void queueCommand(ICommand<V> command, DataRequestMonitor<V> rm) {
        this.processCommandSent(command);
        if (command instanceof DsfExprMetaGetVar) {
            final DataRequestMonitor<V> drm = rm;
            final ExpressionService.ExpressionDMC exprCtx = (ExpressionService.ExpressionDMC)command.getContext();
            this.getVariable((IDMContext)exprCtx, new DataRequestMonitor<MIVariableObject>((Executor)this.getExecutor(), drm){

                protected void handleOK() {
                    drm.setData((Object)new DsfExprMetaGetVarInfo(MIVariableManager.this.getParentRelativeExpression(exprCtx.getExpression()), ((MIVariableObject)this.getData()).getNumChildren(), ((MIVariableObject)this.getData()).getType()));
                    drm.done();
                }
            });
        } else if (command instanceof DsfExprMetaGetValue) {
            final DataRequestMonitor<V> drm = rm;
            final IFormattedValues.FormattedValueDMContext valueCtx = (IFormattedValues.FormattedValueDMContext)command.getContext();
            this.getVariable((IDMContext)valueCtx, new DataRequestMonitor<MIVariableObject>((Executor)this.getExecutor(), drm){

                protected void handleOK() {
                    MIVariableManager.this.getValue(valueCtx, (MIVariableObject)this.getData(), (DataRequestMonitor<IFormattedValues.FormattedValueDMData>)((DataRequestMonitor)new DataRequestMonitor<IFormattedValues.FormattedValueDMData>((Executor)MIVariableManager.this.getExecutor(), (RequestMonitor)drm){

                        protected void handleOK() {
                            drm.setData((Object)new DsfExprMetaGetValueInfo(((IFormattedValues.FormattedValueDMData)this.getData()).getFormattedValue()));
                            drm.done();
                        }
                    }));
                }
            });
        } else if (command instanceof DsfExprMetaGetChildren) {
            final DataRequestMonitor<V> drm = rm;
            final IExpressions.IExpressionDMContext exprCtx = (IExpressions.IExpressionDMContext)command.getContext();
            this.getVariable((IDMContext)exprCtx, new DataRequestMonitor<MIVariableObject>((Executor)this.getExecutor(), drm){

                protected void handleOK() {
                    final MIVariableObject varObj = (MIVariableObject)this.getData();
                    MIVariableManager.this.getChildren(varObj, (DataRequestMonitor<DsfMIVar[]>)((DataRequestMonitor)new DataRequestMonitor<DsfMIVar[]>((Executor)MIVariableManager.this.getExecutor(), (RequestMonitor)drm){

                        protected void handleOK() {
                            DsfMIVar[] vars = (DsfMIVar[])this.getData();
                            String[] childExpressions = new String[vars.length];
                            for (int i = 0; i < vars.length; ++i) {
                                childExpressions[i] = MIVariableManager.this.createQualifiedExpression(varObj, exprCtx.getExpression(), vars[i].getExp());
                            }
                            drm.setData((Object)new DsfExprMetaGetChildrenInfo(childExpressions));
                            drm.done();
                        }
                    }));
                }
            });
        } else if (command instanceof DsfExprMetaGetChildCount) {
            final DataRequestMonitor<V> drm = rm;
            ExpressionService.ExpressionDMC exprCtx = (ExpressionService.ExpressionDMC)command.getContext();
            this.getVariable((IDMContext)exprCtx, new DataRequestMonitor<MIVariableObject>((Executor)this.getExecutor(), drm){

                protected void handleOK() {
                    MIVariableManager.this.getChildrenCount((MIVariableObject)this.getData(), (DataRequestMonitor<Integer>)((DataRequestMonitor)new DataRequestMonitor<Integer>((Executor)MIVariableManager.this.getExecutor(), (RequestMonitor)drm){

                        protected void handleOK() {
                            drm.setData((Object)new DsfExprMetaGetChildCountInfo((Integer)this.getData()));
                            drm.done();
                        }
                    }));
                }
            });
        } else if (command instanceof DsfMIDataEvaluateExpression) {
            this.commandControl.queueCommand(command, rm);
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Unexpected Expression Meta command", null));
            rm.done();
        }
    }

    public void removeCommand(ICommand<? extends ICommandResult> command) {
        assert (false);
    }

    public void cancelCommand(ICommand<? extends ICommandResult> command) {
    }

    public void addCommandListener(ICommandListener processor) {
        this.fCommandProcessors.add(processor);
    }

    public void removeCommandListener(ICommandListener processor) {
        this.fCommandProcessors.remove(processor);
    }

    public void addEventListener(IEventListener processor) {
    }

    public void removeEventListener(IEventListener processor) {
    }

    private void processCommandSent(ICommand<?> command) {
        for (ICommandListener processor : this.fCommandProcessors) {
            processor.commandSent(command);
        }
    }

    private String getParentRelativeExpression(String qualifiedExp) {
        return qualifiedExp.substring(qualifiedExp.lastIndexOf(46) + 1);
    }

    private String createQualifiedExpression(MIVariableObject varObj, String outerExpression, String innerExpression) {
        String typeName = varObj.getType();
        if (typeName.endsWith("]")) {
            return outerExpression + "[" + innerExpression + "]";
        }
        return outerExpression + "." + innerExpression;
    }

    protected BundleContext getBundleContext() {
        return DsfMIPlugin.getBundleContext();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LRUVariableCache
    extends LinkedHashMap<String, MIVariableObject> {
        public static final long serialVersionUID = 0L;
        private static final int MAX_VARIABLE_LIST = 1000;

        public LRUVariableCache() {
            super(0, 0.75f, true);
        }

        @Override
        public boolean removeEldestEntry(Map.Entry<String, MIVariableObject> eldest) {
            return eldest.getValue().currentState == MIVariableObject.VarState.READY && this.size() > 1000;
        }

        @Override
        public MIVariableObject remove(Object key) {
            MIVariableObject varObj = (MIVariableObject)super.remove(key);
            MIVariableManager.this.deleteVariable(varObj);
            return varObj;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MIVariableObject {
        private final String internalName;
        private String gdbName = null;
        private String format = "NATURAL.Format";
        private ExpressionService.ExpressionDMData expData = null;
        private String value = null;
        private Language lang = null;
        private VarState currentState = VarState.CREATING;
        private List<Runnable> runQueue = new ArrayList<Runnable>();
        private List<DataRequestMonitor<MIVariableObject>> requestsPendingCreation = new ArrayList<DataRequestMonitor<MIVariableObject>>();

        public MIVariableObject(String n) {
            this.internalName = n;
        }

        public String getInternalName() {
            return this.internalName;
        }

        public String getGdbName() {
            return this.gdbName;
        }

        public String getFormat() {
            return this.format;
        }

        public ExpressionService.ExpressionDMData getExpressionData() {
            return this.expData;
        }

        public String getExpression() {
            return this.expData == null ? null : this.expData.getName();
        }

        public String getType() {
            return this.expData == null ? null : this.expData.getTypeName();
        }

        public int getNumChildren() {
            return this.expData == null ? 0 : this.expData.getNumChildren();
        }

        public String getValue() {
            return this.value;
        }

        public Language getLanguage() {
            return this.lang;
        }

        public void setGdbName(String n) {
            this.gdbName = n;
        }

        public void setFormat(String f) {
            this.format = f;
        }

        public void setExpressionData(String expression, String type, int num) {
            this.expData = new ExpressionService.ExpressionDMData(expression, type, num);
        }

        public void setValue(String val) {
            this.value = val;
        }

        public void setLanguage(String lStr) {
            Language l = Language.CPP;
            if (lStr.equals("C++")) {
                l = Language.CPP;
            } else if (lStr.equals("C")) {
                l = Language.C;
            } else if (lStr.equalsIgnoreCase("Java")) {
                l = Language.JAVA;
            }
            this.setLanguage(l);
        }

        public void setLanguage(Language l) {
            this.lang = l;
        }

        public void addCreationListener(DataRequestMonitor<MIVariableObject> rm) {
            if (this.currentState != VarState.CREATING) {
                rm.setData((Object)this);
                rm.done();
            } else {
                this.requestsPendingCreation.add(rm);
            }
        }

        public void creationCompleted(boolean success) {
            assert (this.currentState == VarState.CREATING);
            if (success) {
                this.currentState = VarState.READY;
                while (this.requestsPendingCreation.size() > 0) {
                    DataRequestMonitor<MIVariableObject> rm = this.requestsPendingCreation.remove(0);
                    rm.setData((Object)this);
                    rm.done();
                }
            } else {
                while (this.requestsPendingCreation.size() > 0) {
                    DataRequestMonitor<MIVariableObject> rm = this.requestsPendingCreation.remove(0);
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "Unable to create variable object", null));
                    rm.done();
                }
            }
        }

        public void executeWhenReady(Runnable runObj) {
            if (this.currentState == VarState.READY) {
                runObj.run();
            } else {
                this.runQueue.add(runObj);
            }
        }

        public void lock() {
            this.currentState = VarState.IN_USE;
        }

        public void unlock() {
            this.currentState = VarState.READY;
            while (this.runQueue.size() > 0 && this.currentState == VarState.READY) {
                this.runQueue.remove(0).run();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Language {
            C,
            CPP,
            JAVA;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum VarState {
            CREATING,
            READY,
            IN_USE;

        }
    }
}

